/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import hex.word2vec.Word2VecModel;
import water.Job;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.parser.BufferedString;
import water.util.ArrayUtils;

public class WordVectorConverter
extends MRTask<WordVectorConverter> {
    private final Job<Word2VecModel> _job;
    private final int _wordVecSize;
    private final int _vocabWordCount;
    float[] _syn0;
    BufferedString[] _words;

    public WordVectorConverter(Job<Word2VecModel> job, int wordVecSize, int vocabWordCount) {
        super(null);
        this._job = job;
        this._wordVecSize = wordVecSize;
        this._vocabWordCount = vocabWordCount;
    }

    @Override
    protected void setupLocal() {
        this._syn0 = MemoryManager.malloc4f(this._wordVecSize * this._vocabWordCount);
        this._words = new BufferedString[this._vocabWordCount];
    }

    @Override
    public void map(Chunk[] cs) {
        int wordPos = (int)cs[0].start();
        int pos = this._wordVecSize * wordPos;
        for (int i = 0; i < cs[0]._len; ++i) {
            this._words[wordPos++] = cs[0].atStr(new BufferedString(), i);
            for (int j = 1; j < cs.length; ++j) {
                this._syn0[pos++] = (float)cs[j].atd(i);
            }
        }
        this._job.update(1L);
    }

    @Override
    public void reduce(WordVectorConverter other) {
        if (this._syn0 != other._syn0) {
            ArrayUtils.add(this._syn0, other._syn0);
            for (int i = 0; i < this._vocabWordCount; ++i) {
                if (other._words[i] == null) continue;
                this._words[i] = other._words[i];
            }
        }
    }
}

