/*
 * Decompiled with CFR 0.152.
 */
package hex.word2vec;

import hex.ModelMojoWriter;
import hex.word2vec.Word2VecModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import water.MemoryManager;
import water.parser.BufferedString;

public class Word2VecMojoWriter
extends ModelMojoWriter<Word2VecModel, Word2VecModel.Word2VecParameters, Word2VecModel.Word2VecOutput> {
    public Word2VecMojoWriter() {
    }

    public Word2VecMojoWriter(Word2VecModel model) {
        super(model);
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    @Override
    protected void writeModelData() throws IOException {
        this.writekv("vec_size", ((Word2VecModel.Word2VecParameters)((Word2VecModel)this.model)._parms)._vec_size);
        this.writekv("vocab_size", ((Word2VecModel.Word2VecOutput)((Word2VecModel)this.model)._output)._words.length);
        this.startWritingTextFile("vocabulary");
        for (BufferedString word : ((Word2VecModel.Word2VecOutput)((Word2VecModel)this.model)._output)._words) {
            this.writeln(word.toString(), true);
        }
        this.finishWritingTextFile();
        ByteBuffer bb = ByteBuffer.wrap(MemoryManager.malloc1(((Word2VecModel.Word2VecOutput)((Word2VecModel)this.model)._output)._vecs.length * 4));
        for (float v : ((Word2VecModel.Word2VecOutput)((Word2VecModel)this.model)._output)._vecs) {
            bb.putFloat(v);
        }
        this.writeblob("vectors", bb.array());
    }
}

