/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.uplift;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsBinomialUplift;
import hex.tree.SharedTreeModel;
import hex.tree.uplift.UpliftDRF;
import hex.tree.uplift.UpliftDrfMojoWriter;
import hex.util.EffectiveParametersUtils;
import water.Key;

public class UpliftDRFModel
extends SharedTreeModel<UpliftDRFModel, UpliftDRFParameters, UpliftDRFOutput> {
    public UpliftDRFModel(Key<UpliftDRFModel> selfKey, UpliftDRFParameters parms, UpliftDRFOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public void initActualParamValues() {
        super.initActualParamValues();
        EffectiveParametersUtils.initHistogramType((SharedTreeModel.SharedTreeParameters)this._parms);
        EffectiveParametersUtils.initCategoricalEncoding(this._parms, Model.Parameters.CategoricalEncodingScheme.Enum);
        EffectiveParametersUtils.initUpliftMetric((UpliftDRFParameters)this._parms);
    }

    @Override
    public boolean binomialOpt() {
        return false;
    }

    @Override
    protected double[] score0(double[] data, double[] preds, double offset, int ntrees) {
        super.score0(data, preds, offset, ntrees);
        int N = ((UpliftDRFOutput)this._output)._ntrees;
        preds[1] = preds[1] / (double)N;
        preds[2] = preds[2] / (double)N;
        preds[0] = preds[1] - preds[2];
        return preds;
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsBinomialUplift.MetricBuilderBinomialUplift(domain, ((UpliftDRFOutput)this._output)._defaultAuucThresholds);
    }

    @Override
    public UpliftDrfMojoWriter getMojo() {
        return new UpliftDrfMojoWriter(this);
    }

    public static class UpliftDRFOutput
    extends SharedTreeModel.SharedTreeOutput {
        public double[] _defaultAuucThresholds;

        public UpliftDRFOutput(UpliftDRF b) {
            super(b);
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.BinomialUplift;
        }

        @Override
        public boolean isBinomialClassifier() {
            return true;
        }

        public void setDefaultAuucThresholds(double[] defaultAuucThresholds) {
            this._defaultAuucThresholds = defaultAuucThresholds;
        }
    }

    public static class UpliftDRFParameters
    extends SharedTreeModel.SharedTreeParameters {
        public UpliftMetricType _uplift_metric = UpliftMetricType.AUTO;
        public int _mtries = -2;

        @Override
        public String algoName() {
            return "UpliftDRF";
        }

        @Override
        public String fullName() {
            return "Uplift Distributed Random Forest";
        }

        @Override
        public String javaName() {
            return UpliftDRFModel.class.getName();
        }

        public UpliftDRFParameters() {
            this._max_depth = 20;
            this._min_rows = 1.0;
            this._treatment_column = "treatment";
        }

        @Override
        public long progressUnits() {
            return this._ntrees * 2;
        }

        public static enum UpliftMetricType {
            AUTO,
            KL,
            ChiSquared,
            Euclidean;

        }
    }
}

