/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isoforextended;

import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.tree.isofor.ModelMetricsAnomaly;
import hex.tree.isoforextended.ExtendedIsolationForestModel;
import hex.tree.isoforextended.ScoreExtendedIsolationForestTask;
import hex.tree.isoforextended.isolationtree.CompressedIsolationTree;
import hex.tree.isoforextended.isolationtree.IsolationTree;
import hex.tree.isoforextended.isolationtree.IsolationTreeStats;
import java.util.ArrayList;
import java.util.Random;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.util.FrameUtils;
import water.util.MRUtils;
import water.util.MathUtils;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.Timer;
import water.util.TwoDimTable;

public class ExtendedIsolationForest
extends ModelBuilder<ExtendedIsolationForestModel, ExtendedIsolationForestModel.ExtendedIsolationForestParameters, ExtendedIsolationForestModel.ExtendedIsolationForestOutput> {
    private static final transient Logger LOG = Logger.getLogger(ExtendedIsolationForest.class);
    public static final int MAX_NTREES = 100000;
    public static final int MAX_SAMPLE_SIZE = 100000;
    private ExtendedIsolationForestModel _model;
    transient Random _rand;
    transient IsolationTreeStats isolationTreeStats;

    public ExtendedIsolationForest(ExtendedIsolationForestModel.ExtendedIsolationForestParameters parms) {
        super(parms);
        this.init(false);
    }

    public ExtendedIsolationForest(ExtendedIsolationForestModel.ExtendedIsolationForestParameters parms, Key<ExtendedIsolationForestModel> key) {
        super(parms, key);
        this.init(false);
    }

    public ExtendedIsolationForest(ExtendedIsolationForestModel.ExtendedIsolationForestParameters parms, Job job) {
        super(parms, job);
        this.init(false);
    }

    public ExtendedIsolationForest(boolean startup_once) {
        super(new ExtendedIsolationForestModel.ExtendedIsolationForestParameters(), startup_once);
    }

    @Override
    protected void checkMemoryFootPrint_impl() {
        int heightLimit = (int)Math.ceil(MathUtils.log2(((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._sample_size));
        double numInnerNodes = Math.pow(2.0, heightLimit) - 1.0;
        double numLeafNodes = Math.pow(2.0, heightLimit);
        double sizeOfInnerNode = 2 * this._train.numCols() * 8;
        double sizeOfLeafNode = 4.0;
        long maxMem = H2O.SELF._heartbeat.get_free_mem();
        double oneTree = 0.25 * numInnerNodes * sizeOfInnerNode + numLeafNodes * sizeOfLeafNode;
        long estimatedMemory = (long)((double)((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._ntrees * oneTree);
        long estimatedComputingMemory = 5L * estimatedMemory;
        if (estimatedComputingMemory > H2O.SELF._heartbeat.get_free_mem() || estimatedComputingMemory < 0L) {
            String msg = "Extended Isolation Forest computation won't fit in the driver node's memory (" + PrettyPrint.bytes(estimatedComputingMemory) + " > " + PrettyPrint.bytes(maxMem) + ") - try reducing the number of columns and/or the number of trees and/or the sample_size parameter. You can disable memory check by setting the attribute " + "sys.ai.h2o." + "debug.noMemoryCheck.";
            this.error("_train", msg);
        }
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms).train() != null) {
            if (expensive) {
                long extensionLevelMax = this._train.numCols() - 1;
                if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._extension_level < 0 || (long)((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._extension_level > extensionLevelMax) {
                    this.error("extension_level", "Parameter extension_level must be in interval [0, " + extensionLevelMax + "] but it is " + ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._extension_level);
                }
            }
            long sampleSizeMax = ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms).train().numRows();
            if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._sample_size < 2 || ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._sample_size > 100000 || (long)((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._sample_size > sampleSizeMax) {
                this.error("sample_size", "Parameter sample_size must be in interval [2, 100000] but it is " + ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._sample_size);
            }
            if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._ntrees < 1 || ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._ntrees > 100000) {
                this.error("ntrees", "Parameter ntrees must be in interval [1, 100000] but it is " + ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._ntrees);
            }
        }
        if (expensive && this.error_count() == 0) {
            this.checkMemoryFootPrint();
        }
    }

    @Override
    protected ModelBuilder.Driver trainModelImpl() {
        return new ExtendedIsolationForestDriver();
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.AnomalyDetection};
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public boolean havePojo() {
        return false;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    public TwoDimTable createModelSummaryTable() {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Number of Trees");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("Size of Subsample");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("Extension Level");
        colTypes.add("int");
        colFormat.add("%d");
        colHeaders.add("Seed");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Number of trained trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Min. Depth");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Depth");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Depth");
        colTypes.add("float");
        colFormat.add("%d");
        colHeaders.add("Min. Leaves");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Leaves");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Leaves");
        colTypes.add("float");
        colFormat.add("%d");
        colHeaders.add("Min. Isolated Point");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Isolated Point");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Isolated Point");
        colTypes.add("float");
        colFormat.add("%d");
        colHeaders.add("Min. Not Isolated Point");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Not Isolated Point");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Not Isolated Point");
        colTypes.add("float");
        colFormat.add("%d");
        colHeaders.add("Min. Zero Splits");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Max. Zero Splits");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Zero Splits");
        colTypes.add("float");
        colFormat.add("%d");
        boolean rows = true;
        TwoDimTable table = new TwoDimTable("Model Summary", null, new String[1], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        int col = 0;
        table.set(row, col++, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._ntrees);
        table.set(row, col++, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._sample_size);
        table.set(row, col++, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._extension_level);
        table.set(row, col++, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._seed);
        table.set(row, col++, this.isolationTreeStats._numTrees);
        table.set(row, col++, this.isolationTreeStats._minDepth);
        table.set(row, col++, this.isolationTreeStats._maxDepth);
        table.set(row, col++, Float.valueOf(this.isolationTreeStats._meanDepth));
        table.set(row, col++, this.isolationTreeStats._minLeaves);
        table.set(row, col++, this.isolationTreeStats._maxLeaves);
        table.set(row, col++, Float.valueOf(this.isolationTreeStats._meanLeaves));
        table.set(row, col++, this.isolationTreeStats._minIsolated);
        table.set(row, col++, this.isolationTreeStats._maxIsolated);
        table.set(row, col++, Float.valueOf(this.isolationTreeStats._meanIsolated));
        table.set(row, col++, this.isolationTreeStats._minNotIsolated);
        table.set(row, col++, this.isolationTreeStats._maxNotIsolated);
        table.set(row, col++, Float.valueOf(this.isolationTreeStats._meanNotIsolated));
        table.set(row, col++, this.isolationTreeStats._minZeroSplits);
        table.set(row, col++, this.isolationTreeStats._maxZeroSplits);
        table.set(row, col, Float.valueOf(this.isolationTreeStats._meanZeroSplits));
        return table;
    }

    protected TwoDimTable createScoringHistoryTable(int ntreesTrained) {
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Timestamp");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Duration");
        colTypes.add("string");
        colFormat.add("%s");
        colHeaders.add("Number of Trees");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Mean Tree Path Length");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Mean Anomaly Score");
        colTypes.add("double");
        colFormat.add("%.5f");
        if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._custom_metric_func != null) {
            colHeaders.add("Training Custom");
            colTypes.add("double");
            colFormat.add("%.5f");
        }
        ScoreKeeper[] sks = ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)this._model._output)._scored_train;
        int rows = 0;
        for (int i = 0; i <= ntreesTrained; ++i) {
            if (i != 0 && sks[i] != null && Double.isNaN(sks[i]._anomaly_score) || sks[i] == null) continue;
            ++rows;
        }
        TwoDimTable table = new TwoDimTable("Scoring History", null, new String[rows], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        int row = 0;
        for (int i = 0; i <= ntreesTrained; ++i) {
            if (i != 0 && sks[i] != null && Double.isNaN(sks[i]._anomaly_score) || sks[i] == null) continue;
            int col = 0;
            DateTimeFormatter fmt = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
            table.set(row, col++, fmt.print(((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)this._model._output)._training_time_ms[i]));
            table.set(row, col++, PrettyPrint.msecs(((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)this._model._output)._training_time_ms[i] - this._job.start_time(), true));
            table.set(row, col++, i);
            ScoreKeeper st = sks[i];
            table.set(row, col++, st._anomaly_score);
            table.set(row, col++, st._anomaly_score_normalized);
            if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)this._parms)._custom_metric_func != null) {
                table.set(row, col++, st._custom_metric);
            }
            assert (col == colHeaders.size());
            ++row;
        }
        return table;
    }

    private class ExtendedIsolationForestDriver
    extends ModelBuilder.Driver {
        private ExtendedIsolationForestDriver() {
            super(ExtendedIsolationForest.this);
        }

        @Override
        public void computeImpl() {
            ExtendedIsolationForest.this._model = null;
            try {
                ExtendedIsolationForest.this.init(true);
                if (ExtendedIsolationForest.this.error_count() > 0) {
                    throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(ExtendedIsolationForest.this);
                }
                ExtendedIsolationForest.this._rand = RandomUtils.getRNG(((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._seed);
                ExtendedIsolationForest.this.isolationTreeStats = new IsolationTreeStats();
                ExtendedIsolationForest.this._model = new ExtendedIsolationForestModel(ExtendedIsolationForest.this.dest(), (ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms, new ExtendedIsolationForestModel.ExtendedIsolationForestOutput(ExtendedIsolationForest.this));
                ExtendedIsolationForest.this._model.delete_and_lock(ExtendedIsolationForest.this._job);
                this.buildIsolationTreeEnsemble();
                if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._disable_training_metrics) {
                    ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._model_summary = ExtendedIsolationForest.this.createModelSummaryTable();
                    LOG.info(ExtendedIsolationForest.this._model.toString());
                }
            }
            finally {
                if (ExtendedIsolationForest.this._model != null) {
                    ExtendedIsolationForest.this._model.unlock(ExtendedIsolationForest.this._job);
                }
            }
        }

        private void buildIsolationTreeEnsemble() {
            ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._iTreeKeys = new Key[((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._ntrees];
            ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._scored_train = new ScoreKeeper[((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._ntrees + 1];
            ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._scored_train[0] = new ScoreKeeper();
            ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._training_time_ms = new long[((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._ntrees + 1];
            ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._training_time_ms[0] = System.currentTimeMillis();
            long timeLastScoreStart = 0L;
            long timeLastScoreEnd = 0L;
            long sinceLastScore = 0L;
            int heightLimit = (int)Math.ceil(MathUtils.log2(((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._sample_size));
            IsolationTree isolationTree = new IsolationTree(heightLimit, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._extension_level);
            for (int tid = 0; tid < ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._ntrees; ++tid) {
                boolean printout;
                Timer timer = new Timer();
                Frame subSample = MRUtils.sampleFrameSmall(ExtendedIsolationForest.this._train, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._sample_size, ExtendedIsolationForest.this._rand);
                double[][] subSampleArray = FrameUtils.asDoubles(subSample);
                CompressedIsolationTree compressedIsolationTree = isolationTree.buildTree(subSampleArray, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._seed + (long)ExtendedIsolationForest.this._rand.nextInt(), tid);
                if (LOG.isDebugEnabled()) {
                    isolationTree.logNodesNumRows(Level.DEBUG);
                    isolationTree.logNodesHeight(Level.DEBUG);
                }
                ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._iTreeKeys[tid] = compressedIsolationTree._key;
                DKV.put(compressedIsolationTree);
                ExtendedIsolationForest.this._job.update(1L);
                ExtendedIsolationForest.this._model.update(ExtendedIsolationForest.this._job);
                ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._training_time_ms[tid + 1] = System.currentTimeMillis();
                LOG.info(tid + 1 + ". tree was built in " + timer);
                ExtendedIsolationForest.this.isolationTreeStats.updateBy(isolationTree);
                long now = System.currentTimeMillis();
                sinceLastScore = now - timeLastScoreStart;
                boolean timeToScore = now - ExtendedIsolationForest.this._job.start_time() < (long)((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._initial_score_interval || sinceLastScore > (long)((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_interval && (double)(timeLastScoreEnd - timeLastScoreStart) / (double)sinceLastScore < 0.1;
                boolean manualInterval = ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_tree_interval > 0 && (tid + 1) % ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_tree_interval == 0;
                boolean finalScoring = ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._ntrees == tid + 1;
                boolean scored = false;
                ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._scored_train[tid + 1] = new ScoreKeeper();
                if (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_each_iteration || manualInterval || finalScoring || timeToScore && ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_tree_interval == 0 && !((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._disable_training_metrics) {
                    ModelMetrics modelMetrics;
                    ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._scored_train[tid + 1] = new ScoreKeeper();
                    timeLastScoreStart = System.currentTimeMillis();
                    ModelMetricsAnomaly.MetricBuilderAnomaly metricsBuilder = ((ScoreExtendedIsolationForestTask)new ScoreExtendedIsolationForestTask(ExtendedIsolationForest.this._model).doAll(ExtendedIsolationForest.this._train)).getMetricsBuilder();
                    ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._training_metrics = modelMetrics = ((ModelMetrics.MetricBuilder)metricsBuilder).makeModelMetrics(ExtendedIsolationForest.this._model, ((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms).train(), null, null);
                    ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._scored_train[tid + 1].fillFrom(modelMetrics);
                    scored = true;
                    timeLastScoreEnd = System.currentTimeMillis();
                }
                boolean bl = printout = (((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_each_iteration || finalScoring || sinceLastScore > (long)((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._score_interval && scored) && !((ExtendedIsolationForestModel.ExtendedIsolationForestParameters)ExtendedIsolationForest.this._parms)._disable_training_metrics;
                if (!printout) continue;
                ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._model_summary = ExtendedIsolationForest.this.createModelSummaryTable();
                ((ExtendedIsolationForestModel.ExtendedIsolationForestOutput)((ExtendedIsolationForest)ExtendedIsolationForest.this)._model._output)._scoring_history = ExtendedIsolationForest.this.createScoringHistoryTable(tid + 1);
                LOG.info(ExtendedIsolationForest.this._model.toString());
            }
        }
    }
}

