/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.isofor;

import hex.AUC2;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import water.fvec.Frame;

public class MetricBuilderAnomalySupervised
extends ModelMetricsBinomial.MetricBuilderBinomial<MetricBuilderAnomalySupervised> {
    public MetricBuilderAnomalySupervised(String[] domain) {
        super(domain);
    }

    @Override
    public ModelMetrics makeModelMetrics(Model m, Frame f, Frame frameWithWeights, Frame preds) {
        AUC2 auc;
        double logloss;
        double mse;
        double sigma;
        if (this._wcount > 0.0) {
            sigma = this.weightedSigma();
            mse = this._sumsqe / this._wcount;
            logloss = this._logloss / this._wcount;
            auc = new AUC2(this._auc);
        } else {
            sigma = Double.NaN;
            mse = Double.NaN;
            logloss = Double.NaN;
            auc = AUC2.emptyAUC();
        }
        ModelMetricsBinomial mm = new ModelMetricsBinomial(m, f, this._count, mse, this._domain, sigma, auc, logloss, null, this._customMetric);
        if (m != null) {
            m.addModelMetrics(mm);
        }
        return mm;
    }

    @Override
    public double[] perRow(double[] ds, float[] yact, double w, double o, Model m) {
        MetricBuilderAnomalySupervised.adaptPreds(ds);
        return super.perRow(ds, yact, w, o, m);
    }

    private static void adaptPreds(double[] ds) {
        ds[2] = Math.min(ds[1], 1.0);
        ds[1] = 1.0 - ds[2];
        ds[0] = -1.0;
    }
}

