/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt.mrtasks;

import water.MRTask;
import water.fvec.Chunk;

public class GetClassCountsMRTask
extends MRTask<GetClassCountsMRTask> {
    public int _numClasses;
    public int[] _countsByClass;
    private final double[][] _featuresLimits;

    public GetClassCountsMRTask(double[][] featuresLimits, int numClasses) {
        this._numClasses = numClasses;
        this._featuresLimits = featuresLimits;
    }

    @Override
    public void map(Chunk[] cs) {
        this._countsByClass = new int[this._numClasses];
        int classColumn = cs.length - 1;
        int numRows = cs[0]._len;
        for (int row = 0; row < numRows; ++row) {
            boolean conditionsFailed = false;
            for (int column = 0; column < cs.length - 1; ++column) {
                if (this.verifyLimits(cs[column].atd(row), column)) continue;
                conditionsFailed = true;
                break;
            }
            if (conditionsFailed) continue;
            int n = (int)cs[classColumn].atd(row);
            this._countsByClass[n] = this._countsByClass[n] + 1;
        }
    }

    private boolean isNumerical(int feature) {
        return this._featuresLimits[feature][0] == -1.0;
    }

    private boolean verifyLimits(double featureValue, int column) {
        if (this.isNumerical(column)) {
            return featureValue > this._featuresLimits[column][1] && featureValue <= this._featuresLimits[column][2];
        }
        return this._featuresLimits[column][(int)featureValue] == 1.0;
    }

    @Override
    public void reduce(GetClassCountsMRTask mrt) {
        for (int c = 0; c < this._numClasses; ++c) {
            int n = c;
            this._countsByClass[n] = this._countsByClass[n] + mrt._countsByClass[c];
        }
    }
}

