/*
 * Decompiled with CFR 0.152.
 */
package hex.tree.dt.binning;

import hex.tree.dt.CategoricalFeatureLimits;
import hex.tree.dt.DataFeaturesLimits;
import hex.tree.dt.NumericFeatureLimits;
import hex.tree.dt.binning.AbstractBin;
import hex.tree.dt.binning.CategoricalBin;
import hex.tree.dt.binning.NumericBin;
import hex.tree.dt.mrtasks.CountBinsSamplesCountsMRTask;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import water.fvec.Frame;

public enum BinningStrategy {
    EQUAL_WIDTH{
        public final int NUM_BINS = 10;
        public final int DECIMALS_TO_CONSIDER = 2;
        public final double MIN_REL_COEFF = 1.0E-4;

        double roundToNDecimalPoints(double number, int decimals) {
            BigDecimal bigDecimal = new BigDecimal(number);
            return bigDecimal.setScale(decimals, RoundingMode.HALF_UP).doubleValue();
        }

        double roundToNDecimalPoints(double number) {
            return this.roundToNDecimalPoints(number, 2);
        }

        private List<AbstractBin> createEmptyBinsFromBinningValues(List<Double> binningValues, double realMin, double realMax) {
            ArrayList<AbstractBin> emptyBins = new ArrayList<AbstractBin>();
            for (int i = 0; i < binningValues.size() - 1; ++i) {
                emptyBins.add(new NumericBin(this.roundToNDecimalPoints(binningValues.get(i)), this.roundToNDecimalPoints(binningValues.get(i + 1))));
            }
            ((NumericBin)emptyBins.get(0)).setMin(realMin - 1.0E-4 * (binningValues.get(1) - binningValues.get(0)));
            ((NumericBin)emptyBins.get(emptyBins.size() - 1)).setMax(realMax);
            return emptyBins;
        }

        @Override
        List<AbstractBin> createFeatureBins(Frame originData, DataFeaturesLimits featuresLimits, int feature) {
            if (originData.vec(feature).isNumeric()) {
                NumericFeatureLimits featureLimits = (NumericFeatureLimits)featuresLimits.getFeatureLimits(feature);
                double step = (featureLimits._max - featureLimits._min) / 10.0;
                if (step == 0.0) {
                    return null;
                }
                ArrayList<Double> binningValues = new ArrayList<Double>();
                for (double value = featureLimits._min; value <= featureLimits._max; value += step) {
                    binningValues.add(value);
                }
                List<AbstractBin> emptyBins = this.createEmptyBinsFromBinningValues(binningValues, featureLimits._min, featureLimits._max);
                return BinningStrategy.calculateNumericBinSamplesCount(originData, emptyBins, featuresLimits.toDoubles(), feature);
            }
            CategoricalFeatureLimits featureLimits = (CategoricalFeatureLimits)featuresLimits.getFeatureLimits(feature);
            ArrayList<CategoricalBin> emptyBins = new ArrayList<CategoricalBin>();
            for (int category = 0; category < featureLimits._mask.length; ++category) {
                if (!featureLimits._mask[category]) continue;
                emptyBins.add(new CategoricalBin(category));
            }
            return BinningStrategy.calculateCategoricalBinSamplesCount(originData, emptyBins, featuresLimits.toDoubles(), feature);
        }
    }
    ,
    EQUAL_HEIGHT{

        @Override
        List<AbstractBin> createFeatureBins(Frame originData, DataFeaturesLimits featuresLimits, int feature) {
            return null;
        }
    }
    ,
    CUSTOM_BINS{

        @Override
        List<AbstractBin> createFeatureBins(Frame originData, DataFeaturesLimits featuresLimits, int feature) {
            return null;
        }
    };


    abstract List<AbstractBin> createFeatureBins(Frame var1, DataFeaturesLimits var2, int var3);

    private static List<AbstractBin> calculateCategoricalBinSamplesCount(Frame data, List<AbstractBin> bins, double[][] featuresLimits, int feature) {
        double[][] binsArray = (double[][])bins.stream().map(AbstractBin::toDoubles).toArray(x$0 -> new double[x$0][]);
        CountBinsSamplesCountsMRTask task = new CountBinsSamplesCountsMRTask(feature, featuresLimits, binsArray);
        task.doAll(data);
        for (int i = 0; i < binsArray.length; ++i) {
            bins.get((int)i)._count = (int)task._bins[i][1];
            bins.get((int)i)._count0 = (int)task._bins[i][2];
        }
        return bins;
    }

    private static List<AbstractBin> calculateNumericBinSamplesCount(Frame data, List<AbstractBin> bins, double[][] featuresLimits, int feature) {
        double[][] binsArray = (double[][])bins.stream().map(AbstractBin::toDoubles).toArray(x$0 -> new double[x$0][]);
        CountBinsSamplesCountsMRTask task = new CountBinsSamplesCountsMRTask(feature, featuresLimits, binsArray);
        task.doAll(data);
        for (int i = 0; i < binsArray.length; ++i) {
            bins.get((int)i)._count = (int)task._bins[i][1];
            bins.get((int)i)._count0 = (int)task._bins[i][2];
        }
        return bins;
    }
}

