/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.tree.CompressedTree;

public abstract class MojoUtils {
    public static CompressedTree[][] extractCompressedTrees(SharedTreeMojoModel mojo) {
        int ntrees = mojo.getNTreeGroups();
        int ntreesPerGroup = mojo.getNTreesPerGroup();
        int nclasses = mojo.nclasses();
        CompressedTree[][] trees = new CompressedTree[ntrees][];
        for (int t = 0; t < ntrees; ++t) {
            CompressedTree[] tc = new CompressedTree[nclasses];
            for (int c = 0; c < ntreesPerGroup; ++c) {
                tc[c] = new CompressedTree(mojo.treeBytes(t, c), -1L, t, c);
            }
            trees[t] = tc;
        }
        return trees;
    }

    public static boolean isUsingBinomialOpt(SharedTreeMojoModel mojo, CompressedTree[][] trees) {
        if (mojo.nclasses() != 2) {
            return false;
        }
        for (CompressedTree[] group2 : trees) {
            if (group2.length == 2 && group2[1] == null) continue;
            return false;
        }
        return true;
    }
}

