/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.DHistogram;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import water.util.ArrayUtils;

public class GuidedSplitPoints {
    static final double LOW_DENSITY_THRESHOLD = 0.2;

    static boolean isApplicableTo(DHistogram h) {
        return h._vals != null && h._isInt != 2 && !h._intOpt;
    }

    static double[] makeSplitPoints(DHistogram h, int targetNBins, double min, double maxEx) {
        int newBins;
        List<BinDescriptor> bins = GuidedSplitPoints.extractNonEmptyBins(h);
        int totalBudget = targetNBins - bins.size() - 2;
        if (bins.isEmpty() || totalBudget <= 0) {
            return null;
        }
        int budgetLeft = totalBudget;
        double totalSE = 0.0;
        for (BinDescriptor bin : bins) {
            totalSE += bin._se;
        }
        int[] newBinCounts = new int[bins.size()];
        Collections.sort(bins);
        for (int b = 0; budgetLeft > 0 && b < newBinCounts.length; budgetLeft -= newBins, ++b) {
            BinDescriptor bin = bins.get(b);
            newBins = Math.min((int)Math.ceil((double)totalBudget * bin._se / totalSE), budgetLeft);
            newBinCounts[b] = newBins;
        }
        double[] customSplitPoints = new double[targetNBins - budgetLeft];
        int i = 0;
        for (int b = 0; b < newBinCounts.length; ++b) {
            BinDescriptor bin = bins.get(b);
            customSplitPoints[i++] = bin._start;
            double stepSize = (bin._end - bin._start) / (double)(1 + newBinCounts[b]);
            for (int s = 0; s < newBinCounts[b]; ++s) {
                customSplitPoints[i] = customSplitPoints[i - 1] + stepSize;
                ++i;
            }
        }
        customSplitPoints[i++] = min;
        customSplitPoints[i++] = h._maxIn;
        assert (i == customSplitPoints.length);
        Arrays.sort(customSplitPoints);
        return ArrayUtils.makeUniqueAndLimitToRange(customSplitPoints, min, maxEx);
    }

    static List<BinDescriptor> extractNonEmptyBins(DHistogram h) {
        int nonEmptyBins = h.nonEmptyBins();
        ArrayList<BinDescriptor> bins = new ArrayList<BinDescriptor>(nonEmptyBins);
        for (int i = 0; i < h.nbins(); ++i) {
            double weight = h.w(i);
            if (!(weight > 0.0)) continue;
            BinDescriptor bin = BinDescriptor.fromBin(h, i);
            bins.add(bin);
        }
        return bins;
    }

    static class BinDescriptor
    implements Comparable<BinDescriptor> {
        final double _start;
        final double _end;
        final double _se;
        final double _weight;

        public BinDescriptor(double start, double end, double se, double weight) {
            this._start = start;
            this._end = end;
            this._se = Math.max(se, 0.0);
            this._weight = weight;
        }

        @Override
        public int compareTo(BinDescriptor o) {
            return -Double.compare(this._se, o._se);
        }

        static BinDescriptor fromBin(DHistogram h, int i) {
            double w = h.w(i);
            double wY = h.wY(i);
            double wYY = h.wYY(i);
            double se = w != 0.0 ? wYY - wY * wY / w : 0.0;
            return new BinDescriptor(h.binAt(i), h.binAt(i + 1), se, w);
        }

        public String toString() {
            return "BinDescriptor{_start=" + this._start + ", _end=" + this._end + ", _se=" + this._se + ", _weight=" + this._weight + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BinDescriptor that = (BinDescriptor)o;
            if (Double.compare(that._start, this._start) != 0) {
                return false;
            }
            if (Double.compare(that._end, this._end) != 0) {
                return false;
            }
            if (Double.compare(that._se, this._se) != 0) {
                return false;
            }
            return Double.compare(that._weight, this._weight) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this._start);
            int result = (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this._end);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this._se);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this._weight);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }
}

