/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.Job;
import water.Key;
import water.Lockable;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

class GlobalQuantilesCalc {
    GlobalQuantilesCalc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double[][] splitPoints(Frame trainFr, String weightsColumn, double[][] priorSplitPoints, int N, int nbins_top_level) {
        int[] frToTrain = new int[trainFr.numCols()];
        Frame fr = GlobalQuantilesCalc.collectColumnsForQuantile(trainFr, weightsColumn, priorSplitPoints, frToTrain);
        double[][] splitPoints = new double[trainFr.numCols()][];
        if (fr.numCols() == 0 || weightsColumn != null && fr.numCols() == 1 && weightsColumn.equals(fr.name(0))) {
            return splitPoints;
        }
        Key tmpFrameKey = Key.make();
        DKV.put(tmpFrameKey, fr);
        Lockable qm = null;
        try {
            QuantileModel.QuantileParameters p = new QuantileModel.QuantileParameters();
            p._train = tmpFrameKey;
            p._weights_column = weightsColumn;
            p._combine_method = QuantileModel.CombineMethod.INTERPOLATE;
            p._probs = new double[N];
            for (int i = 0; i < N; ++i) {
                p._probs[i] = (double)i * 1.0 / (double)N;
            }
            Job job = new Quantile(p).trainModel();
            qm = (QuantileModel)job.get();
            job.remove();
            double[][] origQuantiles = ((QuantileModel.QuantileOutput)((QuantileModel)qm)._output)._quantiles;
            for (int q = 0; q < origQuantiles.length; ++q) {
                if (origQuantiles[q].length <= 1) continue;
                int i = frToTrain[q];
                splitPoints[i] = ArrayUtils.makeUniqueAndLimitToRange(origQuantiles[q], fr.vec(q).min(), fr.vec(q).max());
                splitPoints[i] = (double[])(splitPoints[i].length <= 1 ? null : ArrayUtils.padUniformly(splitPoints[i], nbins_top_level));
                assert (splitPoints[i] == null || splitPoints[i].length > 1);
            }
            double[][] dArrayArray = splitPoints;
            return dArrayArray;
        }
        finally {
            DKV.remove(tmpFrameKey);
            if (qm != null) {
                qm.delete();
            }
        }
    }

    static Frame collectColumnsForQuantile(Frame trainFr, String weightsColumn, double[][] priorSplitPoints, int[] frToTrainMap) {
        Frame fr = new Frame(new Vec[0]);
        int weightsIdx = trainFr.find(weightsColumn);
        for (int i = 0; i < trainFr.numCols(); ++i) {
            if (i != weightsIdx && (priorSplitPoints != null && priorSplitPoints[i] != null || !trainFr.vec(i).isNumeric() || trainFr.vec(i).isCategorical() || trainFr.vec(i).isBinary() || trainFr.vec(i).isConst())) continue;
            frToTrainMap[fr.numCols()] = i;
            fr.add(trainFr.name(i), trainFr.vec(i));
        }
        return fr;
    }
}

