/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.genmodel.utils.DistributionFamily;
import hex.tree.Constraints;
import hex.tree.GlobalInteractionConstraints;
import hex.tree.SharedTreeModel;
import hex.tree.uplift.ChiSquaredDivergence;
import hex.tree.uplift.Divergence;
import hex.tree.uplift.EuclideanDistance;
import hex.tree.uplift.KLDivergence;
import hex.tree.uplift.UpliftDRFModel;
import java.util.Arrays;
import java.util.Random;
import org.apache.log4j.Logger;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.RandomBase;
import water.util.RandomUtils;

public final class DHistogram
extends Iced<DHistogram> {
    private static final Logger LOG = Logger.getLogger(DHistogram.class);
    public static final int INT_NA = Integer.MIN_VALUE;
    public final transient String _name;
    public final double _minSplitImprovement;
    public final byte _isInt;
    public final boolean _intOpt;
    public char _nbin;
    public double _step;
    public final double _min;
    public final double _maxEx;
    public final int _minInt;
    public final boolean _initNA;
    public final double _pred1;
    public final double _pred2;
    protected double[] _vals;
    protected final int _vals_dim;
    protected final boolean _useUplift;
    protected double[] _valsUplift;
    protected final int _valsDimUplift = 4;
    protected final Divergence _upliftMetric;
    private final Distribution _dist;
    protected double _min2;
    protected double _maxIn;
    public SharedTreeModel.SharedTreeParameters.HistogramType _histoType;
    transient double[] _splitPts;
    transient int _zeroSplitPntPos;
    public final boolean _checkFloatSplits;
    transient float[] _splitPtsFloat;
    public final long _seed;
    public transient boolean _absoluteSplitPts;
    public Key<HistoSplitPoints> _globalSplitPointsKey;
    final double[] _customSplitPoints;

    public double w(int i) {
        return this._vals[this._vals_dim * i + 0];
    }

    public double wY(int i) {
        return this._vals[this._vals_dim * i + 1];
    }

    public double wYY(int i) {
        return this._vals[this._vals_dim * i + 2];
    }

    public double wNA() {
        return this._vals[this._vals_dim * this._nbin + 0];
    }

    public double wYNA() {
        return this._vals[this._vals_dim * this._nbin + 1];
    }

    public double wYYNA() {
        return this._vals[this._vals_dim * this._nbin + 2];
    }

    public double[] getRawVals() {
        return this._vals;
    }

    public double seP1NA() {
        return this._vals[this._vals_dim * this._nbin + 3];
    }

    public double seP2NA() {
        return this._vals[this._vals_dim * this._nbin + 4];
    }

    public double denNA() {
        return this._vals[this._vals_dim * this._nbin + 5];
    }

    public double nomNA() {
        return this._vals[this._vals_dim * this._nbin + 6];
    }

    final boolean hasPreds() {
        return this._vals_dim >= 5;
    }

    public double numTreatmentNA() {
        return this._valsUplift[4 * this._nbin];
    }

    public double respTreatmentNA() {
        return this._valsUplift[4 * this._nbin + 1];
    }

    public double numControlNA() {
        return this._valsUplift[4 * this._nbin + 2];
    }

    public double respControlNA() {
        return this._valsUplift[4 * this._nbin + 3];
    }

    final boolean hasDenominator() {
        return this._vals_dim >= 6;
    }

    final boolean hasNominator() {
        return this._vals_dim == 7;
    }

    final boolean useUplift() {
        return this._useUplift;
    }

    DHistogram(String name, int nbins, int nbins_cats, byte isInt, double min, double maxEx, boolean intOpt, boolean initNA, double minSplitImprovement, SharedTreeModel.SharedTreeParameters.HistogramType histogramType, long seed, Key<HistoSplitPoints> globalSplitPointsKey, Constraints cs, boolean checkFloatSplits, boolean useUplift, UpliftDRFModel.UpliftDRFParameters.UpliftMetricType upliftMetricType, double[] customSplitPoints) {
        int xbins;
        assert (nbins >= 1);
        assert (nbins_cats >= 1);
        assert (maxEx > min) : "Caller ensures " + maxEx + ">" + min + ", since if max==min== the column " + name + " is all constants";
        if (cs != null) {
            this._pred1 = cs._min;
            this._pred2 = cs._max;
            this._vals_dim = !cs.needsGammaDenom() && !cs.needsGammaNom() ? (Double.isNaN(this._pred1) && Double.isNaN(this._pred2) ? 3 : 5) : (!cs.needsGammaNom() ? 6 : 7);
            this._dist = cs._dist;
        } else {
            this._pred1 = Double.NaN;
            this._pred2 = Double.NaN;
            this._vals_dim = 3;
            this._dist = null;
        }
        this._isInt = isInt;
        this._name = name;
        this._min = min;
        this._maxEx = maxEx;
        this._min2 = Double.MAX_VALUE;
        this._maxIn = -1.7976931348623157E308;
        this._initNA = initNA;
        this._intOpt = intOpt;
        this._minInt = (int)min;
        this._minSplitImprovement = minSplitImprovement;
        this._histoType = histogramType;
        this._seed = seed;
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin) {
            SharedTreeModel.SharedTreeParameters.HistogramType[] h = SharedTreeModel.SharedTreeParameters.HistogramType.ROUND_ROBIN_CANDIDATES;
            this._histoType = h[(int)Math.abs(seed % (long)h.length)];
        }
        assert (this._histoType != SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin);
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.AUTO) {
            this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
        }
        assert (this._histoType != SharedTreeModel.SharedTreeParameters.HistogramType.RoundRobin);
        this._globalSplitPointsKey = globalSplitPointsKey;
        int n = xbins = isInt == 2 ? nbins_cats : nbins;
        if (isInt > 0 && maxEx - min <= (double)xbins) {
            assert ((double)((long)min) == min) : "Overflow for integer/categorical histogram: minimum value cannot be cast to long without loss: (long)" + min + " != " + min + "!";
            xbins = (char)((long)maxEx - (long)min);
            this._step = 1.0;
        } else {
            this._step = (double)xbins / (maxEx - min);
            if (this._step <= 0.0 || Double.isInfinite(this._step) || Double.isNaN(this._step)) {
                throw new StepOutOfRangeException(name, this._step, xbins, maxEx, min);
            }
        }
        this._nbin = (char)xbins;
        this._useUplift = useUplift;
        if (useUplift) {
            switch (upliftMetricType) {
                case ChiSquared: {
                    this._upliftMetric = new ChiSquaredDivergence();
                    break;
                }
                case Euclidean: {
                    this._upliftMetric = new EuclideanDistance();
                    break;
                }
                default: {
                    this._upliftMetric = new KLDivergence();
                    break;
                }
            }
        } else {
            this._upliftMetric = null;
        }
        assert (this._nbin > '\u0000');
        assert (this._vals == null);
        this._checkFloatSplits = checkFloatSplits;
        this._customSplitPoints = customSplitPoints;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Histogram: " + this);
        }
    }

    public int bin(double col_data) {
        int idx1;
        double pos;
        if (Double.isNaN(col_data)) {
            return this._nbin;
        }
        if (Double.isInfinite(col_data)) {
            if (col_data < 0.0) {
                return 0;
            }
            return this._nbin - '\u0001';
        }
        assert (this._min <= col_data && col_data < this._maxEx) : "Coldata " + col_data + " out of range " + this;
        double d = pos = this._absoluteSplitPts ? col_data : (col_data - this._min) * this._step;
        if (this._splitPts != null) {
            int n = idx1 = pos == 0.0 ? this._zeroSplitPntPos : Arrays.binarySearch(this._splitPts, pos);
            if (idx1 < 0) {
                idx1 = -idx1 - 2;
            }
        } else {
            idx1 = (int)pos;
        }
        if (this._splitPtsFloat != null && idx1 + 1 < this._splitPtsFloat.length) {
            float splitAt = this._splitPtsFloat[idx1 + 1];
            if (col_data >= (double)splitAt) {
                ++idx1;
            }
            if (idx1 > 0 && !(col_data >= (double)this._splitPtsFloat[idx1])) {
                --idx1;
            }
        }
        if (idx1 == this._nbin) {
            --idx1;
        }
        assert (0 <= idx1 && idx1 < this._nbin) : idx1 + " " + this._nbin;
        return idx1;
    }

    public double binAt(int b) {
        if (this._absoluteSplitPts) {
            return this._splitPts[b];
        }
        return this._min + (this._splitPts == null ? (double)b : this._splitPts[b]) / this._step;
    }

    public int nbins() {
        return this._nbin;
    }

    public int actNBins() {
        return this.nbins() + (this.hasNABin() ? 1 : 0);
    }

    public double bins(int b) {
        return this.w(b);
    }

    public int nonEmptyBins() {
        if (this._vals == null) {
            return 0;
        }
        int nonEmpty = 0;
        for (int i = 0; i < this._vals.length - this._vals_dim; i += this._vals_dim) {
            if (!(this._vals[i] > 0.0)) continue;
            ++nonEmpty;
        }
        return nonEmpty;
    }

    public boolean hasNABin() {
        if (this._vals == null) {
            return this._initNA;
        }
        return this.wNA() > 0.0;
    }

    public void init() {
        this.init(null, null);
    }

    public void init(double[] vals) {
        this.init(vals, null);
    }

    public void init(double[] vals, double[] valsUplift) {
        assert (this._vals == null);
        if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.Random) {
            RandomBase rng = RandomUtils.getRNG(Double.doubleToRawLongBits((this._step + 0.324) * this._min + 8.3425 + 89.342 * this._maxEx) + (long)(912559 * this._nbin) + (long)(12648430 * this._isInt) + this._seed);
            assert (this._nbin > '\u0001');
            this._splitPts = DHistogram.makeRandomSplitPoints(this._nbin, rng);
        } else if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.QuantilesGlobal) {
            HistoSplitPoints hq;
            assert (this._splitPts == null);
            if (this._globalSplitPointsKey != null && (hq = (HistoSplitPoints)DKV.getGet(this._globalSplitPointsKey)) != null) {
                this._splitPts = hq.splitPts;
                if (this._splitPts != null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Obtaining global splitPoints: " + Arrays.toString(this._splitPts));
                    }
                    this._splitPts = ArrayUtils.limitToRange(this._splitPts, this._min, this._maxEx);
                    if (hq.canRefine && this._splitPts.length > 1 && this._splitPts.length < this._nbin) {
                        this._splitPts = ArrayUtils.padUniformly(this._splitPts, this._nbin);
                    }
                    if (this._splitPts.length <= 1) {
                        this._splitPts = null;
                        this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
                    } else {
                        this._absoluteSplitPts = true;
                        this._nbin = (char)this._splitPts.length;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Refined splitPoints: " + Arrays.toString(this._splitPts));
                        }
                    }
                }
            }
        } else if (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.UniformRobust) {
            if (this._customSplitPoints != null) {
                this.defineSplitPointsFromCustomSplitPoints(this._customSplitPoints);
            } else {
                this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
            }
        } else assert (this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive);
        if (this._splitPts != null) {
            int nzPos;
            this._zeroSplitPntPos = Arrays.binarySearch(this._splitPts, 0.0);
            if (this._zeroSplitPntPos < 0 && (nzPos = Arrays.binarySearch(this._splitPts, -0.0)) >= 0) {
                this._splitPts[nzPos] = 0.0;
                this._zeroSplitPntPos = nzPos;
            }
        }
        double[] dArray = this._vals = vals == null ? MemoryManager.malloc8d(this._vals_dim * this._nbin + this._vals_dim) : vals;
        if (this.useUplift()) {
            double[] dArray2 = this._valsUplift = valsUplift == null ? MemoryManager.malloc8d(4 * this._nbin + 4) : valsUplift;
        }
        assert (this._nbin > '\u0000');
        if (this._checkFloatSplits) {
            this._splitPtsFloat = new float[this._nbin];
            for (int i = 0; i < this._nbin; ++i) {
                this._splitPtsFloat[i] = (float)this.binAt(i);
            }
        }
        assert (!this._intOpt || this._splitPts == null) : "Integer-optimization cannot be enabled when split points are defined";
        assert (!this._intOpt || this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive || this._histoType == SharedTreeModel.SharedTreeParameters.HistogramType.UniformRobust) : "Integer-optimization can only be enabled for histogram type 'UniformAdaptive' or 'UniformRobust'.";
    }

    void defineSplitPointsFromCustomSplitPoints(double[] customSplitPoints) {
        this._splitPts = customSplitPoints;
        this._splitPts = ArrayUtils.limitToRange(this._splitPts, this._min, this._maxEx);
        if (this._splitPts.length <= 1) {
            this._splitPts = null;
            this._histoType = SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive;
        } else {
            this._absoluteSplitPts = true;
            this._nbin = (char)(this._splitPts.length - 1);
        }
    }

    public void add(DHistogram dsh) {
        assert (this._vals == null || dsh._vals == null || this._isInt == dsh._isInt && this._nbin == dsh._nbin && this._step == dsh._step && this._min == dsh._min && this._maxEx == dsh._maxEx);
        if (dsh._vals == null) {
            return;
        }
        if (this._vals == null) {
            this.init(dsh._vals, dsh._valsUplift);
        } else {
            ArrayUtils.add(this._vals, dsh._vals);
            ArrayUtils.add(this._valsUplift, dsh._valsUplift);
        }
        if (this._min2 > dsh._min2) {
            this._min2 = dsh._min2;
        }
        if (this._maxIn < dsh._maxIn) {
            this._maxIn = dsh._maxIn;
        }
    }

    public double find_min() {
        return this._min2;
    }

    public double find_maxIn() {
        return this._maxIn;
    }

    public double find_maxEx() {
        return DHistogram.find_maxEx(this._maxIn, this._isInt);
    }

    public static double find_maxEx(double maxIn, int isInt) {
        double res;
        double ulp = Math.ulp(maxIn);
        if (isInt > 0 && 1.0 > ulp) {
            ulp = 1.0;
        }
        return Double.isInfinite(res = maxIn + ulp) ? maxIn : res;
    }

    public static DHistogram[] initialHist(Frame fr, int ncols, int nbins, DHistogram[] hs, long seed, SharedTreeModel.SharedTreeParameters parms, Key<HistoSplitPoints>[] globalSplitPointsKey, Constraints cs, boolean checkFloatSplits, GlobalInteractionConstraints ics) {
        Vec[] vecs = fr.vecs();
        for (int c = 0; c < ncols; ++c) {
            long vlen = 0L;
            if (ics != null && !ics.allowedInteractionContainsColumn(c)) {
                hs[c] = null;
            } else {
                double maxIn;
                Vec v = vecs[c];
                double minIn = v.isCategorical() ? 0.0 : Math.max(v.min(), -1.7976931348623157E308);
                double d = maxIn = v.isCategorical() ? (double)(v.domain().length - 1) : Math.min(v.max(), Double.MAX_VALUE);
                double maxEx = v.isCategorical() ? (double)v.domain().length : DHistogram.find_maxEx(maxIn, v.isInt() ? 1 : 0);
                vlen = v.length();
                long nacnt = v.naCnt();
                try {
                    byte type = (byte)(v.isCategorical() ? 2 : (v.isInt() ? 1 : 0));
                    boolean intOpt = DHistogram.useIntOpt(v, parms, cs);
                    hs[c] = nacnt == vlen || v.isConst(true) ? null : DHistogram.make(fr._names[c], nbins, type, minIn, maxEx, intOpt, nacnt > 0L, seed, parms, globalSplitPointsKey[c], cs, checkFloatSplits, null);
                }
                catch (StepOutOfRangeException e) {
                    hs[c] = null;
                    LOG.warn("Column " + fr._names[c] + " with min = " + v.min() + ", max = " + v.max() + " has step out of range (" + e.getMessage() + ") and is ignored.");
                }
            }
            assert (hs[c] == null || vlen > 0L);
        }
        return hs;
    }

    public static DHistogram make(String name, int nbins, byte isInt, double min, double maxEx, boolean intOpt, boolean hasNAs, long seed, SharedTreeModel.SharedTreeParameters parms, Key<HistoSplitPoints> globalSplitPointsKey, Constraints cs, boolean checkFloatSplits, double[] customSplitPoints) {
        boolean useUplift = DHistogram.isUplift(parms);
        UpliftDRFModel.UpliftDRFParameters.UpliftMetricType upliftMetricType = useUplift ? ((UpliftDRFModel.UpliftDRFParameters)parms)._uplift_metric : null;
        return new DHistogram(name, nbins, parms._nbins_cats, isInt, min, maxEx, intOpt, hasNAs, parms._min_split_improvement, parms._histogram_type, seed, globalSplitPointsKey, cs, checkFloatSplits, useUplift, upliftMetricType, customSplitPoints);
    }

    private static boolean isUplift(SharedTreeModel.SharedTreeParameters parms) {
        return parms instanceof UpliftDRFModel.UpliftDRFParameters;
    }

    public static boolean useIntOpt(Vec v, SharedTreeModel.SharedTreeParameters parms, Constraints cs) {
        if (DHistogram.isUplift(parms)) {
            return false;
        }
        if (cs != null) {
            return false;
        }
        if (parms._histogram_type != SharedTreeModel.SharedTreeParameters.HistogramType.AUTO && parms._histogram_type != SharedTreeModel.SharedTreeParameters.HistogramType.UniformAdaptive && parms._histogram_type != SharedTreeModel.SharedTreeParameters.HistogramType.UniformRobust) {
            return false;
        }
        if (v.isCategorical()) {
            return v.domain().length < parms._nbins_cats;
        }
        if (v.isInt()) {
            double min = v.min();
            double max = v.max();
            double intLen = max - min;
            return intLen < (double)parms._nbins && (int)max - (int)min == (int)intLen;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._name).append(":").append(this._min).append("-").append(this._maxEx).append(" step=" + 1.0 / this._step + " nbins=" + this.nbins() + " actNBins=" + this.actNBins() + " isInt=" + this._isInt);
        if (this._vals != null) {
            for (int b = 0; b < this._nbin; ++b) {
                sb.append(String.format("\ncnt=%f, [%f - %f], mean/var=", this.w(b), this._min + (double)b / this._step, this._min + (double)(b + '\u0001') / this._step));
                sb.append(String.format("%6.2f/%6.2f,", this.mean(b), this.var(b)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    double mean(int b) {
        double n = this.w(b);
        return n > 0.0 ? this.wY(b) / n : 0.0;
    }

    public double var(int b) {
        double n = this.w(b);
        if (n <= 1.0) {
            return 0.0;
        }
        return Math.max(0.0, (this.wYY(b) - this.wY(b) * this.wY(b) / n) / (n - 1.0));
    }

    void updateHisto(double[] ws, double[] resp, Object cs, double[] ys, double[] preds, int[] rows, int hi, int lo, double[] treatment) {
        if (this._intOpt) {
            assert (treatment == null) : "Integer-optimized histograms cannot be used when treatment is provided";
            this.updateHistoInt(ws, (int[])cs, ys, rows, hi, lo);
        } else {
            this.updateHisto(ws, resp, (double[])cs, ys, preds, rows, hi, lo, treatment);
        }
    }

    void updateHisto(double[] ws, double[] resp, double[] cs, double[] ys, double[] preds, int[] rows, int hi, int lo, double[] treatment) {
        for (int r = lo; r < hi; ++r) {
            int binDimStartUplift;
            double weight;
            int k = rows[r];
            double d = weight = ws == null ? 1.0 : ws[k];
            if (weight == 0.0) continue;
            double col_data = cs[k];
            if (col_data < this._min2) {
                this._min2 = col_data;
            }
            if (col_data > this._maxIn) {
                this._maxIn = col_data;
            }
            double y = ys[r];
            double wy = weight * y;
            double wyy = wy * y;
            int b = this.bin(col_data);
            int binDimStart = this._vals_dim * b;
            int n = binDimStart + 0;
            this._vals[n] = this._vals[n] + weight;
            int n2 = binDimStart + 1;
            this._vals[n2] = this._vals[n2] + wy;
            int n3 = binDimStart + 2;
            this._vals[n3] = this._vals[n3] + wyy;
            if (this._vals_dim >= 5 && !Double.isNaN(resp[k])) {
                if (this._dist._family.equals((Object)DistributionFamily.quantile)) {
                    int n4 = binDimStart + 3;
                    this._vals[n4] = this._vals[n4] + this._dist.deviance(weight, y, this._pred1);
                    int n5 = binDimStart + 4;
                    this._vals[n5] = this._vals[n5] + this._dist.deviance(weight, y, this._pred2);
                } else {
                    int n6 = binDimStart + 3;
                    this._vals[n6] = this._vals[n6] + weight * (this._pred1 - y) * (this._pred1 - y);
                    int n7 = binDimStart + 4;
                    this._vals[n7] = this._vals[n7] + weight * (this._pred2 - y) * (this._pred2 - y);
                }
                if (this._vals_dim >= 6) {
                    int n8 = binDimStart + 5;
                    this._vals[n8] = this._vals[n8] + this._dist.gammaDenom(weight, resp[k], y, preds[k]);
                    if (this._vals_dim == 7) {
                        int n9 = binDimStart + 6;
                        this._vals[n9] = this._vals[n9] + this._dist.gammaNum(weight, resp[k], y, preds[k]);
                    }
                }
            }
            if (!this._useUplift) continue;
            double t = treatment[k];
            double rs = resp[k];
            int n10 = binDimStartUplift = 4 * b;
            this._valsUplift[n10] = this._valsUplift[n10] + t;
            int n11 = binDimStartUplift + 1;
            this._valsUplift[n11] = this._valsUplift[n11] + t * rs;
            int n12 = binDimStartUplift + 2;
            this._valsUplift[n12] = this._valsUplift[n12] + (1.0 - t);
            int n13 = binDimStartUplift + 3;
            this._valsUplift[n13] = this._valsUplift[n13] + (1.0 - t) * rs;
        }
    }

    void updateHistoInt(double[] ws, int[] cs, double[] ys, int[] rows, int hi, int lo) {
        int min2_int = this._min2 == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)this._min2;
        int maxIn_int = this._maxIn == -4.9E-324 ? Integer.MIN_VALUE : (int)this._maxIn;
        for (int r = lo; r < hi; ++r) {
            int b;
            double weight;
            int k = rows[r];
            double d = weight = ws == null ? 1.0 : ws[k];
            if (weight == 0.0) continue;
            int col_data = cs[k];
            if (col_data != Integer.MIN_VALUE) {
                if (col_data < min2_int) {
                    min2_int = col_data;
                }
                if (col_data > maxIn_int) {
                    maxIn_int = col_data;
                }
                b = col_data - this._minInt;
            } else {
                b = this._nbin;
            }
            double y = ys[r];
            double wy = weight * y;
            double wyy = wy * y;
            int binDimStart = this._vals_dim * b;
            int n = binDimStart + 0;
            this._vals[n] = this._vals[n] + weight;
            int n2 = binDimStart + 1;
            this._vals[n2] = this._vals[n2] + wy;
            int n3 = binDimStart + 2;
            this._vals[n3] = this._vals[n3] + wyy;
        }
        this._min2 = min2_int;
        this._maxIn = maxIn_int;
    }

    Object extractData(Chunk chk, Object cache, int len, int maxChunkSz) {
        if (cache == null) {
            cache = this._intOpt ? (Object)MemoryManager.malloc4(maxChunkSz) : (Object)MemoryManager.malloc8d(maxChunkSz);
        }
        if (this._intOpt) {
            chk.getIntegers((int[])cache, 0, len, Integer.MIN_VALUE);
        } else {
            chk.getDoubles((double[])cache, 0, len);
        }
        return cache;
    }

    public void reducePrecision() {
        if (this._vals == null) {
            return;
        }
        for (int i = 0; i < this._vals.length; i += this._vals_dim) {
            this._vals[i + 1] = (float)this._vals[i + 1];
            this._vals[i + 2] = (float)this._vals[i + 2];
        }
    }

    static double[] makeRandomSplitPoints(int nbin, Random rng) {
        double[] splitPts = new double[nbin];
        splitPts[0] = 0.0;
        for (int i = 1; i < nbin; ++i) {
            splitPts[i] = rng.nextFloat() * (float)nbin;
        }
        Arrays.sort(splitPts);
        return splitPts;
    }

    static class StepOutOfRangeException
    extends RuntimeException {
        public StepOutOfRangeException(String name, double step, int xbins, double maxEx, double min) {
            super("column=" + name + " leads to invalid histogram(check numeric range) -> [max=" + maxEx + ", min = " + min + "], step= " + step + ", xbin= " + xbins);
        }
    }

    static class HistoSplitPoints
    extends Keyed<HistoSplitPoints> {
        boolean canRefine;
        double[] splitPts;

        public HistoSplitPoints(Key<HistoSplitPoints> key, double[] splitPts) {
            this(key, splitPts, true);
        }

        public HistoSplitPoints(Key<HistoSplitPoints> key, double[] splitPts, boolean canRefine) {
            super(key);
            this.splitPts = splitPts;
            this.canRefine = canRefine;
        }
    }

    public static enum NASplitDir {
        None(0),
        NAvsREST(1),
        NALeft(2),
        NARight(3),
        Left(4),
        Right(5);

        private final int value;

        private NASplitDir(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

