/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.Distribution;
import hex.genmodel.utils.DistributionFamily;
import water.Iced;

public class Constraints
extends Iced<Constraints> {
    private final int[] _cs;
    final double _min;
    final double _max;
    public final Distribution _dist;
    private final boolean _use_bounds;

    public Constraints(int[] cs, Distribution dist, boolean useBounds) {
        this(cs, dist, useBounds, Double.NaN, Double.NaN);
    }

    private Constraints(int[] cs, Distribution dist, boolean useBounds, double min, double max) {
        this._cs = cs;
        this._min = min;
        this._max = max;
        this._dist = dist;
        this._use_bounds = useBounds;
    }

    public int getColumnConstraint(int col) {
        return this._cs[col];
    }

    Constraints withNewConstraint(int col, int way, double bound) {
        assert (this._cs[col] == 1 || this._cs[col] == -1);
        if (this._cs[col] == 1) {
            if (way == 0) {
                return new Constraints(this._cs, this._dist, this._use_bounds, this._min, Constraints.newMaxBound(this._max, bound));
            }
            return new Constraints(this._cs, this._dist, this._use_bounds, Constraints.newMinBound(this._min, bound), this._max);
        }
        if (way == 0) {
            return new Constraints(this._cs, this._dist, this._use_bounds, Constraints.newMinBound(this._min, bound), this._max);
        }
        return new Constraints(this._cs, this._dist, this._use_bounds, this._min, Constraints.newMaxBound(this._max, bound));
    }

    public boolean useBounds() {
        return this._use_bounds;
    }

    private static double newMaxBound(double old_max, double proposed_max) {
        if (Double.isNaN(old_max)) {
            return proposed_max;
        }
        assert (!Double.isNaN(proposed_max));
        return Math.min(old_max, proposed_max);
    }

    private static double newMinBound(double old_min, double proposed_min) {
        if (Double.isNaN(old_min)) {
            return proposed_min;
        }
        assert (!Double.isNaN(proposed_min));
        return Math.max(old_min, proposed_min);
    }

    boolean needsGammaDenom() {
        return !this._dist._family.equals((Object)DistributionFamily.gaussian) && !this._dist._family.equals((Object)DistributionFamily.quantile);
    }

    boolean needsGammaNom() {
        return this._dist._family.equals((Object)DistributionFamily.tweedie);
    }
}

