/*
 * Decompiled with CFR 0.152.
 */
package hex.tree;

import hex.tree.GlobalInteractionConstraints;
import water.Iced;
import water.util.IcedHashSet;
import water.util.IcedInt;

public class BranchInteractionConstraints
extends Iced<BranchInteractionConstraints> {
    IcedHashSet<IcedInt> allowedInteractionIndices;

    public BranchInteractionConstraints(IcedHashSet<IcedInt> allowedInteractionIndices) {
        this.allowedInteractionIndices = allowedInteractionIndices;
    }

    public boolean isAllowedIndex(int i) {
        return this.allowedInteractionIndices.contains(new IcedInt(i));
    }

    public IcedHashSet<IcedInt> intersection(IcedHashSet<IcedInt> set) {
        IcedHashSet<IcedInt> output = new IcedHashSet<IcedInt>();
        for (IcedInt i : set) {
            if (!this.allowedInteractionIndices.contains(i)) continue;
            output.add(i);
        }
        return output;
    }

    public BranchInteractionConstraints nextLevelInteractionConstraints(GlobalInteractionConstraints ics, int colIndex) {
        assert (ics != null) : "Interaction constraints: Global interaction constraints object cannot be null.";
        assert (ics.allowedInteractionContainsColumn(colIndex)) : "Input column index should be in the allowed interaction map.";
        assert (this.allowedInteractionIndices != null) : "Interaction constraints: Branch allowed interaction set cannot be null.";
        IcedHashSet<IcedInt> allowedInteractions = ics.getAllowedInteractionForIndex(colIndex);
        IcedHashSet<IcedInt> intersection = this.intersection(allowedInteractions);
        return new BranchInteractionConstraints(intersection);
    }
}

