/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.hglm.HGLMModel;
import hex.schemas.HGLMV3;
import java.util.Arrays;
import water.api.API;
import water.api.schemas3.ModelOutputSchemaV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class HGLMModelV3
extends ModelSchemaV3<HGLMModel, HGLMModelV3, HGLMModel.HGLMParameters, HGLMV3.HGLMParametersV3, HGLMModel.HGLMModelOutput, HGLMModelOutputV3> {
    public static TwoDimTable generateCoeffTable(String title1, String title2, double[] coeffs, String[] coeffNames) {
        String[] colnames = new String[]{"coefficients"};
        String[] colFormats = new String[]{"%.5f"};
        String[] colTypes = new String[]{"double"};
        TwoDimTable tdt = new TwoDimTable(title1, title2, coeffNames, colnames, colTypes, colFormats, "names");
        int tableLen = coeffs.length;
        for (int index = 0; index < tableLen; ++index) {
            tdt.set(index, 0, coeffs[index]);
        }
        return tdt;
    }

    public static TwoDimTable generate2DCoeffTable(String title1, String title2, double[][] coeffs, String[] coeffNames, String[] level2Domain) {
        int numLevel2Index = level2Domain.length;
        String[] coeffNamesUsed = coeffNames;
        double[][] coeffsUsed = coeffs;
        double[] fCoeffValues = ArrayUtils.flattenArray(coeffsUsed);
        String[] fCoeffNames = HGLMModelV3.extendCoeffNames(coeffNamesUsed, numLevel2Index);
        String[] fLevel2Vals = HGLMModelV3.extendLevel2Ind(level2Domain, coeffsUsed[0].length);
        String[] colnames = new String[]{"coefficient names", "coefficients"};
        String[] colFormats = new String[]{"%s", "%.5f"};
        String[] colTypes = new String[]{"string", "double"};
        TwoDimTable tdt = new TwoDimTable(title1, title2, fLevel2Vals, colnames, colTypes, colFormats, "names");
        int tableLen = fCoeffNames.length;
        for (int index = 0; index < tableLen; ++index) {
            tdt.set(index, 0, fCoeffNames[index]);
            tdt.set(index, 1, fCoeffValues[index]);
        }
        return tdt;
    }

    public static String[] extendLevel2Ind(String[] level2Domain, int numCoeff) {
        int levelIndNum = level2Domain.length;
        String[][] extendedDomain = new String[levelIndNum][numCoeff];
        int extendLen = extendedDomain.length;
        for (int index = 0; index < extendLen; ++index) {
            Arrays.fill(extendedDomain[index], level2Domain[index]);
        }
        return ArrayUtils.flattenArray(extendedDomain);
    }

    public static String[] extendCoeffNames(String[] coeffNames, int numLevel2Ind) {
        int numCoeff = coeffNames.length;
        String[] extendedCoeffNames = new String[numCoeff * numLevel2Ind];
        for (int index = 0; index < numLevel2Ind; ++index) {
            int indexStart = index * numCoeff;
            System.arraycopy(coeffNames, 0, extendedCoeffNames, indexStart, numCoeff);
        }
        return extendedCoeffNames;
    }

    @Override
    public HGLMV3.HGLMParametersV3 createParametersSchema() {
        return new HGLMV3.HGLMParametersV3();
    }

    @Override
    public HGLMModelOutputV3 createOutputSchema() {
        return new HGLMModelOutputV3();
    }

    @Override
    public HGLMModel createImpl() {
        HGLMModel.HGLMParameters parms = (HGLMModel.HGLMParameters)((HGLMV3.HGLMParametersV3)this.parameters).createImpl();
        return new HGLMModel(this.model_id.key(), parms, null);
    }

    public static final class HGLMModelOutputV3
    extends ModelOutputSchemaV3<HGLMModel.HGLMModelOutput, HGLMModelOutputV3> {
        @API(help="Table of Fixed Coefficients")
        TwoDimTableV3 coefficients_table;
        @API(help="Table of Random Coefficients")
        TwoDimTableV3 random_coefficients_table;
        @API(help="Table of Scoring History for Validation Dataset")
        TwoDimTableV3 scoring_history_valid;
        @API(help="Fixed Effects Coefficient Names")
        public String[] coefficient_names;
        @API(help="Random Effects Coefficient Names")
        public String[] random_coefficient_names;
        @API(help="Level 2 Indice Names")
        public String[] group_column_names;
        @API(help="Fixed Effects Coefficients")
        public double[] beta;
        @API(help="Random Effects Coefficients")
        public double[][] ubeta;
        @API(help="Covariance Matrix for Random Effects (= Tj in section II.I of the doc")
        public double[][] tmat;
        @API(help="Ratio of each random effect variance and (sum of all random effect variances plus the residual noise variance).")
        double[] icc;
        @API(help="Residual noise variance")
        double residual_variance;
        @API(help="Mean residual error with fixed effect coefficients only")
        double mean_residual_fixed;
        @API(help="Mean residual error with fixed effect coefficients only")
        double mean_residual_fixed_valid;

        @Override
        public HGLMModelOutputV3 fillFromImpl(HGLMModel.HGLMModelOutput impl) {
            super.fillFromImpl(impl);
            this.coefficient_names = impl._fixed_coefficient_names;
            this.random_coefficient_names = impl._random_coefficient_names;
            this.group_column_names = impl._group_column_names;
            this.beta = impl._beta;
            this.ubeta = impl._ubeta;
            this.coefficients_table = new TwoDimTableV3();
            this.coefficients_table.fillFromImpl(HGLMModelV3.generateCoeffTable("fixed effect oefficients", "HGLM fixed effect coefficients", this.beta, this.coefficient_names));
            this.random_coefficients_table = new TwoDimTableV3();
            this.random_coefficients_table.fillFromImpl(HGLMModelV3.generate2DCoeffTable("random effect coefficients", "HGLM random effect coefficients", this.ubeta, this.random_coefficient_names, impl._group_column_names));
            this.icc = impl._icc;
            this.residual_variance = impl._tau_e_var;
            this.mean_residual_fixed = impl._yMinusFixPredSquare / (double)impl._nobs;
            if (impl._nobs_valid > 0) {
                this.mean_residual_fixed_valid = impl._yMinusFixPredSquareValid / (double)impl._nobs_valid;
            }
            return this;
        }
    }
}

