/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.glm.GLMModel;
import hex.schemas.GLMV3;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import water.MemoryManager;
import water.api.API;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelOutputSchemaV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class GLMModelV3
extends ModelSchemaV3<GLMModel, GLMModelV3, GLMModel.GLMParameters, GLMV3.GLMParametersV3, GLMModel.GLMOutput, GLMModelOutputV3> {
    public static void calculateVarimpBase(double[] magnitudes, int[] indices, double[] betaNorm) {
        for (int i = 0; i < magnitudes.length; ++i) {
            magnitudes[i] = (float)betaNorm[i];
            if (!(magnitudes[i] < 0.0)) continue;
            int n = i;
            magnitudes[n] = magnitudes[n] * -1.0;
        }
        ArrayUtils.sort(indices, magnitudes, -1, -1);
    }

    @Override
    public GLMV3.GLMParametersV3 createParametersSchema() {
        return new GLMV3.GLMParametersV3();
    }

    @Override
    public GLMModelOutputV3 createOutputSchema() {
        return new GLMModelOutputV3();
    }

    @Override
    public GLMModel createImpl() {
        GLMModel.GLMParameters parms = (GLMModel.GLMParameters)((GLMV3.GLMParametersV3)this.parameters).createImpl();
        return new GLMModel(this.model_id.key(), parms, null, new double[]{0.0}, 0.0, 0.0, 0L);
    }

    public static final class GLMModelOutputV3
    extends ModelOutputSchemaV3<GLMModel.GLMOutput, GLMModelOutputV3> {
        @API(help="Table of Coefficients")
        TwoDimTableV3 coefficients_table;
        @API(help="Table of Coefficients with coefficients denoted with class names for GLM multinonimals only.")
        TwoDimTableV3 coefficients_table_multinomials_with_class_names;
        @API(help="Standardized Coefficient Magnitudes")
        TwoDimTableV3 standardized_coefficient_magnitudes;
        @API(help="Variable Importances", direction=API.Direction.OUTPUT, level=API.Level.secondary)
        TwoDimTableV3 variable_importances;
        @API(help="Lambda minimizing the objective value, only applicable with lambda search or when arrays of alpha and lambdas are provided")
        double lambda_best;
        @API(help="Alpha minimizing the objective value, only applicable when arrays of alphas are given ")
        double alpha_best;
        @API(help="submodel index minimizing the objective value, only applicable for arrays of alphas/lambda ")
        int best_submodel_index;
        @API(help="Lambda best + 1 standard error. Only applicable with lambda search and cross-validation")
        double lambda_1se;
        @API(help="Minimum lambda value calculated that may be used for lambda search.  Early-stop may happen and the minimum lambda value will not be used in this case.")
        double lambda_min;
        @API(help="Starting lambda value used when lambda search is enabled.")
        double lambda_max;
        @API(help="Dispersion parameter, only applicable to Tweedie family (input/output) and fractional Binomial (output only)")
        double dispersion;
        @API(help="Predictor names where variable inflation factors are calculated.")
        String[] vif_predictor_names;
        @API(help="GLM model coefficients names.")
        String[] coefficient_names;
        @API(help="predictor variable inflation factors.")
        double[] variable_inflation_factors;
        @API(help="Beta (if exists) and linear constraints states")
        String[] linear_constraint_states;
        @API(help="Table of beta (if exists) and linear constraints values and status")
        TwoDimTableV3 linear_constraints_table;
        @API(help="Contains the original dataset and the dfbetas calculated for each predictor.")
        KeyV3.FrameKeyV3 regression_influence_diagnostics;
        @API(help="True if all constraints conditions are satisfied.  Otherwise, false.")
        boolean all_constraints_satisfied;

        private GLMModelOutputV3 fillMultinomial(GLMModel.GLMOutput impl) {
            if (impl.get_global_beta_multinomial() == null) {
                return this;
            }
            String[] names = (String[])impl.coefficientNames().clone();
            int len = names.length - 1;
            String[] names2 = new String[len];
            int[] indices = new int[len];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            String[] ns = ArrayUtils.append(new String[]{"Intercept"}, Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableV3();
            if (impl.nclasses() > 2) {
                this.coefficients_table_multinomials_with_class_names = new TwoDimTableV3();
            }
            int n = impl.nclasses();
            String[] cols = impl.hasVIF() ? new String[2 * n + 1] : new String[n * 2];
            String[] cols2 = null;
            if (n > 2) {
                cols2 = impl.hasVIF() ? new String[n * 2 + 1] : new String[n * 2];
                String[] classNames = impl._domains[impl.responseIdx()];
                for (int i = 0; i < n; ++i) {
                    cols2[i] = "coefs_class_" + classNames[i];
                    cols2[n + i] = "std_coefs_class_" + classNames[i];
                }
                if (impl.hasVIF()) {
                    cols2[2 * n] = "variable_inflation_factor";
                }
            }
            for (int i = 0; i < n; ++i) {
                cols[i] = "coefs_class_" + i;
                cols[n + i] = "std_coefs_class_" + i;
            }
            if (impl.hasVIF()) {
                cols[2 * n] = "variable_inflation_factor";
            }
            Object[] colTypes = new String[cols.length];
            Arrays.fill(colTypes, "double");
            Object[] colFormats = new String[cols.length];
            Arrays.fill(colFormats, "%5f");
            double[][] betaNorm = impl.getNormBetaMultinomial();
            if (betaNorm != null) {
                int i;
                TwoDimTable tdt = new TwoDimTable("Coefficients", "glm multinomial coefficients", ns, cols, (String[])colTypes, (String[])colFormats, "names");
                for (int c = 0; c < n; ++c) {
                    double[] beta = impl.get_global_beta_multinomial()[c];
                    tdt.set(0, c, beta[beta.length - 1]);
                    tdt.set(0, n + c, betaNorm[c][beta.length - 1]);
                    for (int i2 = 0; i2 < beta.length - 1; ++i2) {
                        tdt.set(i2 + 1, c, beta[i2]);
                        tdt.set(i2 + 1, n + c, betaNorm[c][i2]);
                    }
                }
                if (impl.hasVIF()) {
                    List vifPredictors = Stream.of(impl.getVIFPredictorNames()).collect(Collectors.toList());
                    double[] varInFactors = impl.variableInflationFactors();
                    for (int row = 0; row < ns.length; ++row) {
                        if (vifPredictors.contains(ns[row])) {
                            int index = vifPredictors.indexOf(ns[row]);
                            tdt.set(row, 2 * n, varInFactors[index]);
                            continue;
                        }
                        tdt.set(row, 2 * n, Double.NaN);
                    }
                }
                this.coefficients_table.fillFromImpl(tdt);
                if (n > 2) {
                    this.coefficients_table_multinomials_with_class_names.fillFromImpl(tdt);
                    this.revertCoeffNames(cols2, n, this.coefficients_table_multinomials_with_class_names);
                }
                double[] magnitudes = new double[betaNorm[0].length];
                GLMModelOutputV3.calculateVarimpMultinomial(magnitudes, indices, betaNorm);
                for (i = 0; i < len; ++i) {
                    names2[i] = names[indices[i]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i = 0; i < magnitudes.length - 1; ++i) {
                    tdt.set(i, 0, magnitudes[indices[i]]);
                    tdt.set(i, 1, "POS");
                }
                this.standardized_coefficient_magnitudes = new TwoDimTableV3();
                this.standardized_coefficient_magnitudes.fillFromImpl(tdt);
            }
            return this;
        }

        public static void calculateVarimpMultinomial(double[] magnitudes, int[] indices, double[][] betaNorm) {
            for (int i = 0; i < betaNorm.length; ++i) {
                for (int j = 0; j < betaNorm[i].length; ++j) {
                    double d = betaNorm[i][j];
                    int n = j;
                    magnitudes[n] = magnitudes[n] + (d < 0.0 ? -d : d);
                }
            }
            ArrayUtils.sort(indices, magnitudes, -1, -1);
        }

        public void revertCoeffNames(String[] colNames, int nclass, TwoDimTableV3 coeffs_table) {
            String newName;
            coeffs_table.name = newName = coeffs_table.name + " with class names";
            boolean bothCoeffStd = colNames.length == 2 * nclass;
            for (int tableIndex = 1; tableIndex <= nclass; ++tableIndex) {
                coeffs_table.columns[tableIndex].name = colNames[tableIndex - 1];
                if (!bothCoeffStd) continue;
                coeffs_table.columns[tableIndex + nclass].name = colNames[tableIndex - 1 + nclass];
            }
        }

        @Override
        public GLMModelOutputV3 fillFromImpl(GLMModel.GLMOutput impl) {
            int i;
            int[] indices;
            List validVIFNames;
            super.fillFromImpl(impl);
            this.lambda_1se = impl.lambda_1se();
            this.lambda_best = impl.lambda_best();
            this.alpha_best = impl.alpha_best();
            this.best_submodel_index = impl.bestSubmodelIndex();
            this.dispersion = impl.dispersion();
            this.coefficient_names = (String[])impl.coefficientNames().clone();
            if (impl._linear_constraint_states != null) {
                this.linear_constraint_states = (String[])impl._linear_constraint_states.clone();
            }
            this.variable_inflation_factors = impl.getVariableInflationFactors();
            this.vif_predictor_names = impl.hasVIF() ? impl.getVIFPredictorNames() : null;
            List list = validVIFNames = impl.hasVIF() ? Stream.of(this.vif_predictor_names).collect(Collectors.toList()) : null;
            if (impl._multinomial || impl._ordinal) {
                return this.fillMultinomial(impl);
            }
            String[] names = (String[])impl.coefficientNames().clone();
            String[] ns = ArrayUtils.append(new String[]{"Intercept"}, Arrays.copyOf(names, names.length - 1));
            this.coefficients_table = new TwoDimTableV3();
            double[] beta = impl.beta();
            double[] magnitudes = beta == null ? null : new double[beta.length];
            int len = beta == null ? 0 : magnitudes.length - 1;
            int[] nArray = indices = beta == null ? null : new int[len];
            if (beta != null) {
                for (int i2 = 0; i2 < indices.length; ++i2) {
                    indices[i2] = i2;
                }
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d(names.length);
            }
            String[] colTypes = new String[]{"double"};
            String[] colFormats = new String[]{"%5f"};
            String[] colnames = new String[]{"Coefficients"};
            if (impl.hasPValues()) {
                if (impl.hasVIF()) {
                    colTypes = new String[]{"double", "double", "double", "double", "double"};
                    colFormats = new String[]{"%5f", "%5f", "%5f", "%5f", "%5f"};
                    colnames = new String[]{"Coefficients", "Std. Error", "z value", "p value", "variable_inflation_factor"};
                } else {
                    colTypes = new String[]{"double", "double", "double", "double"};
                    colFormats = new String[]{"%5f", "%5f", "%5f", "%5f"};
                    colnames = new String[]{"Coefficients", "Std. Error", "z value", "p value"};
                }
            } else if (impl.hasVIF()) {
                colTypes = new String[]{"double", "double"};
                colFormats = new String[]{"%5f", "%5f"};
                colnames = new String[]{"Coefficients", "variable_inflation_factor"};
            }
            int stdOff = colnames.length;
            colTypes = ArrayUtils.append(colTypes, "double");
            colFormats = ArrayUtils.append(colFormats, "%5f");
            colnames = ArrayUtils.append(colnames, "Standardized Coefficients");
            TwoDimTable tdt = new TwoDimTable("Coefficients", "glm coefficients", ns, colnames, colTypes, colFormats, "names");
            tdt.set(0, 0, beta[beta.length - 1]);
            for (int i3 = 0; i3 < beta.length - 1; ++i3) {
                tdt.set(i3 + 1, 0, beta[i3]);
            }
            double[] norm_beta = null;
            if (impl.beta() != null) {
                norm_beta = impl.getNormBeta();
                tdt.set(0, stdOff, norm_beta[norm_beta.length - 1]);
                for (i = 0; i < norm_beta.length - 1; ++i) {
                    tdt.set(i + 1, stdOff, norm_beta[i]);
                }
            }
            if (impl.hasPValues()) {
                int i4;
                double[] stdErr = impl.stdErr();
                double[] zVals = impl.zValues();
                double[] pVals = impl.pValues();
                tdt.set(0, 1, stdErr[stdErr.length - 1]);
                tdt.set(0, 2, zVals[zVals.length - 1]);
                tdt.set(0, 3, pVals[pVals.length - 1]);
                for (i4 = 0; i4 < stdErr.length - 1; ++i4) {
                    tdt.set(i4 + 1, 1, stdErr[i4]);
                    tdt.set(i4 + 1, 2, zVals[i4]);
                    tdt.set(i4 + 1, 3, pVals[i4]);
                }
                if (impl.hasVIF()) {
                    for (i4 = 0; i4 < stdErr.length; ++i4) {
                        if (validVIFNames.contains(ns[i4])) {
                            int index = validVIFNames.indexOf(ns[i4]);
                            tdt.set(i4, 4, this.variable_inflation_factors[index]);
                            continue;
                        }
                        tdt.set(i4, 4, Double.NaN);
                    }
                }
            } else if (impl.hasVIF()) {
                for (i = 0; i < ns.length; ++i) {
                    if (validVIFNames.contains(ns[i])) {
                        int index = validVIFNames.indexOf(ns[i]);
                        tdt.set(i, 1, this.variable_inflation_factors[index]);
                        continue;
                    }
                    tdt.set(i, 1, Double.NaN);
                }
            }
            this.coefficients_table.fillFromImpl(tdt);
            if (impl.beta() != null) {
                int i5;
                GLMModelV3.calculateVarimpBase(magnitudes, indices, impl.getNormBeta());
                String[] names2 = new String[len];
                for (i5 = 0; i5 < len; ++i5) {
                    names2[i5] = names[indices[i5]];
                }
                tdt = new TwoDimTable("Standardized Coefficient Magnitudes", "standardized coefficient magnitudes", names2, new String[]{"Coefficients", "Sign"}, new String[]{"double", "string"}, new String[]{"%5f", "%s"}, "names");
                for (i5 = 0; i5 < beta.length - 1; ++i5) {
                    tdt.set(i5, 0, magnitudes[indices[i5]]);
                    tdt.set(i5, 1, beta[indices[i5]] < 0.0 ? "NEG" : "POS");
                }
                this.standardized_coefficient_magnitudes = new TwoDimTableV3();
                this.standardized_coefficient_magnitudes.fillFromImpl(tdt);
            }
            return this;
        }
    }
}

