/*
 * Decompiled with CFR 0.152.
 */
package hex.psvm.psvm;

import hex.psvm.psvm.LLMatrix;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class MatrixUtils {
    public static LLMatrix productMtDM(Frame m, Vec diagonal) {
        Vec[] vecs = ArrayUtils.append(m.vecs(), diagonal);
        double[] result = ((ProductMMTask)new ProductMMTask().doAll(vecs))._result;
        LLMatrix product = new LLMatrix(m.numCols());
        int pos = 0;
        for (int i = 0; i < m.numCols(); ++i) {
            for (int j = 0; j <= i; ++j) {
                product.set(i, j, result[pos++]);
            }
        }
        return product;
    }

    public static double[] productMtv(Frame m, Vec v) {
        Vec[] vecs = ArrayUtils.append(m.vecs(), v);
        return ((ProductMtvTask)new ProductMtvTask().doAll(vecs))._result;
    }

    static class ProductMtvTask
    extends MRTask<ProductMtvTask> {
        private double[] _result;

        ProductMtvTask() {
        }

        @Override
        public void map(Chunk[] cs) {
            int column = cs.length - 1;
            Chunk v = cs[column];
            this._result = new double[column];
            for (int j = 0; j < column; ++j) {
                double sum = 0.0;
                for (int i = 0; i < cs[0]._len; ++i) {
                    sum += cs[j].atd(i) * v.atd(i);
                }
                this._result[j] = sum;
            }
        }

        @Override
        public void reduce(ProductMtvTask mrt) {
            ArrayUtils.add(this._result, mrt._result);
        }
    }

    private static class ProductMMTask
    extends MRTask<ProductMMTask> {
        private double[] _result;

        private ProductMMTask() {
        }

        @Override
        public void map(Chunk[] cs) {
            int column = cs.length - 1;
            Chunk diagonal = cs[column];
            this._result = new double[(column + 1) * column / 2];
            double[] buff = new double[cs[0]._len];
            int offset = 0;
            for (int i = 0; i < column; ++i) {
                offset += i;
                for (int p = 0; p < buff.length; ++p) {
                    buff[p] = cs[i].atd(p) * diagonal.atd(p);
                }
                for (int j = 0; j <= i; ++j) {
                    double sum = 0.0;
                    for (int p = 0; p < buff.length; ++p) {
                        sum += buff[p] * cs[j].atd(p);
                    }
                    this._result[offset + j] = sum;
                }
            }
        }

        @Override
        public void reduce(ProductMMTask mrt) {
            ArrayUtils.add(this._result, mrt._result);
        }
    }
}

