/*
 * Decompiled with CFR 0.152.
 */
package hex.pca.jama;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import hex.pca.PCAInterface;

public class PCAJama
implements PCAInterface {
    private Matrix gramMatrix;
    private SingularValueDecomposition svd;
    private double[][] rightEigenvectors;

    public PCAJama(double[][] gramMatrix) {
        this.gramMatrix = new Matrix(gramMatrix);
        this.runSVD();
    }

    @Override
    public double[] getVariances() {
        return this.svd.getSingularValues();
    }

    @Override
    public double[][] getPrincipalComponents() {
        return this.rightEigenvectors;
    }

    private void runSVD() {
        this.svd = this.gramMatrix.svd();
        this.rightEigenvectors = this.svd.getV().getArray();
    }
}

