/*
 * Decompiled with CFR 0.152.
 */
package hex.modelselection;

import hex.DataInfo;
import hex.Model;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.gram.Gram;
import hex.modelselection.ModelSelectionModel;
import hex.modelselection.ModelSelectionTasks;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.DKV;
import water.Key;
import water.Lockable;
import water.MemoryManager;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class ModelSelectionUtils {
    public static Frame[] generateTrainingFrames(ModelSelectionModel.ModelSelectionParameters parms, int predNum, String[] predNames, int numModels, String foldColumn) {
        int maxPredNum = predNames.length;
        Frame[] trainFrames = new Frame[numModels];
        int[] predIndices = IntStream.range(0, predNum).toArray();
        int zeroBound = maxPredNum - predNum;
        int[] bounds = IntStream.range(zeroBound, maxPredNum).toArray();
        for (int frameCount = 0; frameCount < numModels; ++frameCount) {
            trainFrames[frameCount] = ModelSelectionUtils.generateOneFrame(predIndices, parms, predNames, foldColumn);
            DKV.put(trainFrames[frameCount]);
            ModelSelectionUtils.updatePredIndices(predIndices, bounds);
        }
        return trainFrames;
    }

    public static void updatePredIndices(int[] currentPredIndices, int[] indicesBounds) {
        int lastPredInd;
        for (int index = lastPredInd = currentPredIndices.length - 1; index >= 0; --index) {
            if (currentPredIndices[index] >= indicesBounds[index]) continue;
            int n = index;
            currentPredIndices[n] = currentPredIndices[n] + 1;
            ModelSelectionUtils.updateLaterIndices(currentPredIndices, index, lastPredInd);
            break;
        }
    }

    public static void updateLaterIndices(int[] currentPredIndices, int indexUpdated, int lastPredInd) {
        for (int index = indexUpdated; index < lastPredInd; ++index) {
            currentPredIndices[index + 1] = currentPredIndices[index] + 1;
        }
    }

    public static Frame generateOneFrame(int[] predIndices, Model.Parameters parms, String[] predNames, String foldColumn) {
        Frame predVecs = new Frame(Key.make());
        Frame train = parms.train();
        boolean usePredIndices = predIndices != null;
        int numPreds = usePredIndices ? predIndices.length : predNames.length;
        for (int index = 0; index < numPreds; ++index) {
            int predVecNum = usePredIndices ? predIndices[index] : index;
            predVecs.add(predNames[predVecNum], train.vec(predNames[predVecNum]));
        }
        if (parms._weights_column != null) {
            predVecs.add(parms._weights_column, train.vec(parms._weights_column));
        }
        if (parms._offset_column != null) {
            predVecs.add(parms._offset_column, train.vec(parms._offset_column));
        }
        if (foldColumn != null) {
            predVecs.add(foldColumn, train.vec(foldColumn));
        }
        predVecs.add(parms._response_column, train.vec(parms._response_column));
        return predVecs;
    }

    public static void setBitSet(BitSet predBitSet, int[] currIndices) {
        for (int predIndex : currIndices) {
            predBitSet.set(predIndex);
        }
    }

    public static CPMnPredNames genCPMPredNamesIndex(Key jobKey, DataInfo dinfo, String[] predictorNames, ModelSelectionModel.ModelSelectionParameters parms) {
        double[] xTransposey;
        ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
        GLMTask.GLMIterationTask gtask = ModelSelectionUtils.genGramCheckDup(jobKey, dinfo, ignoredCols, parms);
        Gram gram = gtask.getGram();
        ArrayList<Integer> ignoredFullPredCols = new ArrayList();
        String[] coefNames = dinfo.coefNames();
        if (ignoredCols.size() > 0) {
            ArrayList<String> ignoredPredNames = new ArrayList<String>();
            ArrayList<String> ignoredCoefNames = new ArrayList<String>();
            ignoredFullPredCols = ModelSelectionUtils.findFullDupPred(dinfo, ignoredCols, ignoredPredNames, ignoredCoefNames, predictorNames);
            coefNames = (String[])Arrays.stream(coefNames).filter(x -> !ignoredCoefNames.contains(x)).toArray(String[]::new);
            predictorNames = (String[])Arrays.stream(predictorNames).filter(x -> !ignoredPredNames.contains(x)).toArray(String[]::new);
            xTransposey = ModelSelectionUtils.dropIgnoredCols(gtask, ignoredFullPredCols);
        } else {
            xTransposey = gtask.getXY();
        }
        return new CPMnPredNames(ModelSelectionUtils.formCPM(gram, xTransposey, gtask.getYY()), predictorNames, coefNames, ModelSelectionUtils.mapPredIndex2CPMIndices(dinfo, predictorNames.length, ignoredFullPredCols));
    }

    public static int[][] mapPredIndex2CPMIndices(DataInfo dinfo, int numPreds, List<Integer> ignoredPredInd) {
        int[][] pred2CPMMapping = new int[numPreds][];
        int offset = 0;
        int countPreds = 0;
        for (int index = 0; index < dinfo._cats; ++index) {
            int catStartLevel = dinfo._catOffsets[index];
            if (!ignoredPredInd.contains(catStartLevel)) {
                int numLevels = dinfo._catOffsets[index + 1] - dinfo._catOffsets[index];
                pred2CPMMapping[countPreds++] = IntStream.iterate(offset, n -> n + 1).limit(numLevels).toArray();
                offset += numLevels;
            }
            if (countPreds >= numPreds) break;
        }
        int totPreds = dinfo._catOffsets[dinfo._cats] + dinfo._nums;
        for (int index = dinfo._catOffsets[dinfo._cats]; index < totPreds && countPreds < numPreds; ++index) {
            if (ignoredPredInd.contains(index)) continue;
            pred2CPMMapping[countPreds++] = new int[]{offset++};
        }
        return pred2CPMMapping;
    }

    public static double[][] formCPM(Gram gram, double[] xTransposey, double yy) {
        int coeffSize = xTransposey.length;
        int cPMsize = coeffSize + 1;
        double[][] crossProductMatrix = MemoryManager.malloc8d(cPMsize, cPMsize);
        gram.getXXCPM(crossProductMatrix, false, false);
        for (int rowIndex = 0; rowIndex < coeffSize; ++rowIndex) {
            crossProductMatrix[rowIndex][coeffSize] = xTransposey[rowIndex];
        }
        System.arraycopy(xTransposey, 0, crossProductMatrix[coeffSize], 0, coeffSize);
        crossProductMatrix[coeffSize][coeffSize] = yy;
        return crossProductMatrix;
    }

    public static double[] dropIgnoredCols(GLMTask.GLMIterationTask gtask, List<Integer> ignoredCols) {
        Gram gram = gtask.getGram();
        int[] droppedCols = ignoredCols.stream().mapToInt(x -> x).toArray();
        gram.dropCols(droppedCols);
        return ArrayUtils.removeIds(gtask.getXY(), droppedCols);
    }

    public static List<Integer> findFullDupPred(DataInfo dinfo, List<Integer> ignoredCols, List<String> ignoredPredNames, List<String> ignoredCoefNames, String[] prednames) {
        ArrayList<Integer> ignoredColsCopy = new ArrayList<Integer>(ignoredCols);
        ArrayList<Integer> fullIgnoredCols = new ArrayList<Integer>();
        int[] catOffsets = dinfo._catOffsets;
        String[] allCoefNames = dinfo.coefNames();
        if (dinfo._cats > 0) {
            int catOffsetsLen = catOffsets.length;
            for (int index = 1; index < catOffsetsLen; ++index) {
                int counter = index;
                List discarded = ignoredColsCopy.stream().filter(x -> x < catOffsets[counter]).collect(Collectors.toList());
                if (discarded != null && discarded.size() == catOffsets[index] - catOffsets[index - 1]) {
                    fullIgnoredCols.addAll(discarded);
                    ignoredPredNames.add(prednames[index - 1]);
                    ignoredCoefNames.addAll(discarded.stream().map(x -> allCoefNames[x]).collect(Collectors.toList()));
                }
                if (discarded == null || discarded.size() <= 0) continue;
                ignoredColsCopy.removeAll(discarded);
            }
        }
        if (ignoredColsCopy != null && ignoredColsCopy.size() > 0) {
            int offsetNum = dinfo._numOffsets[0] - dinfo._cats;
            ignoredPredNames.addAll(ignoredColsCopy.stream().map(x -> prednames[x - offsetNum]).collect(Collectors.toList()));
            ignoredCoefNames.addAll(ignoredColsCopy.stream().map(x -> allCoefNames[x]).collect(Collectors.toList()));
            fullIgnoredCols.addAll(ignoredColsCopy);
        }
        return fullIgnoredCols;
    }

    public static GLMTask.GLMIterationTask genGramCheckDup(Key jobKey, DataInfo dinfo, ArrayList<Integer> ignoredCols, ModelSelectionModel.ModelSelectionParameters parms) {
        double[] beta = new double[dinfo.coefNames().length];
        GLMTask.GLMIterationTask gtask = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(jobKey, dinfo, new GLMModel.GLMWeightsFun(GLMModel.GLMParameters.Family.gaussian, GLMModel.GLMParameters.Link.identity, 1.0, 0.1, 0.1, 1.0, false), beta = Arrays.stream(beta).map(x -> 1.0).toArray()).doAll(dinfo._adaptedFrame);
        Gram gram = gtask.getGram();
        Gram.Cholesky chol = gram.qrCholesky(ignoredCols, parms._standardize);
        if (!chol.isSPD()) {
            throw new Gram.NonSPDMatrixException();
        }
        return gtask;
    }

    public static double calR2Scale(Frame train, String resp) {
        Vec respV = train.vec(resp);
        double sigma = respV.sigma();
        double var = sigma * sigma;
        long nobs = train.numRows() - respV.naCnt() - 1L;
        return (double)nobs * var;
    }

    static CoeffNormalization generateScale(DataInfo dinfo, boolean standardize) {
        int numCols = dinfo._nums;
        double[] sigmaOrOneOverSigma = new double[numCols];
        double[] mOverSigma = new double[numCols];
        for (int index = 0; index < numCols; ++index) {
            if (standardize) {
                sigmaOrOneOverSigma[index] = dinfo._normMul[index];
                mOverSigma[index] = dinfo._numMeans[index] * dinfo._normMul[index];
                continue;
            }
            sigmaOrOneOverSigma[index] = dinfo._normSigmaStandardizationOff[index];
            mOverSigma[index] = dinfo._numMeans[index] / dinfo._normSigmaStandardizationOff[index];
        }
        return new CoeffNormalization(sigmaOrOneOverSigma, mOverSigma, standardize);
    }

    public static Frame[] generateMaxRTrainingFrames(ModelSelectionModel.ModelSelectionParameters parms, String[] predictorNames, String foldColumn, List<Integer> currSubsetIndices, int newPredPos, List<Integer> validSubsets, Set<BitSet> usedCombo) {
        ArrayList<Frame> trainFramesList = new ArrayList<Frame>();
        ArrayList<Integer> changedSubset = new ArrayList<Integer>(currSubsetIndices);
        changedSubset.add(newPredPos, -1);
        int[] predIndices = changedSubset.stream().mapToInt(Integer::intValue).toArray();
        int predNum = predictorNames.length;
        BitSet tempIndices = new BitSet(predNum);
        int predSizes = changedSubset.size();
        boolean emptyUsedCombo = usedCombo != null && usedCombo.size() == 0;
        Iterator<Integer> iterator = validSubsets.iterator();
        while (iterator.hasNext()) {
            Frame trainFrame;
            int predIndex;
            predIndices[newPredPos] = predIndex = iterator.next().intValue();
            if (emptyUsedCombo && predSizes > 1) {
                tempIndices.clear();
                ModelSelectionUtils.setBitSet(tempIndices, predIndices);
                usedCombo.add((BitSet)tempIndices.clone());
                trainFrame = ModelSelectionUtils.generateOneFrame(predIndices, parms, predictorNames, foldColumn);
                DKV.put(trainFrame);
                trainFramesList.add(trainFrame);
                continue;
            }
            if (usedCombo != null && predSizes > 1) {
                tempIndices.clear();
                ModelSelectionUtils.setBitSet(tempIndices, predIndices);
                if (!usedCombo.add((BitSet)tempIndices.clone())) continue;
                trainFrame = ModelSelectionUtils.generateOneFrame(predIndices, parms, predictorNames, foldColumn);
                DKV.put(trainFrame);
                trainFramesList.add(trainFrame);
                continue;
            }
            trainFrame = ModelSelectionUtils.generateOneFrame(predIndices, parms, predictorNames, foldColumn);
            DKV.put(trainFrame);
            trainFramesList.add(trainFrame);
        }
        return (Frame[])trainFramesList.stream().toArray(Frame[]::new);
    }

    public static double[] generateAllErrVarR(double[][] allCPM, Frame allCPMFrame, double[][] prevCPM, int predPos, List<Integer> currSubsetIndices, List<Integer> validSubsets, Set<BitSet> usedCombo, BitSet tempIndices, int[][] pred2CPMIndices, boolean hasIntercept, int[] removedPredSweepInd, SweepVector[][] removedPredSV) {
        int[] allPreds = new int[currSubsetIndices.size() + 1];
        int lastPredInd = allPreds.length - 1;
        System.arraycopy(currSubsetIndices.stream().mapToInt(Integer::intValue).toArray(), 0, allPreds, 0, allPreds.length - 1);
        int maxModelCount = validSubsets.size();
        RecursiveAction[] resA = new RecursiveAction[maxModelCount];
        double[] subsetMSE = new double[maxModelCount];
        Arrays.fill(subsetMSE, Double.MAX_VALUE);
        int modelCount = 0;
        int[] oneLessSub = new int[lastPredInd];
        ArrayList<Integer> oneLessSubset = new ArrayList<Integer>(currSubsetIndices);
        oneLessSubset.remove(predPos);
        System.arraycopy(oneLessSubset.stream().mapToInt(Integer::intValue).toArray(), 0, oneLessSub, 0, oneLessSub.length - 1);
        int oneLessSubInd = lastPredInd - 1;
        Iterator<Integer> iterator = validSubsets.iterator();
        while (iterator.hasNext()) {
            int predIndex;
            allPreds[lastPredInd] = predIndex = iterator.next().intValue();
            oneLessSub[oneLessSubInd] = predIndex;
            tempIndices.clear();
            ModelSelectionUtils.setBitSet(tempIndices, oneLessSub);
            if (!usedCombo.add((BitSet)tempIndices.clone())) continue;
            int resCount = modelCount++;
            ModelSelectionUtils.genMSE4MorePredsR(pred2CPMIndices, allCPM, allCPMFrame, prevCPM, allPreds, subsetMSE, resA, resCount, hasIntercept, removedPredSV, removedPredSweepInd);
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])Arrays.stream(resA).filter(Objects::nonNull).toArray(RecursiveAction[]::new));
        return subsetMSE;
    }

    public static void genMSE4MorePredsR(final int[][] pred2CPMIndices, final double[][] allCPM, final Frame allCPMFrame, final double[][] prevCPM, int[] allPreds, final double[] subsetMSE, RecursiveAction[] resA, final int resCount, final boolean hasIntercept, final SweepVector[][] removePredSV, final int[] removedPredSweepInd) {
        final int[] subsetIndices = (int[])allPreds.clone();
        resA[resCount] = new RecursiveAction(){

            @Override
            protected void compute() {
                double[][] subsetCPM = ModelSelectionUtils.addNewPred2CPM(allCPM, allCPMFrame, prevCPM, subsetIndices, pred2CPMIndices, hasIntercept);
                int newPredInd = subsetIndices[subsetIndices.length - 1];
                int newPredCPMLength = pred2CPMIndices[newPredInd].length;
                int lastSweepIndex = prevCPM.length - 1;
                if (newPredCPMLength == 1) {
                    ModelSelectionUtils.applySweepVectors2NewPred(removePredSV, subsetCPM, newPredCPMLength, removedPredSweepInd);
                } else {
                    SweepVector[][] newSV = ModelSelectionUtils.mapBasicVector2Multiple(removePredSV, newPredCPMLength);
                    ModelSelectionUtils.applySweepVectors2NewPred(newSV, subsetCPM, newPredCPMLength, removedPredSweepInd);
                }
                int[] newPredSweepInd = IntStream.range(0, newPredCPMLength).map(x -> x + lastSweepIndex).toArray();
                ModelSelectionUtils.sweepCPM(subsetCPM, newPredSweepInd, false);
                int lastInd = subsetCPM.length - 1;
                subsetMSE[resCount] = subsetCPM[lastInd][lastInd];
            }
        };
    }

    public static double[] generateAllErrVar(double[][] allCPM, Frame allCPMFrame, int prevCPMSize, List<Integer> currSubsetIndices, List<Integer> validSubsets, Set<BitSet> usedCombo, BitSet tempIndices, int[][] pred2CPMIndices, boolean hasIntercept) {
        int[] allPreds = new int[currSubsetIndices.size() + 1];
        int lastPredInd = allPreds.length - 1;
        if (currSubsetIndices.size() > 0) {
            System.arraycopy(currSubsetIndices.stream().mapToInt(Integer::intValue).toArray(), 0, allPreds, 0, allPreds.length - 1);
        }
        int predSizes = allPreds.length;
        int maxModelCount = validSubsets.size();
        RecursiveAction[] resA = new RecursiveAction[maxModelCount];
        double[] subsetMSE = Arrays.stream(new double[maxModelCount]).map(x -> Double.MAX_VALUE).toArray();
        int modelCount = 0;
        Iterator<Integer> iterator = validSubsets.iterator();
        while (iterator.hasNext()) {
            int resCount;
            int predIndex;
            allPreds[lastPredInd] = predIndex = iterator.next().intValue();
            if (predSizes > 1) {
                tempIndices.clear();
                ModelSelectionUtils.setBitSet(tempIndices, allPreds);
                if (!usedCombo.add((BitSet)tempIndices.clone())) continue;
                resCount = modelCount++;
                ModelSelectionUtils.genMSE4MorePreds(pred2CPMIndices, allCPM, allCPMFrame, allPreds, prevCPMSize, subsetMSE, resA, resCount, hasIntercept);
                continue;
            }
            resCount = modelCount++;
            ModelSelectionUtils.genMSE1stPred(pred2CPMIndices, allCPM, allCPMFrame, allPreds, subsetMSE, resA, resCount, hasIntercept);
        }
        ForkJoinTask.invokeAll((ForkJoinTask[])Arrays.stream(resA).filter(Objects::nonNull).toArray(RecursiveAction[]::new));
        return subsetMSE;
    }

    public static void genMSE4MorePreds(final int[][] pred2CPMIndices, final double[][] allCPM, final Frame allCPMFrame, int[] allPreds, final int lastSweepIndex, final double[] subsetMSE, RecursiveAction[] resA, final int resCount, final boolean hasIntercept) {
        final int[] subsetIndices = (int[])allPreds.clone();
        resA[resCount] = new RecursiveAction(){

            @Override
            protected void compute() {
                boolean multinodeMode = allCPM == null && allCPMFrame != null;
                double[][] subsetCPM = multinodeMode ? ModelSelectionUtils.extractPredSubsetsCPMFrame(allCPMFrame, subsetIndices, pred2CPMIndices, hasIntercept) : ModelSelectionUtils.extractPredSubsetsCPM(allCPM, subsetIndices, pred2CPMIndices, hasIntercept);
                int lastPredInd = subsetIndices[subsetIndices.length - 1];
                int newPredCPMLength = pred2CPMIndices[lastPredInd].length;
                int[] sweepIndices = IntStream.range(0, newPredCPMLength).map(x -> x + lastSweepIndex).toArray();
                ModelSelectionUtils.sweepCPM(subsetCPM, sweepIndices, false);
                int lastInd = subsetCPM.length - 1;
                subsetMSE[resCount] = subsetCPM[lastInd][lastInd];
            }
        };
    }

    public static double sweepMSE(double[][] subsetCPM, List<Integer> sweepIndices) {
        int sweepLen = sweepIndices.size();
        int cpmLen = subsetCPM.length;
        int lastInd = cpmLen - 1;
        if (sweepLen == 1) {
            int sweepInd = sweepIndices.get(0);
            return subsetCPM[lastInd][lastInd] - subsetCPM[lastInd][sweepInd] * subsetCPM[sweepInd][lastInd] / subsetCPM[sweepInd][sweepInd];
        }
        Set[] sweepElements = new Set[sweepLen];
        ArrayList<SweepElement> tempElements = new ArrayList<SweepElement>();
        tempElements.add(new SweepElement(lastInd, lastInd, new ArrayList<Integer>(sweepIndices)));
        while (tempElements.size() > 0) {
            SweepElement oneEle = (SweepElement)tempElements.remove(0);
            if (oneEle._sweepIndices.size() == 1) {
                if (sweepElements[0] == null) {
                    sweepElements[0] = new HashSet();
                }
                sweepElements[0].add(oneEle);
                continue;
            }
            int arrIndex = oneEle._sweepIndices.size() - 1;
            if (sweepElements[arrIndex] == null) {
                sweepElements[arrIndex] = new HashSet();
            }
            sweepElements[arrIndex].add(oneEle);
            ModelSelectionUtils.process(oneEle, tempElements);
        }
        ModelSelectionUtils.sweepCPMElements(sweepElements, subsetCPM);
        return subsetCPM[lastInd][lastInd];
    }

    public static void sweepCPMElements(Set<SweepElement>[] sweepElements, double[][] subsetCPM) {
        for (Set<SweepElement> oneSweepAction : sweepElements) {
            for (SweepElement oneElement : oneSweepAction) {
                int oneIndex = oneElement._sweepIndices.get(oneElement._sweepIndices.size() - 1);
                int row = oneElement._row;
                int col = oneElement._col;
                subsetCPM[row][col] = subsetCPM[row][col] - subsetCPM[row][oneIndex] * subsetCPM[oneIndex][col] / subsetCPM[oneIndex][oneIndex];
            }
        }
    }

    public static void process(SweepElement currEle, List<SweepElement> tempList) {
        ArrayList<Integer> newSweepIndices = new ArrayList<Integer>(currEle._sweepIndices);
        int sweepIndex = (Integer)newSweepIndices.remove(newSweepIndices.size() - 1);
        tempList.add(new SweepElement(currEle._row, currEle._col, newSweepIndices));
        tempList.add(new SweepElement(currEle._row, sweepIndex, newSweepIndices));
        tempList.add(new SweepElement(sweepIndex, currEle._col, newSweepIndices));
        tempList.add(new SweepElement(sweepIndex, sweepIndex, newSweepIndices));
    }

    public static void genMSE1stPred(final int[][] pred2CPMIndices, final double[][] allCPM, final Frame allCPMFrame, int[] allPreds, final double[] subsetMSE, RecursiveAction[] resA, final int resCount, final boolean hasIntercept) {
        final int[] subsetIndices = (int[])allPreds.clone();
        resA[resCount] = new RecursiveAction(){

            @Override
            protected void compute() {
                boolean multinodeMode = allCPM == null && allCPMFrame != null;
                double[][] subsetCPM = multinodeMode ? ModelSelectionUtils.extractPredSubsetsCPMFrame(allCPMFrame, subsetIndices, pred2CPMIndices, hasIntercept) : ModelSelectionUtils.extractPredSubsetsCPM(allCPM, subsetIndices, pred2CPMIndices, hasIntercept);
                int lastSubsetIndex = subsetCPM.length - 1;
                subsetMSE[resCount] = ModelSelectionUtils.sweepMSE(subsetCPM, IntStream.range(1, lastSubsetIndex).boxed().collect(Collectors.toList()));
            }
        };
    }

    public static SweepVector[][] mapBasicVector2Multiple(SweepVector[][] sweepVec, int newPredCPMLen) {
        int numSweep = sweepVec.length;
        int oldColLen = sweepVec[0].length / 2;
        int newColLen = oldColLen + newPredCPMLen - 1;
        int lastNewColInd = newColLen - 1;
        int lastOldColInd = oldColLen - 1;
        SweepVector[][] newSweepVec = new SweepVector[numSweep][newColLen * 2];
        for (int sInd = 0; sInd < numSweep; ++sInd) {
            double oneOverPivot = sweepVec[sInd][lastOldColInd - 1]._value;
            int rowColInd = sweepVec[sInd][0]._column;
            for (int vInd = 0; vInd < lastNewColInd; ++vInd) {
                if (vInd < lastOldColInd) {
                    newSweepVec[sInd][vInd] = new SweepVector(vInd, rowColInd, sweepVec[sInd][vInd]._value);
                    newSweepVec[sInd][vInd + newColLen] = new SweepVector(rowColInd, vInd, sweepVec[sInd][vInd + oldColLen]._value);
                    continue;
                }
                if (vInd == lastOldColInd) {
                    newSweepVec[sInd][lastNewColInd] = new SweepVector(lastNewColInd, rowColInd, sweepVec[sInd][lastOldColInd]._value);
                    newSweepVec[sInd][lastNewColInd + newColLen] = new SweepVector(rowColInd, lastNewColInd, sweepVec[sInd][lastOldColInd + oldColLen]._value);
                    newSweepVec[sInd][vInd] = new SweepVector(vInd, rowColInd, oneOverPivot);
                    newSweepVec[sInd][vInd + newColLen] = new SweepVector(rowColInd, vInd, oneOverPivot);
                    continue;
                }
                newSweepVec[sInd][vInd] = new SweepVector(vInd, rowColInd, oneOverPivot);
                newSweepVec[sInd][vInd + newColLen] = new SweepVector(rowColInd, vInd, oneOverPivot);
            }
        }
        return newSweepVec;
    }

    public static void applySweepVectors2NewPred(SweepVector[][] sweepVec, double[][] subsetCPM, int numNewRows, int[] sweepMat) {
        int numSweep = sweepVec.length;
        if (sweepMat == null) {
            for (int sweepInd = 0; sweepInd < numSweep; ++sweepInd) {
                ModelSelectionUtils.oneSweepWSweepVector(sweepVec[sweepInd], subsetCPM, sweepInd, numNewRows);
            }
        } else {
            for (int index = 0; index < numSweep; ++index) {
                int sweepInd = sweepMat[index];
                ModelSelectionUtils.oneSweepWSweepVector(sweepVec[index], subsetCPM, sweepInd, numNewRows);
            }
        }
    }

    public static void oneSweepWSweepVector(SweepVector[] sweepVec, double[][] subsetCPM, int sweepIndex, int colRowsAdded) {
        int rowColInd;
        int rcInd;
        int sweepVecLen = sweepVec.length / 2;
        int newLastCPMInd = sweepVecLen - 1;
        int oldSweepVec = sweepVecLen - colRowsAdded;
        int oldLastCPMInd = oldSweepVec - 1;
        double[] colSweeps = new double[colRowsAdded];
        double[] rowSweeps = new double[colRowsAdded];
        HashSet<CPMElement> trackSweep = new HashSet<CPMElement>();
        for (rcInd = 0; rcInd < colRowsAdded; ++rcInd) {
            rowColInd = sweepVec[0]._column + rcInd;
            for (int svInd = 0; svInd < sweepVecLen; ++svInd) {
                CPMElement oneEle;
                int svIndOffset = svInd + sweepVecLen;
                if (sweepVec[svInd]._row == sweepIndex) {
                    rowSweeps[rcInd] = sweepVec[svInd]._value * subsetCPM[sweepIndex][rowColInd];
                    colSweeps[rcInd] = sweepVec[svIndOffset]._value * subsetCPM[rowColInd][sweepIndex];
                    continue;
                }
                if (sweepVec[svInd]._row == newLastCPMInd) {
                    oneEle = new CPMElement(newLastCPMInd, rowColInd);
                    if (!trackSweep.contains(oneEle)) {
                        trackSweep.add(oneEle);
                        subsetCPM[newLastCPMInd][rowColInd] = subsetCPM[newLastCPMInd][rowColInd] - sweepVec[svInd]._value * subsetCPM[sweepIndex][rowColInd];
                    }
                    if (trackSweep.contains(oneEle = new CPMElement(rowColInd, newLastCPMInd))) continue;
                    trackSweep.add(oneEle);
                    subsetCPM[rowColInd][newLastCPMInd] = subsetCPM[rowColInd][newLastCPMInd] - sweepVec[svIndOffset]._value * subsetCPM[rowColInd][sweepIndex];
                    continue;
                }
                if (sweepVec[svInd]._row == rowColInd) {
                    oneEle = new CPMElement(rowColInd, rowColInd);
                    if (trackSweep.contains(oneEle)) continue;
                    subsetCPM[rowColInd][rowColInd] = subsetCPM[rowColInd][rowColInd] - subsetCPM[rowColInd][sweepIndex] * subsetCPM[sweepIndex][rowColInd] * sweepVec[svInd]._value;
                    trackSweep.add(oneEle);
                    continue;
                }
                if (sweepVec[svInd]._row < oldLastCPMInd) {
                    oneEle = new CPMElement(sweepVec[svInd]._row, rowColInd);
                    if (!trackSweep.contains(oneEle)) {
                        subsetCPM[sweepVec[svInd]._row][rowColInd] = subsetCPM[sweepVec[svInd]._row][rowColInd] - subsetCPM[sweepIndex][rowColInd] * sweepVec[svInd]._value;
                        trackSweep.add(oneEle);
                    }
                    if (trackSweep.contains(oneEle = new CPMElement(rowColInd, sweepVec[svIndOffset]._column))) continue;
                    trackSweep.add(oneEle);
                    subsetCPM[rowColInd][sweepVec[svIndOffset]._column] = subsetCPM[rowColInd][sweepVec[svIndOffset]._column] - subsetCPM[rowColInd][sweepIndex] * sweepVec[svIndOffset]._value;
                    continue;
                }
                oneEle = new CPMElement(sweepVec[svInd]._row, rowColInd);
                if (!trackSweep.contains(oneEle)) {
                    trackSweep.add(oneEle);
                    subsetCPM[sweepVec[svInd]._row][rowColInd] = subsetCPM[sweepVec[svInd]._row][rowColInd] - subsetCPM[sweepVec[svInd]._row][sweepIndex] * subsetCPM[sweepIndex][rowColInd] * sweepVec[svInd]._value;
                }
                if (trackSweep.contains(oneEle = new CPMElement(rowColInd, sweepVec[svIndOffset]._column))) continue;
                trackSweep.add(oneEle);
                subsetCPM[rowColInd][sweepVec[svIndOffset]._column] = subsetCPM[rowColInd][sweepVec[svIndOffset]._column] - subsetCPM[rowColInd][sweepIndex] * subsetCPM[sweepIndex][sweepVec[svIndOffset]._column] * sweepVec[svIndOffset]._value;
            }
        }
        for (rcInd = 0; rcInd < colRowsAdded; ++rcInd) {
            rowColInd = sweepVec[0]._column + rcInd;
            subsetCPM[sweepIndex][rowColInd] = rowSweeps[rcInd];
            subsetCPM[rowColInd][sweepIndex] = colSweeps[rcInd];
        }
    }

    public static double[][] addNewPred2CPM(double[][] allCPM, Frame allCPMFrame, double[][] currentCPM, int[] subsetPredIndex, int[][] pred2CPMIndices, boolean hasIntercept) {
        boolean multinodeMode = allCPM == null && allCPMFrame != null;
        double[][] newCPM = multinodeMode ? ModelSelectionUtils.extractPredSubsetsCPMFrame(allCPMFrame, subsetPredIndex, pred2CPMIndices, hasIntercept) : ModelSelectionUtils.extractPredSubsetsCPM(allCPM, subsetPredIndex, pred2CPMIndices, hasIntercept);
        int oldCPMDim = currentCPM.length - 1;
        int newCPMDim = newCPM.length;
        int lastnewCPMInd = newCPMDim - 1;
        for (int index = 0; index < oldCPMDim; ++index) {
            System.arraycopy(currentCPM[index], 0, newCPM[index], 0, oldCPMDim);
            newCPM[index][lastnewCPMInd] = currentCPM[index][oldCPMDim];
        }
        System.arraycopy(currentCPM[oldCPMDim], 0, newCPM[lastnewCPMInd], 0, oldCPMDim);
        newCPM[lastnewCPMInd][lastnewCPMInd] = currentCPM[oldCPMDim][oldCPMDim];
        return newCPM;
    }

    public static int[] extractSweepIndices(List<Integer> currSubsetIndices, int predPos, int predRemoved, int[][] predInd2CPMIndices, boolean hasIntercept) {
        int predRemovedLen = predInd2CPMIndices[predRemoved].length;
        int totalSize = IntStream.range(0, predPos).map(x -> predInd2CPMIndices[(Integer)currSubsetIndices.get(x)].length).sum() + (hasIntercept ? 1 : 0);
        return IntStream.range(0, predRemovedLen).map(x -> x + totalSize).toArray();
    }

    public static List<Integer> extractCPMIndexFromPred(int cpmLastIndex, int[][] pred2CPMIndices, int[] newPredList, boolean hasIntercept) {
        List<Integer> CPMIndices = ModelSelectionUtils.extractCPMIndexFromPredOnly(pred2CPMIndices, newPredList);
        if (hasIntercept) {
            CPMIndices.add(0, cpmLastIndex - 1);
        }
        CPMIndices.add(cpmLastIndex);
        return CPMIndices;
    }

    public static List<Integer> extractCPMIndexFromPredOnly(int[][] pred2CPMIndices, int[] newPredList) {
        ArrayList<Integer> CPMIndices = new ArrayList<Integer>();
        for (int predInd : newPredList) {
            CPMIndices.addAll(Arrays.stream(pred2CPMIndices[predInd]).boxed().collect(Collectors.toList()));
        }
        return CPMIndices;
    }

    public static SweepVector[][] sweepCPM(double[][] subsetCPM, int[] sweepIndices, boolean genSweepVector) {
        int currSubsetCPMSize = subsetCPM.length;
        int numSweep = sweepIndices.length;
        SweepVector[][] sweepVecs = new SweepVector[numSweep][2 * (currSubsetCPMSize + 1)];
        for (int index = 0; index < numSweep; ++index) {
            ModelSelectionUtils.performOneSweep(subsetCPM, sweepVecs[index], sweepIndices[index], genSweepVector);
        }
        return sweepVecs;
    }

    public static void sweepCPMParallel(Frame cpm, int[] sweepIndices, int[] trackPivotSweeps) {
        int numSweep = sweepIndices.length;
        for (int index = 0; index < numSweep; ++index) {
            new ModelSelectionTasks.SweepFrameParallel(trackPivotSweeps, sweepIndices[index], cpm).doAll(cpm);
            DKV.put(cpm);
            int n = sweepIndices[index];
            trackPivotSweeps[n] = trackPivotSweeps[n] * -1;
        }
    }

    public static void performOneSweep(double[][] subsetCPM, SweepVector[] sweepVec, int sweepIndex, boolean genSweepVector) {
        int subsetCPMLen = subsetCPM.length;
        int lastSubsetInd = subsetCPMLen - 1;
        if (subsetCPM[sweepIndex][sweepIndex] == 0.0) {
            subsetCPM[lastSubsetInd][lastSubsetInd] = Double.MAX_VALUE;
            return;
        }
        double oneOverPivot = 1.0 / subsetCPM[sweepIndex][sweepIndex];
        if (genSweepVector) {
            int sweepVecLen = sweepVec.length / 2;
            for (int index = 0; index < sweepVecLen; ++index) {
                if (index == sweepIndex) {
                    sweepVec[index] = new SweepVector(index, lastSubsetInd, oneOverPivot);
                    sweepVec[index + sweepVecLen] = new SweepVector(lastSubsetInd, index, -oneOverPivot);
                    continue;
                }
                if (index == subsetCPMLen) {
                    sweepVec[index] = new SweepVector(index, lastSubsetInd, subsetCPM[lastSubsetInd][sweepIndex] * oneOverPivot);
                    sweepVec[index + sweepVecLen] = new SweepVector(lastSubsetInd, index, subsetCPM[sweepIndex][lastSubsetInd] * oneOverPivot);
                    continue;
                }
                if (index == lastSubsetInd) {
                    sweepVec[index] = new SweepVector(index, lastSubsetInd, oneOverPivot);
                    sweepVec[index + sweepVecLen] = new SweepVector(lastSubsetInd, index, oneOverPivot);
                    continue;
                }
                sweepVec[index] = new SweepVector(index, lastSubsetInd, subsetCPM[index][sweepIndex] * oneOverPivot);
                sweepVec[index + sweepVecLen] = new SweepVector(lastSubsetInd, index, subsetCPM[sweepIndex][index] * oneOverPivot);
            }
        }
        for (int rInd = 0; rInd < subsetCPMLen; ++rInd) {
            for (int cInd = rInd; cInd < subsetCPMLen; ++cInd) {
                if (rInd == sweepIndex || cInd == sweepIndex) continue;
                subsetCPM[rInd][cInd] = subsetCPM[rInd][cInd] - subsetCPM[rInd][sweepIndex] * subsetCPM[sweepIndex][cInd] * oneOverPivot;
                if (cInd == rInd) continue;
                subsetCPM[cInd][rInd] = subsetCPM[cInd][rInd] - subsetCPM[cInd][sweepIndex] * subsetCPM[sweepIndex][rInd] * oneOverPivot;
            }
        }
        for (int index = 0; index < subsetCPMLen; ++index) {
            subsetCPM[index][sweepIndex] = -subsetCPM[index][sweepIndex] * oneOverPivot;
            if (sweepIndex == index) continue;
            subsetCPM[sweepIndex][index] = subsetCPM[sweepIndex][index] * oneOverPivot;
        }
        subsetCPM[sweepIndex][sweepIndex] = oneOverPivot;
    }

    public static String[][] shrinkStringArray(String[][] array, int numModels) {
        int offset = array.length - numModels;
        String[][] newArray = new String[numModels][];
        for (int index = 0; index < numModels; ++index) {
            newArray[index] = (String[])array[offset + index].clone();
        }
        return newArray;
    }

    public static double[][] shrinkDoubleArray(double[][] array, int numModels) {
        int offset = array.length - numModels;
        double[][] newArray = new double[numModels][];
        for (int index = 0; index < numModels; ++index) {
            newArray[index] = (double[])array[offset + index].clone();
        }
        return newArray;
    }

    public static Key[] shrinkKeyArray(Key[] array, int numModels) {
        int arrLen = array.length;
        Key[] newArray = new Key[numModels];
        System.arraycopy(array, arrLen - numModels, newArray, 0, numModels);
        return newArray;
    }

    public static String joinDouble(double[] val) {
        int arrLen = val.length;
        CharSequence[] strVal = new String[arrLen];
        for (int index = 0; index < arrLen; ++index) {
            strVal[index] = Double.toString(val[index]);
        }
        return String.join((CharSequence)", ", strVal);
    }

    public static GLMModel.GLMParameters[] generateGLMParameters(Frame[] trainingFrames, ModelSelectionModel.ModelSelectionParameters parms, int nfolds, String foldColumn, Model.Parameters.FoldAssignmentScheme foldAssignment) {
        int numModels = trainingFrames.length;
        GLMModel.GLMParameters[] params = new GLMModel.GLMParameters[numModels];
        Field[] field1 = ModelSelectionModel.ModelSelectionParameters.class.getDeclaredFields();
        Field[] field2 = Model.Parameters.class.getDeclaredFields();
        for (int index = 0; index < numModels; ++index) {
            params[index] = new GLMModel.GLMParameters();
            ModelSelectionUtils.setParamField(parms, params[index], false, field1, Collections.emptyList());
            ModelSelectionUtils.setParamField(parms, params[index], true, field2, Collections.emptyList());
            params[index]._train = trainingFrames[index]._key;
            params[index]._nfolds = nfolds;
            params[index]._fold_column = foldColumn;
            params[index]._fold_assignment = foldAssignment;
        }
        return params;
    }

    public static void setParamField(Model.Parameters params, GLMModel.GLMParameters glmParam, boolean superClassParams, Field[] paramFields, List<String> excludeList) {
        boolean emptyExcludeList = excludeList.size() == 0;
        for (Field oneField : paramFields) {
            try {
                if (!emptyExcludeList && excludeList.contains(oneField.getName())) continue;
                Field glmField = superClassParams ? glmParam.getClass().getSuperclass().getDeclaredField(oneField.getName()) : glmParam.getClass().getDeclaredField(oneField.getName());
                glmField.set(glmParam, oneField.get(params));
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static GLM[] buildGLMBuilders(GLMModel.GLMParameters[] trainingParams) {
        int numModels = trainingParams.length;
        GLM[] builders = new GLM[numModels];
        for (int index = 0; index < numModels; ++index) {
            builders[index] = new GLM(trainingParams[index]);
        }
        return builders;
    }

    public static void removeTrainingFrames(Frame[] trainingFrames) {
        for (Frame oneFrame : trainingFrames) {
            DKV.remove(oneFrame._key);
        }
    }

    public static GLMModel findBestModel(GLM[] glmResults) {
        double bestR2Val = 0.0;
        int numModels = glmResults.length;
        Lockable bestModel = null;
        for (int index = 0; index < numModels; ++index) {
            GLMModel oneModel = (GLMModel)glmResults[index].get();
            double currR2 = oneModel.r2();
            if (((GLMModel.GLMParameters)oneModel._parms)._nfolds > 0) {
                int r2Index = Arrays.asList(((GLMModel.GLMOutput)oneModel._output)._cross_validation_metrics_summary.getRowHeaders()).indexOf("r2");
                Float tempR2 = (Float)((GLMModel.GLMOutput)oneModel._output)._cross_validation_metrics_summary.get(r2Index, 0);
                currR2 = tempR2.doubleValue();
            }
            if (currR2 > bestR2Val) {
                bestR2Val = currR2;
                if (bestModel != null) {
                    bestModel.delete();
                }
                bestModel = oneModel;
                continue;
            }
            oneModel.delete();
        }
        return bestModel;
    }

    public static String[] extractPredictorNames(Model.Parameters parms, DataInfo dinfo, String foldColumn) {
        String[] nonResponseCols;
        List frameNames = Arrays.stream(dinfo._adaptedFrame.names()).collect(Collectors.toList());
        for (String col : nonResponseCols = parms.getNonPredictors()) {
            frameNames.remove(col);
        }
        if (foldColumn != null && frameNames.contains(foldColumn)) {
            frameNames.remove(foldColumn);
        }
        return (String[])frameNames.stream().toArray(String[]::new);
    }

    public static int findMinZValue(GLMModel model, List<String> numPredNames, List<String> catPredNames, List<String> predNames) {
        List<Double> zValList = Arrays.stream(((GLMModel.GLMOutput)model._output).zValues()).boxed().map(Math::abs).collect(Collectors.toList());
        List<String> coeffNames = Arrays.stream(((GLMModel.GLMOutput)model._output).coefficientNames()).collect(Collectors.toList());
        if (coeffNames.contains("Intercept")) {
            int interceptIndex = coeffNames.indexOf("Intercept");
            zValList.remove(interceptIndex);
            coeffNames.remove(interceptIndex);
        }
        PredNameMinZVal numericalPred = ModelSelectionUtils.findNumMinZVal(numPredNames, zValList, coeffNames);
        PredNameMinZVal categoricalPred = ModelSelectionUtils.findCatMinOfMaxZScore(model, zValList);
        if (categoricalPred != null && categoricalPred._minZVal >= 0.0 && categoricalPred._minZVal < numericalPred._minZVal) {
            return predNames.indexOf(categoricalPred._predName);
        }
        return predNames.indexOf(numericalPred._predName);
    }

    public static PredNameMinZVal findNumMinZVal(List<String> numPredNames, List<Double> zValList, List<String> coeffNames) {
        double minNumVal = -1.0;
        String numPredMinZ = null;
        if (numPredNames != null && numPredNames.size() > 0) {
            ArrayList<Double> numZValues = new ArrayList<Double>();
            for (String predName : numPredNames) {
                int eleInd = coeffNames.indexOf(predName);
                double oneZValue = zValList.get(eleInd);
                if (Double.isNaN(oneZValue)) {
                    zValList.set(eleInd, Double.POSITIVE_INFINITY);
                    numZValues.add(Double.POSITIVE_INFINITY);
                    continue;
                }
                numZValues.add(oneZValue);
            }
            minNumVal = (Double)numZValues.stream().min(Double::compare).get();
            numPredMinZ = numPredNames.get(numZValues.indexOf(minNumVal));
        }
        return new PredNameMinZVal(numPredMinZ, minNumVal);
    }

    public static PredNameMinZVal findCatMinOfMaxZScore(GLMModel model, List<Double> zValList) {
        String[] columnNames = model.names();
        int[] catOffsets = ((GLMModel.GLMOutput)model._output).getDinfo()._catOffsets;
        ArrayList<Double> bestZValues = new ArrayList<Double>();
        ArrayList<String> catPredNames = new ArrayList<String>();
        if (catOffsets != null) {
            int numCatCol = catOffsets.length - 1;
            int numNaN = (int)zValList.stream().filter(x -> Double.isNaN(x)).count();
            if (numNaN == zValList.size()) {
                return null;
            }
            for (int catInd = 0; catInd < numCatCol; ++catInd) {
                ArrayList<Double> catZValues = new ArrayList<Double>();
                int nextCatOffset = catOffsets[catInd + 1];
                for (int eleInd = catOffsets[catInd]; eleInd < nextCatOffset; ++eleInd) {
                    double oneZVal = zValList.get(eleInd);
                    if (Double.isNaN(oneZVal)) {
                        zValList.set(eleInd, 0.0);
                        catZValues.add(0.0);
                        continue;
                    }
                    catZValues.add(oneZVal);
                }
                if (catZValues.size() <= 0) continue;
                double oneCatMinZ = (Double)catZValues.stream().max(Double::compare).get();
                bestZValues.add(oneCatMinZ);
                catPredNames.add(columnNames[catInd]);
            }
        }
        if (bestZValues.size() < 1) {
            return null;
        }
        double maxCatLevel = (Double)bestZValues.stream().min(Double::compare).get();
        String catPredBestZ = (String)catPredNames.get(bestZValues.indexOf(maxCatLevel));
        return new PredNameMinZVal(catPredBestZ, maxCatLevel);
    }

    public static List<String> extraModelColumnNames(List<String> coefNames, GLMModel bestModel) {
        ArrayList<String> coefUsed = new ArrayList<String>();
        ArrayList<String> modelColumns = new ArrayList<String>(Arrays.asList(bestModel.names()));
        for (String coefName : modelColumns) {
            if (!coefNames.contains(coefName)) continue;
            coefUsed.add(coefName);
        }
        return coefUsed;
    }

    public static double[][] extractPredSubsetsCPM(double[][] allCPM, int[] predIndices, int[][] pred2CPMIndices, boolean hasIntercept) {
        List<Integer> CPMIndices = ModelSelectionUtils.extractCPMIndexFromPred(allCPM.length - 1, pred2CPMIndices, predIndices, hasIntercept);
        int subsetcpmDim = CPMIndices.size();
        double[][] subsetCPM = new double[subsetcpmDim][subsetcpmDim];
        for (int rIndex = 0; rIndex < subsetcpmDim; ++rIndex) {
            for (int cIndex = rIndex; cIndex < subsetcpmDim; ++cIndex) {
                subsetCPM[rIndex][cIndex] = allCPM[CPMIndices.get(rIndex)][CPMIndices.get(cIndex)];
                subsetCPM[cIndex][rIndex] = allCPM[CPMIndices.get(cIndex)][CPMIndices.get(rIndex)];
            }
        }
        return subsetCPM;
    }

    public static double[][] extractPredSubsetsCPMFrame(Frame allCPM, int[] predIndices, int[][] pred2CPMIndices, boolean hasIntercept) {
        List<Integer> CPMIndices = ModelSelectionUtils.extractCPMIndexFromPred(allCPM.numCols() - 1, pred2CPMIndices, predIndices, hasIntercept);
        int subsetcpmDim = CPMIndices.size();
        double[][] subsetCPM = new double[subsetcpmDim][subsetcpmDim];
        for (int rIndex = 0; rIndex < subsetcpmDim; ++rIndex) {
            for (int cIndex = rIndex; cIndex < subsetcpmDim; ++cIndex) {
                subsetCPM[rIndex][cIndex] = allCPM.vec(CPMIndices.get(cIndex)).at(CPMIndices.get(rIndex).intValue());
                subsetCPM[cIndex][rIndex] = allCPM.vec(CPMIndices.get(rIndex)).at(CPMIndices.get(cIndex).intValue());
            }
        }
        return subsetCPM;
    }

    static class PredNameMinZVal {
        String _predName;
        double _minZVal;

        public PredNameMinZVal(String predName, double minZVal) {
            this._predName = predName;
            this._minZVal = minZVal;
        }
    }

    public static class SweepVector {
        int _row;
        int _column;
        double _value;

        public SweepVector(int rIndex, int cIndex, double val) {
            this._row = rIndex;
            this._column = cIndex;
            this._value = val;
        }
    }

    static class CPMElement {
        final int _row;
        final int _col;

        public CPMElement(int row, int col) {
            this._row = row;
            this._col = col;
        }

        public boolean equals(Object o) {
            if (o instanceof CPMElement) {
                return this._row == ((CPMElement)o)._row && this._col == ((CPMElement)o)._col;
            }
            return false;
        }

        public int hashCode() {
            Integer rowCol = this._row + (this._col + 1) * 10;
            return rowCol.hashCode();
        }
    }

    static class SweepElement {
        final int _row;
        final int _col;
        final List<Integer> _sweepIndices;

        public SweepElement(int row, int col, List<Integer> sweepInd) {
            this._row = row;
            this._col = col;
            this._sweepIndices = sweepInd;
        }

        public boolean equals(Object o) {
            return o instanceof SweepElement && this._row == ((SweepElement)o)._row && this._col == ((SweepElement)o)._col && this._sweepIndices.equals(((SweepElement)o)._sweepIndices);
        }

        public int hashCode() {
            return this._row + (this._col + 1) * 10 + this._sweepIndices.hashCode();
        }
    }

    static class CoeffNormalization {
        double[] _sigmaOrOneOSigma;
        double[] _meanOverSigma;
        boolean _standardize;

        public CoeffNormalization(double[] oOSigma, double[] mOSigma, boolean standardize) {
            this._sigmaOrOneOSigma = oOSigma;
            this._meanOverSigma = mOSigma;
            this._standardize = standardize;
        }
    }

    static class CPMnPredNames {
        double[][] _cpm;
        String[] _predNames;
        String[] _coefNames;
        int[][] _pred2CPMMapping;

        public CPMnPredNames(double[][] cpm, String[] predNames, String[] coeffNames, int[][] pred2CPMM) {
            this._cpm = cpm;
            this._predNames = predNames;
            this._pred2CPMMapping = pred2CPMM;
            this._coefNames = coeffNames;
        }
    }
}

