/*
 * Decompiled with CFR 0.152.
 */
package hex.modelselection;

import java.util.stream.LongStream;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class ModelSelectionTasks {

    public static class SweepFrameParallel
    extends MRTask<SweepFrameParallel> {
        final double _oneOPivot;
        final int[] _trackPivotSweeps;
        final int _sweepIndex;
        final double[] _ariCol;
        final int _cpmLen;

        public SweepFrameParallel(int[] trackPSweeps, int sweepInd, Frame cpm) {
            this._trackPivotSweeps = trackPSweeps;
            this._sweepIndex = sweepInd;
            this._cpmLen = cpm.numCols();
            Vec sweepVec = cpm.vec(this._sweepIndex);
            this._ariCol = LongStream.range(0L, this._cpmLen).mapToDouble(x -> sweepVec.at(x)).toArray();
            this._oneOPivot = 1.0 / this._ariCol[this._sweepIndex];
        }

        @Override
        public void map(Chunk[] chks) {
            int chunkNRows = chks[0]._len;
            int rowOffset = (int)chks[0].start();
            int numCols = chks.length;
            for (int rInd = 0; rInd < chunkNRows; ++rInd) {
                int trueRowInd = rInd + rowOffset;
                for (int cInd = 0; cInd < numCols; ++cInd) {
                    double currEle = chks[cInd].atd(rInd);
                    if (trueRowInd != this._sweepIndex && cInd != this._sweepIndex) {
                        currEle -= this._ariCol[trueRowInd] * (double)this._trackPivotSweeps[cInd] * (double)this._trackPivotSweeps[this._sweepIndex] * this._ariCol[cInd] * this._oneOPivot;
                    } else if (trueRowInd == this._sweepIndex && cInd == this._sweepIndex) {
                        currEle = this._oneOPivot;
                    } else if (trueRowInd == this._sweepIndex && cInd != this._sweepIndex) {
                        currEle = (double)(this._trackPivotSweeps[cInd] * this._trackPivotSweeps[this._sweepIndex]) * this._ariCol[cInd] * this._oneOPivot;
                    } else if (trueRowInd != this._sweepIndex && cInd == this._sweepIndex) {
                        currEle = -this._oneOPivot * this._ariCol[trueRowInd];
                    }
                    chks[cInd].set(rInd, currEle);
                }
            }
        }
    }
}

