/*
 * Decompiled with CFR 0.152.
 */
package hex.modelselection;

import hex.DataInfo;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsRegression;
import hex.deeplearning.DeepLearningModel;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.modelselection.ModelSelection;
import hex.modelselection.ModelSelectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.TwoDimTable;

public class ModelSelectionModel
extends Model<ModelSelectionModel, ModelSelectionParameters, ModelSelectionModelOutput> {
    public ModelSelectionModel(Key<ModelSelectionModel> selfKey, ModelSelectionParameters parms, ModelSelectionModelOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        assert (domain == null);
        switch (((ModelSelectionModelOutput)this._output).getModelCategory()) {
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
        }
        throw H2O.unimpl("Invalid ModelCategory " + (Object)((Object)((ModelSelectionModelOutput)this._output).getModelCategory()));
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("ModelSelection does not support scoring on data.  It only provide information on predictor relevance");
    }

    @Override
    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        throw new UnsupportedOperationException("AnovaGLM does not support scoring on data.  It only provide information on predictor relevance");
    }

    @Override
    public Frame result() {
        return ((ModelSelectionModelOutput)this._output).generateResultFrame();
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        super.remove_impl(fs, cascade);
        if (cascade && ((ModelSelectionModelOutput)this._output)._best_model_ids != null && ((ModelSelectionModelOutput)this._output)._best_model_ids.length > 0) {
            for (Key oneModelID : ((ModelSelectionModelOutput)this._output)._best_model_ids) {
                if (null == oneModelID) continue;
                Keyed.remove(oneModelID, fs, cascade);
            }
        }
        return fs;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((ModelSelectionModelOutput)this._output)._best_model_ids != null && ((ModelSelectionModelOutput)this._output)._best_model_ids.length > 0) {
            for (Key oneModelID : ((ModelSelectionModelOutput)this._output)._best_model_ids) {
                if (null == oneModelID) continue;
                ab.putKey(oneModelID);
            }
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        if (((ModelSelectionModelOutput)this._output)._best_model_ids != null && ((ModelSelectionModelOutput)this._output)._best_model_ids.length > 0) {
            for (Key oneModelID : ((ModelSelectionModelOutput)this._output)._best_model_ids) {
                if (null == oneModelID) continue;
                ab.getKey(oneModelID, fs);
            }
        }
        return super.readAll_impl(ab, fs);
    }

    public HashMap<String, Double>[] coefficients() {
        return this.coefficients(false);
    }

    public HashMap<String, Double>[] coefficients(boolean standardize) {
        int numModel = ((ModelSelectionModelOutput)this._output)._best_model_ids.length;
        HashMap[] coeffs = new HashMap[numModel];
        for (int index = 0; index < numModel; ++index) {
            coeffs[index] = this.coefficients(index + 1, standardize);
        }
        return coeffs;
    }

    public HashMap<String, Double> coefficients(int predictorSize) {
        return this.coefficients(predictorSize, false);
    }

    public HashMap<String, Double> coefficients(int predictorSize, boolean standardize) {
        int numModel = ((ModelSelectionModelOutput)this._output)._best_model_ids.length;
        if (predictorSize <= 0 || predictorSize > numModel) {
            throw new IllegalArgumentException("predictorSize must be between 1 and maximum size of predictor subset size.");
        }
        GLMModel oneModel = (GLMModel)DKV.getGet(((ModelSelectionModelOutput)this._output)._best_model_ids[predictorSize - 1]);
        return oneModel.coefficients(standardize);
    }

    public static class ModelSelectionModelOutput
    extends Model.Output {
        GLMModel.GLMParameters.Family _family;
        DataInfo _dinfo;
        String[][] _coefficient_names;
        double[] _best_r2_values;
        String[][] _predictors_added_per_step;
        String[][] _predictors_removed_per_step;
        public Key[] _best_model_ids;
        double[][] _coef_p_values;
        double[][] _coefficient_values;
        double[][] _coefficient_values_normalized;
        double[][] _z_values;
        public ModelSelectionParameters.Mode _mode;
        String[][] _best_predictors_subset;

        public ModelSelectionModelOutput(ModelSelection b, DataInfo dinfo) {
            super(b, dinfo._adaptedFrame);
            this._dinfo = dinfo;
        }

        public String[][] coefficientNames() {
            return this._coefficient_names;
        }

        public double[][] beta() {
            int numModel = this._best_model_ids.length;
            double[][] coeffs = new double[numModel][];
            for (int index = 0; index < numModel; ++index) {
                GLMModel oneModel = (GLMModel)DKV.getGet(this._best_model_ids[index]);
                coeffs[index] = (double[])((GLMModel.GLMOutput)oneModel._output).beta().clone();
            }
            return coeffs;
        }

        public double[][] getNormBeta() {
            int numModel = this._best_model_ids.length;
            double[][] coeffs = new double[numModel][];
            for (int index = 0; index < numModel; ++index) {
                GLMModel oneModel = (GLMModel)DKV.getGet(this._best_model_ids[index]);
                coeffs[index] = (double[])((GLMModel.GLMOutput)oneModel._output).getNormBeta().clone();
            }
            return coeffs;
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.Regression;
        }

        private Frame generateResultFrame() {
            int numRows = this._coefficient_names.length;
            String[] modelNames = new String[numRows];
            String[] coefNames = new String[numRows];
            String[] predNames = new String[numRows];
            String[] modelIds = this._best_model_ids == null ? null : (String[])Stream.of(this._best_model_ids).map(Key::toString).toArray(String[]::new);
            String[] zvalues = new String[numRows];
            String[] pvalues = new String[numRows];
            String[] predAddedNames = new String[numRows];
            String[] predRemovedNames = new String[numRows];
            boolean backwardMode = this._z_values != null;
            for (int index = 0; index < numRows; ++index) {
                int numPred = this._best_predictors_subset[index].length;
                modelNames[index] = "best " + numPred + " predictors model";
                coefNames[index] = backwardMode ? String.join((CharSequence)", ", this._coefficient_names[index]) : String.join((CharSequence)", ", this._coefficient_names[index]);
                predAddedNames[index] = backwardMode ? "" : String.join((CharSequence)", ", this._predictors_added_per_step[index]);
                predRemovedNames[index] = this._predictors_removed_per_step[index] == null ? "" : String.join((CharSequence)", ", this._predictors_removed_per_step[index]);
                predNames[index] = String.join((CharSequence)", ", this._best_predictors_subset[index]);
                if (!backwardMode) continue;
                zvalues[index] = ModelSelectionUtils.joinDouble(this._z_values[index]);
                pvalues[index] = ModelSelectionUtils.joinDouble(this._coef_p_values[index]);
            }
            Vec.VectorGroup vg = Vec.VectorGroup.VG_LEN1;
            Vec modNames = Vec.makeVec(modelNames, vg.addVec());
            Vec modelIDV = modelIds == null ? null : Vec.makeVec(modelIds, vg.addVec());
            Vec r2 = null;
            Vec zval = null;
            Vec pval = null;
            Vec predAdded = null;
            if (backwardMode) {
                zval = Vec.makeVec(zvalues, vg.addVec());
                pval = Vec.makeVec(pvalues, vg.addVec());
            } else {
                r2 = Vec.makeVec(this._best_r2_values, vg.addVec());
                predAdded = Vec.makeVec(predAddedNames, vg.addVec());
            }
            Vec predRemoved = Vec.makeVec(predRemovedNames, vg.addVec());
            Vec coefN = Vec.makeVec(coefNames, vg.addVec());
            Vec predN = Vec.makeVec(predNames, vg.addVec());
            if (backwardMode) {
                String[] colNames = new String[]{"model_name", "model_id", "z_values", "p_values", "coefficient_names", "predictor_names", "predictors_removed"};
                return new Frame(Key.make(), colNames, new Vec[]{modNames, modelIDV, zval, pval, coefN, predN, predRemoved});
            }
            if (modelIds == null) {
                String[] colNames = new String[]{"model_name", "best_r2_value", "coefficient_names", "predictor_names", "predictors_removed", "predictors_added"};
                return new Frame(Key.make(), colNames, new Vec[]{modNames, r2, coefN, predN, predRemoved, predAdded});
            }
            String[] colNames = new String[]{"model_name", "model_id", "best_r2_value", "coefficient_names", "predictor_names", "predictors_removed", "predictors_added"};
            return new Frame(Key.make(), colNames, new Vec[]{modNames, modelIDV, r2, coefN, predN, predRemoved, predAdded});
        }

        public void shrinkArrays(int numModelsBuilt) {
            if (this._coefficient_names.length > numModelsBuilt) {
                this._coefficient_names = ModelSelectionUtils.shrinkStringArray(this._coefficient_names, numModelsBuilt);
                this._best_predictors_subset = ModelSelectionUtils.shrinkStringArray(this._best_predictors_subset, numModelsBuilt);
                this._coefficient_names = ModelSelectionUtils.shrinkStringArray(this._coefficient_names, numModelsBuilt);
                this._z_values = ModelSelectionUtils.shrinkDoubleArray(this._z_values, numModelsBuilt);
                this._coef_p_values = ModelSelectionUtils.shrinkDoubleArray(this._coef_p_values, numModelsBuilt);
                this._best_model_ids = ModelSelectionUtils.shrinkKeyArray(this._best_model_ids, numModelsBuilt);
                this._predictors_removed_per_step = ModelSelectionUtils.shrinkStringArray(this._predictors_removed_per_step, numModelsBuilt);
            }
        }

        public void generateSummary() {
            int numModels = this._best_r2_values.length;
            String[] names = new String[]{"best_r2_value", "coefficient_names", "predictor_names", "predictors_removed", "predictors_added"};
            String[] types = new String[]{"double", "String", "String", "String", "String"};
            String[] formats = new String[]{"%d", "%s", "%s", "%s", "%s"};
            String[] rowHeaders = new String[numModels];
            for (int index = 1; index <= numModels; ++index) {
                rowHeaders[index - 1] = "with " + this._best_predictors_subset[index - 1].length + " predictors";
            }
            this._model_summary = new TwoDimTable("ModelSelection Model Summary", "summary", rowHeaders, names, types, formats, "");
            for (int rIndex = 0; rIndex < numModels; ++rIndex) {
                int colInd = 0;
                this._model_summary.set(rIndex, colInd++, this._best_r2_values[rIndex]);
                this._model_summary.set(rIndex, colInd++, String.join((CharSequence)", ", this._coefficient_names[rIndex]));
                this._model_summary.set(rIndex, colInd++, String.join((CharSequence)", ", this._best_predictors_subset[rIndex]));
                if (this._predictors_removed_per_step[rIndex] != null) {
                    this._model_summary.set(rIndex, colInd++, String.join((CharSequence)", ", this._predictors_removed_per_step[rIndex]));
                } else {
                    this._model_summary.set(rIndex, colInd++, "");
                }
                this._model_summary.set(rIndex, colInd++, String.join((CharSequence)", ", this._predictors_added_per_step[rIndex]));
            }
        }

        public void generateSummary(int numModels) {
            String[] names = new String[]{"coefficient_names", "predictor_names", "z_values", "p_values", "predictors_removed"};
            String[] types = new String[]{"string", "string", "string", "string", "string"};
            String[] formats = new String[]{"%s", "%s", "%s", "%s", "%s"};
            String[] rowHeaders = new String[numModels];
            for (int index = 0; index < numModels; ++index) {
                rowHeaders[index] = "with " + this._best_predictors_subset[index].length + " predictors";
            }
            this._model_summary = new TwoDimTable("ModelSelection Model Summary", "summary", rowHeaders, names, types, formats, "");
            for (int rIndex = 0; rIndex < numModels; ++rIndex) {
                int colInd = 0;
                String coeffNames = String.join((CharSequence)", ", this._coefficient_names[rIndex]);
                String predNames = String.join((CharSequence)", ", this._best_predictors_subset[rIndex]);
                String pValue = ModelSelectionUtils.joinDouble(this._coef_p_values[rIndex]);
                String zValue = ModelSelectionUtils.joinDouble(this._z_values[rIndex]);
                this._model_summary.set(rIndex, colInd++, coeffNames);
                this._model_summary.set(rIndex, colInd++, predNames);
                this._model_summary.set(rIndex, colInd++, zValue);
                this._model_summary.set(rIndex, colInd++, pValue);
                this._model_summary.set(rIndex, colInd, this._predictors_removed_per_step[rIndex][0]);
            }
        }

        void updateBestModels(GLMModel bestModel, int index) {
            this._best_model_ids[index] = bestModel.getKey();
            if (((GLMModel.GLMParameters)bestModel._parms)._nfolds > 0) {
                int r2Index = Arrays.asList(((GLMModel.GLMOutput)bestModel._output)._cross_validation_metrics_summary.getRowHeaders()).indexOf("r2");
                Float tempR2 = (Float)((GLMModel.GLMOutput)bestModel._output)._cross_validation_metrics_summary.get(r2Index, 0);
                this._best_r2_values[index] = tempR2.doubleValue();
            } else {
                this._best_r2_values[index] = bestModel.r2();
            }
            this.extractCoeffs(bestModel, index);
            this.updateAddedRemovedPredictors(index);
        }

        void extractCoeffs(GLMModel model, int index) {
            this._coefficient_names[index] = (String[])((GLMModel.GLMOutput)model._output).coefficientNames().clone();
            ArrayList<String> coeffNames = new ArrayList<String>(Arrays.asList(((GLMModel.GLMOutput)model._output).coefficientNames()));
            this._coefficient_names[index] = coeffNames.toArray(new String[0]);
            List predNames = Stream.of(model.names()).collect(Collectors.toList());
            predNames.remove(((GLMModel.GLMParameters)model._parms)._response_column);
            this._best_predictors_subset[index] = (String[])predNames.stream().toArray(String[]::new);
        }

        void updateBestModels(String[] predictorNames, List<String> allCoefNames, int index, boolean hasIntercept, int actualCPMSize, int[] predsubset, double[][] lastCPM, double r2Scale, ModelSelectionUtils.CoeffNormalization coeffN, int[][] pred2CPMIndex, DataInfo dinfo) {
            int lastCPMIndex = actualCPMSize - 1;
            this._best_r2_values[index] = lastCPM[lastCPMIndex][lastCPMIndex] == Double.MAX_VALUE ? -1.0 : 1.0 - r2Scale * lastCPM[lastCPMIndex][lastCPMIndex];
            this.extractCoeffs(predictorNames, allCoefNames, lastCPM, index, hasIntercept, actualCPMSize, predsubset, coeffN, pred2CPMIndex, dinfo);
            this.updateAddedRemovedPredictors(index);
        }

        void extractCoeffs(String[] predNames, List<String> allCoefNames, double[][] cpm, int index, boolean hasIntercept, int actualCPMSize, int[] predSubset, ModelSelectionUtils.CoeffNormalization coeffN, int[][] predsubset2CPMIndices, DataInfo dinfo) {
            this._best_predictors_subset[index] = ModelSelectionModelOutput.extractPredsFromPredIndices(predNames, predSubset);
            this._coefficient_names[index] = ModelSelectionModelOutput.extractCoefsFromPred(allCoefNames, hasIntercept, dinfo, predSubset);
            this.extractCoefsValues(cpm, this._coefficient_names[index].length, hasIntercept, actualCPMSize, coeffN, index, predSubset, predsubset2CPMIndices);
        }

        public void extractCoefsValues(double[][] cpm, int coefValLen, boolean hasIntercept, int actualCPMSize, ModelSelectionUtils.CoeffNormalization coeffN, int predIndex, int[] predSubset, int[][] pred2CPMIndices) {
            this._coefficient_values[predIndex] = new double[coefValLen];
            this._coefficient_values_normalized[predIndex] = new double[coefValLen];
            int lastCPMIndex = actualCPMSize - 1;
            int cpmIndexOffset = hasIntercept ? 1 : 0;
            boolean standardize = coeffN._standardize;
            double[] sigmaOrOneOSigma = coeffN._sigmaOrOneOSigma;
            double[] meanOverSigma = coeffN._meanOverSigma;
            double sumBetaMeanOverSigma = 0.0;
            int numIndexStart = this._dinfo._cats;
            int offset = 0;
            int predSubsetLen = predSubset.length;
            for (int pIndex = 0; pIndex < predSubsetLen; ++pIndex) {
                int cpmInd;
                int coefIndex;
                int predictor = predSubset[pIndex];
                if (predictor >= numIndexStart) {
                    coefIndex = pIndex + offset;
                    cpmInd = cpmIndexOffset + pIndex;
                    if (standardize) {
                        this._coefficient_values[predIndex][coefIndex] = cpm[cpmInd][lastCPMIndex] * sigmaOrOneOSigma[predictor - numIndexStart];
                        this._coefficient_values_normalized[predIndex][coefIndex] = cpm[cpmInd][lastCPMIndex];
                    } else {
                        this._coefficient_values[predIndex][coefIndex] = cpm[cpmInd][lastCPMIndex];
                        this._coefficient_values_normalized[predIndex][coefIndex] = cpm[cpmInd][lastCPMIndex] * sigmaOrOneOSigma[predictor - numIndexStart];
                    }
                    sumBetaMeanOverSigma += this._coefficient_values_normalized[predIndex][coefIndex] * meanOverSigma[predictor - numIndexStart];
                    continue;
                }
                int cpmLen = pred2CPMIndices[predictor].length;
                for (int cpmIndex = 0; cpmIndex < cpmLen; ++cpmIndex) {
                    coefIndex = offset + cpmIndex + pIndex;
                    cpmInd = cpmIndexOffset + cpmIndex + pIndex;
                    this._coefficient_values[predIndex][coefIndex] = cpm[cpmInd][lastCPMIndex];
                    this._coefficient_values_normalized[predIndex][coefIndex] = cpm[cpmInd][lastCPMIndex];
                }
                offset += cpmLen - 1;
                cpmIndexOffset += cpmLen - 1;
            }
            if (hasIntercept) {
                int lastCoefInd = this._coefficient_values[predIndex].length - 1;
                if (coeffN._standardize) {
                    this._coefficient_values_normalized[predIndex][lastCoefInd] = cpm[0][lastCPMIndex];
                    this._coefficient_values[predIndex][lastCoefInd] = cpm[0][lastCPMIndex] - sumBetaMeanOverSigma;
                } else {
                    this._coefficient_values_normalized[predIndex][lastCoefInd] = cpm[0][lastCPMIndex] + sumBetaMeanOverSigma;
                    this._coefficient_values[predIndex][lastCoefInd] = cpm[0][lastCPMIndex];
                }
            }
        }

        public static String[] extractCoefsFromPred(List<String> allCoefList, boolean hasIntercept, DataInfo dinfo, int[] predSubset) {
            ArrayList<Object> coefNames = new ArrayList<Object>();
            int numPred = predSubset.length;
            int numCats = dinfo._cats;
            int catOffsets = dinfo._catOffsets[dinfo._catOffsets.length - 1];
            for (int index = 0; index < numPred; ++index) {
                int predIndex = predSubset[index];
                if (predIndex < numCats) {
                    int numCatLevel = dinfo._catOffsets[predIndex + 1] - dinfo._catOffsets[predIndex];
                    int predictorInd = predIndex;
                    List coeffs = IntStream.range(0, numCatLevel).mapToObj(x -> (String)allCoefList.get(x + dinfo._catOffsets[predictorInd])).collect(Collectors.toList());
                    coefNames.addAll(coeffs);
                    continue;
                }
                coefNames.add(allCoefList.get(predIndex + catOffsets - numCats));
            }
            if (hasIntercept) {
                coefNames.add("Intercept");
            }
            return coefNames.toArray(new String[0]);
        }

        public static String[] extractPredsFromPredIndices(String[] allPreds, int[] predSubset) {
            int numPreds = predSubset.length;
            String[] predSubsetNames = new String[numPreds];
            for (int index = 0; index < numPreds; ++index) {
                predSubsetNames[index] = allPreds[predSubset[index]];
            }
            return predSubsetNames;
        }

        void updateAddedRemovedPredictors(int index) {
            List newSet = Stream.of(this._coefficient_names[index]).collect(Collectors.toList());
            if (index > 0) {
                String[] stringArray;
                List oldSet = Stream.of(this._coefficient_names[index - 1]).collect(Collectors.toList());
                List<String> predDeleted = oldSet.stream().filter(x -> !newSet.contains(x) && !"Intercept".equals(x)).collect(Collectors.toList());
                if (predDeleted == null || predDeleted.size() == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    stringArray = this._predictors_removed_per_step[index] = predDeleted.toArray(new String[predDeleted.size()]);
                }
                if (!ModelSelectionParameters.Mode.backward.equals((Object)this._mode)) {
                    List<String> predAdded = newSet.stream().filter(x -> !oldSet.contains(x) && !"Intercept".equals(x)).collect(Collectors.toList());
                    this._predictors_added_per_step[index] = predAdded.toArray(new String[0]);
                }
                return;
            }
            if (!ModelSelectionParameters.Mode.backward.equals((Object)this._mode)) {
                this._predictors_added_per_step[index] = new String[]{this._coefficient_names[index][0]};
                this._predictors_removed_per_step[index] = new String[]{""};
                return;
            }
            this._predictors_removed_per_step[index] = new String[]{""};
            this._predictors_added_per_step[index] = new String[]{""};
        }

        void resetCoeffs(GLMModel model, List<String> predNames, List<String> numPredNames, List<String> catPredNames) {
            String[] coeffName = ((GLMModel.GLMOutput)model._output).coefficientNames();
            int[] idxs = ((GLMModel.GLMOutput)model._output).bestSubmodel().idxs;
            if (idxs == null) {
                return;
            }
            List<String> coeffNames = Arrays.stream(idxs).mapToObj(x -> coeffName[x]).collect(Collectors.toList());
            this.resetAllPreds(predNames, catPredNames, numPredNames, model, coeffNames);
        }

        void resetAllPreds(List<String> predNames, List<String> catPredNames, List<String> numPredNames, GLMModel model, List<String> coeffNames) {
            if (((GLMModel.GLMOutput)model._output).bestSubmodel().idxs.length == model.coefficients().size()) {
                return;
            }
            this.resetNumPredNames(numPredNames, coeffNames);
            this.resetCatPredNames(model.dinfo(), ((GLMModel.GLMOutput)model._output).bestSubmodel().idxs, catPredNames);
            if (predNames.size() > numPredNames.size() + catPredNames.size()) {
                predNames.clear();
                predNames.addAll(catPredNames);
                predNames.addAll(numPredNames);
            }
        }

        public void resetNumPredNames(List<String> numPredNames, List<String> coeffNames) {
            List newNumPredNames = numPredNames.stream().filter(x -> coeffNames.contains(x)).collect(Collectors.toList());
            numPredNames.clear();
            numPredNames.addAll(newNumPredNames);
        }

        public void resetCatPredNames(DataInfo dinfo, int[] idxs, List<String> catPredNames) {
            ArrayList<String> newCatPredNames = new ArrayList<String>();
            List idxsList = Arrays.stream(idxs).boxed().collect(Collectors.toList());
            int[] catOffset = dinfo._catOffsets;
            int catIndex = catOffset.length;
            int maxCatOffset = catOffset[catIndex - 1];
            for (int index = 1; index < catIndex; ++index) {
                int offsetedIndex = index - 1;
                List currCatList = IntStream.range(catOffset[offsetedIndex], catOffset[index]).boxed().collect(Collectors.toList());
                if (currCatList.stream().filter(x -> idxsList.contains(x)).count() <= 0L || (Integer)currCatList.get(currCatList.size() - 1) >= maxCatOffset) continue;
                newCatPredNames.add(catPredNames.get(offsetedIndex));
            }
            if (newCatPredNames.size() < catPredNames.size()) {
                catPredNames.clear();
                catPredNames.addAll(newCatPredNames);
            }
        }

        void extractPredictors4NextModel(GLMModel model, int index, List<String> predNames, List<String> numPredNames, List<String> catPredNames) {
            boolean firstRun = index + 1 == predNames.size();
            ArrayList<String> oldPredNames = firstRun ? new ArrayList<String>(predNames) : null;
            this.extractCoeffs(model, index);
            int predIndex2Remove = ModelSelectionUtils.findMinZValue(model, numPredNames, catPredNames, predNames);
            String pred2Remove = predNames.get(predIndex2Remove);
            if (firstRun) {
                this.resetCoeffs(model, predNames, numPredNames, catPredNames);
            }
            List redundantPred = firstRun ? oldPredNames.stream().filter(x -> !predNames.contains(x)).collect(Collectors.toList()) : null;
            this._best_model_ids[index] = model.getKey();
            if (redundantPred != null && redundantPred.size() > 0) {
                redundantPred = redundantPred.stream().map(x -> x + "(redundant_predictor)").collect(Collectors.toList());
                redundantPred.add(pred2Remove);
                this._predictors_removed_per_step[index] = (String[])redundantPred.stream().toArray(String[]::new);
            } else {
                this._predictors_removed_per_step[index] = new String[]{pred2Remove};
            }
            this._z_values[index] = (double[])((GLMModel.GLMOutput)model._output).zValues().clone();
            this._coef_p_values[index] = (double[])((GLMModel.GLMOutput)model._output).pValues().clone();
            predNames.remove(pred2Remove);
            if (catPredNames.contains(pred2Remove)) {
                catPredNames.remove(pred2Remove);
            } else {
                numPredNames.remove(pred2Remove);
            }
        }
    }

    public static class ModelSelectionParameters
    extends Model.Parameters {
        public double[] _alpha;
        public boolean _standardize = true;
        public boolean _intercept = true;
        GLMModel.GLMParameters.Family _family = GLMModel.GLMParameters.Family.AUTO;
        public boolean _lambda_search;
        public GLMModel.GLMParameters.Link _link = GLMModel.GLMParameters.Link.family_default;
        public GLMModel.GLMParameters.Solver _solver = GLMModel.GLMParameters.Solver.IRLSM;
        public String[] _interactions = null;
        public Serializable _missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
        public boolean _compute_p_values = false;
        public boolean _remove_collinear_columns = false;
        public int _nfolds = 0;
        public Key<Frame> _plug_values = null;
        public int _max_predictor_number = 1;
        public int _min_predictor_number = 1;
        public int _nparallelism = 0;
        public double _p_values_threshold = 0.0;
        public double _tweedie_variance_power;
        public double _tweedie_link_power;
        public Mode _mode = Mode.maxr;
        public double _beta_epsilon = 1.0E-4;
        public double _objective_epsilon = -1.0;
        public double _gradient_epsilon = -1.0;
        public double _obj_reg = -1.0;
        public double[] _lambda = new double[]{0.0};
        public boolean _use_all_factor_levels = false;
        public boolean _build_glm_model = false;
        public GLMModel.GLMParameters.Influence _influence;
        public boolean _multinode_mode = false;

        @Override
        public String algoName() {
            return "ModelSelection";
        }

        @Override
        public String fullName() {
            return "Model Selection";
        }

        @Override
        public String javaName() {
            return ModelSelectionModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return 1L;
        }

        public GLMModel.GLMParameters.MissingValuesHandling missingValuesHandling() {
            if (this._missing_values_handling instanceof GLMModel.GLMParameters.MissingValuesHandling) {
                return (GLMModel.GLMParameters.MissingValuesHandling)((Object)this._missing_values_handling);
            }
            assert (this._missing_values_handling instanceof DeepLearningModel.DeepLearningParameters.MissingValuesHandling);
            switch ((DeepLearningModel.DeepLearningParameters.MissingValuesHandling)((Object)this._missing_values_handling)) {
                case MeanImputation: {
                    return GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
                }
                case Skip: {
                    return GLMModel.GLMParameters.MissingValuesHandling.Skip;
                }
            }
            throw new IllegalStateException("Unsupported missing values handling value: " + this._missing_values_handling);
        }

        public boolean imputeMissing() {
            return this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues;
        }

        public DataInfo.Imputer makeImputer() {
            if (this.missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
                if (this._plug_values == null || this._plug_values.get() == null) {
                    throw new IllegalStateException("Plug values frame needs to be specified when Missing Value Handling = PlugValues.");
                }
                return new GLM.PlugValuesImputer(this._plug_values.get());
            }
            return new DataInfo.MeanImputer();
        }

        public static enum Mode {
            allsubsets,
            maxr,
            maxrsweep,
            backward;

        }
    }
}

