/*
 * Decompiled with CFR 0.152.
 */
package hex.modelselection;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelBuilderHelper;
import hex.ModelCategory;
import hex.genmodel.utils.MathUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.modelselection.ModelSelectionModel;
import hex.modelselection.ModelSelectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Key;
import water.Lockable;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.PrettyPrint;

public class ModelSelection
extends ModelBuilder<ModelSelectionModel, ModelSelectionModel.ModelSelectionParameters, ModelSelectionModel.ModelSelectionModelOutput> {
    public String[][] _bestModelPredictors;
    public double[] _bestR2Values;
    public String[][] _predictorsAdd;
    public String[][] _predictorsRemoved;
    DataInfo _dinfo;
    String[] _coefNames;
    public int _numPredictors;
    public String[] _predictorNames;
    double[][] _currCPM;
    Frame _currCPMFrame;
    int[] _trackSweep;
    public int _glmNFolds = 0;
    Model.Parameters.FoldAssignmentScheme _foldAssignment = null;
    String _foldColumn = null;

    public ModelSelection(boolean startup_once) {
        super(new ModelSelectionModel.ModelSelectionParameters(), startup_once);
    }

    public ModelSelection(ModelSelectionModel.ModelSelectionParameters parms) {
        super(parms);
        this.init(false);
    }

    public ModelSelection(ModelSelectionModel.ModelSelectionParameters parms, Key<ModelSelectionModel> key) {
        super(parms, key);
        this.init(false);
    }

    @Override
    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(1, 2);
    }

    @Override
    protected ModelSelectionDriver trainModelImpl() {
        return new ModelSelectionDriver();
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression};
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    @Override
    public boolean haveMojo() {
        return false;
    }

    @Override
    public boolean havePojo() {
        return false;
    }

    @Override
    public void init(boolean expensive) {
        if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._nfolds > 0 || ((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_column != null) {
            if (ModelSelectionModel.ModelSelectionParameters.Mode.backward.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
                this.error("nfolds/fold_column", "cross-validation is not supported for backward selection.");
            } else if (ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
                this.error("nfolds/fold_column", "cross-validation is not supported for maxrsweep,  maxrsweepsmall, maxrsweep and maxrsweepfull.");
            } else {
                this._glmNFolds = ((ModelSelectionModel.ModelSelectionParameters)this._parms)._nfolds;
                if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_assignment != null) {
                    this._foldAssignment = ((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_assignment;
                    ((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_assignment = null;
                }
                if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_column != null) {
                    this._foldColumn = ((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_column;
                    ((ModelSelectionModel.ModelSelectionParameters)this._parms)._fold_column = null;
                }
                ((ModelSelectionModel.ModelSelectionParameters)this._parms)._nfolds = 0;
            }
        }
        super.init(expensive);
        if (this.error_count() > 0) {
            return;
        }
        if (expensive) {
            this.initModelSelectionParameters();
            if (this.error_count() > 0) {
                return;
            }
            this.initModelParameters();
        }
    }

    private void initModelParameters() {
        if (!ModelSelectionModel.ModelSelectionParameters.Mode.backward.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
            this._bestR2Values = new double[((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number];
            this._bestModelPredictors = new String[((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number][];
            if (!ModelSelectionModel.ModelSelectionParameters.Mode.backward.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
                this._predictorsAdd = new String[((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number][];
            }
            this._predictorsRemoved = new String[((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number][];
        }
    }

    private void initModelSelectionParameters() {
        this._predictorNames = ModelSelectionUtils.extractPredictorNames(this._parms, this._dinfo, this._foldColumn);
        this._numPredictors = this._predictorNames.length;
        if (ModelSelectionModel.ModelSelectionParameters.Mode.maxr.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode) || ModelSelectionModel.ModelSelectionParameters.Mode.allsubsets.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode) || ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda == null && !((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda_search && ((ModelSelectionModel.ModelSelectionParameters)this._parms)._alpha == null && !ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
                ((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda = new double[]{0.0};
            }
            if (this.nclasses() > 1) {
                this.error("response", "'allsubsets', 'maxr', 'maxrsweep', 'maxrsweep' only works with regression.");
            }
            if (!GLMModel.GLMParameters.Family.AUTO.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.gaussian.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._family)) {
                this.error("_family", "ModelSelection only supports Gaussian family for 'allsubset' and 'maxr' mode.");
            }
            if (GLMModel.GLMParameters.Family.AUTO.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._family)) {
                ((ModelSelectionModel.ModelSelectionParameters)this._parms)._family = GLMModel.GLMParameters.Family.gaussian;
            }
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number < 1 || ((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number > this._numPredictors) {
                this.error("max_predictor_number", "max_predictor_number must exceed 0 and be no greater than the number of predictors of the training frame.");
            }
        } else {
            ((ModelSelectionModel.ModelSelectionParameters)this._parms)._compute_p_values = true;
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._valid != null) {
                this.error("validation_frame", " is not supported for ModelSelection mode='backward'");
            }
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda_search) {
                this.error("lambda_search", "backward selection does not support lambda_search.");
            }
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda != null) {
                if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda.length > 1) {
                    this.error("lambda", "if set must be set to 0 and cannot be an array or more than length one for backward selection.");
                }
                if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda[0] != 0.0) {
                    this.error("lambda", "must be set to 0 for backward selection");
                }
            } else {
                ((ModelSelectionModel.ModelSelectionParameters)this._parms)._lambda = new double[]{0.0};
            }
            if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._family)) {
                this.error("family", "backward selection does not support multinomial or ordinal");
            }
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._min_predictor_number <= 0) {
                this.error("min_predictor_number", "must be >= 1.");
            }
            if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._min_predictor_number > this._numPredictors) {
                this.error("min_predictor_number", "cannot exceed the total number of predictors (" + this._numPredictors + ")in the dataset.");
            }
        }
        if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._nparallelism < 0) {
            this.error("nparallelism", "must be >= 0.");
        }
        if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._nparallelism == 0) {
            ((ModelSelectionModel.ModelSelectionParameters)this._parms)._nparallelism = H2O.NUMCPUS;
        }
        if (ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
            this.warn("validation_frame", " is not used in choosing the best k subset for ModelSelection models with maxrsweep.");
        }
        if (ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode) && !((ModelSelectionModel.ModelSelectionParameters)this._parms)._build_glm_model && ((ModelSelectionModel.ModelSelectionParameters)this._parms)._influence != null) {
            this.error("influence", " can only be set if glm models are built.  With maxrsweep model without build_glm_model = true, no GLM models will be built and hence no regression influence diagnostics can be calculated.");
        }
    }

    protected void checkMemoryFootPrint(int p) {
        long max_mem;
        HeartBeat hb;
        long mem_usage;
        if (ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)this._parms)._mode)) {
            p = (int)Math.ceil(p * (((ModelSelectionModel.ModelSelectionParameters)this._parms)._max_predictor_number + 2) / this._dinfo.fullN());
        }
        if ((mem_usage = (long)(hb._cpus_allowed * (p * p * p))) > (max_mem = (hb = H2O.SELF._heartbeat).get_free_mem())) {
            String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes(mem_usage) + " > " + PrettyPrint.bytes(max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
            this.error("_train", msg);
        }
    }

    public SweepModel forwardStep(List<Integer> currSubsetIndices, List<Integer> validSubsets, Set<BitSet> usedCombo, BitSet predIndices, int[][] predInd2CPMInd, SweepModel bestModel, boolean hasIntercept) {
        double[] subsetErrVar = bestModel == null ? ModelSelectionUtils.generateAllErrVar(this._currCPM, this._currCPMFrame, -1, currSubsetIndices, validSubsets, usedCombo, predIndices, predInd2CPMInd, hasIntercept) : ModelSelectionUtils.generateAllErrVar(this._currCPM, this._currCPMFrame, bestModel._CPM.length - 1, currSubsetIndices, validSubsets, usedCombo, predIndices, predInd2CPMInd, hasIntercept);
        int bestInd = -1;
        double errorVarianceMin = Double.MAX_VALUE;
        int numModel = subsetErrVar.length;
        for (int index = 0; index < numModel; ++index) {
            if (!(subsetErrVar[index] < errorVarianceMin)) continue;
            errorVarianceMin = subsetErrVar[index];
            bestInd = index;
        }
        if (bestInd == -1) {
            return new SweepModel(null, null, errorVarianceMin);
        }
        int newPredictor = validSubsets.get(bestInd);
        List<Integer> newIndices = ModelSelectionUtils.extractCPMIndexFromPredOnly(predInd2CPMInd, new int[]{newPredictor});
        if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._multinode_mode) {
            ModelSelectionUtils.sweepCPMParallel(this._currCPMFrame, newIndices.stream().mapToInt(x -> x).toArray(), this._trackSweep);
        } else {
            ModelSelectionUtils.sweepCPM(this._currCPM, newIndices.stream().mapToInt(x -> x).toArray(), false);
        }
        currSubsetIndices.add(newPredictor);
        int[] subsetPred = currSubsetIndices.stream().mapToInt(x -> x).toArray();
        double[][] subsetCPM = ((ModelSelectionModel.ModelSelectionParameters)this._parms)._multinode_mode ? ModelSelectionUtils.extractPredSubsetsCPMFrame(this._currCPMFrame, subsetPred, predInd2CPMInd, hasIntercept) : ModelSelectionUtils.extractPredSubsetsCPM(this._currCPM, subsetPred, predInd2CPMInd, hasIntercept);
        return new SweepModel(subsetPred, subsetCPM, errorVarianceMin);
    }

    public SweepModel replacement(List<Integer> currSubsetIndices, List<Integer> validSubset, Set<BitSet> usedCombos, BitSet predIndices, SweepModel bestModel, int[][] predictorIndex2CPMIndices) {
        double errorVarianceMin = bestModel._errorVariance;
        int currSubsetSize = currSubsetIndices.size();
        int lastBestErrVarPosIndex = -1;
        SweepModel currModel = new SweepModel(bestModel._predSubset, bestModel._CPM, bestModel._errorVariance);
        SweepModel bestErrVarModel = new SweepModel(bestModel._predSubset, bestModel._CPM, bestModel._errorVariance);
        while (true) {
            for (int index = 0; index < currSubsetSize; ++index) {
                ArrayList<Integer> oneLessSubset = new ArrayList<Integer>(currSubsetIndices);
                int removedPred = oneLessSubset.remove(index);
                validSubset.removeAll(oneLessSubset);
                currModel._predSubset = oneLessSubset.stream().mapToInt(x -> x).toArray();
                SweepModel tempModel = this.forwardStepR(currSubsetIndices, validSubset, usedCombos, predIndices, predictorIndex2CPMIndices, currModel, errorVarianceMin, index);
                if (tempModel._CPM == null || !(errorVarianceMin > tempModel._errorVariance)) continue;
                currModel = tempModel;
                errorVarianceMin = currModel._errorVariance;
                lastBestErrVarPosIndex = index;
                bestErrVarModel = new SweepModel(currModel._predSubset, currModel._CPM, currModel._errorVariance);
                validSubset.add(removedPred);
            }
            if (lastBestErrVarPosIndex < 0) break;
            lastBestErrVarPosIndex = -1;
        }
        return bestErrVarModel;
    }

    public SweepModel forwardStepR(List<Integer> currSubsetIndices, List<Integer> validSubsets, Set<BitSet> usedCombo, BitSet predIndices, int[][] predInd2CPMInd, SweepModel bestModel, double bestErrVar, int predPos) {
        double[][] subsetCPM;
        double[][] subsetCPMO = ArrayUtils.deepClone(bestModel._CPM);
        int predRemoved = currSubsetIndices.get(predPos);
        int[] removedPredSweepInd = ModelSelectionUtils.extractSweepIndices(currSubsetIndices, predPos, predRemoved, predInd2CPMInd, ((ModelSelectionModel.ModelSelectionParameters)this._parms)._intercept);
        ModelSelectionUtils.SweepVector[][] removedPredSV = ModelSelectionUtils.sweepCPM(subsetCPMO, removedPredSweepInd, true);
        double[] subsetErrVar = ModelSelectionUtils.generateAllErrVarR(this._currCPM, this._currCPMFrame, subsetCPMO, predPos, currSubsetIndices, validSubsets, usedCombo, predIndices, predInd2CPMInd, ((ModelSelectionModel.ModelSelectionParameters)this._parms)._intercept, removedPredSweepInd, removedPredSV);
        int bestInd = -1;
        double errorVarianceMin = Double.MAX_VALUE;
        int numModel = subsetErrVar.length;
        for (int index = 0; index < numModel; ++index) {
            if (!(subsetErrVar[index] < errorVarianceMin)) continue;
            errorVarianceMin = subsetErrVar[index];
            bestInd = index;
        }
        if (bestInd == -1 || errorVarianceMin > bestErrVar) {
            return new SweepModel(null, null, errorVarianceMin);
        }
        int newPredictor = validSubsets.get(bestInd);
        currSubsetIndices.remove(predPos);
        currSubsetIndices.add(predPos, newPredictor);
        int[] subsetPred = currSubsetIndices.stream().mapToInt(Integer::intValue).toArray();
        bestModel._predSubset = subsetPred;
        if (((ModelSelectionModel.ModelSelectionParameters)this._parms)._multinode_mode) {
            ModelSelectionUtils.sweepCPMParallel(this._currCPMFrame, predInd2CPMInd[predRemoved], this._trackSweep);
            ModelSelectionUtils.sweepCPMParallel(this._currCPMFrame, predInd2CPMInd[newPredictor], this._trackSweep);
            subsetCPM = ModelSelectionUtils.extractPredSubsetsCPMFrame(this._currCPMFrame, subsetPred, predInd2CPMInd, ((ModelSelectionModel.ModelSelectionParameters)this._parms)._intercept);
        } else {
            ModelSelectionUtils.sweepCPM(this._currCPM, predInd2CPMInd[predRemoved], false);
            ModelSelectionUtils.sweepCPM(this._currCPM, predInd2CPMInd[newPredictor], false);
            subsetCPM = ModelSelectionUtils.extractPredSubsetsCPM(this._currCPM, subsetPred, predInd2CPMInd, ((ModelSelectionModel.ModelSelectionParameters)this._parms)._intercept);
        }
        bestModel._CPM = subsetCPM;
        bestModel._errorVariance = errorVarianceMin;
        return bestModel;
    }

    public static GLMModel buildExtractBestR2Model(Frame[] trainingFrames, ModelSelectionModel.ModelSelectionParameters parms, int glmNFolds, String foldColumn, Model.Parameters.FoldAssignmentScheme foldAssignment) {
        GLMModel.GLMParameters[] trainingParams = ModelSelectionUtils.generateGLMParameters(trainingFrames, parms, glmNFolds, foldColumn, foldAssignment);
        ModelBuilder[] glmBuilder = ModelSelectionUtils.buildGLMBuilders(trainingParams);
        GLM[] glmResults = (GLM[])ModelBuilderHelper.trainModelsParallel((ModelBuilder[])glmBuilder, (int)parms._nparallelism);
        return ModelSelectionUtils.findBestModel(glmResults);
    }

    public static GLMModel forwardStep(List<Integer> currSubsetIndices, List<String> coefNames, int predPos, List<Integer> validSubsets, ModelSelectionModel.ModelSelectionParameters parms, String foldColumn, int glmNFolds, Model.Parameters.FoldAssignmentScheme foldAssignment, Set<BitSet> usedCombo) {
        String[] predictorNames = (String[])coefNames.stream().toArray(String[]::new);
        Frame[] trainingFrames = ModelSelectionUtils.generateMaxRTrainingFrames(parms, predictorNames, foldColumn, currSubsetIndices, predPos, validSubsets, usedCombo);
        if (trainingFrames.length > 0) {
            GLMModel bestModel = ModelSelection.buildExtractBestR2Model(trainingFrames, parms, glmNFolds, foldColumn, foldAssignment);
            List<String> coefUsed = ModelSelectionUtils.extraModelColumnNames(coefNames, bestModel);
            for (int predIndex = coefUsed.size() - 1; predIndex >= 0; --predIndex) {
                int index = coefNames.indexOf(coefUsed.get(predIndex));
                if (currSubsetIndices.contains(index)) continue;
                currSubsetIndices.add(predPos, index);
                break;
            }
            ModelSelectionUtils.removeTrainingFrames(trainingFrames);
            return bestModel;
        }
        return null;
    }

    public static GLMModel forwardStep(List<Integer> currSubsetIndices, List<String> coefNames, int predPos, List<Integer> validSubsets, ModelSelectionModel.ModelSelectionParameters parms, String foldColumn, int glmNFolds, Model.Parameters.FoldAssignmentScheme foldAssignment) {
        return ModelSelection.forwardStep(currSubsetIndices, coefNames, predPos, validSubsets, parms, foldColumn, glmNFolds, foldAssignment, null);
    }

    public static GLMModel replacement(List<Integer> currSubsetIndices, List<String> coefNames, double bestR2, ModelSelectionModel.ModelSelectionParameters parms, int glmNFolds, String foldColumn, List<Integer> validSubset, Model.Parameters.FoldAssignmentScheme foldAssignment, Set<BitSet> usedCombos) {
        int currSubsetSize = currSubsetIndices.size();
        int lastInd = currSubsetSize - 1;
        int lastBestR2PosIndex = -1;
        Lockable bestR2Model = null;
        while (true) {
            for (int index = 0; index < currSubsetSize; ++index) {
                ArrayList<Integer> oneLessSubset = new ArrayList<Integer>(currSubsetIndices);
                int predIndexRemoved = oneLessSubset.remove(index);
                GLMModel oneModel = ModelSelection.forwardStep(oneLessSubset, coefNames, index, validSubset, parms, foldColumn, glmNFolds, foldAssignment, usedCombos);
                if (oneModel == null) continue;
                if (oneModel.r2() > bestR2) {
                    lastBestR2PosIndex = index;
                    validSubset.remove(oneLessSubset.get(lastInd));
                    if (bestR2Model != null) {
                        bestR2Model.delete();
                    }
                    bestR2Model = oneModel;
                    bestR2 = ((Model)bestR2Model).r2();
                    currSubsetIndices.clear();
                    currSubsetIndices.addAll(oneLessSubset);
                    validSubset.add(predIndexRemoved);
                    continue;
                }
                oneModel.delete();
            }
            if (lastBestR2PosIndex < 0) break;
            lastBestR2PosIndex = -1;
        }
        return bestR2Model;
    }

    public static class SweepModel {
        int[] _predSubset;
        double[][] _CPM;
        double _errorVariance;

        public SweepModel(int[] predSubset, double[][] cpm, double mse) {
            this._predSubset = predSubset;
            this._CPM = cpm;
            this._errorVariance = mse;
        }
    }

    public class ModelSelectionDriver
    extends ModelBuilder.Driver {
        public ModelSelectionDriver() {
            super(ModelSelection.this);
        }

        public final void buildModel() {
            Lockable model = null;
            try {
                int numModelBuilt = 0;
                model = new ModelSelectionModel(ModelSelection.this.dest(), (ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms, new ModelSelectionModel.ModelSelectionModelOutput(ModelSelection.this, ModelSelection.this._dinfo));
                model.write_lock(ModelSelection.this._job);
                ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._mode = ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode;
                if (ModelSelectionModel.ModelSelectionParameters.Mode.backward.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode)) {
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._best_model_ids = new Key[ModelSelection.this._numPredictors];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._coef_p_values = new double[ModelSelection.this._numPredictors][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._z_values = new double[ModelSelection.this._numPredictors][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._best_predictors_subset = new String[ModelSelection.this._numPredictors][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._coefficient_names = new String[ModelSelection.this._numPredictors][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._predictors_removed_per_step = new String[ModelSelection.this._numPredictors][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._predictors_added_per_step = new String[ModelSelection.this._numPredictors][];
                } else {
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._best_r2_values = new double[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._best_predictors_subset = new String[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._coefficient_names = new String[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._predictors_removed_per_step = new String[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number][];
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._predictors_added_per_step = new String[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number][];
                    if (ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode) && !((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._build_glm_model) {
                        ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._coefficient_values = new double[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number][];
                        ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._coefficient_values_normalized = new double[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number][];
                        ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._best_model_ids = null;
                    } else {
                        ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output)._best_model_ids = new Key[((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number];
                    }
                }
                if (ModelSelectionModel.ModelSelectionParameters.Mode.allsubsets.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode)) {
                    this.buildAllSubsetsModels((ModelSelectionModel)model);
                } else if (ModelSelectionModel.ModelSelectionParameters.Mode.maxr.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode)) {
                    this.buildMaxRModels((ModelSelectionModel)model);
                } else if (ModelSelectionModel.ModelSelectionParameters.Mode.backward.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode)) {
                    numModelBuilt = this.buildBackwardModels((ModelSelectionModel)model);
                } else if (ModelSelectionModel.ModelSelectionParameters.Mode.maxrsweep.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode)) {
                    this.buildMaxRSweepModels((ModelSelectionModel)model);
                }
                ModelSelection.this._job.update(0L, "Completed GLM model building.  Extracting results now.");
                model.update(ModelSelection.this._job);
                if (ModelSelectionModel.ModelSelectionParameters.Mode.backward.equals((Object)((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._mode)) {
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output).shrinkArrays(numModelBuilt);
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output).generateSummary(numModelBuilt);
                } else {
                    ((ModelSelectionModel.ModelSelectionModelOutput)((ModelSelectionModel)model)._output).generateSummary();
                }
            }
            finally {
                model.update(ModelSelection.this._job);
                model.unlock(ModelSelection.this._job);
            }
        }

        Frame extractCPM(double[][] cpmA, String[] coefNames) {
            String[] coefnames = coefNames == null || coefNames.length == 0 ? ModelSelection.this._dinfo.coefNames() : coefNames;
            List predList = Arrays.stream(coefnames).collect(Collectors.toList());
            if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._intercept) {
                predList.add("intercept");
            }
            predList.add("XTYnYTY");
            new ArrayUtils();
            Frame cpm = ArrayUtils.frame(Key.make(), (String[])predList.stream().toArray(String[]::new), cpmA);
            Scope.track(cpm);
            return ModelSelection.this.rebalance(cpm, false, Key.make().toString());
        }

        void buildMaxRSweepModels(ModelSelectionModel model) {
            ModelSelection.this._coefNames = ModelSelection.this._dinfo.coefNames();
            ModelSelectionUtils.CPMnPredNames cpmPredIndex = ModelSelectionUtils.genCPMPredNamesIndex(ModelSelection.this._job._key, ModelSelection.this._dinfo, ModelSelection.this._predictorNames, (ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms);
            ModelSelection.this._predictorNames = cpmPredIndex._predNames;
            if (ModelSelection.this._predictorNames.length < ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number) {
                ModelSelection.this.error("max_predictor_number", "Your dataset contains duplicated predictors.  After removal, reduce your max_predictor_number to " + ModelSelection.this._predictorNames.length + " or less.");
            }
            if (ModelSelection.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(ModelSelection.this);
            }
            int cpmSize = cpmPredIndex._cpm.length;
            if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._multinode_mode) {
                ModelSelection.this._currCPMFrame = this.extractCPM(cpmPredIndex._cpm, cpmPredIndex._coefNames);
                Scope.track(ModelSelection.this._currCPMFrame);
                DKV.put(ModelSelection.this._currCPMFrame);
                ModelSelection.this._trackSweep = IntStream.range(0, cpmPredIndex._cpm.length).map(x -> 1).toArray();
                if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._intercept) {
                    ModelSelectionUtils.sweepCPMParallel(ModelSelection.this._currCPMFrame, new int[]{cpmSize - 2}, ModelSelection.this._trackSweep);
                }
                cpmPredIndex._cpm = null;
            } else {
                ModelSelection.this._currCPM = cpmPredIndex._cpm;
                if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._intercept) {
                    ModelSelectionUtils.sweepCPM(ModelSelection.this._currCPM, new int[]{cpmSize - 2}, false);
                }
            }
            int[][] pred2CPMIndice = cpmPredIndex._pred2CPMMapping;
            ModelSelection.this.checkMemoryFootPrint(cpmSize);
            double r2Scale = 1.0 / ModelSelectionUtils.calR2Scale(ModelSelection.this.train(), ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._response_column);
            ModelSelectionUtils.CoeffNormalization coefNorm = ModelSelectionUtils.generateScale(ModelSelection.this._dinfo, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._standardize);
            List<Integer> currSubsetIndices = new ArrayList<Integer>();
            ArrayList<String> predNames = new ArrayList<String>(Arrays.asList(ModelSelection.this._predictorNames));
            List<Integer> validSubset = IntStream.rangeClosed(0, predNames.size() - 1).boxed().collect(Collectors.toList());
            SweepModel bestModel = null;
            List<String> allCoefList = Stream.of(ModelSelection.this._coefNames).collect(Collectors.toList());
            BitSet predictorIndices = new BitSet(ModelSelection.this._predictorNames.length);
            for (int predNum = 1; predNum <= ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number; ++predNum) {
                HashSet<BitSet> usedCombos = new HashSet<BitSet>();
                bestModel = ModelSelection.this.forwardStep(currSubsetIndices, validSubset, usedCombos, predictorIndices, pred2CPMIndice, bestModel, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._intercept);
                validSubset.removeAll(currSubsetIndices);
                ModelSelection.this._job.update(predNum, "Finished forward step with " + predNum + " predictors.");
                if (predNum <= ModelSelection.this._numPredictors && predNum > 1) {
                    bestModel = ModelSelection.this.replacement(currSubsetIndices, validSubset, usedCombos, predictorIndices, bestModel, pred2CPMIndice);
                    currSubsetIndices = IntStream.of(bestModel._predSubset).boxed().collect(Collectors.toList());
                    validSubset = IntStream.rangeClosed(0, predNames.size() - 1).boxed().collect(Collectors.toList());
                    validSubset.removeAll(currSubsetIndices);
                }
                if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._build_glm_model) {
                    GLMModel bestR2Model = this.buildGLMModel(currSubsetIndices);
                    DKV.put(bestR2Model);
                    ((ModelSelectionModel.ModelSelectionModelOutput)model._output).updateBestModels(bestR2Model, predNum - 1);
                    continue;
                }
                ((ModelSelectionModel.ModelSelectionModelOutput)model._output).updateBestModels(ModelSelection.this._predictorNames, allCoefList, predNum - 1, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._intercept, bestModel._CPM.length, bestModel._predSubset, bestModel._CPM, r2Scale, coefNorm, pred2CPMIndice, ModelSelection.this._dinfo);
            }
        }

        public GLMModel buildGLMModel(List<Integer> bestSubsetIndices) {
            int[] subsetIndices = bestSubsetIndices.stream().mapToInt(Integer::intValue).toArray();
            Frame trainFrame = ModelSelectionUtils.generateOneFrame(subsetIndices, ModelSelection.this._parms, ModelSelection.this._predictorNames, null);
            DKV.put(trainFrame);
            Field[] field1 = ModelSelectionModel.ModelSelectionParameters.class.getDeclaredFields();
            Field[] field2 = Model.Parameters.class.getDeclaredFields();
            GLMModel.GLMParameters params = new GLMModel.GLMParameters();
            ModelSelectionUtils.setParamField(ModelSelection.this._parms, params, false, field1, Collections.emptyList());
            ModelSelectionUtils.setParamField(ModelSelection.this._parms, params, true, field2, Collections.emptyList());
            params._train = trainFrame._key;
            if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._valid != null) {
                params._valid = ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._valid;
            }
            GLMModel model = (GLMModel)new GLM(params).trainModel().get();
            DKV.remove(trainFrame._key);
            return model;
        }

        void buildMaxRModels(ModelSelectionModel model) {
            ArrayList<Integer> currSubsetIndices = new ArrayList<Integer>();
            ArrayList<String> coefNames = new ArrayList<String>(Arrays.asList(ModelSelection.this._predictorNames));
            List<Integer> validSubset = IntStream.rangeClosed(0, coefNames.size() - 1).boxed().collect(Collectors.toList());
            for (int predNum = 1; predNum <= ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number; ++predNum) {
                HashSet<BitSet> usedCombos = new HashSet<BitSet>();
                GLMModel bestR2Model = ModelSelection.forwardStep(currSubsetIndices, coefNames, predNum - 1, validSubset, (ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms, ModelSelection.this._foldColumn, ModelSelection.this._glmNFolds, ModelSelection.this._foldAssignment, usedCombos);
                validSubset.removeAll(currSubsetIndices);
                ModelSelection.this._job.update(predNum, "Finished building all models with " + predNum + " predictors.");
                if (predNum < ModelSelection.this._numPredictors && predNum > 1) {
                    GLMModel currBestR2Model;
                    double bestR2ofModel = 0.0;
                    if (bestR2Model != null) {
                        bestR2ofModel = bestR2Model.r2();
                    }
                    if ((currBestR2Model = ModelSelection.replacement(currSubsetIndices, coefNames, bestR2ofModel, (ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms, ModelSelection.this._glmNFolds, ModelSelection.this._foldColumn, validSubset, ModelSelection.this._foldAssignment, usedCombos)) != null) {
                        bestR2Model.delete();
                        bestR2Model = currBestR2Model;
                    }
                    validSubset.removeAll(currSubsetIndices);
                }
                DKV.put(bestR2Model);
                ((ModelSelectionModel.ModelSelectionModelOutput)model._output).updateBestModels(bestR2Model, predNum - 1);
            }
        }

        private int buildBackwardModels(ModelSelectionModel model) {
            ArrayList<String> predNames = new ArrayList<String>(Arrays.asList(ModelSelection.this._predictorNames));
            Frame train = (Frame)DKV.getGet(((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._train);
            List<String> numPredNames = predNames.stream().filter(x -> train.vec((String)x).isNumeric()).collect(Collectors.toList());
            List<String> catPredNames = predNames.stream().filter(x -> !numPredNames.contains(x)).collect(Collectors.toList());
            int numModelsBuilt = 0;
            String[] coefName = predNames.toArray(new String[0]);
            for (int predNum = ModelSelection.this._numPredictors; predNum >= ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._min_predictor_number; --predNum) {
                int modelIndex = predNum - 1;
                Frame trainingFrame = ModelSelectionUtils.generateOneFrame(null, ModelSelection.this._parms, coefName, ModelSelection.this._foldColumn);
                DKV.put(trainingFrame);
                GLMModel.GLMParameters[] glmParam = ModelSelectionUtils.generateGLMParameters(new Frame[]{trainingFrame}, (ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms, ModelSelection.this._glmNFolds, ModelSelection.this._foldColumn, ModelSelection.this._foldAssignment);
                GLMModel glmModel = (GLMModel)new GLM(glmParam[0]).trainModel().get();
                DKV.put(glmModel);
                ((ModelSelectionModel.ModelSelectionModelOutput)model._output).extractPredictors4NextModel(glmModel, modelIndex, predNames, numPredNames, catPredNames);
                ++numModelsBuilt;
                DKV.remove(trainingFrame._key);
                coefName = predNames.toArray(new String[0]);
                ModelSelection.this._job.update(predNum, "Finished building all models with " + predNum + " predictors.");
                if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._p_values_threshold > 0.0 && DoubleStream.of(((ModelSelectionModel.ModelSelectionModelOutput)model._output)._coef_p_values[modelIndex]).limit(((ModelSelectionModel.ModelSelectionModelOutput)model._output)._coef_p_values[modelIndex].length - 1).allMatch(x -> x <= ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._p_values_threshold) || predNames.size() == 0) break;
            }
            return numModelsBuilt;
        }

        void buildAllSubsetsModels(ModelSelectionModel model) {
            for (int predNum = 1; predNum <= ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._max_predictor_number; ++predNum) {
                int numModels = MathUtils.combinatorial(ModelSelection.this._numPredictors, predNum);
                Frame[] trainingFrames = ModelSelectionUtils.generateTrainingFrames((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms, predNum, ModelSelection.this._predictorNames, numModels, ModelSelection.this._foldColumn);
                GLMModel bestModel = ModelSelection.buildExtractBestR2Model(trainingFrames, (ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms, ModelSelection.this._glmNFolds, ModelSelection.this._foldColumn, ModelSelection.this._foldAssignment);
                DKV.put(bestModel);
                int index = predNum - 1;
                ((ModelSelectionModel.ModelSelectionModelOutput)model._output).updateBestModels(bestModel, index);
                ModelSelectionUtils.removeTrainingFrames(trainingFrames);
                ModelSelection.this._job.update(predNum, "Finished building all models with " + predNum + " predictors.");
            }
        }

        @Override
        public void computeImpl() {
            if (((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._lambda_search || !((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._intercept || ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._lambda == null || ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._lambda[0] > 0.0) {
                ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._use_all_factor_levels = true;
            }
            ModelSelection.this._dinfo = new DataInfo((Frame)ModelSelection.this._train.clone(), ModelSelection.this._valid, 1, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._use_all_factor_levels, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms).imputeMissing(), ((ModelSelectionModel.ModelSelectionParameters)ModelSelection.this._parms).makeImputer(), false, ModelSelection.this.hasWeightCol(), ModelSelection.this.hasOffsetCol(), ModelSelection.this.hasFoldCol(), null);
            ModelSelection.this.init(true);
            if (ModelSelection.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(ModelSelection.this);
            }
            ModelSelection.this._job.update(0L, "finished init and ready to build models");
            this.buildModel();
        }
    }
}

