/*
 * Decompiled with CFR 0.152.
 */
package hex.kmeans;

import hex.kmeans.NodesEdgesObject;
import java.util.ArrayList;
import java.util.Collections;
import water.Iced;
import water.fvec.Vec;

class SpanningTree
extends Iced<SpanningTree> {
    public long _nodeSize;
    public long _edgeSize;
    public int _secondLayerSize;
    public long _dataPointSize;
    public Vec[] _edgeFlowDataPoints;
    public Vec _edgeFlowRest;
    public Vec _nodePotentials;
    public Vec _parents;
    public Vec _parentEdges;
    public Vec _subtreeSize;
    public Vec _nextDepthFirst;
    public Vec _previousNodes;
    public Vec _lastDescendants;
    public Vec _sources;
    public Vec _targets;

    SpanningTree(long nodeSize, long edgeSize, int secondLayerSize) {
        this._nodeSize = nodeSize;
        this._edgeSize = edgeSize;
        this._secondLayerSize = secondLayerSize;
        this._dataPointSize = nodeSize - (long)secondLayerSize - 1L;
        this._edgeFlowDataPoints = new Vec[secondLayerSize];
        for (int i = 0; i < secondLayerSize; ++i) {
            this._edgeFlowDataPoints[i] = Vec.makeCon(0.0, this._dataPointSize, (byte)3);
        }
        this._edgeFlowRest = Vec.makeCon(0.0, (long)secondLayerSize + nodeSize, (byte)3);
        this._nodePotentials = Vec.makeCon(0.0, nodeSize, (byte)3);
        this._parents = Vec.makeCon(0.0, nodeSize + 1L, (byte)3);
        this._parentEdges = Vec.makeCon(0.0, nodeSize + 1L, (byte)3);
        this._subtreeSize = Vec.makeCon(1.0, nodeSize + 1L, (byte)3);
        this._nextDepthFirst = Vec.makeCon(0.0, nodeSize + 1L, (byte)3);
        this._previousNodes = Vec.makeCon(0.0, nodeSize + 1L, (byte)3);
        this._lastDescendants = Vec.makeCon(0.0, nodeSize + 1L, (byte)3);
    }

    public void init(long numberOfPoints, double maxCapacity, Vec demands) {
        long i;
        this._sources = Vec.makeCon(0.0, this._edgeSize + this._nodeSize, (byte)3);
        this._targets = Vec.makeCon(0.0, this._edgeSize + this._nodeSize, (byte)3);
        for (i = 0L; i < this._nodeSize; ++i) {
            if (i < numberOfPoints) {
                for (int j = 0; j < this._secondLayerSize; ++j) {
                    this._sources.set(i * (long)this._secondLayerSize + (long)j, i);
                    this._targets.set(i * (long)this._secondLayerSize + (long)j, numberOfPoints + (long)j);
                }
                continue;
            }
            if (i >= this._nodeSize - 1L) continue;
            this._sources.set(numberOfPoints * (long)this._secondLayerSize + i - numberOfPoints, i);
            this._targets.set(numberOfPoints * (long)this._secondLayerSize + i - numberOfPoints, this._nodeSize - 1L);
        }
        for (i = 0L; i < this._nodeSize; ++i) {
            long demand = demands.at8(i);
            if (demand >= 0L) {
                this._sources.set(this._edgeSize + i, this._nodeSize);
                this._targets.set(this._edgeSize + i, i);
            } else {
                this._sources.set(this._edgeSize + i, i);
                this._targets.set(this._edgeSize + i, this._nodeSize);
            }
            if (i < this._nodeSize - 1L) {
                this._nextDepthFirst.set(i, i + 1L);
            }
            this._edgeFlowRest.set((long)this._secondLayerSize + i, Math.abs(demand));
            this._nodePotentials.set(i, demand < 0L ? maxCapacity : -maxCapacity);
            this._parents.set(i, this._nodeSize);
            this._parentEdges.set(i, i + this._edgeSize);
            this._previousNodes.set(i, i - 1L);
            this._lastDescendants.set(i, i);
        }
        this._parents.set(this._nodeSize, -1L);
        this._subtreeSize.set(this._nodeSize, this._nodeSize + 1L);
        this._nextDepthFirst.set(this._nodeSize - 1L, this._nodeSize);
        this._previousNodes.set(0L, this._nodeSize);
        this._previousNodes.set(this._nodeSize, this._nodeSize - 1L);
        this._lastDescendants.set(this._nodeSize, this._nodeSize - 1L);
    }

    public boolean areConstraintsSatisfied() {
        Vec.Reader flowReader = new Vec.Reader(this._edgeFlowRest);
        long length = flowReader.length();
        for (long i = 2L; i < (long)(this._secondLayerSize + 2); ++i) {
            if (flowReader.at8(length - i) <= 0L) continue;
            return false;
        }
        return true;
    }

    public long findAncestor(long sourceIndex, long targetIndex) {
        long subtreeSizeSource = this._subtreeSize.at8(sourceIndex);
        long subtreeSizeTarget = this._subtreeSize.at8(targetIndex);
        while (true) {
            if (subtreeSizeSource < subtreeSizeTarget) {
                sourceIndex = this._parents.at8(sourceIndex);
                subtreeSizeSource = this._subtreeSize.at8(sourceIndex);
                continue;
            }
            while (subtreeSizeSource > subtreeSizeTarget) {
                targetIndex = this._parents.at8(targetIndex);
                subtreeSizeTarget = this._subtreeSize.at8(targetIndex);
            }
            if (subtreeSizeSource != subtreeSizeTarget) continue;
            if (sourceIndex == targetIndex) break;
            sourceIndex = this._parents.at8(sourceIndex);
            subtreeSizeSource = this._subtreeSize.at8(sourceIndex);
            targetIndex = this._parents.at8(targetIndex);
            subtreeSizeTarget = this._subtreeSize.at8(targetIndex);
        }
        return sourceIndex;
    }

    public long getFlowByEdgeIndex(long edgeIndex) {
        if (edgeIndex < this._dataPointSize * (long)this._secondLayerSize) {
            int i = (int)(edgeIndex % (long)this._secondLayerSize);
            long j = Math.round(edgeIndex / (long)this._secondLayerSize);
            return this._edgeFlowDataPoints[i].at8(j);
        }
        return this._edgeFlowRest.at8(edgeIndex - this._dataPointSize * (long)this._secondLayerSize);
    }

    public void setFlowByEdgeIndex(long edgeIndex, long value) {
        if (edgeIndex < this._dataPointSize * (long)this._secondLayerSize) {
            int i = (int)(edgeIndex % (long)this._secondLayerSize);
            long j = Math.round(edgeIndex / (long)this._secondLayerSize);
            this._edgeFlowDataPoints[i].set(j, value);
        } else {
            this._edgeFlowRest.set(edgeIndex - this._dataPointSize * (long)this._secondLayerSize, value);
        }
    }

    public double reduceWeight(long edgeIndex, double weight) {
        double newWeight = weight - this._nodePotentials.at(this._sources.at8(edgeIndex)) + this._nodePotentials.at(this._targets.at8(edgeIndex));
        return this.getFlowByEdgeIndex(edgeIndex) == 0L ? newWeight : -newWeight;
    }

    public NodesEdgesObject getPath(long node, long ancestor) {
        NodesEdgesObject result = new NodesEdgesObject();
        result.addNode(node);
        while (node != ancestor) {
            result.addEdge(this._parentEdges.at8(node));
            node = this._parents.at8(node);
            result.addNode(node);
        }
        return result;
    }

    public double getResidualCapacity(long edgeIndex, long nodeIndex, double capacity) {
        long flow = this.getFlowByEdgeIndex(edgeIndex);
        return nodeIndex == this._sources.at8(edgeIndex) ? capacity - (double)flow : (double)flow;
    }

    public void augmentFlow(NodesEdgesObject nodesEdges, double flow) {
        for (int i = 0; i < nodesEdges.edgeSize(); ++i) {
            long edge = nodesEdges.getEdge(i);
            long node = nodesEdges.getNode(i);
            long edgeFlow = this.getFlowByEdgeIndex(edge);
            if (node == this._sources.at8(edge)) {
                this.setFlowByEdgeIndex(edge, edgeFlow + (long)((int)flow));
                continue;
            }
            this.setFlowByEdgeIndex(edge, edgeFlow - (long)((int)flow));
        }
    }

    public void removeParentEdge(long sourceIndex, long targetIndex) {
        long subtreeSizeTarget = this._subtreeSize.at8(targetIndex);
        long previousTargetIndex = this._previousNodes.at8(targetIndex);
        long lastTargetIndex = this._lastDescendants.at8(targetIndex);
        long nextTargetIndex = this._nextDepthFirst.at8(lastTargetIndex);
        this._parents.set(targetIndex, -1L);
        this._parentEdges.set(targetIndex, -1L);
        this._nextDepthFirst.set(previousTargetIndex, nextTargetIndex);
        this._previousNodes.set(nextTargetIndex, previousTargetIndex);
        this._nextDepthFirst.set(lastTargetIndex, targetIndex);
        this._previousNodes.set(targetIndex, lastTargetIndex);
        while (sourceIndex != -1L) {
            this._subtreeSize.set(sourceIndex, this._subtreeSize.at8(sourceIndex) - subtreeSizeTarget);
            if (lastTargetIndex == this._lastDescendants.at8(sourceIndex)) {
                this._lastDescendants.set(sourceIndex, previousTargetIndex);
            }
            sourceIndex = this._parents.at8(sourceIndex);
        }
    }

    public void makeRoot(long nodeIndex) {
        ArrayList<Long> ancestors = new ArrayList<Long>();
        while (nodeIndex != -1L) {
            ancestors.add(nodeIndex);
            nodeIndex = this._parents.at8(nodeIndex);
        }
        Collections.reverse(ancestors);
        for (int i = 0; i < ancestors.size() - 1; ++i) {
            long sourceIndex = (Long)ancestors.get(i);
            long targetIndex = (Long)ancestors.get(i + 1);
            long subtreeSizeSource = this._subtreeSize.at8(sourceIndex);
            long lastSourceIndex = this._lastDescendants.at8(sourceIndex);
            long prevTargetIndex = this._previousNodes.at8(targetIndex);
            long lastTargetIndex = this._lastDescendants.at8(targetIndex);
            long nextTargetIndex = this._nextDepthFirst.at8(lastTargetIndex);
            this._parents.set(sourceIndex, targetIndex);
            this._parents.set(targetIndex, -1L);
            this._parentEdges.set(sourceIndex, this._parentEdges.at8(targetIndex));
            this._parentEdges.set(targetIndex, -1L);
            this._subtreeSize.set(sourceIndex, subtreeSizeSource - this._subtreeSize.at8(targetIndex));
            this._subtreeSize.set(targetIndex, subtreeSizeSource);
            this._nextDepthFirst.set(prevTargetIndex, nextTargetIndex);
            this._previousNodes.set(nextTargetIndex, prevTargetIndex);
            this._nextDepthFirst.set(lastTargetIndex, targetIndex);
            this._previousNodes.set(targetIndex, lastTargetIndex);
            if (lastSourceIndex == lastTargetIndex) {
                this._lastDescendants.set(sourceIndex, prevTargetIndex);
                lastSourceIndex = prevTargetIndex;
            }
            this._previousNodes.set(sourceIndex, lastTargetIndex);
            this._nextDepthFirst.set(lastTargetIndex, sourceIndex);
            this._nextDepthFirst.set(lastSourceIndex, targetIndex);
            this._previousNodes.set(targetIndex, lastSourceIndex);
            this._lastDescendants.set(targetIndex, lastSourceIndex);
        }
    }

    public void addEdge(long edgeIndex, long sourceIndex, long targetIndex) {
        long lastSourceIndex = this._lastDescendants.at8(sourceIndex);
        long nextSourceIndex = this._nextDepthFirst.at8(lastSourceIndex);
        long subtreeSizeTarget = this._subtreeSize.at8(targetIndex);
        long lastTargetIndex = this._lastDescendants.at8(targetIndex);
        this._parents.set(targetIndex, sourceIndex);
        this._parentEdges.set(targetIndex, edgeIndex);
        this._nextDepthFirst.set(lastSourceIndex, targetIndex);
        this._previousNodes.set(targetIndex, lastSourceIndex);
        this._previousNodes.set(nextSourceIndex, lastTargetIndex);
        this._nextDepthFirst.set(lastTargetIndex, nextSourceIndex);
        while (sourceIndex != -1L) {
            this._subtreeSize.set(sourceIndex, this._subtreeSize.at8(sourceIndex) + subtreeSizeTarget);
            if (lastSourceIndex == this._lastDescendants.at8(sourceIndex)) {
                this._lastDescendants.set(sourceIndex, lastTargetIndex);
            }
            sourceIndex = this._parents.at8(sourceIndex);
        }
    }

    public void updatePotentials(long edgeIndex, long sourceIndex, long targetIndex, double weight) {
        double potential = targetIndex == this._targets.at8(edgeIndex) ? this._nodePotentials.at(sourceIndex) - weight - this._nodePotentials.at(targetIndex) : this._nodePotentials.at(sourceIndex) + weight - this._nodePotentials.at(targetIndex);
        this._nodePotentials.set(targetIndex, this._nodePotentials.at(targetIndex) + potential);
        long last = this._lastDescendants.at8(targetIndex);
        while (targetIndex != last) {
            targetIndex = this._nextDepthFirst.at8(targetIndex);
            this._nodePotentials.set(targetIndex, this._nodePotentials.at(targetIndex) + potential);
        }
    }
}

