/*
 * Decompiled with CFR 0.152.
 */
package hex.isotonic;

import hex.isotonic.PoolAdjacentViolators;
import java.util.Arrays;
import water.Futures;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.rapids.Merge;

public class PoolAdjacentViolatorsDriver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame runPAV(Frame fr) {
        if (fr.numCols() != 3) {
            throw new IllegalArgumentException("Input frame is expected to have 3 columns: y, X, weights.");
        }
        if (fr.lastVec().min() < 0.0) {
            throw new IllegalArgumentException("Weights cannot be negative.");
        }
        Keyed sorted = null;
        Keyed local = null;
        Keyed single = null;
        try {
            sorted = Merge.sort(fr, new int[]{1, 0});
            local = PoolAdjacentViolatorsDriver.pav((Frame)sorted);
            single = RebalanceDataSet.toSingleChunk((Frame)local);
            Frame frame = PoolAdjacentViolatorsDriver.pav((Frame)single);
            return frame;
        }
        finally {
            Futures fs = new Futures();
            if (sorted != null) {
                sorted.remove(fs);
            }
            if (local != null) {
                local.remove(fs);
            }
            if (single != null) {
                single.remove(fs);
            }
            fs.blockForPending();
        }
    }

    static Frame pav(Frame fr) {
        return ((PoolAdjacentViolatorsTask)new PoolAdjacentViolatorsTask().doAll(3, (byte)3, fr)).outputFrame();
    }

    static class PoolAdjacentViolatorsTask
    extends MRTask<PoolAdjacentViolatorsTask> {
        PoolAdjacentViolatorsTask() {
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            assert (cs.length == 3);
            Chunk weightChunk = cs[2];
            int len = 0;
            int[] idx = new int[weightChunk._len];
            for (int i = 0; i < idx.length; ++i) {
                double w;
                if (weightChunk.isNA(i) || (w = weightChunk.atd(i)) == 0.0) continue;
                idx[len++] = i;
            }
            idx = Arrays.copyOf(idx, len);
            double[] ys = cs[0].getDoubles(MemoryManager.malloc8d(len), idx);
            double[] xs = cs[1].getDoubles(MemoryManager.malloc8d(len), idx);
            double[] ws = cs[2].getDoubles(MemoryManager.malloc8d(len), idx);
            new PoolAdjacentViolators(ys, ws).findThresholds(xs, ncs);
        }
    }
}

