/*
 * Decompiled with CFR 0.152.
 */
package hex.isotonic;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ModelMetricsRegression;
import hex.genmodel.algos.isotonic.IsotonicCalibrator;
import hex.genmodel.algos.isotonic.IsotonicRegressionUtils;
import hex.isotonic.IsotonicRegression;
import hex.isotonic.IsotonicRegressionMojoWriter;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.udf.CFuncRef;

public class IsotonicRegressionModel
extends Model<IsotonicRegressionModel, IsotonicRegressionParameters, IsotonicRegressionOutput> {
    public IsotonicRegressionModel(Key<IsotonicRegressionModel> selfKey, IsotonicRegressionParameters parms, IsotonicRegressionOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    protected Model.BigScore makeBigScoreTask(String[][] domains, String[] names, Frame adaptFrm, boolean computeMetrics, boolean makePrediction, Job j, CFuncRef customMetricFunc) {
        return super.makeBigScoreTask(domains, names, adaptFrm, computeMetrics, makePrediction, j, customMetricFunc);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        return new ModelMetricsRegression.MetricBuilderRegression();
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        double x = ((IsotonicRegressionParameters)this._parms)._out_of_bounds == OutOfBoundsHandling.Clip ? this.clip(data[0]) : data[0];
        preds[0] = IsotonicRegressionUtils.score(x, ((IsotonicRegressionOutput)this._output)._min_x, ((IsotonicRegressionOutput)this._output)._max_x, ((IsotonicRegressionOutput)this._output)._thresholds_x, ((IsotonicRegressionOutput)this._output)._thresholds_y);
        return preds;
    }

    private double clip(double x) {
        return IsotonicRegressionUtils.clip(x, ((IsotonicRegressionOutput)this._output)._min_x, ((IsotonicRegressionOutput)this._output)._max_x);
    }

    @Override
    protected String[] makeScoringNames() {
        return new String[]{"predict"};
    }

    @Override
    protected String[][] makeScoringDomains(Frame adaptFrm, boolean computeMetrics, String[] names) {
        return new String[1][];
    }

    public IsotonicCalibrator toIsotonicCalibrator() {
        return new IsotonicCalibrator(((IsotonicRegressionOutput)this._output)._min_x, ((IsotonicRegressionOutput)this._output)._max_x, ((IsotonicRegressionOutput)this._output)._thresholds_x, ((IsotonicRegressionOutput)this._output)._thresholds_y);
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    @Override
    public IsotonicRegressionMojoWriter getMojo() {
        return new IsotonicRegressionMojoWriter(this);
    }

    public static class IsotonicRegressionOutput
    extends Model.Output {
        public long _nobs;
        public double[] _thresholds_y;
        public double[] _thresholds_x;
        public double _min_x;
        public double _max_x;

        public IsotonicRegressionOutput(IsotonicRegression b) {
            super(b);
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.Regression;
        }

        @Override
        public String[] classNames() {
            return null;
        }
    }

    public static class IsotonicRegressionParameters
    extends Model.Parameters {
        public OutOfBoundsHandling _out_of_bounds = OutOfBoundsHandling.NA;

        @Override
        public String algoName() {
            return "IsotonicRegression";
        }

        @Override
        public String fullName() {
            return "Isotonic Regression";
        }

        @Override
        public String javaName() {
            return IsotonicRegressionModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return 1L;
        }
    }

    public static enum OutOfBoundsHandling {
        NA,
        Clip;

    }
}

