/*
 * Decompiled with CFR 0.152.
 */
package hex.isotonic;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.isotonic.IsotonicRegressionModel;
import hex.isotonic.PoolAdjacentViolatorsDriver;
import water.Keyed;
import water.Lockable;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.TwoDimTable;
import water.util.VecUtils;

public class IsotonicRegression
extends ModelBuilder<IsotonicRegressionModel, IsotonicRegressionModel.IsotonicRegressionParameters, IsotonicRegressionModel.IsotonicRegressionOutput> {
    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression};
    }

    @Override
    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    public IsotonicRegression(boolean startup_once) {
        super(new IsotonicRegressionModel.IsotonicRegressionParameters(), startup_once);
    }

    public IsotonicRegression(IsotonicRegressionModel.IsotonicRegressionParameters parms) {
        super(parms);
        this.init(false);
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (this.train() != null) {
            if (this.numFeatureCols() != 1) {
                this.error("_train", "Training frame for Isotonic Regression can only have a single feature column, training frame columns: " + ArrayUtils.toStringQuotedElements(this.train().names()));
            }
            if (expensive) {
                Vec xVec;
                Vec resp = this.response();
                if (resp != null && resp.naCnt() > 0L) {
                    this.error("_response_column", "Isotonic Regression doesn't support NA values in response.");
                }
                if (this.numFeatureCols() == 1 && (xVec = this.train().vec(0)) != null && xVec.naCnt() > 0L) {
                    this.error("_response_column", "Isotonic Regression doesn't support NA values in feature column '" + this.train().name(0) + "'.");
                }
            }
        }
    }

    private int numFeatureCols() {
        return this.train().numCols() - (this.numSpecialCols() + 1);
    }

    @Override
    protected IsotonicRegressionDriver trainModelImpl() {
        return new IsotonicRegressionDriver();
    }

    private TwoDimTable generateSummary(IsotonicRegressionModel.IsotonicRegressionOutput output) {
        String[] names = new String[]{"Number of Observations", "Number of Thresholds"};
        String[] types = new String[]{"long", "long"};
        String[] formats = new String[]{"%d", "%d"};
        TwoDimTable summary = new TwoDimTable("Isotonic Regression Model", "summary", new String[]{""}, names, types, formats, "");
        summary.set(0, 0, output._nobs);
        summary.set(0, 1, output._thresholds_x.length);
        return summary;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    private class IsotonicRegressionDriver
    extends ModelBuilder.Driver {
        private IsotonicRegressionDriver() {
            super(IsotonicRegression.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void computeImpl() {
            Lockable model = null;
            Lockable thresholds = null;
            Keyed weights = null;
            try {
                IsotonicRegression.this.init(true);
                model = new IsotonicRegressionModel(IsotonicRegression.this.dest(), (IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms, new IsotonicRegressionModel.IsotonicRegressionOutput(IsotonicRegression.this));
                model.delete_and_lock(IsotonicRegression.this._job);
                Vec xVec = IsotonicRegression.this._train.vec(0);
                weights = IsotonicRegression.this.hasWeightCol() ? IsotonicRegression.this._weights : IsotonicRegression.this._train.anyVec().makeCon(1.0);
                VecUtils.MinMaxTask minMax = VecUtils.findMinMax(xVec, (Vec)weights);
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._min_x = minMax._min;
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._max_x = minMax._max;
                Frame fr = new Frame(new Vec[0]);
                fr.add("y", IsotonicRegression.this.response());
                fr.add("X", xVec);
                fr.add("w", (Vec)weights);
                thresholds = PoolAdjacentViolatorsDriver.runPAV(fr);
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._nobs = ((Vec)weights).nzCnt();
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._thresholds_y = FrameUtils.asDoubles(((Frame)thresholds).vec(0));
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._thresholds_x = FrameUtils.asDoubles(((Frame)thresholds).vec(1));
                IsotonicRegression.this._job.update(1L);
                model.update(IsotonicRegression.this._job);
                ((Model)model).score(((IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms).train(), null, CFuncRef.from(((IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms)._custom_metric_func)).delete();
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._training_metrics = ModelMetrics.getFromDKV((Model)model, ((IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms).train());
                if (IsotonicRegression.this.valid() != null) {
                    IsotonicRegression.this._job.update(0L, "Scoring validation frame");
                    ((Model)model).score(((IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms).valid(), null, CFuncRef.from(((IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms)._custom_metric_func)).delete();
                    ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._validation_metrics = ModelMetrics.getFromDKV((Model)model, ((IsotonicRegressionModel.IsotonicRegressionParameters)IsotonicRegression.this._parms).valid());
                }
                ((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output)._model_summary = IsotonicRegression.this.generateSummary((IsotonicRegressionModel.IsotonicRegressionOutput)((IsotonicRegressionModel)model)._output);
                model.update(IsotonicRegression.this._job);
            }
            finally {
                if (model != null) {
                    model.unlock(IsotonicRegression.this._job);
                }
                if (thresholds != null) {
                    thresholds.delete();
                }
                if (weights != null && !IsotonicRegression.this.hasWeightCol()) {
                    weights.remove();
                }
            }
        }
    }
}

