/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.glm.DispersionTask;
import hex.glm.GLMModel;
import java.util.stream.DoubleStream;
import water.DKV;
import water.Key;
import water.Scope;
import water.fvec.Frame;
import water.fvec.Vec;

public class TweedieMLDispersionOnly {
    double _dispersionParameter;
    final double _variancePower;
    int _constNCol;
    int _nWorkingCol = 0;
    Frame _infoFrame;
    Frame _mu;
    final String[] _constFrameNames;
    String[] _workFrameNames;
    boolean _weightPresent;
    int _indexBound;
    int _nWVs = 3;
    boolean[] _computationAccuracy;
    boolean _debugOn;

    public TweedieMLDispersionOnly(Frame train, GLMModel.GLMParameters parms, GLMModel model, double[] beta, DataInfo dinfo) {
        this._variancePower = parms._tweedie_variance_power;
        this._dispersionParameter = parms._init_dispersion_parameter;
        this._constFrameNames = new String[]{"jMaxConst", "zConst", "part2Const", "oneOverY", "oneOverPiY", "firstOrderDerivConst", "secondOrderDerivConst"};
        this._constNCol = this._constFrameNames.length;
        DispersionTask.GenPrediction gPred = (DispersionTask.GenPrediction)new DispersionTask.GenPrediction(beta, model, dinfo).doAll(1, (byte)3, dinfo._adaptedFrame);
        this._mu = gPred.outputFrame(Key.make(), new String[]{"prediction"}, null);
        DKV.put(this._mu);
        this._infoFrame = TweedieMLDispersionOnly.formInfoFrame(train, this._mu, parms);
        DKV.put(this._infoFrame);
        DispersionTask.ComputeTweedieConstTsk _tweedieConst = new DispersionTask.ComputeTweedieConstTsk(this._variancePower, this._infoFrame);
        _tweedieConst.doAll(this._constNCol, (byte)3, this._infoFrame);
        this._infoFrame.add(Scope.track(_tweedieConst.outputFrame(Key.make(), this._constFrameNames, null)));
        this._debugOn = parms._debugTDispersionOnly;
        if (this._debugOn) {
            this._workFrameNames = new String[]{"jOrKMax", "logZ", "_WOrVMax", "dWOrVMax", "d2WOrVMax", "jOrkL", "jOrkU", "djOrkL", "djOrkU", "d2jOrkL", "d2jOrKU", "sumWV", "sumDWV", "sumD2WV", "ll", "dll", "d2ll"};
            this._nWorkingCol = this._workFrameNames.length;
            Vec[] vecs = this._infoFrame.anyVec().makeDoubles(this._nWorkingCol, DoubleStream.generate(() -> Math.random()).limit(this._nWorkingCol).map(x -> 0.0).toArray());
            this._infoFrame.add(this._workFrameNames, vecs);
            DKV.put(this._infoFrame);
        }
        this._weightPresent = parms._weights_column != null;
        this._indexBound = parms._max_series_index;
        this._computationAccuracy = new boolean[this._nWVs];
    }

    public static Frame formInfoFrame(Frame train, Frame mu, GLMModel.GLMParameters parms) {
        Vec[] vecs;
        String[] colNames;
        Frame infoFrame = new Frame(Key.make());
        if (parms._weights_column != null) {
            colNames = new String[]{parms._response_column, mu.names()[0], parms._weights_column};
            vecs = new Vec[]{train.vec(parms._response_column), mu.vec(0), train.vec(parms._weights_column)};
        } else {
            colNames = new String[]{parms._response_column, mu.names()[0]};
            vecs = new Vec[]{train.vec(parms._response_column), mu.vec(0)};
        }
        infoFrame.add(colNames, vecs);
        return infoFrame;
    }

    public void updateDispersionP(double phi) {
        this._dispersionParameter = phi;
    }

    public void cleanUp() {
        DKV.remove(this._mu._key);
        DKV.remove(this._infoFrame._key);
    }
}

