/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import Jama.Matrix;
import hex.DataInfo;
import hex.GLMMetrics;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.glm.ComputationState;
import hex.glm.ConstrainedGLMUtils;
import hex.glm.DispersionTask;
import hex.glm.DispersionUtils;
import hex.glm.GLMModel;
import hex.glm.GLMScoringInfo;
import hex.glm.GLMTask;
import hex.glm.GLMUtils;
import hex.glm.RegressionInfluenceDiagnosticsTasks;
import hex.glm.TweedieEstimator;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.L_BFGS;
import hex.optimization.OptimizationUtils;
import hex.util.CheckpointUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jsr166y.CountedCompleter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.DKV;
import water.H2O;
import water.HeartBeat;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Scope;
import water.Value;
import water.exceptions.H2OFailException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.TwoDimTable;

public class GLM
extends ModelBuilder<GLMModel, GLMModel.GLMParameters, GLMModel.GLMOutput> {
    static double BAD_CONDITION_NUMBER = 20000.0;
    static NumberFormat lambdaFormatter = new DecimalFormat(".##E0");
    static NumberFormat devFormatter = new DecimalFormat(".##");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    public static final int SCORING_INTERVAL_MSEC = 15000;
    public String _generatedWeights = null;
    public double[][][] _penaltyMatrix = null;
    public String[][] _gamColnames = null;
    public int[][] _gamColIndices = null;
    public BetaInfo _betaInfo;
    private boolean _earlyStopEnabled = false;
    private boolean _checkPointFirstIter = false;
    private boolean _betaConstraintsOn = false;
    private boolean _tweedieDispersionOnly = false;
    private boolean _linearConstraintsOn = false;
    private transient GLMDriver _driver;
    private double _lambdaCVEstimate = Double.NaN;
    private int _bestCVSubmodel;
    private boolean _doInit = true;
    private double[] _xval_deviances;
    private double[] _xval_sd;
    private double[][] _xval_zValues;
    private double[] _xval_deviances_generate_SH;
    private double[] _xval_sd_generate_SH;
    private int[] _xval_iters_generate_SH;
    private boolean _insideCVCheck = false;
    private boolean _enumInCS = false;
    private Frame _betaConstraints = null;
    private boolean _cvRuns = false;
    DataInfo _dinfo;
    private transient DataInfo _validDinfo;
    private transient ScoringHistory _scoringHistory;
    private transient LambdaSearchScoringHistory _lambdaSearchScoringHistory;
    long _t0 = System.currentTimeMillis();
    private transient double _iceptAdjust = 0.0;
    private double _lmax;
    private double _gmax;
    private transient long _nobs;
    private transient GLMModel _model;
    private boolean _earlyStop = false;
    private GLMGradientInfo _ginfoStart;
    private double _betaDiffStart;
    private double[] _betaStart;
    private int _initIter = 0;
    private transient double[] _nullBeta;
    protected static final long WORK_TOTAL = 1000000L;
    transient Key[] _toRemove;
    private transient ComputationState _state;

    public GLM(boolean startup_once) {
        super(new GLMModel.GLMParameters(), startup_once);
    }

    public GLM(GLMModel.GLMParameters parms) {
        super(parms);
        this.init(false);
    }

    public GLM(GLMModel.GLMParameters parms, double[][][] penaltyMatrix, String[][] gamColnames) {
        super(parms);
        this.init(false);
        this._penaltyMatrix = penaltyMatrix;
        this._gamColnames = gamColnames;
    }

    public GLM(GLMModel.GLMParameters parms, Key dest) {
        super(parms, dest);
        this.init(false);
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial};
    }

    @Override
    public boolean havePojo() {
        return true;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    @Override
    public void computeCrossValidation() {
        this.init(true);
        this._cvRuns = true;
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        super.computeCrossValidation();
    }

    private double[] alignSubModelsAcrossCVModels(ModelBuilder[] cvModelBuilders) {
        int i;
        double[] alphas = Arrays.stream(cvModelBuilders).mapToDouble(cv -> {
            GLM g = (GLM)cv;
            return ((GLMModel.GLMOutput)g._model._output)._submodels[((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx].alpha_value;
        }).distinct().toArray();
        int[] alphaIndices = new int[alphas.length];
        int k = 0;
        for (int i2 = 0; i2 < ((GLMModel.GLMParameters)this._parms)._alpha.length; ++i2) {
            for (int j = 0; j < alphas.length; ++j) {
                if (alphas[j] != ((GLMModel.GLMParameters)this._parms)._alpha[i2]) continue;
                alphaIndices[k] = i2;
                if (k < j) {
                    double tmpAlpha = alphas[k];
                    alphas[k] = alphas[j];
                    alphas[j] = tmpAlpha;
                }
                ++k;
            }
        }
        int[] alphaChangePoints = new int[alphas.length + 1];
        int[] alphaSubmodels = new int[((GLMModel.GLMParameters)this._parms)._alpha.length];
        for (i = 0; i < cvModelBuilders.length; ++i) {
            GLM g = (GLM)cvModelBuilders[i];
            Map<Double, List<GLMModel.Submodel>> submodels = Arrays.stream(((GLMModel.GLMOutput)g._model._output)._submodels).collect(Collectors.groupingBy(sm -> sm.alpha_value));
            for (int j = 0; j < ((GLMModel.GLMParameters)this._parms)._alpha.length; ++j) {
                alphaSubmodels[j] = Math.max(alphaSubmodels[j], submodels.containsKey(((GLMModel.GLMParameters)this._parms)._alpha[j]) ? submodels.get(((GLMModel.GLMParameters)this._parms)._alpha[j]).size() : 0);
            }
        }
        for (i = 0; i < alphas.length; ++i) {
            alphaChangePoints[i + 1] = alphaChangePoints[i] + alphaSubmodels[alphaIndices[i]];
        }
        double[] alphasAndLambdas = new double[alphaChangePoints[alphas.length] * 2];
        for (int i3 = 0; i3 < cvModelBuilders.length; ++i3) {
            GLM g = (GLM)cvModelBuilders[i3];
            GLMModel.Submodel[] alignedSubmodels = new GLMModel.Submodel[alphaChangePoints[alphas.length]];
            double lastAlpha = -1.0;
            int alphaIdx = -1;
            k = 0;
            int nNullsUntilSelectedSubModel = 0;
            for (int j = 0; j < ((GLMModel.GLMOutput)g._model._output)._submodels.length; ++j) {
                if (lastAlpha != ((GLMModel.GLMOutput)g._model._output)._submodels[j].alpha_value) {
                    lastAlpha = ((GLMModel.GLMOutput)g._model._output)._submodels[j].alpha_value;
                    if (alphaIdx + 1 < alphas.length && lastAlpha == alphas[alphaIdx + 1]) {
                        k = 0;
                        ++alphaIdx;
                        if (((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx >= j) {
                            nNullsUntilSelectedSubModel = alphaChangePoints[alphaIdx] - j;
                        }
                    }
                }
                if (alphaIdx < 0 || ((GLMModel.GLMOutput)g._model._output)._submodels[j].alpha_value != alphas[alphaIdx]) continue;
                alignedSubmodels[alphaChangePoints[alphaIdx] + k] = ((GLMModel.GLMOutput)g._model._output)._submodels[j];
                assert (alphasAndLambdas[alphaChangePoints[alphaIdx] + k] == 0.0 || alphasAndLambdas[alphaChangePoints[alphaIdx] + k] == ((GLMModel.GLMOutput)g._model._output)._submodels[j].alpha_value && alphasAndLambdas[alphaChangePoints[alphas.length] + alphaChangePoints[alphaIdx] + k] == ((GLMModel.GLMOutput)g._model._output)._submodels[j].lambda_value);
                alphasAndLambdas[alphaChangePoints[alphaIdx] + k] = ((GLMModel.GLMOutput)g._model._output)._submodels[j].alpha_value;
                alphasAndLambdas[alphaChangePoints[alphas.length] + alphaChangePoints[alphaIdx] + k] = ((GLMModel.GLMOutput)g._model._output)._submodels[j].lambda_value;
                ++k;
            }
            assert (((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx == ((GLMModel.GLMOutput)g._model._output)._best_submodel_idx);
            assert (((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx == ((GLMModel.GLMOutput)g._model._output)._best_lambda_idx);
            assert (((GLMModel.GLMOutput)g._model._output)._submodels[((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx].alpha_value == alignedSubmodels[((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx + nNullsUntilSelectedSubModel].alpha_value && ((GLMModel.GLMOutput)g._model._output)._submodels[((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx].lambda_value == alignedSubmodels[((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx + nNullsUntilSelectedSubModel].lambda_value);
            ((GLMModel.GLMOutput)g._model._output)._submodels = alignedSubmodels;
            ((GLMModel.GLMOutput)g._model._output).setSubmodelIdx(((GLMModel.GLMOutput)g._model._output)._selected_submodel_idx + nNullsUntilSelectedSubModel, (GLMModel.GLMParameters)g._parms);
        }
        return alphasAndLambdas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cv_computeAndSetOptimalParameters(ModelBuilder[] cvModelBuilders) {
        int bestId1se;
        GLM g;
        int i2;
        int i3;
        this.setMaxRuntimeSecsForMainModel();
        double bestTestDev = Double.POSITIVE_INFINITY;
        double[] alphasAndLambdas = this.alignSubModelsAcrossCVModels(cvModelBuilders);
        int numOfSubmodels = alphasAndLambdas.length / 2;
        int lmin_max = 0;
        boolean lambdasSorted = ((GLMModel.GLMParameters)this._parms)._lambda.length >= 1;
        for (i3 = 1; i3 < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i3) {
            if (!(((GLMModel.GLMParameters)this._parms)._lambda[i3] >= ((GLMModel.GLMParameters)this._parms)._lambda[i3 - 1])) continue;
            lambdasSorted = false;
            break;
        }
        if (lambdasSorted) {
            for (i3 = 0; i3 < cvModelBuilders.length; ++i3) {
                GLM g2 = (GLM)cvModelBuilders[i3];
                lmin_max = Math.max(lmin_max, ((GLMModel.GLMOutput)g2._model._output)._selected_submodel_idx + 1);
            }
        } else {
            lmin_max = numOfSubmodels;
        }
        this._xval_deviances = new double[lmin_max];
        this._xval_sd = new double[lmin_max];
        this._xval_zValues = new double[lmin_max][this._state._nbetas];
        int bestId = 0;
        int cnt = 0;
        for (int lidx = 0; lidx < lmin_max; ++lidx) {
            double testDev = 0.0;
            double testDevSq = 0.0;
            double[] zValues = new double[this._state._nbetas];
            double[] zValuesSq = new double[this._state._nbetas];
            for (int i4 = 0; i4 < cvModelBuilders.length; ++i4) {
                GLM g3 = (GLM)cvModelBuilders[i4];
                if (((GLMModel.GLMOutput)g3._model._output)._submodels[lidx] == null) {
                    double alpha = g3._state.alpha();
                    try {
                        g3._insideCVCheck = true;
                        g3._state.setAlpha(alphasAndLambdas[lidx]);
                        g3._driver.computeSubmodel(lidx, alphasAndLambdas[lidx + numOfSubmodels], Double.NaN, Double.NaN);
                    }
                    finally {
                        g3._insideCVCheck = false;
                        g3._state.setAlpha(alpha);
                    }
                }
                assert (alphasAndLambdas[lidx] == ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].alpha_value && alphasAndLambdas[lidx + numOfSubmodels] == ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].lambda_value);
                testDev += ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].devianceValid;
                testDevSq += ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].devianceValid * ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].devianceValid;
                if (((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].zValues == null) continue;
                for (int z2 = 0; z2 < zValues.length; ++z2) {
                    int n = z2;
                    zValues[n] = zValues[n] + ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].zValues[z2];
                    int n2 = z2;
                    zValuesSq[n2] = zValuesSq[n2] + ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].zValues[z2] * ((GLMModel.GLMOutput)g3._model._output)._submodels[lidx].zValues[z2];
                }
            }
            double testDevAvg = testDev / (double)cvModelBuilders.length;
            double testDevSE = testDevSq - testDevAvg * testDev;
            double[] zValuesAvg = Arrays.stream(zValues).map(z -> z / (double)cvModelBuilders.length).toArray();
            this._xval_sd[lidx] = Math.sqrt(testDevSE / (double)((cvModelBuilders.length - 1) * cvModelBuilders.length));
            this._xval_deviances[lidx] = testDevAvg;
            this._xval_zValues[lidx] = zValuesAvg;
            if (testDevAvg < bestTestDev) {
                bestTestDev = testDevAvg;
                bestId = lidx;
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha != null && ((GLMModel.GLMParameters)this._parms)._alpha.length > 1 || !lambdasSorted || !(testDevAvg > bestTestDev) || ++cnt != 3) continue;
            lmin_max = lidx;
            break;
        }
        for (i2 = 0; i2 < cvModelBuilders.length; ++i2) {
            g = (GLM)cvModelBuilders[i2];
            if (g._toRemove == null) continue;
            for (Key k : g._toRemove) {
                Keyed.remove(k);
            }
        }
        for (i2 = 0; i2 < cvModelBuilders.length; ++i2) {
            g = (GLM)cvModelBuilders[i2];
            ((GLMModel.GLMOutput)g._model._output).setSubmodelIdx(bestId, (GLMModel.GLMParameters)g._parms);
        }
        double bestDev = this._xval_deviances[bestId];
        double bestDev1se = bestDev + this._xval_sd[bestId];
        int finalBestId = bestId;
        Integer[] orderedLambdaIndices = (Integer[])IntStream.range(0, lmin_max).filter(i -> alphasAndLambdas[i] == alphasAndLambdas[finalBestId]).boxed().sorted((a, b) -> (int)Math.signum(alphasAndLambdas[b + numOfSubmodels] - alphasAndLambdas[a + numOfSubmodels])).toArray(Integer[]::new);
        for (bestId1se = IntStream.range(0, orderedLambdaIndices.length).filter(i -> orderedLambdaIndices[i] == finalBestId).findFirst().orElse(orderedLambdaIndices.length - 1); bestId1se > 0 && this._xval_deviances[orderedLambdaIndices[bestId1se - 1]] <= bestDev1se; --bestId1se) {
        }
        this._lambdaCVEstimate = alphasAndLambdas[numOfSubmodels + bestId];
        bestId1se = orderedLambdaIndices[bestId1se];
        ((GLMModel.GLMOutput)this._model._output)._lambda_1se = alphasAndLambdas[numOfSubmodels + bestId1se];
        ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{alphasAndLambdas[bestId]};
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            int newLminMax = 0;
            int newBestId = 0;
            for (int i5 = 0; i5 < lmin_max; ++i5) {
                if (alphasAndLambdas[i5] != ((GLMModel.GLMParameters)this._parms)._alpha[0]) continue;
                ++newLminMax;
                if (i5 >= bestId) continue;
                ++newBestId;
            }
            ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, newLminMax + 1);
            ((GLMModel.GLMOutput)this._model._output)._selected_submodel_idx = newBestId;
            this._bestCVSubmodel = newBestId;
            this._xval_deviances = Arrays.copyOfRange(this._xval_deviances, bestId - newBestId, lmin_max + 1);
            this._xval_sd = Arrays.copyOfRange(this._xval_sd, bestId - newBestId, lmin_max + 1);
            this._xval_zValues = (double[][])Arrays.copyOfRange(this._xval_zValues, bestId - newBestId, lmin_max + 1);
        } else {
            ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{alphasAndLambdas[numOfSubmodels + bestId]};
            ((GLMModel.GLMOutput)this._model._output)._selected_submodel_idx = 0;
            this._bestCVSubmodel = 0;
        }
        ((GLMModel.GLMParameters)this._parms)._max_iterations = (int)Math.ceil(1.0 + Arrays.stream(cvModelBuilders).mapToDouble(cv -> ((GLMModel.GLMOutput)((GLM)cv)._model._output)._submodels[finalBestId].iteration).filter(Double::isFinite).max().orElse(((GLMModel.GLMParameters)this._parms)._max_iterations));
        if (((GLMModel.GLMParameters)this._parms)._generate_scoring_history) {
            this.generateCVScoringHistory(cvModelBuilders);
        }
        for (int i6 = 0; i6 < cvModelBuilders.length; ++i6) {
            GLM g4 = (GLM)cvModelBuilders[i6];
            GLMModel gm = g4._model;
            gm.write_lock(this._job);
            gm.update(this._job);
            gm.unlock(this._job);
        }
        if (this._betaConstraints != null) {
            DKV.remove(this._betaConstraints._key);
            this._betaConstraints.delete();
            this._betaConstraints = null;
        }
        this._doInit = false;
    }

    private void generateCVScoringHistory(ModelBuilder[] cvModelBuilders) {
        int devianceTestLength = Integer.MAX_VALUE;
        List[] cvModelIters = new List[cvModelBuilders.length];
        for (int i = 0; i < cvModelBuilders.length; ++i) {
            GLM g = (GLM)cvModelBuilders[i];
            if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                if (g._lambdaSearchScoringHistory._lambdaDevTest.size() < devianceTestLength) {
                    devianceTestLength = g._lambdaSearchScoringHistory._lambdaDevTest.size();
                }
                cvModelIters[i] = new ArrayList(g._lambdaSearchScoringHistory._lambdaIters);
                continue;
            }
            if (g._scoringHistory._lambdaDevTest.size() < devianceTestLength) {
                devianceTestLength = g._scoringHistory._lambdaDevTest.size();
            }
            cvModelIters[i] = new ArrayList(g._scoringHistory._scoringIters);
        }
        this._xval_deviances_generate_SH = new double[devianceTestLength];
        this._xval_sd_generate_SH = new double[devianceTestLength];
        this._xval_iters_generate_SH = new int[devianceTestLength];
        int countIndex = 0;
        for (int index = 0; index < devianceTestLength; ++index) {
            double testDev = 0.0;
            double testDevSq = 0.0;
            int[] foldIterIndex = GLM.findIterIndexAcrossFolds(cvModelIters, index);
            if (foldIterIndex == null) continue;
            this._xval_iters_generate_SH[countIndex] = (Integer)cvModelIters[0].get(index);
            for (int modelIndex = 0; modelIndex < cvModelBuilders.length; ++modelIndex) {
                GLM g = (GLM)cvModelBuilders[modelIndex];
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    testDev += ((Double)g._lambdaSearchScoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex])).doubleValue();
                    testDevSq += (Double)g._lambdaSearchScoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]) * (Double)g._lambdaSearchScoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]);
                    continue;
                }
                testDev += ((Double)g._scoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex])).doubleValue();
                testDevSq += (Double)g._scoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]) * (Double)g._scoringHistory._lambdaDevTest.get(foldIterIndex[modelIndex]);
            }
            double testDevAvg = testDev / (double)cvModelBuilders.length;
            double testDevSE = testDevSq - testDevAvg * testDevAvg;
            this._xval_sd_generate_SH[countIndex] = Math.sqrt(testDevSE / (double)((cvModelBuilders.length - 1) * cvModelBuilders.length));
            this._xval_deviances_generate_SH[countIndex++] = testDevAvg;
        }
        this._xval_sd_generate_SH = Arrays.copyOf(this._xval_sd_generate_SH, countIndex);
        this._xval_deviances_generate_SH = Arrays.copyOf(this._xval_deviances_generate_SH, countIndex);
        this._xval_iters_generate_SH = Arrays.copyOf(this._xval_iters_generate_SH, countIndex);
    }

    public static int[] findIterIndexAcrossFolds(List<Integer>[] cvModelIters, int fold0Index) {
        int numFolds = cvModelIters.length;
        int[] iterIndexAcrossFolds = new int[numFolds];
        int fold0Iter = cvModelIters[0].get(fold0Index);
        iterIndexAcrossFolds[0] = fold0Index;
        for (int foldIndex = 1; foldIndex < numFolds; ++foldIndex) {
            if (cvModelIters[foldIndex].get(fold0Index) == fold0Iter) {
                iterIndexAcrossFolds[foldIndex] = fold0Index;
                continue;
            }
            int currFoldIterIndex = ArrayUtils.find(cvModelIters[foldIndex].toArray(), Integer.valueOf(fold0Iter));
            if (currFoldIterIndex < 0) {
                return null;
            }
            iterIndexAcrossFolds[foldIndex] = currFoldIterIndex;
        }
        return iterIndexAcrossFolds;
    }

    protected void checkMemoryFootPrint(DataInfo activeData) {
        if (GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.COORDINATE_DESCENT.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
            long max_mem;
            int p = activeData.fullN();
            HeartBeat hb = H2O.SELF._heartbeat;
            long mem_usage = (long)((double)(hb._cpus_allowed * (p * p + activeData.largestCat()) * 8) * (1.0 + 0.5 * Math.log(this._train.lastVec().nChunks()) / Math.log(2.0)));
            if (mem_usage > (max_mem = hb.get_free_mem())) {
                String msg = "Gram matrices (one per thread) won't fit in the driver node's memory (" + PrettyPrint.bytes(mem_usage) + " > " + PrettyPrint.bytes(max_mem) + ") - try reducing the number of columns and/or the number of categorical factors (or switch to the L-BFGS solver).";
                this.error("_train", msg);
            }
        }
    }

    @Override
    public int nclasses() {
        if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
            return this._nclass;
        }
        if (GLMModel.GLMParameters.Family.binomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.quasibinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.fractionalbinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
            return 2;
        }
        return 1;
    }

    private double[] getNullBeta() {
        if (this._nullBeta == null) {
            if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this._nullBeta = MemoryManager.malloc8d((this._dinfo.fullN() + 1) * this.nclasses());
                int N = this._dinfo.fullN() + 1;
                if (((GLMModel.GLMParameters)this._parms)._intercept) {
                    if (GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                        int i;
                        RandomBase rng = RandomUtils.getRNG(((GLMModel.GLMParameters)this._parms)._seed);
                        int lastClass = this.nclasses() - 1;
                        double[] tempIcpt = new double[lastClass];
                        for (i = 0; i < lastClass; ++i) {
                            tempIcpt[i] = (-1.0 + 2.0 * rng.nextDouble()) * (double)this.nclasses();
                        }
                        Arrays.sort(tempIcpt);
                        for (i = 0; i < lastClass; ++i) {
                            this._nullBeta[this._dinfo.fullN() + i * N] = tempIcpt[i];
                        }
                    } else {
                        for (int i = 0; i < this.nclasses(); ++i) {
                            this._nullBeta[this._dinfo.fullN() + i * N] = Math.log(this._state._ymu[i]);
                        }
                    }
                }
            } else {
                this._nullBeta = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
                this._nullBeta[this._dinfo.fullN()] = ((GLMModel.GLMParameters)this._parms)._intercept && !GLMModel.GLMParameters.Family.quasibinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)this._parms).link(this._state._ymu[0]) : 0.0;
            }
        }
        return this._nullBeta;
    }

    @Override
    protected boolean computePriorClassDistribution() {
        return GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && this.nclasses() > 2;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        this.hide("_balance_classes", "Not applicable since class balancing is not required for GLM.");
        this.hide("_max_after_balance_size", "Not applicable since class balancing is not required for GLM.");
        this.hide("_class_sampling_factors", "Not applicable since class balancing is not required for GLM.");
        if (((GLMModel.GLMParameters)this._parms)._influence != null && (((GLMModel.GLMParameters)this._parms)._nfolds > 0 || ((GLMModel.GLMParameters)this._parms)._fold_column != null)) {
            this.error("influence", " cross-validation is not allowed when influence is set to dfbetas.");
        }
        ((GLMModel.GLMParameters)this._parms).validate(this);
        if (this._response != null) {
            if (!this.isClassifier() && this._response.isCategorical()) {
                this.error("_response", H2O.technote(2, "Regression requires numeric response, got categorical."));
            }
            if ((GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_LH.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.GRADIENT_DESCENT_SQERR.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) && !GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.error("_solver", "Solvers GRADIENT_DESCENT_LH and GRADIENT_DESCENT_SQERR are only supported for ordinal regression.  Do not choose them unless you specify your family to be ordinal");
            }
            switch (((GLMModel.GLMParameters)this._parms)._family) {
                case AUTO: {
                    if (this.nclasses() == 1 & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.identity && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.log && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.inverse) {
                        this.error("_family", H2O.technote(2, "AUTO for underlying response requires the link to be family_default, identity, log or inverse."));
                        break;
                    }
                    if (this.nclasses() == 2 & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.logit) {
                        this.error("_family", H2O.technote(2, "AUTO for underlying response requires the link to be family_default or logit."));
                        break;
                    }
                    if (!(this.nclasses() > 2 & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default & ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.multinomial)) break;
                    this.error("_family", H2O.technote(2, "AUTO for underlying response requires the link to be family_default or multinomial."));
                    break;
                }
                case binomial: {
                    if (this._response.isBinary() || this._nclass == 2) break;
                    this.error("_family", H2O.technote(2, "Binomial requires the response to be a 2-class categorical or a binary column (0/1)"));
                    break;
                }
                case multinomial: {
                    if (this._nclass > 2) break;
                    this.error("_family", H2O.technote(2, "Multinomial requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    break;
                }
                case poisson: 
                case negativebinomial: {
                    if (this._nclass != 1) {
                        this.error("_family", "Poisson and Negative Binomial require the response to be numeric.");
                    }
                    if (this._response.min() < 0.0) {
                        this.error("_family", "Poisson and Negative Binomial require response >= 0");
                    }
                    if (!this._response.isInt()) {
                        this.warn("_family", "Poisson and Negative Binomial expect non-negative integer response, got floats.");
                    }
                    if (!GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) break;
                    if (((GLMModel.GLMParameters)this._parms)._theta <= 0.0) {
                        this.error("_family", "Illegal Negative Binomial theta value.  Valid theta values be > 0 and <= 1.");
                        break;
                    }
                    ((GLMModel.GLMParameters)this._parms)._invTheta = 1.0 / ((GLMModel.GLMParameters)this._parms)._theta;
                    break;
                }
                case gamma: {
                    if (this._nclass != 1) {
                        this.error("_distribution", H2O.technote(2, "Gamma requires the response to be numeric."));
                    }
                    if (!(this._response.min() <= 0.0)) break;
                    this.error("_family", "Response value for gamma distribution must be greater than 0.");
                    break;
                }
                case tweedie: {
                    if (this._nclass != 1) {
                        this.error("_family", H2O.technote(2, "Tweedie requires the response to be numeric."));
                    }
                    if (!GLMModel.GLMParameters.DispersionMethod.ml.equals((Object)((GLMModel.GLMParameters)this._parms)._dispersion_parameter_method) || !(this._response.min() <= 0.0)) break;
                    this.warn("_tweedie_var_power", "Response contains zeros and/or values lower than zero. Tweedie variance power ML estimation will be limited between 1 and 2. Values lower than zero will be ignored.");
                    break;
                }
                case quasibinomial: {
                    if (this._nclass == 1) break;
                    this.error("_family", H2O.technote(2, "Quasi_binomial requires the response to be numeric."));
                    break;
                }
                case ordinal: {
                    if (this._nclass <= 2) {
                        this.error("_family", H2O.technote(2, "Ordinal requires a categorical response with at least 3 levels (for 2 class problem use family=binomial."));
                    }
                    if (((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.oprobit && ((GLMModel.GLMParameters)this._parms)._link != GLMModel.GLMParameters.Link.ologlog) break;
                    this.error("_link", "Ordinal regression only supports ologit as link.");
                    break;
                }
                case gaussian: {
                    break;
                }
                case fractionalbinomial: {
                    Vec resp = this.train().vec(((GLMModel.GLMParameters)this._parms)._response_column);
                    if (!(resp.min() < 0.0) && !(resp.max() > 1.0)) break;
                    this.error("response", String.format("Response '%s' must be between 0 and 1 for fractional_binomial family. Min: %f, Max: %f", ((GLMModel.GLMParameters)this._parms)._response_column, resp.min(), resp.max()));
                    break;
                }
                default: {
                    this.error("_family", "Invalid distribution: " + (Object)((Object)((GLMModel.GLMParameters)this._parms)._distribution));
                }
            }
        }
        if (((GLMModel.GLMParameters)this._parms)._plug_values != null && ((GLMModel.GLMParameters)this._parms).missingValuesHandling() != GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
            this.error("_missing_values_handling", "When plug values are provided - Missing Values Handling needs to be explicitly set to PlugValues.");
        }
        if (((GLMModel.GLMParameters)this._parms)._plug_values == null && ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues) {
            this.error("_missing_values_handling", "No plug values frame provided for Missing Values Handling = PlugValues.");
        }
        if (((GLMModel.GLMParameters)this._parms)._max_iterations == 0) {
            this.warn("max_iterations", "for GLM, must be >= 1 (or -1 for unlimited or default setting) to obtain proper model.  Setting it to be 0 will only return the correct coefficient names and an empty model.");
            this.warn("_max_iterations", H2O.technote(2, "for GLM, if specified, must be >= 1 or == -1."));
        }
        if (((GLMModel.GLMParameters)this._parms)._linear_constraints != null) {
            this.checkInitLinearConstraints();
        }
        if (expensive) {
            BetaConstraint bc;
            boolean skippingRows;
            String[] vifPredictors;
            if (((GLMModel.GLMParameters)this._parms)._build_null_model) {
                if (!(GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.gamma.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family))) {
                    this.error("build_null_model", " is only supported for tweedie, gamma and negativebinomial familes");
                } else {
                    GLMUtils.removePredictors((GLMModel.GLMParameters)this._parms, this._train);
                }
            }
            if (this.error_count() > 0) {
                return;
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._stopping_rounds > 0) {
                this.error("early stop", " cannot run when lambda_search=True.  Lambda_search has its own early-stopping mechanism");
            }
            if (!((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._stopping_rounds > 0) {
                this._earlyStopEnabled = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._alpha == null) {
                ((GLMModel.GLMParameters)this._parms)._alpha = new double[]{((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS ? 0.0 : 0.5};
            }
            if (((GLMModel.GLMParameters)this._parms)._lambda_search && ((GLMModel.GLMParameters)this._parms)._nlambdas == -1) {
                ((GLMModel.GLMParameters)this._parms)._nlambdas = ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0 ? 30 : 100;
            }
            this._lambdaSearchScoringHistory = new LambdaSearchScoringHistory(((GLMModel.GLMParameters)this._parms)._valid != null, ((GLMModel.GLMParameters)this._parms)._nfolds > 1);
            this._scoringHistory = new ScoringHistory(((GLMModel.GLMParameters)this._parms)._valid != null, ((GLMModel.GLMParameters)this._parms)._nfolds > 1, ((GLMModel.GLMParameters)this._parms)._generate_scoring_history);
            this._train.bulkRollups();
            this._t0 = System.currentTimeMillis();
            if (((GLMModel.GLMParameters)this._parms)._lambda_search || !((GLMModel.GLMParameters)this._parms)._intercept || ((GLMModel.GLMParameters)this._parms)._lambda == null || ((GLMModel.GLMParameters)this._parms)._lambda[0] > 0.0) {
                ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
                ((GLMModel.GLMParameters)this._parms)._family = this._nclass == 1 ? GLMModel.GLMParameters.Family.gaussian : (this._nclass == 2 ? GLMModel.GLMParameters.Family.binomial : GLMModel.GLMParameters.Family.multinomial);
            }
            if (((GLMModel.GLMParameters)this._parms)._link == GLMModel.GLMParameters.Link.family_default) {
                ((GLMModel.GLMParameters)this._parms)._link = ((GLMModel.GLMParameters)this._parms)._family.defaultLink;
            }
            if (((GLMModel.GLMParameters)this._parms)._plug_values != null) {
                Frame plugValues = ((GLMModel.GLMParameters)this._parms)._plug_values.get();
                if (plugValues == null) {
                    this.error("_plug_values", "Supplied plug values frame with key=`" + ((GLMModel.GLMParameters)this._parms)._plug_values + "` doesn't exist.");
                } else if (plugValues.numRows() != 1L) {
                    this.error("_plug_values", "Plug values frame needs to have exactly 1 row.");
                }
            }
            if (this.hasOffsetCol() && GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.warn("offset_column", " has no effect on multinomial and will be ignored.");
                if (((GLMModel.GLMParameters)this._parms)._ignored_columns != null) {
                    List<String> ignoredCols = Arrays.asList(((GLMModel.GLMParameters)this._parms)._ignored_columns);
                    ignoredCols.add(((GLMModel.GLMParameters)this._parms)._offset_column);
                    ((GLMModel.GLMParameters)this._parms)._ignored_columns = ignoredCols.toArray(new String[0]);
                } else {
                    ((GLMModel.GLMParameters)this._parms)._ignored_columns = new String[]{((GLMModel.GLMParameters)this._parms)._offset_column};
                }
                ((GLMModel.GLMParameters)this._parms)._offset_column = null;
                this._offset = null;
            }
            if (this.hasOffsetCol() && GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.error("offset_column", " does not work with ordinal family right now.  Will be fixed in the future.");
            }
            if ((((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.multinomial) || ((GLMModel.GLMParameters)this._parms)._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) && (((GLMModel.GLMParameters)this._parms)._beta_constraints != null || ((GLMModel.GLMParameters)this._parms)._non_negative)) {
                this.error(((GLMModel.GLMParameters)this._parms)._non_negative ? "non_negative" : "beta_constraints", " does not work with " + (Object)((Object)((GLMModel.GLMParameters)this._parms)._family) + " family.");
            }
            if (GLMModel.GLMParameters.DispersionMethod.ml.equals((Object)((GLMModel.GLMParameters)this._parms)._dispersion_parameter_method) && !GLMModel.GLMParameters.Family.gamma.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.error("dispersion_parameter_mode", " ml can only be used for family gamma, tweedie, negative binomial.");
            }
            if (GLMModel.GLMParameters.DispersionMethod.ml.equals((Object)((GLMModel.GLMParameters)this._parms)._dispersion_parameter_method)) {
                if (((GLMModel.GLMParameters)this._parms)._lambda == null && ((GLMModel.GLMParameters)this._parms)._lambda_search || ((GLMModel.GLMParameters)this._parms)._lambda != null && Arrays.stream(((GLMModel.GLMParameters)this._parms)._lambda).anyMatch(v -> v != 0.0)) {
                    this.error("dispersion_parameter_method", "ML is supported only without regularization!");
                } else if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                    this.info("lambda", "Setting lambda to 0 to disable regularization which is unsupported with ML dispersion estimation.");
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{0.0};
                }
                if (((GLMModel.GLMParameters)this._parms)._fix_dispersion_parameter && !GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.gamma.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this.error("fix_dispersion_parameter", " is only supported for gamma, tweedie, negativebinomial families.");
                }
                if (((GLMModel.GLMParameters)this._parms)._fix_tweedie_variance_power && GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    double minResponse = ((GLMModel.GLMParameters)this._parms).train().vec(((GLMModel.GLMParameters)this._parms)._response_column).min();
                    if (minResponse < 0.0) {
                        this.error("response_column", " must >= 0 for tweedie_variance_power > 1 when using ml to estimate the dispersion parameter.");
                    }
                    if (((GLMModel.GLMParameters)this._parms)._tweedie_variance_power > 2.0 && minResponse <= 0.0) {
                        this.warn("response_column", " must > 0 when tweedie_variance_power > 2, such rows will be ignored.");
                    }
                }
                if (((GLMModel.GLMParameters)this._parms)._dispersion_learning_rate <= 0.0 && GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this.error("dispersion_learning_rate", "must > 0 and is only used with tweedie dispersion parameter estimation using ml.");
                }
                if (((GLMModel.GLMParameters)this._parms)._fix_tweedie_variance_power && GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && ((GLMModel.GLMParameters)this._parms)._tweedie_variance_power > 1.0 && ((GLMModel.GLMParameters)this._parms)._tweedie_variance_power < 1.2) {
                    this.warn("tweedie_variance_power", "when tweedie_variance_power is close to 1 and < 1.2, there is a potential of tweedie density function being multimodal.  This will cause the optimization procedure to generate a dispsersion parameter estimation that is suboptimal.  To overcome this, try to run the model building process with different init_dispersion_parameter values.");
                }
                if (!((GLMModel.GLMParameters)this._parms)._fix_tweedie_variance_power && !GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this.error("fix_tweedie_variance_power", " can only be set to false for tweedie family.");
                }
                if (((GLMModel.GLMParameters)this._parms)._max_iterations_dispersion <= 0) {
                    this.error("max_iterations_dispersion", " must > 0.");
                }
                if (((GLMModel.GLMParameters)this._parms)._dispersion_epsilon < 0.0) {
                    this.error("dispersion_epsilon", " must >= 0.");
                }
                if (GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    if (((GLMModel.GLMParameters)this._parms)._tweedie_variance_power <= 1.0) {
                        this.error("tweedie_variance_power", " must exceed 1.");
                    }
                    if (((GLMModel.GLMParameters)this._parms)._tweedie_variance_power == 1.0) {
                        this.error("tweedie_variance_power", "Tweedie family with tweedie_variance_power=1.0 is equivalent to the Poisson family.  Please use Poisson family instead.");
                    }
                    if (((GLMModel.GLMParameters)this._parms)._tweedie_variance_power == 2.0) {
                        this.error("tweedie_variance_power", "Tweedie family with tweedie_variance_power=2.0 is equivalent to the Gamma family.  Please use Gamma family instead.");
                    }
                    if (((GLMModel.GLMParameters)this._parms)._tweedie_epsilon <= 0.0) {
                        this.error("tweedie_epsilon", " must exceed 0.");
                    }
                    if (((GLMModel.GLMParameters)this._parms)._tweedie_variance_power == 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._tweedie_variance_power = 1.5;
                    }
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._init_dispersion_parameter <= 0.0) {
                this.error("init_dispersion_parameter", " must exceed 0.0.");
            }
            boolean standardizeQ = ((GLMModel.GLMParameters)this._parms)._standardize;
            this._dinfo = new DataInfo((Frame)this._train.clone(), this._valid, 1, ((GLMModel.GLMParameters)this._parms)._use_all_factor_levels || ((GLMModel.GLMParameters)this._parms)._lambda_search, standardizeQ ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((GLMModel.GLMParameters)this._parms).imputeMissing(), ((GLMModel.GLMParameters)this._parms).makeImputer(), false, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol(), ((GLMModel.GLMParameters)this._parms).interactionSpec());
            if (((GLMModel.GLMParameters)this._parms)._generate_variable_inflation_factors && ((vifPredictors = GLMModel.getVifPredictors(this._train, (GLMModel.GLMParameters)this._parms, this._dinfo)) == null || vifPredictors.length == 0)) {
                this.error("generate_variable_inflation_factors", " cannot be enabled for GLM models with only non-numerical predictors.");
            }
            int nBetas = GLMModel.GLMParameters.Family.fractionalbinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? 2 : (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? this.nclasses() : 1);
            this._betaInfo = new BetaInfo(nBetas, this._dinfo.fullN() + 1);
            if (GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType)) {
                this._gamColIndices = GLMUtils.extractAdaptedFrameIndices(this._dinfo._adaptedFrame, this._gamColnames, this._dinfo._numOffsets[0] - this._dinfo._cats);
            }
            if (((GLMModel.GLMParameters)this._parms)._max_iterations == -1) {
                int numclasses;
                int n = numclasses = GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? this.nclasses() : 1;
                if (((GLMModel.GLMParameters)this._parms)._solver == GLMModel.GLMParameters.Solver.L_BFGS) {
                    int n2 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? ((GLMModel.GLMParameters)this._parms)._nlambdas * 100 * numclasses : numclasses * Math.max(20, this._dinfo.fullN() >> 2);
                    if (((GLMModel.GLMParameters)this._parms)._alpha[0] > 0.0) {
                        ((GLMModel.GLMParameters)this._parms)._max_iterations *= 10;
                    }
                } else {
                    int n3 = ((GLMModel.GLMParameters)this._parms)._max_iterations = ((GLMModel.GLMParameters)this._parms)._lambda_search ? 10 * ((GLMModel.GLMParameters)this._parms)._nlambdas : 50;
                }
            }
            if (this._valid != null) {
                this._validDinfo = this._dinfo.validDinfo(this._valid);
            }
            this._state = new ComputationState(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, null, this._betaInfo, this._penaltyMatrix, this._gamColIndices);
            boolean bl = skippingRows = ((GLMModel.GLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip && this._train.hasNAs();
            if (this.hasWeightCol() || skippingRows) {
                GLMTask.YMUTask ymt;
                boolean setWeights = skippingRows;
                if (setWeights) {
                    Vec wc = this._weights == null ? this._dinfo._adaptedFrame.anyVec().makeCon(1.0) : this._weights.makeCopy();
                    this._generatedWeights = "__glm_gen_weights";
                    this._dinfo.setWeights("__glm_gen_weights", wc);
                }
                if ((ymt = (GLMTask.YMUTask)new GLMTask.YMUTask(this._dinfo, GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family) ? this.nclasses() : 1, setWeights, skippingRows, true, false).doAll(this._dinfo._adaptedFrame)).wsum() == 0.0) {
                    throw new IllegalArgumentException("No rows left in the dataset after filtering out rows with missing values. Ignore columns with many NAs or impute your missing values prior to calling glm.");
                }
                Log.info(this.LogMsg("using " + ymt.nobs() + " nobs out of " + this._dinfo._adaptedFrame.numRows() + " total"));
                this._nobs = ymt.nobs();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / ymt.wsum();
                }
                if (!((GLMModel.GLMParameters)this._parms)._stdOverride) {
                    this._dinfo.updateWeightedSigmaAndMean(ymt.predictorSDs(), ymt.predictorMeans());
                }
                if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this._state._ymu = MemoryManager.malloc8d(this._nclass);
                    for (int i = 0; i < this._state._ymu.length; ++i) {
                        this._state._ymu[i] = this._priorClassDist[i];
                    }
                } else {
                    double[] dArray;
                    if (((GLMModel.GLMParameters)this._parms)._intercept) {
                        dArray = ymt._yMu;
                    } else {
                        double[] dArray2 = new double[1];
                        dArray = dArray2;
                        dArray2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(0.0);
                    }
                    this._state._ymu = dArray;
                }
            } else {
                this._nobs = this._train.numRows();
                if (((GLMModel.GLMParameters)this._parms)._obj_reg == -1.0) {
                    ((GLMModel.GLMParameters)this._parms)._obj_reg = 1.0 / (double)this._nobs;
                }
                if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this._state._ymu = MemoryManager.malloc8d(this._nclass);
                    for (int i = 0; i < this._state._ymu.length; ++i) {
                        this._state._ymu[i] = this._priorClassDist[i];
                    }
                } else {
                    this._state._ymu = new double[]{((GLMModel.GLMParameters)this._parms)._intercept ? this._train.lastVec().mean() : ((GLMModel.GLMParameters)this._parms).linkInv(0.0)};
                }
            }
            boolean betaContsOn = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null || ((GLMModel.GLMParameters)this._parms)._non_negative;
            this._linearConstraintsOn = ((GLMModel.GLMParameters)this._parms)._linear_constraints != null;
            boolean bl2 = this._betaConstraintsOn = betaContsOn && (GLMModel.GLMParameters.Solver.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.COORDINATE_DESCENT.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || GLMModel.GLMParameters.Solver.L_BFGS.equals((Object)((GLMModel.GLMParameters)this._parms)._solver));
            if (((GLMModel.GLMParameters)this._parms)._beta_constraints != null && !this._enumInCS && GLMUtils.findEnumInBetaCS(((GLMModel.GLMParameters)this._parms)._beta_constraints.get(), (GLMModel.GLMParameters)this._parms)) {
                if (this._betaConstraints == null) {
                    this._betaConstraints = GLMUtils.expandedCatCS(((GLMModel.GLMParameters)this._parms)._beta_constraints.get(), (GLMModel.GLMParameters)this._parms);
                    DKV.put(this._betaConstraints);
                }
                this._enumInCS = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._expose_constraints && ((GLMModel.GLMParameters)this._parms)._linear_constraints == null) {
                this.error("_expose_constraints", "can only be enabled when there are linear constraints.");
            }
            BetaConstraint betaConstraint = bc = ((GLMModel.GLMParameters)this._parms)._beta_constraints != null ? new BetaConstraint(((GLMModel.GLMParameters)this._parms)._beta_constraints.get()) : new BetaConstraint();
            if (betaContsOn && !this._betaConstraintsOn) {
                this.warn("Beta Constraints", "will be disabled except for solver AUTO, COORDINATE_DESCENT, IRLSM or L_BFGS.  It is not available for ordinal or multinomial families.");
            }
            if (bc.hasProximalPenalty() && ((GLMModel.GLMParameters)this._parms)._compute_p_values) {
                this.error("_compute_p_values", "P-values can not be computed for constrained problems with proximal penalty");
            }
            if (bc.hasBounds() && ((GLMModel.GLMParameters)this._parms)._early_stopping) {
                this.warn("beta constraint and early_stopping", "if both are enabled may degrade model performance.");
            }
            this._state.setBC(bc);
            if (this.hasOffsetCol() && ((GLMModel.GLMParameters)this._parms)._intercept && !GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                GLMGradientSolver gslvr = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType) ? new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC(), this._betaInfo, this._penaltyMatrix, this._gamColIndices) : new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo.filterExpandedColumns(new int[0]), 0.0, this._state.activeBC(), this._betaInfo);
                double[] x2 = new L_BFGS().solve((OptimizationUtils.GradientSolver)gslvr, (double[])new double[]{-this._offset.mean()}).coefs;
                Log.info(this.LogMsg("fitted intercept = " + x2[0]));
                x2[0] = ((GLMModel.GLMParameters)this._parms).linkInv(x2[0]);
                this._state._ymu = x2;
            }
            if (((GLMModel.GLMParameters)this._parms)._prior > 0.0) {
                this._iceptAdjust = -Math.log(this._state._ymu[0] * (1.0 - ((GLMModel.GLMParameters)this._parms)._prior) / (((GLMModel.GLMParameters)this._parms)._prior * (1.0 - this._state._ymu[0])));
            }
            ArrayList<Vec> vecs = new ArrayList<Vec>();
            if (this._weights != null) {
                vecs.add(this._weights);
            }
            if (this._offset != null) {
                vecs.add(this._offset);
            }
            vecs.add(this._response);
            double[] beta = this.getNullBeta();
            if (((GLMModel.GLMParameters)this._parms)._startval != null) {
                if (((GLMModel.GLMParameters)this._parms)._startval.length != beta.length) {
                    throw new IllegalArgumentException("Initial coefficient length (" + ((GLMModel.GLMParameters)this._parms)._startval.length + ") does not equal to actual GLM coefficient length(" + beta.length + ").\n  The order of coefficients should be the following:\n" + String.join((CharSequence)"\n", this._dinfo._adaptedFrame._names) + "\n Intercept.\n  Run your model without specifying startval to find out the actual coefficients names and lengths.");
                }
                System.arraycopy(((GLMModel.GLMParameters)this._parms)._startval, 0, beta, 0, beta.length);
            } else if (((GLMModel.GLMParameters)this._parms)._linear_constraints != null && ((GLMModel.GLMParameters)this._parms)._init_optimal_glm) {
                beta = this.genInitBeta();
            }
            GLMGradientInfo ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType) ? new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC(), this._betaInfo, this._penaltyMatrix, this._gamColIndices).getGradient(beta) : new GLMGradientSolver(this._job, (GLMModel.GLMParameters)this._parms, this._dinfo, 0.0, this._state.activeBC(), this._betaInfo).getGradient(beta);
            this._lmax = this.lmax(ginfo._gradient);
            this._gmax = this._lmax * Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
            this._state.setLambdaMax(this._lmax);
            this._state.setgMax(this._gmax);
            if (((GLMModel.GLMParameters)this._parms)._lambda_min_ratio == -1.0) {
                double d = ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio = this._nobs >> 4 > (long)this._dinfo.fullN() ? 1.0E-4 : 0.01;
                if (((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
                    ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio *= 0.01;
                }
            }
            this._betaStart = new double[beta.length];
            System.arraycopy(beta, 0, this._betaStart, 0, beta.length);
            this._state.updateState(beta, ginfo);
            if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[((GLMModel.GLMParameters)this._parms)._nlambdas];
                    double dec = Math.pow(((GLMModel.GLMParameters)this._parms)._lambda_min_ratio, 1.0 / (double)(((GLMModel.GLMParameters)this._parms)._nlambdas - 1));
                    ((GLMModel.GLMParameters)this._parms)._lambda[0] = this._lmax;
                    double l = this._lmax;
                    for (int i = 1; i < ((GLMModel.GLMParameters)this._parms)._nlambdas; ++i) {
                        ((GLMModel.GLMParameters)this._parms)._lambda[i] = l *= dec;
                    }
                } else {
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{10.0 * ((GLMModel.GLMParameters)this._parms)._lambda_min_ratio * this._lmax};
                }
            }
            if (!Double.isNaN(this._lambdaCVEstimate)) {
                for (int i = 0; i < ((GLMModel.GLMParameters)this._parms)._lambda.length; ++i) {
                    if (!(((GLMModel.GLMParameters)this._parms)._lambda[i] < this._lambdaCVEstimate)) continue;
                    ((GLMModel.GLMParameters)this._parms)._lambda = Arrays.copyOf(((GLMModel.GLMParameters)this._parms)._lambda, i + 1);
                    break;
                }
                ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
                ((GLMModel.GLMParameters)this._parms)._lambda[((GLMModel.GLMParameters)this._parms)._lambda.length - 1] = this._lambdaCVEstimate;
            }
            if (((GLMModel.GLMParameters)this._parms)._objective_epsilon == -1.0) {
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._objective_epsilon = 1.0E-4;
                } else {
                    double d = ((GLMModel.GLMParameters)this._parms)._objective_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._gradient_epsilon == -1.0) {
                double d = ((GLMModel.GLMParameters)this._parms)._gradient_epsilon = ((GLMModel.GLMParameters)this._parms)._lambda[0] == 0.0 ? 1.0E-6 : 1.0E-4;
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    ((GLMModel.GLMParameters)this._parms)._gradient_epsilon *= 0.01;
                }
            }
            if (((GLMModel.GLMParameters)this._parms)._fix_dispersion_parameter && !GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.gamma.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                this.error("fix_dispersion_parameter", " is only allowed for tweedie, gamma and negativebinomial families");
            }
            if (((GLMModel.GLMParameters)this._parms)._fix_tweedie_variance_power && !((GLMModel.GLMParameters)this._parms)._fix_dispersion_parameter) {
                this._tweedieDispersionOnly = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._calc_like) {
                switch (((GLMModel.GLMParameters)this._parms)._family) {
                    case gaussian: {
                        ((GLMModel.GLMParameters)this._parms)._compute_p_values = true;
                        ((GLMModel.GLMParameters)this._parms)._remove_collinear_columns = true;
                        break;
                    }
                    case negativebinomial: 
                    case gamma: {
                        ((GLMModel.GLMParameters)this._parms)._compute_p_values = true;
                        ((GLMModel.GLMParameters)this._parms)._remove_collinear_columns = true;
                    }
                    case tweedie: {
                        ((GLMModel.GLMParameters)this._parms)._dispersion_parameter_method = GLMModel.GLMParameters.DispersionMethod.ml;
                        ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{0.0};
                    }
                }
            }
            if (((GLMModel.GLMParameters)this._parms).hasCheckpoint()) {
                if (!GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this._checkPointFirstIter = true;
                }
                if (!GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
                    this.error("_checkpoint", "GLM checkpoint is supported only for IRLSM.  Please specify it explicitly.  Do not use AUTO or default");
                }
                Value cv = DKV.get(((GLMModel.GLMParameters)this._parms)._checkpoint);
                CheckpointUtils.getAndValidateCheckpointModel(this, GLMModel.GLMParameters.CHECKPOINT_NON_MODIFIABLE_FIELDS, cv);
            }
            if (((GLMModel.GLMParameters)this._parms)._influence != null) {
                if (!GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && !GLMModel.GLMParameters.Family.binomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
                    this.error("influence", " can only be specified for the gaussian and binomial families.");
                }
                if (((GLMModel.GLMParameters)this._parms)._lambda == null) {
                    ((GLMModel.GLMParameters)this._parms)._lambda = new double[]{0.0};
                }
                if (((GLMModel.GLMParameters)this._parms)._lambda != null && Arrays.stream(((GLMModel.GLMParameters)this._parms)._lambda).filter(x -> x > 0.0).count() > 0L) {
                    this.error("regularization", "regularization is not allowed when influence is set to dfbetas.  Please set all lambdas to 0.0.");
                }
                if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
                    this.error("lambda_search", "lambda_search and regularization are not allowed when influence is set to dfbetas.");
                }
                if (GLMModel.GLMParameters.Solver.AUTO.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
                    ((GLMModel.GLMParameters)this._parms)._solver = GLMModel.GLMParameters.Solver.IRLSM;
                } else if (!GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
                    this.error("solver", "regression influence diagnostic is only calculated for IRLSM solver.");
                }
                ((GLMModel.GLMParameters)this._parms)._compute_p_values = true;
                ((GLMModel.GLMParameters)this._parms)._remove_collinear_columns = true;
            }
            if (((GLMModel.GLMParameters)this._parms)._linear_constraints != null) {
                this.checkAssignLinearConstraints();
            }
            this.buildModel();
        }
    }

    public double[] genInitBeta() {
        if (this._checkPointFirstIter) {
            return this._model._betaCndCheckpoint;
        }
        Key<Frame> linear_constr = ((GLMModel.GLMParameters)this._parms)._linear_constraints;
        Key<Frame> beta_constr = ((GLMModel.GLMParameters)this._parms)._beta_constraints;
        ((GLMModel.GLMParameters)this._parms)._beta_constraints = null;
        ((GLMModel.GLMParameters)this._parms)._linear_constraints = null;
        GLMModel model = (GLMModel)new GLM((GLMModel.GLMParameters)this._parms).trainModel().get();
        Scope.track_generic(model);
        ((GLMModel.GLMParameters)this._parms)._linear_constraints = linear_constr;
        ((GLMModel.GLMParameters)this._parms)._beta_constraints = beta_constr;
        ScoringInfo[] scInfo = model.getScoringInfo();
        this._initIter = ((GLMScoringInfo)scInfo[scInfo.length - 1]).iterations;
        return ((GLMModel.GLMParameters)this._parms)._standardize ? ((GLMModel.GLMOutput)model._output).getNormBeta() : ((GLMModel.GLMOutput)model._output).beta();
    }

    void checkInitLinearConstraints() {
        if (!GLMModel.GLMParameters.Solver.IRLSM.equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
            this.error("solver", "constrained GLM is only available for IRLSM.  PLease set solver to IRLSM/irlsm explicitly.");
            return;
        }
        if (((GLMModel.GLMParameters)this._parms)._constraint_eta0 <= 0.0) {
            this.error("constraint_eta0", "must be > 0.");
            return;
        }
        if (((GLMModel.GLMParameters)this._parms)._constraint_tau <= 0.0) {
            this.error("constraint_tau", "must be > 0.");
            return;
        }
        if (((GLMModel.GLMParameters)this._parms)._constraint_c0 <= 0.0) {
            this.error("constraint_c0", "must be > 0.");
            return;
        }
        if (!((GLMModel.GLMParameters)this._parms)._intercept) {
            this.error("intercept", "constrained GLM is only supported with when intercept=true.");
            return;
        }
        if ((GLMUtils.notZeroLambdas(((GLMModel.GLMParameters)this._parms)._lambda) || ((GLMModel.GLMParameters)this._parms)._lambda_search) && !((GLMModel.GLMParameters)this._parms)._testCSZeroGram) {
            this.error("lambda or lambda_search", "Regularization is not allowed for constrained GLM.  Set lambda to 0.0.");
            return;
        }
        if ("multinomial".equals((Object)((GLMModel.GLMParameters)this._parms)._solver) || "ordinal".equals((Object)((GLMModel.GLMParameters)this._parms)._solver)) {
            this.error("solver", "Constrained GLM is not supported for multinomial and ordinal families");
            return;
        }
        if ("ml".equals((Object)((GLMModel.GLMParameters)this._parms)._dispersion_parameter_method)) {
            this.error("dispersion_parameter_method", "Only pearson and deviance is supported for dipsersion parameter calculation.");
            return;
        }
    }

    void checkAssignLinearConstraints() {
        List<String> redundantConstraints;
        String[] coefNames = this._dinfo.coefNames();
        int[] betaEqualLessThanArr = null;
        if (((GLMModel.GLMParameters)this._parms)._beta_constraints != null) {
            betaEqualLessThanArr = ConstrainedGLMUtils.extractBetaConstraints(this._state, coefNames);
        }
        ConstrainedGLMUtils.extractLinearConstraints(this._state, ((GLMModel.GLMParameters)this._parms)._linear_constraints, this._dinfo);
        ArrayList<String> constraintNames = new ArrayList<String>();
        double[][] initConstraintMatrix = ConstrainedGLMUtils.formConstraintMatrix(this._state, constraintNames, betaEqualLessThanArr);
        String[] constraintCoefficientNames = constraintNames.toArray(new String[0]);
        if (ConstrainedGLMUtils.countNumConst(this._state) > coefNames.length) {
            this.warn("number of constraints", " exceeds the number of coefficients.  The system is over-constraints with duplicated constraints.  Consider reducing the number of constraints.");
        }
        if ((redundantConstraints = ConstrainedGLMUtils.foundRedundantConstraints(this._state, initConstraintMatrix)) != null) {
            int numRedundant = redundantConstraints.size();
            for (int index = 0; index < numRedundant; ++index) {
                this.error("redundant linear constraints", redundantConstraints.get(index));
            }
        } else {
            this._state._csGLMState = new ConstrainedGLMUtils.ConstraintGLMStates(constraintCoefficientNames, initConstraintMatrix, (GLMModel.GLMParameters)this._parms);
        }
    }

    private void restoreScoringHistoryFromCheckpoint() {
        String[] stringArray;
        TwoDimTable scoringHistory = ((GLMModel.GLMOutput)this._model._output)._scoring_history;
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            String[] stringArray2 = new String[7];
            stringArray2[0] = "iteration";
            stringArray2[1] = "timestamp";
            stringArray2[2] = "lambda";
            stringArray2[3] = "predictors";
            stringArray2[4] = "deviance_train";
            stringArray2[5] = "deviance_test";
            stringArray = stringArray2;
            stringArray2[6] = "alpha";
        } else {
            String[] stringArray3 = new String[6];
            stringArray3[0] = "iteration";
            stringArray3[1] = "timestamp";
            stringArray3[2] = "negative_log_likelihood";
            stringArray3[3] = "objective";
            stringArray3[4] = "sum(etai-eta0)^2";
            stringArray = stringArray3;
            stringArray3[5] = "convergence";
        }
        String[] colHeaders2Restore = stringArray;
        int num2Copy = ((GLMModel.GLMParameters)this._parms)._lambda_search ? colHeaders2Restore.length : colHeaders2Restore.length - 2;
        int[] colHeadersIndex = GLM.grabHeaderIndex(scoringHistory, num2Copy, colHeaders2Restore);
        if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            this._lambdaSearchScoringHistory.restoreFromCheckpoint(scoringHistory, colHeadersIndex);
        } else {
            this._scoringHistory.restoreFromCheckpoint(scoringHistory, colHeadersIndex);
        }
    }

    static int[] grabHeaderIndex(TwoDimTable sHist, int numHeaders, String[] colHeadersUseful) {
        int[] colHeadersIndex = new int[numHeaders];
        List<String> colHeadersList = Arrays.asList(sHist.getColHeaders());
        for (int colInd = 0; colInd < numHeaders; ++colInd) {
            if (colInd == 0) {
                int indexFound = colHeadersList.indexOf(colHeadersUseful[colInd]);
                if (indexFound < 0) {
                    indexFound = colHeadersList.indexOf(colHeadersUseful[colInd] + "s");
                }
                colHeadersIndex[colInd] = indexFound;
                continue;
            }
            colHeadersIndex[colInd] = colHeadersList.indexOf(colHeadersUseful[colInd]);
        }
        return colHeadersIndex;
    }

    private void buildModel() {
        if (((GLMModel.GLMParameters)this._parms).hasCheckpoint()) {
            GLMModel model = ((GLMModel)DKV.getGet(((GLMModel.GLMParameters)this._parms)._checkpoint)).deepClone(this._result);
            model._parms = this._parms;
            this._model = model;
            this.restoreScoringHistoryFromCheckpoint();
        } else {
            this._model = new GLMModel(this._result, (GLMModel.GLMParameters)this._parms, this, this._state._ymu, this._dinfo._adaptedFrame.lastVec().sigma(), this._lmax, this._nobs);
        }
        ((GLMModel.GLMOutput)this._model._output).setLambdas((GLMModel.GLMParameters)this._parms);
        ((GLMModel.GLMOutput)this._model._output)._ymu = (double[])this._state._ymu.clone();
        this._model.delete_and_lock(this._job);
    }

    private Key[] removeLater(Key ... k) {
        this._toRemove = this._toRemove == null ? k : ArrayUtils.append(this._toRemove, k);
        return k;
    }

    @Override
    protected GLMDriver trainModelImpl() {
        this._driver = new GLMDriver();
        return this._driver;
    }

    private final double lmax(double[] grad) {
        if (GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)this._parms)._glmType)) {
            int totGamCols = 0;
            for (int numG = 0; numG < this._penaltyMatrix.length; ++numG) {
                totGamCols += this._penaltyMatrix[numG].length;
            }
            int endIndex = grad.length - totGamCols;
            return Math.max(ArrayUtils.maxValue(grad, 0, endIndex), -ArrayUtils.minValue(grad, 0, endIndex)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
        }
        return Math.max(ArrayUtils.maxValue(grad), -ArrayUtils.minValue(grad)) / Math.max(0.01, ((GLMModel.GLMParameters)this._parms)._alpha[0]);
    }

    private boolean updateEarlyStop() {
        return this._earlyStop || ScoreKeeper.stopEarly(this._model.scoreKeepers(), ((GLMModel.GLMParameters)this._parms)._stopping_rounds, ScoreKeeper.ProblemType.forSupervised(this._nclass > 1), ((GLMModel.GLMParameters)this._parms)._stopping_metric, ((GLMModel.GLMParameters)this._parms)._stopping_tolerance, "model's last", true);
    }

    private GLMModel.GLMParameters.Solver defaultSolver() {
        GLMModel.GLMParameters.Solver s = GLMModel.GLMParameters.Solver.IRLSM;
        if (((GLMModel.GLMParameters)this._parms)._remove_collinear_columns) {
            Log.info(this.LogMsg("picked solver " + (Object)((Object)s)));
            ((GLMModel.GLMParameters)this._parms)._solver = s;
            return s;
        }
        int max_active = 0;
        if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family)) {
            for (int c = 0; c < this._nclass; ++c) {
                max_active += this._state.activeDataMultinomial(c).fullN();
            }
        } else {
            max_active = this._state.activeData().fullN();
        }
        if (max_active >= 5000) {
            s = GLMModel.GLMParameters.Solver.L_BFGS;
        } else if (((GLMModel.GLMParameters)this._parms)._lambda_search) {
            s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (this._state.activeBC().hasBounds() && !this._state.activeBC().hasProximalPenalty()) {
            s = GLMModel.GLMParameters.Solver.COORDINATE_DESCENT;
        } else if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)this._parms)._family) && ((GLMModel.GLMParameters)this._parms)._alpha[0] == 0.0) {
            s = GLMModel.GLMParameters.Solver.L_BFGS;
        } else {
            Log.info(this.LogMsg("picked solver " + (Object)((Object)s)));
        }
        if (s != GLMModel.GLMParameters.Solver.L_BFGS && ((GLMModel.GLMParameters)this._parms)._max_active_predictors == -1) {
            ((GLMModel.GLMParameters)this._parms)._max_active_predictors = 5000;
        }
        ((GLMModel.GLMParameters)this._parms)._solver = s;
        return s;
    }

    double objVal(double likelihood, double[] beta, double lambda) {
        double alpha = ((GLMModel.GLMParameters)this._parms)._alpha[0];
        double proximalPen = 0.0;
        BetaConstraint bc = this._state.activeBC();
        if (this._state.activeBC()._betaGiven != null && bc._rho != null) {
            for (int i = 0; i < bc._betaGiven.length; ++i) {
                double diff = beta[i] - bc._betaGiven[i];
                proximalPen += diff * diff * bc._rho[i];
            }
        }
        return likelihood * ((GLMModel.GLMParameters)this._parms)._obj_reg + 0.5 * proximalPen + lambda * (alpha * ArrayUtils.l1norm(beta, ((GLMModel.GLMParameters)this._parms)._intercept) + (1.0 - alpha) * 0.5 * ArrayUtils.l2norm2(beta, ((GLMModel.GLMParameters)this._parms)._intercept));
    }

    private String LogMsg(String msg) {
        return "GLM[dest=" + this.dest() + ", " + this._state + "] " + msg;
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN) {
        return GLM.expandVec(beta, activeCols, fullN, 0.0);
    }

    private static final double[] expandVec(double[] beta, int[] activeCols, int fullN, double filler) {
        assert (beta != null);
        if (activeCols == null) {
            return beta;
        }
        double[] res = MemoryManager.malloc8d(fullN);
        Arrays.fill(res, filler);
        int i = 0;
        for (int c : activeCols) {
            res[c] = beta[i++];
        }
        res[res.length - 1] = beta[beta.length - 1];
        return res;
    }

    private static double[] doUpdateCD(double[] grads, double[] ary, double diff, int variable_min, int variable_max) {
        int i;
        for (i = 0; i < variable_min; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        for (i = variable_max; i < grads.length; ++i) {
            int n = i;
            grads[n] = grads[n] + diff * ary[i];
        }
        return grads;
    }

    public double[] COD_solve(ComputationState.GramXY gram, double alpha, double lambda) {
        double[] res = this.COD_solve(gram.gram.getXX(), gram.xy, gram.getCODGradients(), gram.newCols, alpha, lambda);
        gram.newCols = new int[0];
        return res;
    }

    private double[] COD_solve(double[][] xx, double[] xy, double[] grads, int[] newCols, double alpha, double lambda) {
        double wsumInv = 1.0 / xx[xx.length - 1][xx.length - 1];
        double betaEpsilon = ((GLMModel.GLMParameters)this._parms)._beta_epsilon * ((GLMModel.GLMParameters)this._parms)._beta_epsilon;
        double updateEpsilon = 0.01 * betaEpsilon;
        double l1pen = lambda * alpha;
        double l2pen = lambda * (1.0 - alpha);
        double[] diagInv = MemoryManager.malloc8d(xx.length);
        for (int i = 0; i < diagInv.length; ++i) {
            diagInv[i] = 1.0 / (xx[i][i] + l2pen);
        }
        DataInfo activeData = this._state.activeData();
        int[][] nzs = new int[activeData.numStart()][];
        int sparseCnt = 0;
        if (nzs.length > 1000) {
            int[] nzs_ary = new int[xx.length];
            for (int i = 0; i < activeData._cats; ++i) {
                int var_min = activeData._catOffsets[i];
                int var_max = activeData._catOffsets[i + 1];
                for (int l = var_min; l < var_max; ++l) {
                    int j;
                    int k = 0;
                    double[] x = xx[l];
                    for (j = 0; j < var_min; ++j) {
                        if (x[j] == 0.0) continue;
                        nzs_ary[k++] = j;
                    }
                    for (j = var_max; j < activeData.numStart(); ++j) {
                        if (x[j] == 0.0) continue;
                        nzs_ary[k++] = j;
                    }
                    if (k >= nzs_ary.length - var_max + var_min >> 3) continue;
                    ++sparseCnt;
                    nzs[l] = Arrays.copyOf(nzs_ary, k);
                }
            }
        }
        BetaConstraint bc = this._state.activeBC();
        double[] beta = (double[])this._state.beta().clone();
        int numStart = activeData.numStart();
        if (newCols != null) {
            for (int id : newCols) {
                double b = bc.applyBounds(ADMM.shrinkage(grads[id], l1pen) * diagInv[id], id);
                if (b == 0.0) continue;
                GLM.doUpdateCD(grads, xx[id], -b, id, id + 1);
                beta[id] = b;
            }
        }
        int iter1 = 0;
        int P = xy.length - 1;
        double maxDiff = 0.0;
        while (iter1++ < Math.max(P, 500)) {
            int i;
            maxDiff = 0.0;
            for (i = 0; i < activeData._cats; ++i) {
                for (int j = activeData._catOffsets[i]; j < activeData._catOffsets[i + 1]; ++j) {
                    double b = bc.applyBounds(ADMM.shrinkage(grads[j], l1pen) * diagInv[j], j);
                    double bd = beta[j] - b;
                    if (bd == 0.0) continue;
                    double diff = bd * bd * xx[j][j];
                    if (diff > maxDiff) {
                        maxDiff = diff;
                    }
                    if (nzs[j] == null) {
                        GLM.doUpdateCD(grads, xx[j], bd, activeData._catOffsets[i], activeData._catOffsets[i + 1]);
                    } else {
                        int[] ids;
                        double[] x = xx[j];
                        int[] nArray = ids = nzs[j];
                        int n = nArray.length;
                        for (int k = 0; k < n; ++k) {
                            int id;
                            int n2 = id = nArray[k];
                            grads[n2] = grads[n2] + bd * x[id];
                        }
                        GLM.doUpdateCD(grads, x, bd, 0, activeData.numStart());
                    }
                    beta[j] = b;
                }
            }
            for (i = numStart; i < P; ++i) {
                double b = bc.applyBounds(ADMM.shrinkage(grads[i], l1pen) * diagInv[i], i);
                double bd = beta[i] - b;
                double diff = bd * bd * xx[i][i];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                if (!(diff > updateEpsilon)) continue;
                GLM.doUpdateCD(grads, xx[i], bd, i, i + 1);
                beta[i] = b;
            }
            if (((GLMModel.GLMParameters)this._parms)._intercept) {
                double b = bc.applyBounds(grads[P] * wsumInv, P);
                double bd = beta[P] - b;
                double diff = bd * bd * xx[P][P];
                if (diff > maxDiff) {
                    maxDiff = diff;
                }
                GLM.doUpdateCD(grads, xx[P], bd, P, P + 1);
                beta[P] = b;
            }
            if (!(maxDiff < betaEpsilon)) continue;
            break;
        }
        return beta;
    }

    protected static double sparseOffset(double[] beta, DataInfo dinfo) {
        double etaOffset = 0.0;
        if (dinfo._normMul != null && dinfo._normSub != null && beta != null) {
            int ns = dinfo.numStart();
            for (int i = 0; i < dinfo._nums; ++i) {
                etaOffset -= beta[i + ns] * dinfo._normSub[i] * dinfo._normMul[i];
            }
        }
        return etaOffset;
    }

    public static class PlugValuesImputer
    implements DataInfo.Imputer {
        private final Frame _plug_vals;

        public PlugValuesImputer(Frame plugValues) {
            this._plug_vals = plugValues;
        }

        @Override
        public int imputeCat(String name, Vec v, boolean useAllFactorLevels) {
            String value;
            String[] domain = v.domain();
            Vec pvec = this.pvec(name);
            if (pvec.isCategorical()) {
                value = pvec.domain()[(int)pvec.at(0L)];
            } else if (pvec.isString()) {
                value = pvec.stringAt(0L);
            } else {
                throw new IllegalStateException("Plug value for a categorical column `" + name + "` cannot by of type " + pvec.get_type_str() + "!");
            }
            int valueIndex = ArrayUtils.find(domain, value);
            if (valueIndex < 0) {
                throw new IllegalStateException("Plug value `" + value + "` of column `" + name + "` is not a member of the column's domain!");
            }
            return valueIndex;
        }

        @Override
        public double imputeNum(String name, Vec v) {
            Vec pvec = this.pvec(name);
            if (v.isNumeric() || v.isTime()) {
                return pvec.at(0L);
            }
            throw new IllegalStateException("Plug value for a column `" + name + "` of type " + v.get_type_str() + " cannot by of type " + pvec.get_type_str() + "!");
        }

        @Override
        public double[] imputeInteraction(String name, InteractionWrappedVec iv, double[] means) {
            if (iv.isNumericInteraction()) {
                return new double[]{this.imputeNum(name, iv)};
            }
            assert (iv.v1Domain() == null || iv.v2Domain() == null);
            String[] domain = iv.v1Domain() != null ? iv.v1Domain() : iv.v2Domain();
            double[] vals = new double[domain.length];
            for (int i = 0; i < domain.length; ++i) {
                vals[i] = this.pvec(name + "." + domain[i]).at(0L);
            }
            return vals;
        }

        private Vec pvec(String name) {
            Vec pvec = this._plug_vals.vec(name);
            if (pvec == null) {
                throw new IllegalStateException("Plug value for column `" + name + "` is not defined!");
            }
            return pvec;
        }
    }

    public final class BetaConstraint
    extends Iced {
        double[] _betaStart;
        double[] _betaGiven;
        double[] _rho;
        double[] _betaLB;
        double[] _betaUB;

        public BetaConstraint() {
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                this.setNonNegative();
            }
        }

        public void setNonNegative() {
            if (this._betaLB == null) {
                this._betaLB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + 1);
                this._betaLB[GLM.this._dinfo.fullN()] = Double.NEGATIVE_INFINITY;
            } else {
                for (int i = 0; i < this._betaLB.length - 1; ++i) {
                    this._betaLB[i] = Math.max(0.0, this._betaLB[i]);
                }
            }
            if (this._betaUB == null) {
                this._betaUB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + 1);
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
            }
        }

        public void setNonNegative(Frame otherConst) {
            List<String> constraintNames = this.extractVec2List(otherConst);
            List coefNames = Arrays.stream(GLM.this._dinfo.coefNames()).collect(Collectors.toList());
            int numCoef = coefNames.size();
            for (int index = 0; index < numCoef; ++index) {
                if (constraintNames.contains(coefNames.get(index))) continue;
                this._betaLB[index] = 0.0;
                this._betaUB[index] = Double.POSITIVE_INFINITY;
            }
        }

        public List<String> extractVec2List(Frame constraintF) {
            ArrayList<String> constraintNames = new ArrayList<String>();
            Vec.Reader vr = new Vec.Reader(constraintF.vec(0));
            long numRows = constraintF.numRows();
            for (long index = 0L; index < numRows; ++index) {
                BufferedString bs = vr.atStr(new BufferedString(), index);
                constraintNames.add(bs.toString());
            }
            return constraintNames;
        }

        public void applyAllBounds(double[] beta) {
            int betaLength = beta.length;
            for (int index = 0; index < betaLength; ++index) {
                beta[index] = this.applyBounds(beta[index], index);
            }
        }

        public double applyBounds(double d, int i) {
            if (this._betaLB != null && d < this._betaLB[i]) {
                return this._betaLB[i];
            }
            if (this._betaUB != null && d > this._betaUB[i]) {
                return this._betaUB[i];
            }
            return d;
        }

        private Frame encodeCategoricalsIfPresent(Frame beta_constraints) {
            String[] coefNames = GLM.this._dinfo.coefNames();
            String[] coefOriginalNames = GLM.this._dinfo.coefOriginalNames();
            Frame transformedFrame = FrameUtils.encodeBetaConstraints(null, coefNames, coefOriginalNames, beta_constraints);
            return transformedFrame;
        }

        public BetaConstraint(Frame beta_constraints) {
            int idx;
            Object[] names;
            int i;
            int[] map;
            Object[] dom;
            Vec v;
            if (GLM.this._enumInCS) {
                if (GLM.this._betaConstraints == null) {
                    beta_constraints = GLMUtils.expandedCatCS(((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints.get(), (GLMModel.GLMParameters)GLM.this._parms);
                    DKV.put(beta_constraints);
                    GLM.this._betaConstraints = beta_constraints;
                } else {
                    beta_constraints = GLM.this._betaConstraints;
                }
            }
            if ((v = beta_constraints.vec("names")).isString()) {
                dom = new String[(int)v.length()];
                map = new int[dom.length];
                BufferedString tmpStr = new BufferedString();
                for (int i2 = 0; i2 < dom.length; ++i2) {
                    dom[i2] = v.atStr(tmpStr, i2).toString();
                    if ("intercept".equals(dom[i2])) {
                        throw new IllegalArgumentException("Beta constraints cannot be applied to the intercept right row.");
                    }
                    map[i2] = i2;
                }
                Object[] sortedDom = (String[])dom.clone();
                Arrays.sort(sortedDom);
                for (i = 1; i < sortedDom.length; ++i) {
                    if (!((String)sortedDom[i - 1]).equals(sortedDom[i])) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)sortedDom[i - 1] + "'!");
                }
            } else if (v.isCategorical()) {
                dom = v.domain();
                map = FrameUtils.asInts(v);
                int[] sortedMap = MemoryManager.arrayCopyOf(map, map.length);
                Arrays.sort(sortedMap);
                for (int i3 = 1; i3 < sortedMap.length; ++i3) {
                    if (sortedMap[i3 - 1] != sortedMap[i3]) continue;
                    throw new IllegalArgumentException("Illegal beta constraints file, got duplicate constraint for predictor '" + (String)dom[sortedMap[i3 - 1]] + "'!");
                }
            } else {
                throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
            }
            if (!Arrays.deepEquals(dom, names = ArrayUtils.append(GLM.this._dinfo.coefNames(), "Intercept"))) {
                HashMap<Object, Integer> m = new HashMap<Object, Integer>();
                for (i = 0; i < names.length; ++i) {
                    m.put(names[i], i);
                }
                int[] newMap = MemoryManager.malloc4(dom.length);
                for (int i4 = 0; i4 < map.length; ++i4) {
                    if (GLM.this._removedCols.contains(dom[map[i4]])) {
                        newMap[i4] = -1;
                        continue;
                    }
                    Integer I = (Integer)m.get(dom[map[i4]]);
                    if (I == null) {
                        throw new IllegalArgumentException("Unrecognized coefficient name in beta-constraint file, unknown name '" + (String)dom[map[i4]] + "'");
                    }
                    newMap[i4] = I;
                }
                map = newMap;
            }
            int numoff = GLM.this._dinfo.numStart();
            Object[] valid_col_names = new String[]{"names", "beta_given", "beta_start", "lower_bounds", "upper_bounds", "rho", "mean", "std_dev"};
            Arrays.sort(valid_col_names);
            for (String s : beta_constraints.names()) {
                if (Arrays.binarySearch(valid_col_names, s) >= 0) continue;
                GLM.this.error("beta_constraints", "Unknown column name '" + s + "'");
            }
            v = beta_constraints.vec("beta_start");
            if (v != null) {
                this._betaStart = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                for (int i5 = 0; i5 < (int)v.length(); ++i5) {
                    if (map[i5] == -1) continue;
                    this._betaStart[map[i5]] = v.at(i5);
                }
            }
            if ((v = beta_constraints.vec("beta_given")) != null) {
                this._betaGiven = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                for (int i6 = 0; i6 < (int)v.length(); ++i6) {
                    if (map[i6] == -1) continue;
                    this._betaGiven[map[i6]] = v.at(i6);
                }
            }
            if ((v = beta_constraints.vec("upper_bounds")) != null) {
                this._betaUB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                Arrays.fill(this._betaUB, Double.POSITIVE_INFINITY);
                for (int i7 = 0; i7 < (int)v.length(); ++i7) {
                    if (map[i7] == -1) continue;
                    this._betaUB[map[i7]] = v.at(i7);
                }
            }
            if ((v = beta_constraints.vec("lower_bounds")) != null) {
                this._betaLB = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                Arrays.fill(this._betaLB, Double.NEGATIVE_INFINITY);
                for (int i8 = 0; i8 < (int)v.length(); ++i8) {
                    if (map[i8] == -1) continue;
                    this._betaLB[map[i8]] = v.at(i8);
                }
            }
            if ((v = beta_constraints.vec("rho")) != null) {
                this._rho = MemoryManager.malloc8d(GLM.this._dinfo.fullN() + (GLM.this._dinfo._intercept ? 1 : 0));
                for (int i9 = 0; i9 < (int)v.length(); ++i9) {
                    if (map[i9] == -1) continue;
                    this._rho[map[i9]] = v.at(i9);
                }
            }
            if ((v = beta_constraints.vec("mean")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i10 = 0;
                while ((long)i10 < v.length()) {
                    if (!v.isNA(i10) && map[i10] != -1) {
                        int n = idx = map == null ? i10 : map[i10];
                        if (idx >= GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normSub[idx - GLM.this._dinfo.numStart()] = v.at(i10);
                        }
                    }
                    ++i10;
                }
            }
            if ((v = beta_constraints.vec("std_dev")) != null) {
                ((GLMModel.GLMParameters)GLM.this._parms)._stdOverride = true;
                int i11 = 0;
                while ((long)i11 < v.length()) {
                    if (!v.isNA(i11) && map[i11] != -1) {
                        int n = idx = map == null ? i11 : map[i11];
                        if (idx >= GLM.this._dinfo.numStart() && idx < GLM.this._dinfo.fullN()) {
                            GLM.this._dinfo._normMul[idx - GLM.this._dinfo.numStart()] = 1.0 / v.at(i11);
                        }
                    }
                    ++i11;
                }
            }
            if (GLM.this._dinfo._normMul != null) {
                double normG = 0.0;
                double normS = 0.0;
                double normLB = 0.0;
                double normUB = 0.0;
                for (int i12 = numoff; i12 < GLM.this._dinfo.fullN(); ++i12) {
                    double s = GLM.this._dinfo._normSub[i12 - numoff];
                    double d = 1.0 / GLM.this._dinfo._normMul[i12 - numoff];
                    if (this._betaUB != null && !Double.isInfinite(this._betaUB[i12])) {
                        normUB *= s;
                        int n = i12;
                        this._betaUB[n] = this._betaUB[n] * d;
                    }
                    if (this._betaLB != null && !Double.isInfinite(this._betaLB[i12])) {
                        normLB *= s;
                        int n = i12;
                        this._betaLB[n] = this._betaLB[n] * d;
                    }
                    if (this._betaGiven != null) {
                        normG += this._betaGiven[i12] * s;
                        int n = i12;
                        this._betaGiven[n] = this._betaGiven[n] * d;
                    }
                    if (this._betaStart == null) continue;
                    normS += this._betaStart[i12] * s;
                    int n = i12;
                    this._betaStart[n] = this._betaStart[n] * d;
                }
                if (GLM.this._dinfo._intercept) {
                    int n = GLM.this._dinfo.fullN();
                    if (this._betaGiven != null) {
                        int n2 = n;
                        this._betaGiven[n2] = this._betaGiven[n2] + normG;
                    }
                    if (this._betaStart != null) {
                        int n3 = n;
                        this._betaStart[n3] = this._betaStart[n3] + normS;
                    }
                    if (this._betaLB != null) {
                        int n4 = n;
                        this._betaLB[n4] = this._betaLB[n4] + normLB;
                    }
                    if (this._betaUB != null) {
                        int n5 = n;
                        this._betaUB[n5] = this._betaUB[n5] + normUB;
                    }
                }
            }
            if (this._betaStart == null && this._betaGiven != null) {
                this._betaStart = (double[])this._betaGiven.clone();
            }
            if (this._betaStart != null && (this._betaLB != null || this._betaUB != null)) {
                for (int i13 = 0; i13 < this._betaStart.length; ++i13) {
                    if (this._betaLB != null && this._betaLB[i13] > this._betaStart[i13]) {
                        this._betaStart[i13] = this._betaLB[i13];
                    }
                    if (this._betaUB == null || !(this._betaUB[i13] < this._betaStart[i13])) continue;
                    this._betaStart[i13] = this._betaUB[i13];
                }
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._non_negative) {
                if (GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType)) {
                    this.setNonNegative(beta_constraints);
                } else {
                    this.setNonNegative();
                }
            }
            this.check();
        }

        public String toString() {
            double[][] ary = new double[this._betaGiven.length][3];
            for (int i = 0; i < this._betaGiven.length; ++i) {
                ary[i][0] = this._betaGiven[i];
                ary[i][1] = this._betaLB[i];
                ary[i][2] = this._betaUB[i];
            }
            return ArrayUtils.pprint(ary);
        }

        public boolean hasBounds() {
            if (this._betaLB != null) {
                for (double d : this._betaLB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            if (this._betaUB != null) {
                for (double d : this._betaUB) {
                    if (Double.isInfinite(d)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasProximalPenalty() {
            return this._betaGiven != null && this._rho != null && ArrayUtils.countNonzeros(this._rho) > 0;
        }

        public void adjustGradient(double[] beta, double[] grad) {
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    int n = i;
                    grad[n] = grad[n] + this._rho[i] * diff;
                }
            }
        }

        double proxPen(double[] beta) {
            double res = 0.0;
            if (this._betaGiven != null && this._rho != null) {
                for (int i = 0; i < this._betaGiven.length; ++i) {
                    double diff = beta[i] - this._betaGiven[i];
                    res += this._rho[i] * diff * diff;
                }
                res *= 0.5;
            }
            return res;
        }

        public void check() {
            if (this._betaLB != null && this._betaUB != null) {
                for (int i = 0; i < this._betaLB.length; ++i) {
                    if (this._betaLB[i] <= this._betaUB[i]) continue;
                    throw new IllegalArgumentException("lower bounds must be <= upper bounds, " + this._betaLB[i] + " !<= " + this._betaUB[i]);
                }
            }
        }

        public BetaConstraint filterExpandedColumns(int[] activeCols) {
            BetaConstraint res = new BetaConstraint();
            if (this._betaLB != null) {
                res._betaLB = ArrayUtils.select(this._betaLB, activeCols);
            }
            if (this._betaUB != null) {
                res._betaUB = ArrayUtils.select(this._betaUB, activeCols);
            }
            if (this._betaGiven != null) {
                res._betaGiven = ArrayUtils.select(this._betaGiven, activeCols);
            }
            if (this._rho != null) {
                res._rho = ArrayUtils.select(this._rho, activeCols);
            }
            if (this._betaStart != null) {
                res._betaStart = ArrayUtils.select(this._betaStart, activeCols);
            }
            return res;
        }
    }

    public static final class BetaInfo
    extends Iced<BetaInfo> {
        public final int _nBetas;
        public final int _betaLenPerClass;

        public BetaInfo(int nBetas, int betaLenPerClass) {
            this._nBetas = nBetas;
            this._betaLenPerClass = betaLenPerClass;
        }

        public int totalBetaLength() {
            return this._nBetas * this._betaLenPerClass;
        }
    }

    public static final class GLMGradientSolver
    implements OptimizationUtils.GradientSolver {
        final GLMModel.GLMParameters _parms;
        final DataInfo _dinfo;
        final BetaConstraint _bc;
        final double _l2pen;
        final Job _job;
        final BetaInfo _betaInfo;
        double[][] _betaMultinomial;
        double[][][] _penaltyMatrix;
        int[][] _gamColIndices;

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc, BetaInfo bi) {
            this._job = job;
            this._bc = bc;
            this._parms = glmp;
            this._dinfo = dinfo;
            this._l2pen = l2pen;
            this._betaInfo = bi;
        }

        public GLMGradientSolver(Job job, GLMModel.GLMParameters glmp, DataInfo dinfo, double l2pen, BetaConstraint bc, BetaInfo bi, double[][][] penaltyMat, int[][] gamColInd) {
            this(job, glmp, dinfo, l2pen, bc, bi);
            this._penaltyMatrix = penaltyMat;
            this._gamColIndices = gamColInd;
        }

        public GLMGradientInfo getMultinomialLikelihood(double[] beta) {
            assert (GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family)) : "GLMGradientInfo.getMultinomialLikelihood is only used by multinomial GLM";
            assert (this._betaMultinomial != null) : "Multinomial coefficents cannot be null.";
            int off = 0;
            for (int i = 0; i < this._betaMultinomial.length; ++i) {
                System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                off += this._betaMultinomial[i].length;
            }
            GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialLikelihoodTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms).doAll(this._dinfo._adaptedFrame);
            double l2pen = 0.0;
            for (double[] b : this._betaMultinomial) {
                l2pen += ArrayUtils.l2norm2(b, this._dinfo._intercept);
            }
            double smoothval = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(this._betaMultinomial, this._penaltyMatrix, this._gamColIndices) : 0.0;
            return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen + smoothval, null);
        }

        public GLMGradientInfo getGradient(double[] beta, ComputationState state) {
            DataInfo dinfo;
            DataInfo dataInfo = dinfo = state.activeData()._activeCols == null ? this._dinfo : state.activeData();
            assert (beta.length == dinfo.fullN() + 1);
            assert (this._parms._intercept || beta[beta.length - 1] == 0.0);
            GLMTask.GLMGradientTask gt = this._parms._family == GLMModel.GLMParameters.Family.binomial && this._parms._link == GLMModel.GLMParameters.Link.logit || this._parms._family == GLMModel.GLMParameters.Family.fractionalbinomial && this._parms._link == GLMModel.GLMParameters.Link.logit ? (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(this._job == null ? null : this._job._key, dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.gaussian && this._parms._link == GLMModel.GLMParameters.Link.identity ? (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(this._job == null ? null : this._job._key, dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(dinfo._adaptedFrame) : (GLMModel.GLMParameters.Family.negativebinomial.equals((Object)this._parms._family) ? (GLMTask.GLMGradientTask)new GLMTask.GLMNegativeBinomialGradientTask(this._job == null ? null : this._job._key, dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.poisson && this._parms._link == GLMModel.GLMParameters.Link.log ? (GLMTask.GLMGradientTask)new GLMTask.GLMPoissonGradientTask(this._job == null ? null : this._job._key, dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.quasibinomial ? (GLMTask.GLMGradientTask)new GLMTask.GLMQuasiBinomialGradientTask(this._job == null ? null : this._job._key, dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(this._job == null ? null : this._job._key, dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(dinfo._adaptedFrame)))));
            double[] gradient = gt._gradient;
            double likelihood = gt._likelihood;
            if (!this._parms._intercept) {
                gradient[gradient.length - 1] = 0.0;
            }
            double gamSmooth = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, dinfo._activeCols, this._betaInfo.totalBetaLength()), this._penaltyMatrix, this._gamColIndices) : 0.0;
            double obj = likelihood * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2(beta, true) + gamSmooth;
            return new GLMGradientInfo(likelihood, obj, gradient);
        }

        @Override
        public GLMGradientInfo getGradient(double[] beta) {
            if (GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)this._parms._family)) {
                if (this._betaMultinomial == null) {
                    this._betaMultinomial = new double[this._betaInfo._nBetas][];
                    for (int i = 0; i < this._betaInfo._nBetas; ++i) {
                        this._betaMultinomial[i] = MemoryManager.malloc8d(this._dinfo.fullN() + 1);
                    }
                }
                int off = 0;
                for (int i = 0; i < this._betaMultinomial.length; ++i) {
                    if (!this._parms._remove_collinear_columns || this._dinfo._activeCols == null || this._dinfo._activeCols.length == this._betaInfo._betaLenPerClass) {
                        System.arraycopy(beta, off, this._betaMultinomial[i], 0, this._betaMultinomial[i].length);
                    } else {
                        this._betaMultinomial[i] = ComputationState.extractSubRange(this._betaInfo._betaLenPerClass, i, this._dinfo._activeCols, beta);
                    }
                    off += this._betaMultinomial[i].length;
                }
                GLMTask.GLMMultinomialGradientBaseTask gt = (GLMTask.GLMMultinomialGradientBaseTask)new GLMTask.GLMMultinomialGradientTask(this._job, this._dinfo, this._l2pen, this._betaMultinomial, this._parms, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame);
                double l2pen = 0.0;
                for (double[] b : this._betaMultinomial) {
                    l2pen += ArrayUtils.l2norm2(b, this._dinfo._intercept);
                    if (GLMModel.GLMParameters.Family.ordinal.equals((Object)this._parms._family)) break;
                }
                double[] grad = gt.gradient();
                if (!this._parms._intercept) {
                    for (int i = this._dinfo.fullN(); i < beta.length; i += this._dinfo.fullN() + 1) {
                        grad[i] = 0.0;
                    }
                }
                double smoothVal = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(this._betaMultinomial, this._penaltyMatrix, this._gamColIndices) : 0.0;
                return new GLMGradientInfo(gt._likelihood, gt._likelihood * this._parms._obj_reg + 0.5 * this._l2pen * l2pen + smoothVal, grad);
            }
            assert (beta.length == this._dinfo.fullN() + 1);
            assert (this._parms._intercept || beta[beta.length - 1] == 0.0);
            GLMTask.GLMGradientTask gt = this._parms._family == GLMModel.GLMParameters.Family.binomial && this._parms._link == GLMModel.GLMParameters.Link.logit || this._parms._family == GLMModel.GLMParameters.Family.fractionalbinomial && this._parms._link == GLMModel.GLMParameters.Link.logit ? (GLMTask.GLMGradientTask)new GLMTask.GLMBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.gaussian && this._parms._link == GLMModel.GLMParameters.Link.identity ? (GLMTask.GLMGradientTask)new GLMTask.GLMGaussianGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (GLMModel.GLMParameters.Family.negativebinomial.equals((Object)this._parms._family) ? (GLMTask.GLMGradientTask)new GLMTask.GLMNegativeBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.poisson && this._parms._link == GLMModel.GLMParameters.Link.log ? (GLMTask.GLMGradientTask)new GLMTask.GLMPoissonGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (this._parms._family == GLMModel.GLMParameters.Family.quasibinomial ? (GLMTask.GLMGradientTask)new GLMTask.GLMQuasiBinomialGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame) : (GLMTask.GLMGradientTask)new GLMTask.GLMGenericGradientTask(this._job == null ? null : this._job._key, this._dinfo, this._parms, this._l2pen, beta, this._penaltyMatrix, this._gamColIndices).doAll(this._dinfo._adaptedFrame)))));
            double[] gradient = gt._gradient;
            double likelihood = gt._likelihood;
            if (!this._parms._intercept) {
                gradient[gradient.length - 1] = 0.0;
            }
            double gamSmooth = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, this._dinfo._activeCols, this._betaInfo.totalBetaLength()), this._penaltyMatrix, this._gamColIndices) : 0.0;
            double obj = likelihood * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2(beta, true) + gamSmooth;
            if (this._bc != null && this._bc._betaGiven != null && this._bc._rho != null) {
                obj = ProximalGradientSolver.proximal_gradient(gradient, obj, beta, this._bc._betaGiven, this._bc._rho);
            }
            return new GLMGradientInfo(likelihood, obj, gradient);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            double l = ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask((Key)this._job._key, (DataInfo)this._dinfo, (GLMModel.GLMParameters)this._parms, (double[])beta).doAll((Frame)this._dinfo._adaptedFrame))._likelihood;
            double smoothness = GLMModel.GLMParameters.GLMType.gam.equals((Object)this._parms._glmType) ? GLMUtils.calSmoothNess(GLM.expandVec(beta, this._dinfo._activeCols, this._betaInfo.totalBetaLength()), this._penaltyMatrix, this._gamColIndices) : 0.0;
            return new GLMGradientInfo(l, l * this._parms._obj_reg + 0.5 * this._l2pen * ArrayUtils.l2norm2(beta, true) + smoothness, null);
        }
    }

    public static class GLMGradientInfo
    extends OptimizationUtils.GradientInfo {
        final double _likelihood;

        public GLMGradientInfo(double likelihood, double objVal, double[] grad) {
            super(objVal, grad);
            this._likelihood = likelihood;
        }

        @Override
        public String toString() {
            return "GLM grad info: likelihood = " + this._likelihood + super.toString();
        }
    }

    public static class ProximalGradientSolver
    implements OptimizationUtils.GradientSolver,
    ADMM.ProximalSolver {
        final OptimizationUtils.GradientSolver _solver;
        double[] _betaGiven;
        double[] _beta;
        private ProximalGradientInfo _ginfo;
        private final L_BFGS.ProgressMonitor _pm;
        final double[] _rho;
        private final double _objEps;
        private final double _gradEps;
        private int _iter;

        public ProximalGradientSolver(OptimizationUtils.GradientSolver s, double[] betaStart, double[] rho, double objEps, double gradEps, OptimizationUtils.GradientInfo ginfo, L_BFGS.ProgressMonitor pm) {
            this._solver = s;
            this._rho = rho;
            this._objEps = objEps;
            this._gradEps = gradEps;
            this._pm = pm;
            this._beta = betaStart;
            this._betaGiven = MemoryManager.malloc8d(betaStart.length);
        }

        public static double proximal_gradient(double[] grad, double obj, double[] beta, double[] beta_given, double[] rho) {
            for (int i = 0; i < beta.length; ++i) {
                double diff = beta[i] - beta_given[i];
                double pen = rho[i] * diff;
                if (grad != null) {
                    int n = i;
                    grad[n] = grad[n] + pen;
                }
                obj += 0.5 * pen * diff;
            }
            return obj;
        }

        private ProximalGradientInfo computeProxGrad(OptimizationUtils.GradientInfo ginfo, double[] beta) {
            assert (!(ginfo instanceof ProximalGradientInfo));
            double[] gradient = (double[])ginfo._gradient.clone();
            double obj = ProximalGradientSolver.proximal_gradient(gradient, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, gradient);
        }

        @Override
        public ProximalGradientInfo getGradient(double[] beta) {
            return this.computeProxGrad(this._solver.getGradient(beta), beta);
        }

        @Override
        public OptimizationUtils.GradientInfo getObjective(double[] beta) {
            OptimizationUtils.GradientInfo ginfo = this._solver.getObjective(beta);
            double obj = ProximalGradientSolver.proximal_gradient(null, ginfo._objVal, beta, this._betaGiven, this._rho);
            return new ProximalGradientInfo(ginfo, obj, null);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] beta) {
            OptimizationUtils.GradientInfo origGinfo = this._ginfo == null || !Arrays.equals(this._beta, beta) ? this._solver.getGradient(beta) : this._ginfo._origGinfo;
            System.arraycopy(beta_given, 0, this._betaGiven, 0, beta_given.length);
            this._ginfo = this.computeProxGrad(origGinfo, beta);
            L_BFGS.Result r = new L_BFGS().setObjEps(this._objEps).setGradEps(this._gradEps).solve(this, beta, this._ginfo, this._pm);
            System.arraycopy(r.coefs, 0, beta, 0, r.coefs.length);
            this._beta = r.coefs;
            this._iter += r.iter;
            this._ginfo = (ProximalGradientInfo)r.ginfo;
            return r.converged;
        }

        @Override
        public boolean hasGradient() {
            return true;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            return this.getGradient((double[])beta)._origGinfo;
        }

        @Override
        public int iter() {
            return this._iter;
        }
    }

    public static class ProximalGradientInfo
    extends OptimizationUtils.GradientInfo {
        final OptimizationUtils.GradientInfo _origGinfo;

        public ProximalGradientInfo(OptimizationUtils.GradientInfo origGinfo, double objVal, double[] gradient) {
            super(objVal, gradient);
            this._origGinfo = origGinfo;
        }
    }

    public static final class GramSolver
    implements ADMM.ProximalSolver {
        private final Gram _gram;
        private Gram.Cholesky _chol;
        private final double[] _xy;
        final double _lambda;
        double[] _rho;
        boolean _addedL2;
        double _betaEps;

        private static double boundedX(double x, double lb, double ub) {
            if (x < lb) {
                x = lb;
            }
            if (x > ub) {
                x = ub;
            }
            return x;
        }

        public GramSolver(Gram gram, double[] xy, double lmax, double betaEps, boolean intercept) {
            this._gram = gram;
            this._lambda = 0.0;
            this._betaEps = betaEps;
            this._xy = xy;
            double[] rhos = MemoryManager.malloc8d(xy.length);
            this.computeCholesky(gram, rhos, lmax * 1.0E-8, intercept);
            this._addedL2 = rhos[0] != 0.0;
            this._rho = (double[])(this._addedL2 ? rhos : null);
        }

        public void solve(double[] result) {
            System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            this._chol.solve(result);
            double gerr = Double.POSITIVE_INFINITY;
            if (this._addedL2) {
                double[] oldRes = MemoryManager.arrayCopyOf(result, result.length);
                for (int i = 0; i < 1000; ++i) {
                    this.solve(oldRes, result);
                    double[] g = this.gradient((double[])result)._gradient;
                    gerr = Math.max(-ArrayUtils.minValue(g), ArrayUtils.maxValue(g));
                    if (gerr < 1.0E-4) {
                        return;
                    }
                    System.arraycopy(result, 0, oldRes, 0, result.length);
                }
                Log.warn("Gram solver did not converge, gerr = " + gerr);
            }
        }

        public GramSolver(Gram gram, double[] xy, boolean intercept, double l2pen, double l1pen, double[] beta_given, double[] proxPen, double[] lb, double[] ub) {
            int i;
            if (ub != null && lb != null) {
                for (int i2 = 0; i2 < ub.length; ++i2) {
                    assert (ub[i2] >= lb[i2]) : i2 + ": ub < lb, ub = " + Arrays.toString(ub) + ", lb = " + Arrays.toString(lb);
                }
            }
            this._lambda = l2pen;
            this._gram = gram;
            int ii = intercept ? 1 : 0;
            int icptCol = gram.fullN() - 1;
            double[] rhos = MemoryManager.malloc8d(xy.length);
            double min = Double.POSITIVE_INFINITY;
            for (int i3 = 0; i3 < xy.length - ii; ++i3) {
                double d = xy[i3];
                double d2 = d = d >= 0.0 ? d : -d;
                if (!(d < min) || d == 0.0) continue;
                min = d;
            }
            double ybar = xy[icptCol];
            for (i = 0; i < rhos.length - ii; ++i) {
                double y = xy[i];
                if (y == 0.0) {
                    y = min;
                }
                double xbar = gram.get(icptCol, i);
                double x = (y - ybar * xbar) / (gram.get(i, i) - xbar * xbar + l2pen);
                rhos[i] = ADMM.L1Solver.estimateRho(x, l1pen, lb == null ? Double.NEGATIVE_INFINITY : lb[i], ub == null ? Double.POSITIVE_INFINITY : ub[i]);
            }
            if (intercept && (lb != null && !Double.isInfinite(lb[icptCol]) || ub != null && !Double.isInfinite(ub[icptCol]))) {
                int icpt = xy.length - 1;
                rhos[icpt] = 1.0;
            }
            if (l2pen > 0.0) {
                gram.addDiag(l2pen);
            }
            if (proxPen != null && beta_given != null) {
                gram.addDiag(proxPen);
                xy = (double[])xy.clone();
                for (i = 0; i < xy.length; ++i) {
                    int n = i;
                    xy[n] = xy[n] + proxPen[i] * beta_given[i];
                }
            }
            this._xy = xy;
            this._rho = rhos;
            this.computeCholesky(gram, rhos, 1.0E-5, intercept);
        }

        private void computeCholesky(Gram gram, double[] rhos, double rhoAdd, boolean intercept) {
            gram.addDiag(rhos);
            if (!intercept) {
                gram.dropIntercept();
                rhos = Arrays.copyOf(rhos, rhos.length - 1);
                this._xy[this._xy.length - 1] = 0.0;
            }
            this._chol = gram.cholesky(null, true, null);
            if (!this._chol.isSPD()) {
                gram.addDiag(ArrayUtils.mult(rhos, -1.0));
                gram.addDiag(rhoAdd, !intercept);
                Log.info("Got NonSPD matrix with original rho, re-computing with rho = " + (this._rho[0] + rhoAdd));
                this._chol = gram.cholesky(null, true, null);
                int cnt = 0;
                double rhoAddSum = rhoAdd;
                while (!this._chol.isSPD() && cnt++ < 5) {
                    gram.addDiag(rhoAdd, !intercept);
                    Log.warn("Still NonSPD matrix, re-computing with rho = " + (rhos[0] + (rhoAddSum += rhoAdd)));
                    this._chol = gram.cholesky(null, true, null);
                }
                if (!this._chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
            }
            gram.addDiag(ArrayUtils.mult(rhos, -1.0));
            ArrayUtils.mult(rhos, -1.0);
        }

        @Override
        public double[] rho() {
            return this._rho;
        }

        @Override
        public boolean solve(double[] beta_given, double[] result) {
            if (beta_given != null) {
                for (int i = 0; i < this._xy.length; ++i) {
                    result[i] = this._xy[i] + this._rho[i] * beta_given[i];
                }
            } else {
                System.arraycopy(this._xy, 0, result, 0, this._xy.length);
            }
            this._chol.solve(result);
            return true;
        }

        @Override
        public boolean hasGradient() {
            return false;
        }

        @Override
        public OptimizationUtils.GradientInfo gradient(double[] beta) {
            double[] grad = this._gram.mul(beta);
            for (int i = 0; i < this._xy.length; ++i) {
                int n = i;
                grad[n] = grad[n] - this._xy[i];
            }
            return new OptimizationUtils.GradientInfo(Double.NaN, grad);
        }

        @Override
        public int iter() {
            return 0;
        }
    }

    public final class GLMDriver
    extends ModelBuilder.Driver
    implements L_BFGS.ProgressMonitor {
        private long _workPerIteration;
        private transient double[][] _vcov;
        private transient GLMTask.GLMIterationTask _gramInfluence;
        private transient double[][] _cholInvInfluence;
        private transient Gram.Cholesky _chol;
        private transient ADMM.L1Solver _lslvr;
        private long _lastScore;
        private transient long _scoringInterval;

        public GLMDriver() {
            super(GLM.this);
            this._lastScore = System.currentTimeMillis();
            this._scoringInterval = 15000L;
        }

        private void doCleanup() {
            try {
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                    Scope.untrack((Key[])GLM.this.removeLater(new Key[]{GLM.this._dinfo.getWeightsVec()._key}));
                }
            }
            catch (Exception e) {
                Log.err("Error while cleaning up GLM " + GLM.this._result);
                Log.err(e);
            }
        }

        private double[] constraintGLM_solve(ComputationState.GramGrad gram) {
            Gram.Cholesky chol;
            if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                throw H2O.unimpl();
            }
            ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
            double[] xy = (double[])gram._xy.clone();
            Gram.Cholesky cholesky = chol = ((GLM)GLM.this)._state._iter == 0 ? gram.qrCholesky(ignoredCols, ArrayUtils.copy2DArray(gram._gram), ((GLMModel.GLMParameters)GLM.this._parms)._standardize) : gram.cholesky(null, gram._gram);
            if (!chol.isSPD()) {
                throw new Gram.NonSPDMatrixException();
            }
            if (!ignoredCols.isEmpty()) {
                int[] collinearCols = ignoredCols.stream().mapToInt(x -> x).toArray();
                Object[] ignoredConstraints = ConstrainedGLMUtils.collinearInConstraints(ArrayUtils.select(GLM.this._dinfo.coefNames(), collinearCols), ((GLM)GLM.this)._state._csGLMState._constraintNames);
                String collinearColNames = Arrays.toString(ArrayUtils.select(GLM.this._dinfo.coefNames(), collinearCols));
                if (ignoredConstraints != null && ignoredConstraints.length > 0) {
                    throw new IllegalArgumentException("Found constraints " + Arrays.toString(ignoredConstraints) + " included on collinear columns that are going to be removed.  Please remove any constraints involving collinear columns.");
                }
                if (!((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns) {
                    throw new Gram.CollinearColumnsException("Found collinear columns in the dataset. Set remove_collinear_columns flag to true to remove collinear columns automatically. Found collinear columns " + collinearColNames);
                }
                GLM.this._model.addWarning("Removed collinear columns " + collinearColNames);
                Log.warn("Removed collinear columns " + collinearColNames);
                GLM.this._state.removeCols(collinearCols);
                gram._gram = ComputationState.GramGrad.dropCols(collinearCols, gram._gram);
                gram._grad = ArrayUtils.removeIds(gram._grad, collinearCols);
                xy = ArrayUtils.removeIds(xy, collinearCols);
            }
            this._chol = chol;
            chol.solve(xy);
            return xy;
        }

        private double[] ADMM_solve(Gram gram, double[] xy) {
            if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns || ((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                Gram.Cholesky chol;
                if (!((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    throw H2O.unimpl();
                }
                ArrayList<Integer> ignoredCols = new ArrayList<Integer>();
                Gram.Cholesky cholesky = chol = ((GLM)GLM.this)._state._iter == 0 ? gram.qrCholesky(ignoredCols, ((GLMModel.GLMParameters)GLM.this._parms)._standardize) : gram.cholesky(null);
                if (!ignoredCols.isEmpty() && !((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns) {
                    int[] collinearCols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinearCols.length; ++i) {
                        collinearCols[i] = ignoredCols.get(i);
                    }
                    throw new Gram.CollinearColumnsException("Found collinear columns in the dataset. P-values can not be computed with collinear columns in the dataset. Set remove_collinear_columns flag to true to remove collinear columns automatically. Found collinear columns " + Arrays.toString(ArrayUtils.select(GLM.this._dinfo.coefNames(), collinearCols)));
                }
                if (!chol.isSPD()) {
                    throw new Gram.NonSPDMatrixException();
                }
                this._chol = chol;
                if (!ignoredCols.isEmpty()) {
                    int[] collinearCols = new int[ignoredCols.size()];
                    for (int i = 0; i < collinearCols.length; ++i) {
                        collinearCols[i] = ignoredCols.get(i);
                    }
                    Object[] collinearColNames = ArrayUtils.select(GLM.this._state.activeData().coefNames(), collinearCols);
                    GLM.this._model.addWarning("Removed collinear columns " + Arrays.toString(collinearColNames));
                    Log.warn("Removed collinear columns " + Arrays.toString(collinearColNames));
                    GLM.this._state.removeCols(collinearCols);
                    gram.dropCols(collinearCols);
                    xy = ArrayUtils.removeIds(xy, collinearCols);
                }
                xy = (double[])xy.clone();
                chol.solve(xy);
            } else {
                gram = gram.deep_clone();
                xy = (double[])xy.clone();
                GramSolver slvr = new GramSolver((Gram)gram.clone(), (double[])xy.clone(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, GLM.this._state.l2pen(), GLM.this._state.l1pen(), ((GLM)GLM.this)._state.activeBC()._betaGiven, ((GLM)GLM.this)._state.activeBC()._rho, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                this._chol = slvr._chol;
                if (GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds()) {
                    slvr.solve(xy);
                } else {
                    xy = MemoryManager.malloc8d(xy.length);
                    if (((GLM)GLM.this)._state._u == null && !GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        ((GLM)GLM.this)._state._u = MemoryManager.malloc8d(GLM.this._state.activeData().fullN() + 1);
                    }
                    this._lslvr = new ADMM.L1Solver(1.0E-4, 10000, ((GLM)GLM.this)._state._u);
                    this._lslvr.solve(slvr, xy, GLM.this._state.l1pen(), ((GLMModel.GLMParameters)GLM.this._parms)._intercept, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                }
            }
            return xy;
        }

        private void fitCOD_multinomial(GLMModel.GLMParameters.Solver s) {
            double[] beta = GLM.this._state.betaMultinomial();
            do {
                beta = (double[])beta.clone();
                for (int c = 0; c < GLM.this._nclass; ++c) {
                    OptimizationUtils.LineSearchSolver ls;
                    boolean onlyIcpt;
                    GLM.this._state.setActiveClass(c);
                    boolean bl = onlyIcpt = GLM.this._state.activeDataMultinomial(c).fullN() == 0;
                    if (GLM.this._state.l1pen() == 0.0) {
                        if (GLM.this._state.ginfoNull()) {
                            GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
                        }
                        ls = new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.ginfoMultinomial(c));
                    } else {
                        ls = new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.l1pen());
                    }
                    new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                    ComputationState.GramXY gram = GLM.this._state.computeGram(GLM.this._state.betaMultinomial(c, beta), s);
                    double[] betaCnd = GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda());
                    if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract(betaCnd, ls.getX(), betaCnd))) {
                        Log.info(GLM.this.LogMsg("Ls failed " + ls));
                        continue;
                    }
                    GLM.this._state.setBetaMultinomial(c, beta, ls.getX());
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getMultinomialLikelihood(beta)));
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                GLM.this._state.updateState(beta, GLM.this._state.gslvr().getGradient(beta));
            }
        }

        private void fitIRLSM_multinomial(GLMModel.GLMParameters.Solver s) {
            assert (GLM.this._dinfo._responses == 3) : "IRLSM for multinomial needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            if (GLMModel.GLMParameters.Solver.COORDINATE_DESCENT.equals((Object)s)) {
                this.fitCOD_multinomial(s);
            } else {
                double[] beta = GLM.this._state.betaMultinomial();
                do {
                    beta = (double[])beta.clone();
                    for (int c = 0; c < GLM.this._nclass; ++c) {
                        int lsLength;
                        boolean onlyIcpt = GLM.this._state.activeDataMultinomial(c).fullN() == 0;
                        GLM.this._state.setActiveClass(c);
                        OptimizationUtils.LineSearchSolver ls = ((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns ? (GLM.this._state.l1pen() == 0.0 ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomialFull(c, beta), ((GLM)GLM.this)._state._iter == 0 ? GLM.this._state.ginfoMultinomial(c) : GLM.this._state.ginfoMultinomialRCC(c)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomialFull(c, beta), GLM.this._state.l1pen())) : (GLM.this._state.l1pen() == 0.0 ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.ginfoMultinomial(c)) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvrMultinomial(c), GLM.this._state.betaMultinomial(c, beta), GLM.this._state.l1pen()));
                        long t1 = System.currentTimeMillis();
                        if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns && ((GLM)GLM.this)._state.activeDataMultinomial()._activeCols != null && GLM.this._betaInfo._betaLenPerClass != GLM.this._state.activeDataMultinomial().activeCols().length) {
                            double[] shortBeta = GLM.this._state.shrinkFullArray(beta);
                            new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, shortBeta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                        } else {
                            new GLMTask.GLMMultinomialUpdate(GLM.this._state.activeDataMultinomial(), GLM.this._job._key, beta, c).doAll(((GLM)GLM.this)._state.activeDataMultinomial()._adaptedFrame);
                        }
                        long t2 = System.currentTimeMillis();
                        ComputationState.GramXY gram = ((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns && ((GLM)GLM.this)._state._iter > 0 ? GLM.this._state.computeGramRCC(ls.getX(), s) : GLM.this._state.computeGram(ls.getX(), s);
                        long t3 = System.currentTimeMillis();
                        double[] betaCnd = this.ADMM_solve(gram.gram, gram.xy);
                        long t4 = System.currentTimeMillis();
                        if (((GLMModel.GLMParameters)GLM.this._parms)._remove_collinear_columns && (lsLength = ls.getX().length) != betaCnd.length) {
                            double[] wideBetaCnd = new double[lsLength];
                            ComputationState.fillSubRange(lsLength, 0, ((GLM)GLM.this)._state.activeDataMultinomial()._activeCols, betaCnd, wideBetaCnd);
                            betaCnd = wideBetaCnd;
                        }
                        if (!onlyIcpt && !ls.evaluate(ArrayUtils.subtract(betaCnd, ls.getX(), betaCnd))) {
                            Log.info(GLM.this.LogMsg("Ls failed " + ls));
                            continue;
                        }
                        long t5 = System.currentTimeMillis();
                        GLM.this._state.setBetaMultinomial(c, beta, ls.getX());
                        Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "+" + (t5 - t4) + "=" + (t5 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    }
                    GLM.this._state.setActiveClass(-1);
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._activeColsPerClass = GLM.this._state.activeDataMultinomial().activeCols();
                } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
            }
        }

        private void fitIRLSM_ordinal_default(GLMModel.GLMParameters.Solver s) {
            assert (GLM.this._dinfo._responses == 3) : "Solver for ordinal needs extra information encoded in additional reponses, expected 3 response vecs, got " + GLM.this._dinfo._responses;
            double[] beta = GLM.this._state.betaMultinomial();
            int predSize = GLM.this._dinfo.fullN();
            int predSizeP1 = predSize + 1;
            int numClass = ((GLM)GLM.this)._state._nbetas;
            int numIcpt = numClass - 1;
            double[] betaCnd = new double[predSize];
            GLM.this._state.gslvr().getGradient(beta);
            double l1pen = GLM.this._state.lambda() * ((GLM)GLM.this)._state._alpha;
            boolean stopNow = false;
            do {
                int pindex;
                beta = (double[])beta.clone();
                double[] grads = ((GLM)GLM.this)._state.ginfo()._gradient;
                for (pindex = 0; pindex < numIcpt; ++pindex) {
                    int previousIcpt;
                    int icptindex;
                    int n = icptindex = (pindex + 1) * predSizeP1 - 1;
                    beta[n] = beta[n] - grads[icptindex];
                    if (pindex <= 0 || !(beta[icptindex] < beta[previousIcpt = pindex * predSizeP1 - 1])) continue;
                    GLM.this.warn("Ordinal regression training: ", " intercepts of previous class exceed that of current class.  Make sure your training parameters are set properly.  Training will stop now with the last eligible parameters.");
                    stopNow = true;
                    for (int index = 0; index <= pindex; ++index) {
                        int n2 = icptindex = (index + 1) * predSizeP1 - 1;
                        beta[n2] = beta[n2] + grads[icptindex];
                    }
                    break;
                }
                if (stopNow) break;
                for (pindex = 0; pindex < predSize; ++pindex) {
                    betaCnd[pindex] = grads[pindex];
                    if (l1pen > 0.0) {
                        int n = pindex;
                        betaCnd[n] = betaCnd[n] + (beta[pindex] > 0.0 ? l1pen : (beta[pindex] == 0.0 ? 0.0 : -l1pen));
                    }
                    int n = pindex;
                    beta[n] = beta[n] - betaCnd[pindex];
                }
                for (int indC = 1; indC < numIcpt; ++indC) {
                    int indOffset = indC * predSizeP1;
                    for (int index = 0; index < predSize; ++index) {
                        beta[indOffset + index] = beta[index];
                    }
                }
                GLM.this._state.setActiveClass(-1);
            } while (this.progress(beta, GLM.this._state.gslvr().getGradient(beta)));
        }

        private void fitLSM(GLMModel.GLMParameters.Solver s) {
            double[] beta;
            long t0 = System.currentTimeMillis();
            ComputationState.GramXY gramXY = GLM.this._state.computeGram(GLM.this._state.beta(), s);
            Log.info(GLM.this.LogMsg("Gram computed in " + (System.currentTimeMillis() - t0) + "ms"));
            BetaConstraint bc = GLM.this._state.activeBC();
            double[] dArray = beta = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gramXY, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gramXY.gram, gramXY.xy);
            if (GLM.this._betaConstraintsOn) {
                bc.applyAllBounds(beta);
            }
            double[] x = ArrayUtils.mmul(gramXY.gram.getXX(), beta);
            for (int i = 0; i < x.length; ++i) {
                x[i] = x[i] - 2.0 * gramXY.xy[i];
            }
            double l = 0.5 * (ArrayUtils.innerProduct(x, beta) / ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg + gramXY.yy);
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, l);
        }

        private void fitIRLSM(GLMModel.GLMParameters.Solver s) {
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            OptimizationUtils.LineSearchSolver ls = null;
            int iterCnt = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0;
            boolean firstIter = iterCnt == 0;
            BetaConstraint bc = GLM.this._state.activeBC();
            try {
                while (true) {
                    ++iterCnt;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramXY gram = GLM.this._state.computeGram(betaCnd, s);
                    long t2 = System.currentTimeMillis();
                    if (!((GLM)GLM.this)._state._lsNeeded && (Double.isNaN(gram.likelihood) || GLM.this._state.objective(gram.beta, gram.likelihood) > GLM.this._state.objective() + ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon) && !GLM.this._checkPointFirstIter) {
                        ((GLM)GLM.this)._state._lsNeeded = true;
                    } else {
                        if (!(firstIter || ((GLM)GLM.this)._state._lsNeeded || this.progress(gram.beta, gram.likelihood) || GLM.this._checkPointFirstIter)) {
                            Log.info("DONE after " + (iterCnt - 1) + " iterations (1)");
                            ((GLM)GLM.this)._model._betaCndCheckpoint = betaCnd;
                            return;
                        }
                        if (!GLM.this._checkPointFirstIter) {
                            betaCnd = s == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gram.gram, gram.xy);
                        }
                    }
                    firstIter = false;
                    GLM.this._checkPointFirstIter = false;
                    long t3 = System.currentTimeMillis();
                    if (((GLM)GLM.this)._state._lsNeeded) {
                        double[] oldBetaCnd;
                        if (ls == null) {
                            OptimizationUtils.LineSearchSolver lineSearchSolver = ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
                        }
                        if (betaCnd.length != (oldBetaCnd = ls.getX()).length) {
                            betaCnd = ComputationState.extractSubRange(betaCnd.length, 0, ((GLM)GLM.this)._state.activeData()._activeCols, betaCnd);
                        }
                        if (!ls.evaluate(ArrayUtils.subtract(betaCnd, oldBetaCnd, betaCnd))) {
                            Log.info(GLM.this.LogMsg("Ls failed " + ls));
                            return;
                        }
                        betaCnd = ls.getX();
                        if (GLM.this._betaConstraintsOn) {
                            bc.applyAllBounds(betaCnd);
                        }
                        if (!this.progress(betaCnd, ls.ginfo())) {
                            return;
                        }
                        long t4 = System.currentTimeMillis();
                        Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "=" + (t4 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                        continue;
                    }
                    if (GLM.this._betaConstraintsOn) {
                        bc.applyAllBounds(betaCnd);
                    }
                    Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "=" + (t3 - t1) + "ms, step = " + 1 + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                return;
            }
        }

        private void fitIRLSMCS9() {
            boolean applyBetaConstraints;
            ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints;
            ConstrainedGLMUtils.LinearConstraints[] equalityConstraints;
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            double[] tempBeta = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta ? new double[betaCnd.length] : null;
            List<String> coefNames = Arrays.stream(((GLM)GLM.this)._state.activeData()._coefNames).collect(Collectors.toList());
            BetaConstraint bc = GLM.this._state.activeBC();
            if (((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta) {
                equalityConstraints = ((GLM)GLM.this)._state._equalityConstraintsLinear;
                lessThanEqualToConstraints = ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear;
            } else {
                equalityConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._equalityConstraintsBeta, ((GLM)GLM.this)._state._equalityConstraintsLinear);
                lessThanEqualToConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._lessThanEqualToConstraintsBeta, ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear);
            }
            boolean hasEqualityConstraints = equalityConstraints != null;
            boolean hasLessConstraints = lessThanEqualToConstraints != null;
            double[] lambdaEqual = hasEqualityConstraints ? new double[equalityConstraints.length] : null;
            double[] lambdaLessThan = hasLessConstraints ? new double[lessThanEqualToConstraints.length] : null;
            Long startSeed = ((GLMModel.GLMParameters)GLM.this._parms)._seed == -1L ? new Random().nextLong() : ((GLMModel.GLMParameters)GLM.this._parms)._seed;
            Random randObj = new Random(startSeed);
            ConstrainedGLMUtils.updateConstraintValues(betaCnd, coefNames, equalityConstraints, lessThanEqualToConstraints);
            if (hasEqualityConstraints) {
                ConstrainedGLMUtils.genInitialLambda(randObj, equalityConstraints, lambdaEqual);
            }
            if (hasLessConstraints) {
                ConstrainedGLMUtils.genInitialLambda(randObj, lessThanEqualToConstraints, lambdaLessThan);
            }
            OptimizationUtils.ExactLineSearch ls = null;
            int iterCnt = (GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0) + GLM.this._initIter;
            GLM.this._state.initConstraintDerivatives(equalityConstraints, lessThanEqualToConstraints, coefNames);
            GLMGradientSolver ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
            GLMGradientInfo gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
            GLM.this._state.setConstraintInfo(gradientInfo, equalityConstraints, lessThanEqualToConstraints, lambdaEqual, lambdaLessThan);
            boolean bl = applyBetaConstraints = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta && GLM.this._betaConstraintsOn;
            if (ConstrainedGLMUtils.constraintsStop(gradientInfo, GLM.this._state)) {
                Log.info(GLM.this.LogMsg("GLM with constraints model building completed successfully!!"));
                return;
            }
            double gradMagSquare = ArrayUtils.innerProduct(gradientInfo._gradient, gradientInfo._gradient);
            boolean gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
            int origIter = iterCnt + 1;
            try {
                while (true) {
                    boolean done;
                    boolean predictorSizeChange;
                    Matrix gramMatrix;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramGrad gram = GLM.this._state.computeGram(betaCnd, gradientInfo);
                    if (++iterCnt == origIter && (gramMatrix = new Matrix(gram._gram)).cond() >= BAD_CONDITION_NUMBER && ((GLMModel.GLMParameters)GLM.this._parms)._init_optimal_glm) {
                        GLM.this.warn("init_optimal_glm", " should be disabled.  This lead to gram matrix being close to singular.  Please re-run with init_optimal_glm set to false.");
                    }
                    boolean bl2 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[coefNames.size()];
                    }
                    betaCnd = this.constraintGLM_solve(gram);
                    boolean bl3 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[betaCnd.length];
                    }
                    if (ls == null) {
                        ls = new OptimizationUtils.ExactLineSearch(betaCnd, GLM.this._state, coefNames);
                    } else {
                        ls.reset(betaCnd, GLM.this._state, coefNames);
                    }
                    boolean lineSearchSuccess = ls.findAlpha(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo);
                    gradMagSquare = ArrayUtils.innerProduct(ls._ginfoOriginal._gradient, ls._ginfoOriginal._gradient);
                    boolean bl4 = gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
                    if (!lineSearchSuccess) {
                        if (applyBetaConstraints) {
                            bc.applyAllBounds(GLM.this._state.beta());
                        }
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, GLM.this._state.beta());
                        Log.info(GLM.this.LogMsg("Line search failed " + ls));
                        return;
                    }
                    betaCnd = ls._newBeta;
                    gradientInfo = ls._ginfoOriginal;
                    if (applyBetaConstraints) {
                        System.arraycopy(betaCnd, 0, tempBeta, 0, betaCnd.length);
                        bc.applyAllBounds(betaCnd);
                        ArrayUtils.subtract(betaCnd, tempBeta, tempBeta);
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, betaCnd);
                        gradientInfo = ls._ginfoOriginal;
                    }
                    boolean bl5 = done = GLM.this.stop_requested() || ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations || GLM.this._earlyStop;
                    if (!this.progress(betaCnd, gradientInfo)) {
                        this.checkKKTConditions(betaCnd, gradientInfo, iterCnt);
                        return;
                    }
                    Log.info(GLM.this.LogMsg("computed in " + (System.currentTimeMillis() - t1) + "ms, step = " + iterCnt + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    if (!gradSmallEnough) continue;
                    ConstrainedGLMUtils.updateConstraintParameters(GLM.this._state, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints, (GLMModel.GLMParameters)GLM.this._parms);
                    gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
                    GLM.this._state.updateState(betaCnd, gradientInfo);
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                return;
            }
        }

        private void fitIRLSMCS8() {
            boolean applyBetaConstraints;
            ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints;
            ConstrainedGLMUtils.LinearConstraints[] equalityConstraints;
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            double[] tempBeta = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta ? new double[betaCnd.length] : null;
            List<String> coefNames = Arrays.stream(((GLM)GLM.this)._state.activeData()._coefNames).collect(Collectors.toList());
            BetaConstraint bc = GLM.this._state.activeBC();
            if (((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta) {
                equalityConstraints = ((GLM)GLM.this)._state._equalityConstraintsLinear;
                lessThanEqualToConstraints = ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear;
            } else {
                equalityConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._equalityConstraintsBeta, ((GLM)GLM.this)._state._equalityConstraintsLinear);
                lessThanEqualToConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._lessThanEqualToConstraintsBeta, ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear);
            }
            boolean hasEqualityConstraints = equalityConstraints != null;
            boolean hasLessConstraints = lessThanEqualToConstraints != null;
            double[] lambdaEqual = hasEqualityConstraints ? new double[equalityConstraints.length] : null;
            double[] lambdaLessThan = hasLessConstraints ? new double[lessThanEqualToConstraints.length] : null;
            Long startSeed = ((GLMModel.GLMParameters)GLM.this._parms)._seed == -1L ? new Random().nextLong() : ((GLMModel.GLMParameters)GLM.this._parms)._seed;
            Random randObj = new Random(startSeed);
            ConstrainedGLMUtils.updateConstraintValues(betaCnd, coefNames, equalityConstraints, lessThanEqualToConstraints);
            if (hasEqualityConstraints) {
                ConstrainedGLMUtils.genInitialLambda(randObj, equalityConstraints, lambdaEqual);
            }
            if (hasLessConstraints) {
                ConstrainedGLMUtils.genInitialLambda(randObj, lessThanEqualToConstraints, lambdaLessThan);
                ConstrainedGLMUtils.adjustLambda(lessThanEqualToConstraints, lambdaLessThan);
            }
            OptimizationUtils.ExactLineSearch ls = null;
            int iterCnt = (GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0) + GLM.this._initIter;
            GLM.this._state.initConstraintDerivatives(equalityConstraints, lessThanEqualToConstraints, coefNames);
            GLMGradientSolver ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
            GLMGradientInfo gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
            GLM.this._state.setConstraintInfo(gradientInfo, equalityConstraints, lessThanEqualToConstraints, lambdaEqual, lambdaLessThan);
            boolean bl = applyBetaConstraints = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta && GLM.this._betaConstraintsOn;
            if (ConstrainedGLMUtils.constraintsStop(gradientInfo, GLM.this._state)) {
                Log.info(GLM.this.LogMsg("GLM with constraints model building completed successfully!!"));
                return;
            }
            double gradMagSquare = ArrayUtils.innerProduct(gradientInfo._gradient, gradientInfo._gradient);
            boolean gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
            int origIter = iterCnt + 1;
            try {
                while (true) {
                    boolean done;
                    boolean predictorSizeChange;
                    Matrix gramMatrix;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramGrad gram = GLM.this._state.computeGram(betaCnd, gradientInfo);
                    if (++iterCnt == origIter && (gramMatrix = new Matrix(gram._gram)).cond() >= BAD_CONDITION_NUMBER && ((GLMModel.GLMParameters)GLM.this._parms)._init_optimal_glm) {
                        GLM.this.warn("init_optimal_glm", " should be disabled.  This lead to gram matrix being close to singular.  Please re-run with init_optimal_glm set to false.");
                    }
                    boolean bl2 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[coefNames.size()];
                    }
                    betaCnd = this.constraintGLM_solve(gram);
                    boolean bl3 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[betaCnd.length];
                    }
                    if (ls == null) {
                        ls = new OptimizationUtils.ExactLineSearch(betaCnd, GLM.this._state, coefNames);
                    } else {
                        ls.reset(betaCnd, GLM.this._state, coefNames);
                    }
                    boolean lineSearchSuccess = ls.findAlpha(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo);
                    gradMagSquare = ArrayUtils.innerProduct(ls._ginfoOriginal._gradient, ls._ginfoOriginal._gradient);
                    boolean bl4 = gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
                    if (!lineSearchSuccess) {
                        if (applyBetaConstraints) {
                            bc.applyAllBounds(GLM.this._state.beta());
                        }
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, GLM.this._state.beta());
                        Log.info(GLM.this.LogMsg("Line search failed " + ls));
                        return;
                    }
                    betaCnd = ls._newBeta;
                    gradientInfo = ls._ginfoOriginal;
                    if (applyBetaConstraints) {
                        System.arraycopy(betaCnd, 0, tempBeta, 0, betaCnd.length);
                        bc.applyAllBounds(betaCnd);
                        ArrayUtils.subtract(betaCnd, tempBeta, tempBeta);
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, betaCnd);
                        gradientInfo = ls._ginfoOriginal;
                    }
                    boolean bl5 = done = GLM.this.stop_requested() || ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations || GLM.this._earlyStop;
                    if (!this.progress(betaCnd, gradientInfo)) {
                        this.checkKKTConditions(betaCnd, gradientInfo, iterCnt);
                        return;
                    }
                    Log.info(GLM.this.LogMsg("computed in " + (System.currentTimeMillis() - t1) + "ms, step = " + iterCnt + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    if (!gradSmallEnough) continue;
                    ConstrainedGLMUtils.updateConstraintParameters(GLM.this._state, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints, (GLMModel.GLMParameters)GLM.this._parms);
                    if (hasLessConstraints) {
                        ConstrainedGLMUtils.adjustLambda(lessThanEqualToConstraints, lambdaLessThan);
                    }
                    gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
                    GLM.this._state.updateState(betaCnd, gradientInfo);
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                return;
            }
        }

        private void fitIRLSMCS() {
            boolean applyBetaConstraints;
            ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints;
            ConstrainedGLMUtils.LinearConstraints[] equalityConstraints;
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            double[] tempBeta = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta ? new double[betaCnd.length] : null;
            List<String> coefNames = Arrays.stream(((GLM)GLM.this)._state.activeData()._coefNames).collect(Collectors.toList());
            BetaConstraint bc = GLM.this._state.activeBC();
            if (((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta) {
                equalityConstraints = ((GLM)GLM.this)._state._equalityConstraintsLinear;
                lessThanEqualToConstraints = ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear;
            } else {
                equalityConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._equalityConstraintsBeta, ((GLM)GLM.this)._state._equalityConstraintsLinear);
                lessThanEqualToConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._lessThanEqualToConstraintsBeta, ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear);
            }
            boolean hasEqualityConstraints = equalityConstraints != null;
            boolean hasLessConstraints = lessThanEqualToConstraints != null;
            double[] lambdaEqual = hasEqualityConstraints ? new double[equalityConstraints.length] : null;
            double[] lambdaLessThan = hasLessConstraints ? new double[lessThanEqualToConstraints.length] : null;
            Long startSeed = ((GLMModel.GLMParameters)GLM.this._parms)._seed == -1L ? new Random().nextLong() : ((GLMModel.GLMParameters)GLM.this._parms)._seed;
            Random randObj = new Random(startSeed);
            ConstrainedGLMUtils.updateConstraintValues(betaCnd, coefNames, equalityConstraints, lessThanEqualToConstraints);
            if (hasEqualityConstraints) {
                ConstrainedGLMUtils.genInitialLambda(randObj, equalityConstraints, lambdaEqual);
            }
            if (hasLessConstraints) {
                ConstrainedGLMUtils.genInitialLambda(randObj, lessThanEqualToConstraints, lambdaLessThan);
            }
            OptimizationUtils.ExactLineSearch ls = null;
            int iterCnt = (GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0) + GLM.this._initIter;
            GLM.this._state.initConstraintDerivatives(equalityConstraints, lessThanEqualToConstraints, coefNames);
            GLMGradientSolver ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
            GLMGradientInfo gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
            GLM.this._state.setConstraintInfo(gradientInfo, equalityConstraints, lessThanEqualToConstraints, lambdaEqual, lambdaLessThan);
            boolean bl = applyBetaConstraints = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta && GLM.this._betaConstraintsOn;
            if (ConstrainedGLMUtils.constraintsStop(gradientInfo, GLM.this._state)) {
                Log.info(GLM.this.LogMsg("GLM with constraints model building completed successfully!!"));
                return;
            }
            double gradMagSquare = ArrayUtils.innerProduct(gradientInfo._gradient, gradientInfo._gradient);
            boolean gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
            int origIter = iterCnt + 1;
            try {
                while (true) {
                    boolean done;
                    boolean predictorSizeChange;
                    Matrix gramMatrix;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramGrad gram = GLM.this._state.computeGram(betaCnd, gradientInfo);
                    if (++iterCnt == origIter && (gramMatrix = new Matrix(gram._gram)).cond() >= BAD_CONDITION_NUMBER && ((GLMModel.GLMParameters)GLM.this._parms)._init_optimal_glm) {
                        GLM.this.warn("init_optimal_glm", " should be disabled.  This lead to gram matrix being close to singular.  Please re-run with init_optimal_glm set to false.");
                    }
                    boolean bl2 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[coefNames.size()];
                    }
                    betaCnd = this.constraintGLM_solve(gram);
                    boolean bl3 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[betaCnd.length];
                    }
                    if (ls == null) {
                        ls = new OptimizationUtils.ExactLineSearch(betaCnd, GLM.this._state, coefNames);
                    } else {
                        ls.reset(betaCnd, GLM.this._state, coefNames);
                    }
                    boolean lineSearchSuccess = ls.findAlpha(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo);
                    gradMagSquare = ArrayUtils.innerProduct(ls._ginfoOriginal._gradient, ls._ginfoOriginal._gradient);
                    boolean bl4 = gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
                    if (!lineSearchSuccess && !gradSmallEnough) {
                        if (GLM.this._betaConstraintsOn) {
                            bc.applyAllBounds(GLM.this._state.beta());
                        }
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, GLM.this._state.beta());
                        Log.info(GLM.this.LogMsg("Line search failed " + ls));
                        return;
                    }
                    betaCnd = ls._newBeta;
                    gradientInfo = ls._ginfoOriginal;
                    if (applyBetaConstraints) {
                        System.arraycopy(betaCnd, 0, tempBeta, 0, betaCnd.length);
                        bc.applyAllBounds(betaCnd);
                        ArrayUtils.subtract(betaCnd, tempBeta, tempBeta);
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, betaCnd);
                        gradientInfo = ls._ginfoOriginal;
                    }
                    boolean bl5 = done = GLM.this.stop_requested() || ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations || GLM.this._earlyStop;
                    if (!this.progress(betaCnd, gradientInfo) && !gradSmallEnough || done) {
                        this.checkKKTConditions(betaCnd, gradientInfo, iterCnt);
                        if (GLM.this._betaConstraintsOn) {
                            bc.applyAllBounds(GLM.this._state.beta());
                        }
                        return;
                    }
                    Log.info(GLM.this.LogMsg("computed in " + (System.currentTimeMillis() - t1) + "ms, step = " + iterCnt + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    if (!gradSmallEnough) continue;
                    ConstrainedGLMUtils.updateConstraintParameters(GLM.this._state, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints, (GLMModel.GLMParameters)GLM.this._parms);
                    gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
                    GLM.this._state.updateState(betaCnd, gradientInfo);
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                return;
            }
        }

        private void fitIRLSMCS2() {
            boolean applyBetaConstraints;
            ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints;
            ConstrainedGLMUtils.LinearConstraints[] equalityConstraints;
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            double[] tempBeta = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta ? new double[betaCnd.length] : null;
            List<String> coefNames = Arrays.stream(((GLM)GLM.this)._state.activeData()._coefNames).collect(Collectors.toList());
            BetaConstraint bc = GLM.this._state.activeBC();
            if (((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta) {
                equalityConstraints = ((GLM)GLM.this)._state._equalityConstraintsLinear;
                lessThanEqualToConstraints = ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear;
            } else {
                equalityConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._equalityConstraintsBeta, ((GLM)GLM.this)._state._equalityConstraintsLinear);
                lessThanEqualToConstraints = ConstrainedGLMUtils.combineConstraints(((GLM)GLM.this)._state._lessThanEqualToConstraintsBeta, ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear);
            }
            boolean hasEqualityConstraints = equalityConstraints != null;
            boolean hasLessConstraints = lessThanEqualToConstraints != null;
            double[] lambdaEqual = hasEqualityConstraints ? new double[equalityConstraints.length] : null;
            double[] lambdaLessThan = hasLessConstraints ? new double[lessThanEqualToConstraints.length] : null;
            Long startSeed = ((GLMModel.GLMParameters)GLM.this._parms)._seed == -1L ? new Random().nextLong() : ((GLMModel.GLMParameters)GLM.this._parms)._seed;
            Random randObj = new Random(startSeed);
            ConstrainedGLMUtils.updateConstraintValues(betaCnd, coefNames, equalityConstraints, lessThanEqualToConstraints);
            OptimizationUtils.ExactLineSearch ls = null;
            int iterCnt = (GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0) + GLM.this._initIter;
            GLM.this._state.initConstraintDerivatives(equalityConstraints, lessThanEqualToConstraints, coefNames);
            GLMGradientSolver ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
            GLMGradientInfo gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
            GLM.this._state.setConstraintInfo(gradientInfo, equalityConstraints, lessThanEqualToConstraints, lambdaEqual, lambdaLessThan);
            boolean bl = applyBetaConstraints = ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta && GLM.this._betaConstraintsOn;
            if (ConstrainedGLMUtils.constraintsStop(gradientInfo, GLM.this._state)) {
                Log.info(GLM.this.LogMsg("GLM with constraints model building completed successfully!!"));
                return;
            }
            double gradMagSquare = ArrayUtils.innerProduct(gradientInfo._gradient, gradientInfo._gradient);
            boolean gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
            int origIter = iterCnt + 1;
            try {
                while (true) {
                    boolean done;
                    boolean predictorSizeChange;
                    Matrix gramMatrix;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramGrad gram = GLM.this._state.computeGram(betaCnd, gradientInfo);
                    if (++iterCnt == origIter && (gramMatrix = new Matrix(gram._gram)).cond() >= BAD_CONDITION_NUMBER && ((GLMModel.GLMParameters)GLM.this._parms)._init_optimal_glm) {
                        GLM.this.warn("init_optimal_glm", " should be disabled.  This lead to gram matrix being close to singular.  Please re-run with init_optimal_glm set to false.");
                    }
                    boolean bl2 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[coefNames.size()];
                    }
                    betaCnd = this.constraintGLM_solve(gram);
                    boolean bl3 = predictorSizeChange = !coefNames.equals(Arrays.asList(GLM.this._state.activeData().coefNames()));
                    if (predictorSizeChange) {
                        coefNames = this.changeCoeffBetainfo(((GLM)GLM.this)._state.activeData()._coefNames);
                        GLM.this._state.resizeConstraintInfo(equalityConstraints, lessThanEqualToConstraints);
                        ginfo = GLMModel.GLMParameters.GLMType.gam.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._glmType) ? new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo, GLM.this._penaltyMatrix, GLM.this._gamColIndices) : new GLMGradientSolver(GLM.this._job, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state.activeData(), 0.0, GLM.this._state.activeBC(), GLM.this._betaInfo);
                        tempBeta = new double[betaCnd.length];
                    }
                    if (ls == null) {
                        ls = new OptimizationUtils.ExactLineSearch(betaCnd, GLM.this._state, coefNames);
                    } else {
                        ls.reset(betaCnd, GLM.this._state, coefNames);
                    }
                    boolean lineSearchSuccess = ls.findAlpha(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo);
                    if (!lineSearchSuccess) {
                        if (applyBetaConstraints) {
                            bc.applyAllBounds(GLM.this._state.beta());
                        }
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, GLM.this._state.beta());
                        Log.info(GLM.this.LogMsg("Line search failed " + ls));
                        return;
                    }
                    betaCnd = ls._newBeta;
                    gradientInfo = ls._ginfoOriginal;
                    gradMagSquare = ArrayUtils.innerProduct(ls._ginfoOriginal._gradient, ls._ginfoOriginal._gradient);
                    gradSmallEnough = gradMagSquare <= ((GLM)GLM.this)._state._csGLMState._epsilonkCSSquare;
                    if (applyBetaConstraints) {
                        System.arraycopy(betaCnd, 0, tempBeta, 0, betaCnd.length);
                        bc.applyAllBounds(betaCnd);
                        ArrayUtils.subtract(betaCnd, tempBeta, tempBeta);
                        ls.setBetaConstraintsDeriv(lambdaEqual, lambdaLessThan, GLM.this._state, equalityConstraints, lessThanEqualToConstraints, ginfo, betaCnd);
                        gradientInfo = ls._ginfoOriginal;
                    }
                    boolean bl4 = done = GLM.this.stop_requested() || ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations || GLM.this._earlyStop;
                    if (!this.progress(betaCnd, gradientInfo)) {
                        this.checkKKTConditions(betaCnd, gradientInfo, iterCnt);
                        return;
                    }
                    Log.info(GLM.this.LogMsg("computed in " + (System.currentTimeMillis() - t1) + "ms, step = " + iterCnt + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    if (!gradSmallEnough) continue;
                    ConstrainedGLMUtils.updateConstraintParameters(GLM.this._state, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints, (GLMModel.GLMParameters)GLM.this._parms);
                    lambdaEqual = hasEqualityConstraints ? new double[lambdaEqual.length] : null;
                    lambdaLessThan = hasLessConstraints ? new double[lambdaLessThan.length] : null;
                    gradientInfo = ConstrainedGLMUtils.calGradient(betaCnd, GLM.this._state, ginfo, lambdaEqual, lambdaLessThan, equalityConstraints, lessThanEqualToConstraints);
                    GLM.this._state.updateState(betaCnd, gradientInfo);
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                return;
            }
        }

        public void checkKKTConditions(double[] betaCnd, GLMGradientInfo gradientInfo, int iterCnt) {
            ((GLM)GLM.this)._model._betaCndCheckpoint = betaCnd;
            boolean kktAchieved = ConstrainedGLMUtils.constraintsStop(gradientInfo, GLM.this._state);
            if (kktAchieved) {
                Log.info("KKT Conditions achieved after " + iterCnt + " iterations ");
            } else {
                Log.warn("KKT Conditions not achieved but no further progress made due to time out or no changes to coefficients after " + iterCnt + " iterations");
            }
        }

        public List<String> changeCoeffBetainfo(String[] coefNames) {
            GLM.this._betaInfo = new BetaInfo(GLMModel.GLMParameters.Family.fractionalbinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? 2 : (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? GLM.this.nclasses() : 1), coefNames.length);
            return Arrays.stream(coefNames).collect(Collectors.toList());
        }

        private void fitIRLSMML(GLMModel.GLMParameters.Solver s) {
            double[] betaCnd = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._model._betaCndCheckpoint : GLM.this._state.beta();
            OptimizationUtils.LineSearchSolver ls = null;
            int iterCnt = GLM.this._checkPointFirstIter ? ((GLM)GLM.this)._state._iter : 0;
            boolean firstIter = iterCnt == 0;
            BetaConstraint bc = GLM.this._state.activeBC();
            double previousLLH = Double.POSITIVE_INFINITY;
            boolean converged = false;
            int sameLLH = 0;
            Vec weights = GLM.this._dinfo._weights ? GLM.this._dinfo.getWeightsVec() : GLM.this._dinfo._adaptedFrame.makeCompatible(new Frame(Vec.makeOne(GLM.this._dinfo._adaptedFrame.numRows())))[0];
            Vec response = GLM.this._dinfo._adaptedFrame.vec(GLM.this._dinfo.responseChunkId(0));
            try {
                while (!converged && iterCnt < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._job.stop_requested()) {
                    ++iterCnt;
                    long t1 = System.currentTimeMillis();
                    ComputationState.GramXY gram = GLM.this._state.computeGram(betaCnd, s);
                    long t2 = System.currentTimeMillis();
                    if (!((GLM)GLM.this)._state._lsNeeded && (Double.isNaN(gram.likelihood) || GLM.this._state.objective(gram.beta, gram.likelihood) > GLM.this._state.objective() + ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon) && !GLM.this._checkPointFirstIter) {
                        ((GLM)GLM.this)._state._lsNeeded = true;
                    } else {
                        if (!(firstIter || ((GLM)GLM.this)._state._lsNeeded || this.progress(gram.beta, gram.likelihood) || GLM.this._checkPointFirstIter)) {
                            Log.info("DONE after " + (iterCnt - 1) + " iterations (1)");
                            ((GLM)GLM.this)._model._betaCndCheckpoint = betaCnd;
                            converged = true;
                        }
                        if (!GLM.this._checkPointFirstIter) {
                            betaCnd = s == GLMModel.GLMParameters.Solver.COORDINATE_DESCENT ? GLM.this.COD_solve(gram, ((GLM)GLM.this)._state._alpha, GLM.this._state.lambda()) : this.ADMM_solve(gram.gram, gram.xy);
                        }
                    }
                    firstIter = false;
                    GLM.this._checkPointFirstIter = false;
                    long t3 = System.currentTimeMillis();
                    if (((GLM)GLM.this)._state._lsNeeded) {
                        double[] oldBetaCnd;
                        if (ls == null) {
                            OptimizationUtils.LineSearchSolver lineSearchSolver = ls = GLM.this._state.l1pen() == 0.0 && !GLM.this._state.activeBC().hasBounds() ? new OptimizationUtils.MoreThuente(GLM.this._state.gslvr(), GLM.this._state.beta(), GLM.this._state.ginfo()) : new OptimizationUtils.SimpleBacktrackingLS(GLM.this._state.gslvr(), (double[])GLM.this._state.beta().clone(), GLM.this._state.l1pen(), GLM.this._state.ginfo());
                        }
                        if (betaCnd.length != (oldBetaCnd = ls.getX()).length) {
                            betaCnd = ComputationState.extractSubRange(betaCnd.length, 0, ((GLM)GLM.this)._state.activeData()._activeCols, betaCnd);
                        }
                        if (!ls.evaluate(ArrayUtils.subtract(betaCnd, oldBetaCnd, betaCnd))) {
                            Log.info(GLM.this.LogMsg("Ls failed " + ls));
                            converged = true;
                        }
                        betaCnd = ls.getX();
                        if (GLM.this._betaConstraintsOn) {
                            bc.applyAllBounds(betaCnd);
                        }
                        if (!this.progress(betaCnd, ls.ginfo())) {
                            converged = true;
                        }
                        long t4 = System.currentTimeMillis();
                        Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "+" + (t4 - t3) + "=" + (t4 - t1) + "ms, step = " + ls.step() + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    } else {
                        if (GLM.this._betaConstraintsOn) {
                            bc.applyAllBounds(betaCnd);
                        }
                        Log.info(GLM.this.LogMsg("computed in " + (t2 - t1) + "+" + (t3 - t2) + "=" + (t3 - t1) + "ms, step = " + 1 + (this._lslvr != null ? ", l1solver " + this._lslvr : "")));
                    }
                    if (GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        converged = this.updateNegativeBinomialDispersion(iterCnt, GLM.this._state.beta(), previousLLH, weights, response) && converged;
                        Log.info("GLM negative binomial dispersion estimation: iteration = " + iterCnt + "; theta = " + ((GLMModel.GLMParameters)GLM.this._parms)._theta);
                    } else if (GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && !((GLMModel.GLMParameters)GLM.this._parms)._fix_tweedie_variance_power) {
                        if (!((GLMModel.GLMParameters)GLM.this._parms)._fix_dispersion_parameter) {
                            converged = this.updateTweediePandPhi(iterCnt, GLM.this._state.expandBeta(betaCnd), weights, response) && converged;
                            Log.info("GLM Tweedie p and phi estimation: iteration = " + iterCnt + "; p = " + ((GLMModel.GLMParameters)GLM.this._parms)._tweedie_variance_power + "; phi = " + ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_estimated);
                        } else {
                            converged = this.updateTweedieVariancePower(iterCnt, GLM.this._state.expandBeta(betaCnd), weights, response) && converged;
                            Log.info("GLM Tweedie variance power estimation: iteration = " + iterCnt + "; p = " + ((GLMModel.GLMParameters)GLM.this._parms)._tweedie_variance_power);
                        }
                    }
                    sameLLH = Math.abs(previousLLH - gram.likelihood) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon ? ++sameLLH : 0;
                    converged = converged || sameLLH > 10;
                    previousLLH = gram.likelihood;
                }
            }
            catch (Gram.NonSPDMatrixException e) {
                Log.warn(GLM.this.LogMsg("Got Non SPD matrix, stopped."));
                GLM.this.warn("Regression with MLE training", "Got Non SPD matrix, stopped.");
            }
        }

        private boolean updateTweedieVariancePower(int iterCnt, double[] betaCnd, Vec weights, Vec response) {
            double newtonThreshold = 0.1;
            double phi = ((GLMModel.GLMParameters)GLM.this._parms)._init_dispersion_parameter;
            double originalP = ((GLMModel.GLMParameters)GLM.this._parms)._tweedie_variance_power;
            double bestLLH = Double.NEGATIVE_INFINITY;
            double bestP = 1.5;
            double p = originalP;
            int newtonFailures = 0;
            boolean converged = false;
            Scope.enter();
            DispersionTask.GenPrediction gPred = (DispersionTask.GenPrediction)new DispersionTask.GenPrediction(betaCnd, GLM.this._model, GLM.this._dinfo).doAll(1, (byte)3, GLM.this._dinfo._adaptedFrame);
            Vec mu = Scope.track(gPred.outputFrame(Key.make(), new String[]{"prediction"}, null)).vec(0);
            double lowerBound = 1.0;
            double upperBound = response.min() <= 0.0 ? 2.0 : Double.POSITIVE_INFINITY;
            if (iterCnt > 1) {
                boolean forceInversion = originalP > 1.95 && originalP < 2.1;
                TweedieEstimator lo = new TweedieEstimator(Math.max(lowerBound, p - 0.01), phi, forceInversion).compute(mu, response, weights);
                TweedieEstimator mid = new TweedieEstimator(p, phi, forceInversion).compute(mu, response, weights);
                TweedieEstimator hi = new TweedieEstimator(Math.min(upperBound, p + 0.01), phi, forceInversion).compute(mu, response, weights);
                if (mid._loglikelihood > lo._loglikelihood && !Double.isNaN(lo._loglikelihood) && !Double.isNaN(mid._loglikelihood)) {
                    lowerBound = lo._p;
                }
                if (mid._loglikelihood > hi._loglikelihood && !Double.isNaN(mid._loglikelihood) && !Double.isNaN(hi._loglikelihood)) {
                    upperBound = hi._p;
                }
                if (bestLLH < lo._loglikelihood && lo._loglikelihood != 0.0 && !forceInversion) {
                    bestLLH = lo._loglikelihood;
                    bestP = lo._p;
                }
                if (bestLLH < mid._loglikelihood && mid._loglikelihood != 0.0 && !forceInversion) {
                    bestLLH = mid._loglikelihood;
                    bestP = mid._p;
                }
                if (bestLLH < hi._loglikelihood && hi._loglikelihood != 0.0 && !forceInversion) {
                    bestLLH = hi._loglikelihood;
                    bestP = hi._p;
                }
            }
            if (upperBound == Double.POSITIVE_INFINITY) {
                TweedieEstimator tvp2 = new TweedieEstimator(2.0, phi).compute(mu, response, weights);
                TweedieEstimator tvp3 = new TweedieEstimator(3.0, phi).compute(mu, response, weights);
                double llhI = tvp3._loglikelihood;
                double llhIm1 = tvp2._loglikelihood;
                double pI = 3.0;
                double pIm1 = 2.0;
                double pIm2 = lowerBound;
                if (bestLLH < llhI && llhI != 0.0) {
                    bestLLH = llhI;
                    bestP = pI;
                }
                if (bestLLH < llhIm1 && llhIm1 != 0.0) {
                    bestLLH = llhIm1;
                    bestP = pIm1;
                }
                while (llhIm1 < llhI) {
                    pIm2 = pIm1;
                    pIm1 = pI;
                    llhIm1 = llhI;
                    TweedieEstimator tvp = new TweedieEstimator(pI *= 2.0, phi).compute(mu, response, weights);
                    llhI = tvp._loglikelihood;
                    if (!(bestLLH < llhI) || llhI == 0.0) continue;
                    bestLLH = llhI;
                    bestP = pI;
                }
                lowerBound = pIm2;
                upperBound = pI;
            }
            double d = upperBound - lowerBound;
            p = (upperBound + lowerBound) / 2.0;
            for (int i = 0; i < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations_dispersion; ++i) {
                if (d < 0.1 && p >= lowerBound && p <= upperBound && newtonFailures < 3 && (!(p >= 1.95) || !(p <= 2.1)) && p < 2.0) {
                    TweedieEstimator tvp = new TweedieEstimator(p, phi, false, true, true, false).compute(mu, response, weights);
                    if (tvp._loglikelihood > bestLLH && tvp._loglikelihood != 0.0) {
                        bestLLH = tvp._loglikelihood;
                        bestP = p;
                    } else {
                        ++newtonFailures;
                    }
                    double delta = tvp._llhDp / tvp._llhDpDp;
                    p -= delta;
                    if (Math.abs(delta) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon) {
                        converged = true;
                        break;
                    }
                    if (!GLM.this._job.stop_requested()) continue;
                    break;
                }
                if (d < 0.1) {
                    ++newtonFailures;
                }
                boolean forceInversion = lowerBound > 1.95 && upperBound < 2.1;
                double lowerBoundProposal = upperBound - (d *= 0.618);
                double upperBoundProposal = lowerBound + d;
                TweedieEstimator lowerEst = new TweedieEstimator(lowerBoundProposal, phi, forceInversion).compute(mu, response, weights);
                TweedieEstimator upperEst = new TweedieEstimator(upperBoundProposal, phi, forceInversion).compute(mu, response, weights);
                if (forceInversion) {
                    bestLLH = Math.max(lowerEst._loglikelihood, upperEst._loglikelihood);
                }
                if (lowerEst._loglikelihood >= upperEst._loglikelihood) {
                    upperBound = upperBoundProposal;
                    if (lowerEst._loglikelihood >= bestLLH && lowerEst._loglikelihood != 0.0) {
                        bestLLH = lowerEst._loglikelihood;
                        bestP = lowerEst._p;
                    }
                } else {
                    lowerBound = lowerBoundProposal;
                    if (upperEst._loglikelihood >= bestLLH && upperEst._loglikelihood != 0.0) {
                        bestLLH = upperEst._loglikelihood;
                        bestP = upperEst._p;
                    }
                }
                p = (upperBound + lowerBound) / 2.0;
                if (Math.abs(upperBoundProposal - lowerBoundProposal) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon || GLM.this._job.stop_requested()) {
                    bestP = (upperBoundProposal + lowerBoundProposal) / 2.0;
                    converged = true;
                    break;
                }
                if (!Double.isFinite(upperEst._loglikelihood) && !Double.isFinite(lowerEst._loglikelihood) || upperEst._loglikelihood == 0.0 && lowerEst._loglikelihood == 0.0) break;
            }
            this.updateTweedieParms(bestP, phi);
            Scope.exit(new Key[0]);
            return Math.abs(originalP - bestP) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon && converged;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateTweediePandPhi(int iterCnt, double[] betaCnd, Vec weights, Vec response) {
            double originalP = ((GLMModel.GLMParameters)GLM.this._parms)._tweedie_variance_power;
            double originalPhi = ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_estimated;
            double contractRatio = 0.5;
            double pMin = 1.0000000001;
            double pZeroMax = 1.9999999999;
            double phiMin = 1.0E-10;
            double bestLLH = Double.NEGATIVE_INFINITY;
            double bestP = 1.5;
            double bestPhi = 1.0;
            boolean converged = false;
            Scope.enter();
            DispersionTask.GenPrediction gPred = (DispersionTask.GenPrediction)new DispersionTask.GenPrediction(betaCnd, GLM.this._model, GLM.this._dinfo).doAll(1, (byte)3, GLM.this._dinfo._adaptedFrame);
            Vec mu = Scope.track(gPred.outputFrame(Key.make(), new String[]{"prediction"}, null)).vec(0);
            try {
                TweedieEstimator teTmp;
                TweedieEstimator teLow;
                TweedieEstimator teMiddle;
                TweedieEstimator teHigh;
                if (iterCnt > 1) {
                    double maxPDiff;
                    double radius = 0.05 * ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_learning_rate;
                    double aP = originalP + Math.cos(0.41887902047863906 * (double)iterCnt) * radius;
                    double aPhi = originalPhi + Math.sin(0.41887902047863906 * (double)iterCnt) * radius;
                    double bP = originalP + Math.cos(0.41887902047863906 * (double)iterCnt + 2.0943951023931953) * radius;
                    double bPhi = originalPhi + Math.sin(0.41887902047863906 * (double)iterCnt + 2.0943951023931953) * radius;
                    double cP = originalP + Math.cos(0.41887902047863906 * (double)iterCnt + 4.1887902047863905) * radius;
                    double cPhi = originalPhi + Math.sin(0.41887902047863906 * (double)iterCnt + 4.1887902047863905) * radius;
                    double minPDiff = Math.min(aP - 1.0000000001, Math.min(bP - 1.0000000001, cP - 1.0000000001));
                    double minPhiDiff = Math.min(aPhi - 1.0E-10, Math.min(bPhi - 1.0E-10, cPhi - 1.0E-10));
                    if (minPDiff < 0.0) {
                        aP -= minPDiff;
                        bP -= minPDiff;
                        cP -= minPDiff;
                    }
                    if (minPhiDiff < 0.0) {
                        aPhi -= minPhiDiff;
                        bPhi -= minPhiDiff;
                        cPhi -= minPhiDiff;
                    }
                    if (response.min() <= 0.0 && (maxPDiff = Math.max(aP - 1.9999999999, Math.max(bP - 1.9999999999, cP - 1.9999999999))) > 0.0) {
                        aP -= maxPDiff;
                        bP -= maxPDiff;
                        cP -= maxPDiff;
                    }
                    teHigh = new TweedieEstimator(aP, aPhi).compute(mu, response, weights);
                    teMiddle = new TweedieEstimator(bP, bPhi).compute(mu, response, weights);
                    teLow = new TweedieEstimator(cP, cPhi).compute(mu, response, weights);
                } else {
                    teHigh = new TweedieEstimator(1.5, 1.0).compute(mu, response, weights);
                    teMiddle = new TweedieEstimator(response.min() > 0.0 ? 3.0 : 1.75, 0.5).compute(mu, response, weights);
                    teLow = new TweedieEstimator(response.min() > 0.0 ? 2.0 : 1.2, 2.0).compute(mu, response, weights);
                }
                if (teLow._loglikelihood > teHigh._loglikelihood) {
                    teTmp = teLow;
                    teLow = teHigh;
                    teHigh = teTmp;
                }
                if (teMiddle._loglikelihood > teHigh._loglikelihood) {
                    teTmp = teMiddle;
                    teMiddle = teHigh;
                    teHigh = teTmp;
                }
                if (teLow._loglikelihood > teMiddle._loglikelihood) {
                    teTmp = teLow;
                    teLow = teMiddle;
                    teMiddle = teTmp;
                }
                for (int i = 0; i < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations_dispersion; ++i) {
                    if (!Double.isFinite(teLow._loglikelihood) && !Double.isFinite(teHigh._loglikelihood)) {
                        Log.info("Nelder-Mead dispersion (phi) and variance power (p) estimation: beta iter: " + iterCnt + "; Nelder-Mead iter: " + i + "; estimated p: " + bestP + "; estimated phi: " + bestPhi + "; log(Likelihood): " + bestLLH + "; Not finite likelihoods for both high and low point - skipping p and phi estimation for this iteration.");
                        boolean bl = false;
                        return bl;
                    }
                    double centroidP = (teMiddle._p + teHigh._p) / 2.0;
                    double centroidPhi = (teMiddle._phi + teHigh._phi) / 2.0;
                    double diffP = centroidP - teLow._p;
                    double diffPhi = centroidPhi - teLow._phi;
                    double p = teLow._p + 2.0 * diffP;
                    double phi = teLow._phi + 2.0 * diffPhi;
                    p = Math.max(p, 1.0000000001);
                    if (response.min() <= 0.0) {
                        p = Math.min(p, 1.9999999999);
                    }
                    phi = Math.max(phi, 1.0E-10);
                    TweedieEstimator teReflected = new TweedieEstimator(p, phi).compute(mu, response, weights);
                    if (teReflected._loglikelihood > teMiddle._loglikelihood && teReflected._loglikelihood < teHigh._loglikelihood) {
                        teLow = teReflected;
                    } else if (teReflected._loglikelihood > teHigh._loglikelihood) {
                        p += diffP;
                        phi += diffPhi;
                        p = Math.max(p, 1.0000000001);
                        if (response.min() <= 0.0) {
                            p = Math.min(p, 1.9999999999);
                        }
                        phi = Math.max(phi, 1.0E-10);
                        TweedieEstimator teExtended = p == teReflected._p && phi == teReflected._phi ? teReflected : new TweedieEstimator(p, phi).compute(mu, response, weights);
                        teLow = teExtended._loglikelihood > teReflected._loglikelihood ? teExtended : teReflected;
                    } else {
                        if (teReflected._loglikelihood < teMiddle._loglikelihood) {
                            p = Math.max(teLow._p + 1.5 * diffP, 1.0000000001);
                            phi = Math.max(teLow._phi + 1.5 * diffPhi, 1.0E-10);
                            TweedieEstimator teContractedOut = new TweedieEstimator(p, phi).compute(mu, response, weights);
                            p = Math.max(teLow._p + 0.5 * diffP, 1.0000000001);
                            phi = Math.max(teLow._phi + 0.5 * diffPhi, 1.0E-10);
                            TweedieEstimator teContractedIn = new TweedieEstimator(p, phi).compute(mu, response, weights);
                            teTmp = teContractedOut._loglikelihood > teContractedIn._loglikelihood ? teContractedOut : teContractedIn;
                        } else {
                            teTmp = teMiddle;
                        }
                        if (teTmp._loglikelihood > teMiddle._loglikelihood) {
                            teLow = teTmp;
                        } else {
                            p = (teLow._p + teHigh._p) / 2.0;
                            phi = (teLow._phi + teHigh._phi) / 2.0;
                            teLow = new TweedieEstimator(p, phi).compute(mu, response, weights);
                            p = (teMiddle._p + teHigh._p) / 2.0;
                            phi = (teMiddle._phi + teHigh._phi) / 2.0;
                            teMiddle = new TweedieEstimator(p, phi).compute(mu, response, weights);
                        }
                    }
                    if (teLow._loglikelihood > teHigh._loglikelihood) {
                        teTmp = teLow;
                        teLow = teHigh;
                        teHigh = teTmp;
                    }
                    if (teMiddle._loglikelihood > teHigh._loglikelihood) {
                        teTmp = teMiddle;
                        teMiddle = teHigh;
                        teHigh = teTmp;
                    }
                    if (teLow._loglikelihood > teMiddle._loglikelihood) {
                        teTmp = teLow;
                        teLow = teMiddle;
                        teMiddle = teTmp;
                    }
                    if (bestLLH < teHigh._loglikelihood) {
                        bestLLH = teHigh._loglikelihood;
                        bestP = teHigh._p;
                        bestPhi = teHigh._phi;
                    }
                    double diffInParams = Math.max(Math.max(Math.abs(teHigh._p - teMiddle._p), Math.abs(teHigh._p - teLow._p)), Math.max(Math.max(Math.abs(teLow._p - teMiddle._p), Math.abs(teHigh._phi - teMiddle._phi)), Math.max(Math.abs(teHigh._phi - teLow._phi), Math.abs(teLow._phi - teMiddle._phi))));
                    double diffInLLH = Math.abs((teMiddle._loglikelihood - teLow._loglikelihood) / (teHigh._loglikelihood + ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon));
                    Log.info("Nelder-Mead dispersion (phi) and variance power (p) estimation: beta iter: " + iterCnt + "; Nelder-Mead iter: " + i + "; estimated p: " + bestP + "; estimated phi: " + bestPhi + "; log(Likelihood): " + bestLLH + "; diff in params: " + diffInParams + "; diff in LLH: " + diffInLLH + "; dispersion_epsilon: " + ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon);
                    boolean bl = converged = diffInParams < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon && diffInLLH < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon;
                    if (converged) break;
                }
                this.updateTweedieParms(bestP, bestPhi);
                boolean bl = Math.abs(originalP - bestP) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon && Math.abs(originalPhi - bestPhi) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon && converged;
                return bl;
            }
            finally {
                Scope.exit(new Key[0]);
            }
        }

        private void updateTweedieParms(double p, double dispersion) {
            if (!Double.isFinite(p)) {
                return;
            }
            ((GLMModel.GLMParameters)GLM.this._parms).updateTweedieParams(p, ((GLMModel.GLMParameters)GLM.this._parms)._tweedie_link_power, dispersion);
            ((GLMModel.GLMParameters)((GLM)GLM.this)._model._parms).updateTweedieParams(p, ((GLMModel.GLMParameters)((GLM)GLM.this)._model._parms)._tweedie_link_power, dispersion);
            if (((GLM)GLM.this)._state._glmw != null) {
                ((GLM)GLM.this)._state._glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            }
        }

        private void updateTheta(double theta) {
            if (((GLM)GLM.this)._state._glmw != null) {
                ((GLM)GLM.this)._state._glmw._theta = theta;
                ((GLM)GLM.this)._state._glmw._invTheta = 1.0 / theta;
            }
            ((GLMModel.GLMParameters)GLM.this._parms)._theta = theta;
            ((GLMModel.GLMParameters)GLM.this._parms)._invTheta = 1.0 / theta;
            ((GLMModel.GLMParameters)((GLM)GLM.this)._model._parms)._theta = theta;
            ((GLMModel.GLMParameters)((GLM)GLM.this)._model._parms)._invTheta = 1.0 / theta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateNegativeBinomialDispersion(int iterCnt, double[] betaCnd, double previousNLLH, Vec weights, Vec response) {
            boolean converged = false;
            try {
                double delta;
                double theta;
                Scope.enter();
                DispersionTask.GenPrediction gPred = (DispersionTask.GenPrediction)new DispersionTask.GenPrediction(betaCnd, GLM.this._model, GLM.this._dinfo).doAll(1, (byte)3, GLM.this._dinfo._adaptedFrame);
                Vec mu = Scope.track(gPred.outputFrame(Key.make(), new String[]{"prediction"}, null)).vec(0);
                if (iterCnt == 1) {
                    theta = DispersionUtils.estimateNegBinomialDispersionMomentMethod(GLM.this._model, betaCnd, GLM.this._dinfo, weights, response, mu);
                } else {
                    theta = ((GLMModel.GLMParameters)GLM.this._parms)._theta;
                    DispersionUtils.NegativeBinomialGradientAndHessian nbGrad = (DispersionUtils.NegativeBinomialGradientAndHessian)new DispersionUtils.NegativeBinomialGradientAndHessian(theta).doAll(mu, response, weights);
                    delta = ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_learning_rate * nbGrad._grad / nbGrad._hess;
                    double bestLLH = Math.max(-previousNLLH, nbGrad._llh);
                    double bestTheta = theta;
                    delta = Double.isFinite(delta) ? delta : 1.0;
                    double lowerBound = theta + 10.0 * delta < 0.0 ? 0.999999999999999 * theta / delta : -10.0;
                    double upperBound = theta - 1000.0 * delta < 0.0 ? 0.999999999999999 * theta / delta : 1000.0;
                    double d = upperBound - lowerBound;
                    for (int i = 0; i < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations_dispersion; ++i) {
                        double lowerBoundProposal = upperBound - (d *= 0.618);
                        double upperBoundProposal = lowerBound + d;
                        DispersionUtils.NegativeBinomialGradientAndHessian nbLower = (DispersionUtils.NegativeBinomialGradientAndHessian)new DispersionUtils.NegativeBinomialGradientAndHessian(theta - lowerBoundProposal * delta).doAll(mu, response, weights);
                        DispersionUtils.NegativeBinomialGradientAndHessian nbUpper = (DispersionUtils.NegativeBinomialGradientAndHessian)new DispersionUtils.NegativeBinomialGradientAndHessian(theta - upperBoundProposal * delta).doAll(mu, response, weights);
                        if (nbLower._llh >= nbUpper._llh) {
                            upperBound = upperBoundProposal;
                            if (nbLower._llh > bestLLH) {
                                bestLLH = nbLower._llh;
                                bestTheta = nbLower._theta;
                            }
                        } else {
                            lowerBound = lowerBoundProposal;
                            if (nbUpper._llh > bestLLH) {
                                bestLLH = nbUpper._llh;
                                bestTheta = nbUpper._theta;
                            }
                        }
                        if (Math.abs((upperBoundProposal - lowerBoundProposal) * Math.max(1.0, delta / Math.max(((GLMModel.GLMParameters)GLM.this._parms)._theta, bestTheta))) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon || GLM.this._job.stop_requested()) break;
                    }
                    theta = bestTheta;
                    converged = nbGrad._llh + previousNLLH <= ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon || !Double.isFinite(theta);
                }
                delta = ((GLMModel.GLMParameters)GLM.this._parms)._theta - theta;
                converged = converged && Math.abs(delta) / Math.max(((GLMModel.GLMParameters)GLM.this._parms)._theta, theta) < ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_epsilon;
                this.updateTheta(theta);
                boolean bl = converged;
                return bl;
            }
            finally {
                Scope.exit(new Key[0]);
            }
        }

        private void fitLBFGS() {
            double[] beta = GLM.this._state.beta();
            double l1pen = GLM.this._state.l1pen();
            GLMGradientSolver gslvr = GLM.this._state.gslvr();
            GLMModel.GLMWeightsFun glmw = new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms);
            if (beta == null && (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family))) {
                beta = MemoryManager.malloc8d((GLM.this._state.activeData().fullN() + 1) * GLM.this._nclass);
                int P = GLM.this._state.activeData().fullN() + 1;
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    for (int i = 0; i < GLM.this._nclass; ++i) {
                        beta[i * P + P - 1] = glmw.link(((GLM)GLM.this)._state._ymu[i]);
                    }
                }
            }
            if (beta == null) {
                beta = MemoryManager.malloc8d(GLM.this._state.activeData().fullN() + 1);
                if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                    beta[beta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                }
            }
            L_BFGS lbfgs = new L_BFGS().setObjEps(((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon).setGradEps(((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon).setMaxIter(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations);
            assert (beta.length == ((GLM)GLM.this)._state.ginfo()._gradient.length);
            int P = GLM.this._dinfo.fullN();
            if (l1pen > 0.0 || GLM.this._state.activeBC().hasBounds()) {
                double[] nullBeta = MemoryManager.malloc8d(beta.length);
                if (GLM.this._dinfo._intercept) {
                    if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            nullBeta[(c + 1) * (P + 1) - 1] = glmw.link(((GLM)GLM.this)._state._ymu[c]);
                        }
                    } else {
                        nullBeta[nullBeta.length - 1] = glmw.link(((GLM)GLM.this)._state._ymu[0]);
                    }
                }
                GLMGradientInfo ginfo = gslvr.getGradient(nullBeta);
                double[] direction = ArrayUtils.mult((double[])ginfo._gradient.clone(), -1.0);
                double t = 1.0;
                if (l1pen > 0.0) {
                    OptimizationUtils.MoreThuente mt = new OptimizationUtils.MoreThuente(gslvr, nullBeta);
                    mt.evaluate(direction);
                    t = mt.step();
                }
                double[] rho = MemoryManager.malloc8d(beta.length);
                double r = GLM.this._state.activeBC().hasBounds() ? 1.0 : 0.1;
                BetaConstraint bc = GLM.this._state.activeBC();
                for (int i = 0; i < rho.length - 1; ++i) {
                    rho[i] = r * ADMM.L1Solver.estimateRho(nullBeta[i] + t * direction[i], l1pen, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[i], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[i]);
                }
                for (int ii = P; ii < rho.length; ii += P + 1) {
                    rho[ii] = r * ADMM.L1Solver.estimateRho(nullBeta[ii] + t * direction[ii], 0.0, bc._betaLB == null ? Double.NEGATIVE_INFINITY : bc._betaLB[ii], bc._betaUB == null ? Double.POSITIVE_INFINITY : bc._betaUB[ii]);
                }
                double[] objvals = new double[2];
                objvals[1] = Double.POSITIVE_INFINITY;
                double reltol = ADMM.L1Solver.DEFAULT_RELTOL;
                double abstol = ADMM.L1Solver.DEFAULT_ABSTOL;
                double ADMM_gradEps = 0.001;
                ProximalGradientSolver innerSolver = new ProximalGradientSolver(gslvr, beta, rho, ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon * 0.1, ((GLMModel.GLMParameters)GLM.this._parms)._gradient_epsilon, GLM.this._state.ginfo(), this);
                ADMM.L1Solver l1Solver = new ADMM.L1Solver(ADMM_gradEps, 250, reltol, abstol, ((GLM)GLM.this)._state._u);
                l1Solver._pm = this;
                l1Solver.solve(innerSolver, beta, l1pen, true, ((GLM)GLM.this)._state.activeBC()._betaLB, ((GLM)GLM.this)._state.activeBC()._betaUB);
                ((GLM)GLM.this)._state._u = l1Solver._u;
                GLM.this._state.updateState(beta, gslvr.getGradient(beta));
            } else {
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter == 0) {
                    this.updateProgress(false);
                }
                L_BFGS.Result r = lbfgs.solve(gslvr, beta, GLM.this._state.ginfo(), new L_BFGS.ProgressMonitor(){

                    @Override
                    public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
                        if (((GLM)GLM.this)._state._iter < 4 || (((GLM)GLM.this)._state._iter & 3) == 0) {
                            Log.info(GLM.this.LogMsg("LBFGS, gradient norm = " + ArrayUtils.linfnorm(ginfo._gradient, false)));
                        }
                        return GLMDriver.this.progress(beta, ginfo);
                    }
                });
                Log.info(GLM.this.LogMsg(r.toString()));
                GLM.this._state.updateState(r.coefs, (GLMGradientInfo)r.ginfo);
            }
        }

        private void fitCOD() {
            double[] beta = GLM.this._state.beta();
            int p = GLM.this._state.activeData().fullN() + 1;
            boolean skipFirstLevel = !((GLM)GLM.this)._state.activeData()._useAllFactorLevels;
            double[] betaold = (double[])beta.clone();
            double objold = GLM.this._state.objective();
            int iter2 = 0;
            Vec[] newVecs = ((GLM)GLM.this)._state.activeData()._adaptedFrame.anyVec().makeZeros(3);
            Vec w = newVecs[0];
            Vec z = newVecs[1];
            Vec zTilda = newVecs[2];
            long startTimeTotalNaive = System.currentTimeMillis();
            while (iter2++ < 30) {
                double percdiff;
                Frame fr = new Frame(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                fr.add("w", w);
                fr.add("z", z);
                fr.add("zTilda", zTilda);
                GLMTask.GLMGenerateWeightsTask gt = (GLMTask.GLMGenerateWeightsTask)new GLMTask.GLMGenerateWeightsTask(GLM.this._job._key, GLM.this._state.activeData(), (GLMModel.GLMParameters)GLM.this._parms, beta).doAll(fr);
                double objVal = GLM.this.objVal(gt._likelihood, gt._betaw, GLM.this._state.lambda());
                double[] denums = gt.denums;
                double wsum = gt.wsum;
                double wsumu = gt.wsumu;
                int iter1 = 0;
                while (iter1++ < 100) {
                    boolean intercept;
                    Frame fr2 = new Frame(new Vec[0]);
                    fr2.add("w", w);
                    fr2.add("z", z);
                    fr2.add("zTilda", zTilda);
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._cats; ++i) {
                        Frame fr3 = new Frame(fr2);
                        int level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i + 1] - ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        int prev_level_num = 0;
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i));
                        boolean bl = intercept = i == 0;
                        if (!intercept) {
                            prev_level_num = ((GLM)GLM.this)._state.activeData()._catOffsets[i] - ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1];
                            fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1));
                        }
                        int start_old = ((GLM)GLM.this)._state.activeData()._catOffsets[i];
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate = intercept ? (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 4, Arrays.copyOfRange(betaold, start_old, start_old + level_num), new double[]{beta[p - 1]}, ((GLM)GLM.this)._state.activeData()._catLvls[i], null, null, null, null, null, skipFirstLevel).doAll(fr3) : (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, 1, Arrays.copyOfRange(betaold, start_old, start_old + level_num), Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[i - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[i]), ((GLM)GLM.this)._state.activeData()._catLvls[i], ((GLM)GLM.this)._state.activeData()._catLvls[i - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        for (int j = 0; j < level_num; ++j) {
                            beta[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] = ADMM.shrinkage(stupdate._temp[j] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[((GLM)GLM.this)._state.activeData()._catOffsets[i] + j] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                        }
                    }
                    int cat_num = 2;
                    for (int i = 0; i < ((GLM)GLM.this)._state.activeData()._nums; ++i) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive stupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xj", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i + ((GLM)GLM.this)._state.activeData()._cats));
                        intercept = i == 0 && GLM.this._state.activeData().numStart() == 0;
                        double[] meannew = null;
                        double[] meanold = null;
                        double[] varnew = null;
                        double[] varold = null;
                        if (i > 0 || intercept) {
                            cat_num = 3;
                            if (!intercept) {
                                fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(i - 1 + ((GLM)GLM.this)._state.activeData()._cats));
                            }
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                                meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                                if (i != 0) {
                                    varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i - 1]};
                                    meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i - 1]};
                                }
                            }
                            stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart() + i]}, new double[]{beta[(GLM.this._state.activeData().numStart() + i - 1 + p) % p]}, null, null, varold, meanold, varnew, meannew, skipFirstLevel).doAll(fr3);
                            beta[i + ((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[i + GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                            continue;
                        }
                        if (i != 0 || intercept) continue;
                        int prev_level_num = GLM.this._state.activeData().numStart() - ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1];
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats - 1));
                        if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                            varold = new double[]{((GLM)GLM.this)._state.activeData()._normMul[i]};
                            meanold = new double[]{((GLM)GLM.this)._state.activeData()._normSub[i]};
                        }
                        stupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(intercept, false, cat_num, new double[]{betaold[GLM.this._state.activeData().numStart()]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], GLM.this._state.activeData().numStart()), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], varold, meanold, null, null, skipFirstLevel).doAll(fr3);
                        beta[((GLM)GLM.this)._state.activeData().numStart()] = ADMM.shrinkage(stupdate._temp[0] / wsumu, GLM.this._state.lambda() * ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]) / (denums[GLM.this._state.activeData().numStart()] / wsumu + GLM.this._state.lambda() * (1.0 - ((GLMModel.GLMParameters)GLM.this._parms)._alpha[0]));
                    }
                    if (((GLM)GLM.this)._state.activeData()._nums + ((GLM)GLM.this)._state.activeData()._cats > 0) {
                        GLMTask.GLMCoordinateDescentTaskSeqNaive iupdate;
                        Frame fr3 = new Frame(fr2);
                        fr3.add("xjm1", ((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1));
                        if (((GLM)GLM.this)._state.activeData()._adaptedFrame.vec(((GLM)GLM.this)._state.activeData()._cats + ((GLM)GLM.this)._state.activeData()._nums - 1).isCategorical()) {
                            cat_num = 2;
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, Arrays.copyOfRange(beta, ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats - 1], ((GLM)GLM.this)._state.activeData()._catOffsets[((GLM)GLM.this)._state.activeData()._cats]), null, ((GLM)GLM.this)._state.activeData()._catLvls[((GLM)GLM.this)._state.activeData()._cats - 1], null, null, null, null, skipFirstLevel).doAll(fr3);
                        } else {
                            cat_num = 3;
                            double[] meannew = null;
                            double[] varnew = null;
                            if (((GLM)GLM.this)._state.activeData()._normMul != null) {
                                varnew = new double[]{((GLM)GLM.this)._state.activeData()._normMul[((GLM)GLM.this)._state.activeData()._normMul.length - 1]};
                                meannew = new double[]{((GLM)GLM.this)._state.activeData()._normSub[((GLM)GLM.this)._state.activeData()._normSub.length - 1]};
                            }
                            iupdate = (GLMTask.GLMCoordinateDescentTaskSeqNaive)new GLMTask.GLMCoordinateDescentTaskSeqNaive(false, true, cat_num, new double[]{betaold[betaold.length - 1]}, new double[]{beta[beta.length - 2]}, null, null, null, null, varnew, meannew, skipFirstLevel).doAll(fr3);
                        }
                        if (((GLMModel.GLMParameters)GLM.this._parms)._intercept) {
                            beta[beta.length - 1] = iupdate._temp[0] / wsum;
                        }
                    }
                    double maxdiff = ArrayUtils.linfnorm(ArrayUtils.subtract(beta, betaold), false);
                    System.arraycopy(beta, 0, betaold, 0, beta.length);
                    if (!(maxdiff < ((GLMModel.GLMParameters)GLM.this._parms)._beta_epsilon)) continue;
                    break;
                }
                if ((percdiff = Math.abs((objold - objVal) / objold)) < ((GLMModel.GLMParameters)GLM.this._parms)._objective_epsilon & iter2 > 1) break;
                objold = objVal;
                Log.debug("iter1 = " + iter1);
            }
            Log.debug("iter2 = " + iter2);
            long endTimeTotalNaive = System.currentTimeMillis();
            long durationTotalNaive = (endTimeTotalNaive - startTimeTotalNaive) / 1000L;
            Log.info("Time to run Naive Coordinate Descent " + durationTotalNaive);
            ((GLM)GLM.this)._state._iter = iter2;
            for (Vec v : newVecs) {
                v.remove();
            }
            GLM.this._state.updateState(beta, objold);
        }

        private void fitModel() {
            GLMModel.GLMParameters.Solver solver = ((GLMModel.GLMParameters)GLM.this._parms)._solver == GLMModel.GLMParameters.Solver.AUTO ? GLM.this.defaultSolver() : ((GLMModel.GLMParameters)GLM.this._parms)._solver;
            switch (solver) {
                case COORDINATE_DESCENT: 
                case IRLSM: {
                    if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        this.fitIRLSM_multinomial(solver);
                        break;
                    }
                    if (GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        this.fitIRLSM_ordinal_default(solver);
                        break;
                    }
                    if (GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && GLMModel.GLMParameters.Link.identity.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._link) && ((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints == null) {
                        this.fitLSM(solver);
                        break;
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._dispersion_parameter_method.equals((Object)GLMModel.GLMParameters.DispersionMethod.ml)) {
                        this.fitIRLSMML(solver);
                        break;
                    }
                    if (((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints == null) {
                        this.fitIRLSM(solver);
                        break;
                    }
                    this.fitIRLSMCS();
                    break;
                }
                case GRADIENT_DESCENT_LH: 
                case GRADIENT_DESCENT_SQERR: {
                    if (!GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) break;
                    this.fitIRLSM_ordinal_default(solver);
                    break;
                }
                case L_BFGS: {
                    this.fitLBFGS();
                    break;
                }
                case COORDINATE_DESCENT_NAIVE: {
                    this.fitCOD();
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            if (GLMModel.GLMParameters.Family.tweedie.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && !((GLMModel.GLMParameters)GLM.this._parms)._fix_dispersion_parameter && !((GLMModel.GLMParameters)GLM.this._parms)._fix_tweedie_variance_power) {
                GLM.this._model.setDispersion(((GLMModel.GLMParameters)GLM.this._parms)._dispersion_estimated, true);
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._compute_p_values) {
                double se = ((GLMModel.GLMParameters)GLM.this._parms)._init_dispersion_parameter;
                boolean seEst = false;
                double[] beta = GLM.this._state.beta();
                Log.info("estimating dispersion parameter using method: " + (Object)((Object)((GLMModel.GLMParameters)GLM.this._parms)._dispersion_parameter_method));
                if (((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.binomial && ((GLMModel.GLMParameters)GLM.this._parms)._family != GLMModel.GLMParameters.Family.poisson && !((GLMModel.GLMParameters)GLM.this._parms)._fix_dispersion_parameter) {
                    seEst = true;
                    if (GLMModel.GLMParameters.DispersionMethod.pearson.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._dispersion_parameter_method) || GLMModel.GLMParameters.DispersionMethod.deviance.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._dispersion_parameter_method)) {
                        if (((GLMModel.GLMParameters)GLM.this._parms)._useDispersion1) {
                            se = 1.0;
                        } else {
                            GLMTask.ComputeSEorDEVIANCETsk ct = (GLMTask.ComputeSEorDEVIANCETsk)new GLMTask.ComputeSEorDEVIANCETsk(null, GLM.this._state.activeData(), GLM.this._job._key, beta, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._model).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                            se = ct._sumsqe / (double)(GLM.this._nobs - 1L - (long)GLM.this._state.activeData().fullN());
                        }
                    } else if (GLMModel.GLMParameters.DispersionMethod.ml.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._dispersion_parameter_method)) {
                        if (GLMModel.GLMParameters.Family.gamma.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                            GLMTask.ComputeGammaMLSETsk mlCT = (GLMTask.ComputeGammaMLSETsk)new GLMTask.ComputeGammaMLSETsk(null, GLM.this._state.activeData(), GLM.this._job._key, beta, (GLMModel.GLMParameters)GLM.this._parms).doAll(((GLM)GLM.this)._state.activeData()._adaptedFrame);
                            double oneOverSe = DispersionUtils.estimateGammaMLSE(mlCT, 1.0 / se, beta, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._state, GLM.this._job, GLM.this._model);
                            se = 1.0 / oneOverSe;
                        } else if (GLMModel.GLMParameters.Family.negativebinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                            se = ((GLMModel.GLMParameters)GLM.this._parms)._theta;
                        } else if (GLM.this._tweedieDispersionOnly && !Double.isFinite(se = DispersionUtils.estimateTweedieDispersionOnly((GLMModel.GLMParameters)GLM.this._parms, GLM.this._model, GLM.this._job, beta, GLM.this._state.activeData()))) {
                            Log.warn("Tweedie dispersion parameter estimation diverged. Estimation of both dispersion and variance power might have better luck.");
                        }
                    }
                    ((GLMModel.GLMParameters)GLM.this._parms)._dispersion_estimated = se;
                }
                double[] zvalues = MemoryManager.malloc8d(GLM.this._state.activeData().fullN() + 1);
                Gram.Cholesky chol = this._chol;
                DataInfo activeData = GLM.this._state.activeData();
                if (((GLMModel.GLMParameters)GLM.this._parms)._standardize) {
                    double[] beta_nostd = activeData.denormalizeBeta(beta);
                    DataInfo.TransformType transform = activeData._predictor_transform;
                    activeData.setPredictorTransform(DataInfo.TransformType.NONE);
                    this._gramInfluence = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._job._key, activeData, new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms), beta_nostd).doAll(activeData._adaptedFrame);
                    activeData.setPredictorTransform(transform);
                    beta = beta_nostd;
                } else {
                    this._gramInfluence = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(GLM.this._job._key, activeData, new GLMModel.GLMWeightsFun((GLMModel.GLMParameters)GLM.this._parms), beta).doAll(activeData._adaptedFrame);
                }
                Gram g = this._gramInfluence._gram;
                g.mul(((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                chol = g.cholesky(null);
                double[][] inv = chol.getInv();
                if (((GLMModel.GLMParameters)GLM.this._parms)._influence != null) {
                    this._cholInvInfluence = new double[inv.length][inv.length];
                    ArrayUtils.copy2DArray(inv, this._cholInvInfluence);
                    ArrayUtils.mult(this._cholInvInfluence, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                    g.mul(1.0 / ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg);
                }
                ArrayUtils.mult(inv, ((GLMModel.GLMParameters)GLM.this._parms)._obj_reg * se);
                this._vcov = inv;
                for (int i = 0; i < zvalues.length; ++i) {
                    zvalues[i] = beta[i] / Math.sqrt(inv[i][i]);
                }
                GLM.this._model.setZValues(GLM.expandVec(zvalues, ((GLM)GLM.this)._state.activeData()._activeCols, GLM.this._dinfo.fullN() + 1, Double.NaN), se, seEst);
                GLM.this._state.setZValues(GLM.expandVec(zvalues, ((GLM)GLM.this)._state.activeData()._activeCols, GLM.this._dinfo.fullN() + 1, Double.NaN), seEst);
            }
        }

        private long timeSinceLastScoring() {
            return System.currentTimeMillis() - this._lastScore;
        }

        private void scoreAndUpdateModel() {
            Log.info(GLM.this.LogMsg("Scoring after " + this.timeSinceLastScoring() + "ms"));
            long t1 = System.currentTimeMillis();
            Frame train = (Frame)DKV.getGet(((GLMModel.GLMParameters)GLM.this._parms)._train);
            GLM.this._model.score(((GLMModel.GLMParameters)GLM.this._parms).train(), null, CFuncRef.from(((GLMModel.GLMParameters)GLM.this._parms)._custom_metric_func)).delete();
            this.scorePostProcessing(train, t1);
        }

        private void scorePostProcessing(Frame train, long t1) {
            ModelMetrics mtrain = ModelMetrics.getFromDKV(GLM.this._model, train);
            long t2 = System.currentTimeMillis();
            if (mtrain != null) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_metrics = mtrain;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._training_time_ms = t2 - ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._start_time;
                ScoreKeeper trainScore = new ScoreKeeper(Double.NaN);
                trainScore.fillFrom(mtrain);
                Log.info(GLM.this.LogMsg(mtrain.toString()));
            } else {
                Log.info(GLM.this.LogMsg("ModelMetrics mtrain is null"));
            }
            Log.info(GLM.this.LogMsg("Training metrics computed in " + (t2 - t1) + "ms"));
            if (GLM.this._valid != null) {
                Frame valid = (Frame)DKV.getGet(((GLMModel.GLMParameters)GLM.this._parms)._valid);
                GLM.this._model.score(((GLMModel.GLMParameters)GLM.this._parms).valid(), null, CFuncRef.from(((GLMModel.GLMParameters)GLM.this._parms)._custom_metric_func)).delete();
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics = ModelMetrics.getFromDKV(GLM.this._model, valid);
                ScoreKeeper validScore = new ScoreKeeper(Double.NaN);
                validScore.fillFrom(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics);
            }
            GLM.this._model.addScoringInfo((GLMModel.GLMParameters)GLM.this._parms, GLM.this.nclasses(), t2, ((GLM)GLM.this)._state._iter);
            if (((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history) {
                int xval_iter_index;
                double xval_deviance = Double.NaN;
                double xval_se = Double.NaN;
                if (GLM.this._xval_deviances_generate_SH != null && (xval_iter_index = ArrayUtils.find(GLM.this._xval_iters_generate_SH, ((GLM)GLM.this)._state._iter)) > -1) {
                    xval_deviance = GLM.this._xval_deviances_generate_SH[xval_iter_index];
                    xval_se = GLM.this._xval_sd_generate_SH[xval_iter_index];
                }
                if (mtrain != null && GLM.this._valid != null) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                        double trainDev = GLM.this._state.deviance() / (double)mtrain._nobs;
                        double validDev = ((GLMMetrics)((Object)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics)).residual_deviance() / (double)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics._nobs;
                        GLM.this._lambdaSearchScoringHistory.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros(GLM.this._state.beta()), GLM.this._state.lambda(), trainDev, validDev, xval_deviance, xval_se, GLM.this._state.alpha());
                    } else {
                        GLM.this._scoringHistory.addIterationScore(mtrain != null, GLM.this._valid != null, ((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective(), GLM.this._state.deviance(), ((GLMMetrics)((Object)((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics)).residual_deviance(), mtrain._nobs, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._validation_metrics._nobs, GLM.this._state.lambda(), GLM.this._state.alpha());
                    }
                } else if (mtrain != null) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                        GLM.this._lambdaSearchScoringHistory.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros(GLM.this._state.beta()), GLM.this._state.lambda(), GLM.this._state.deviance() / (double)mtrain._nobs, Double.NaN, xval_deviance, xval_se, GLM.this._state.alpha());
                    } else {
                        GLM.this._scoringHistory.addIterationScore(mtrain != null, GLM.this._valid != null, ((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective(), GLM.this._state.deviance(), Double.NaN, mtrain._nobs, 1L, GLM.this._state.lambda(), GLM.this._state.alpha());
                    }
                }
                GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = ((GLMModel.GLMParameters)GLM.this._parms)._lambda_search ? GLM.this._lambdaSearchScoringHistory.to2dTable() : GLM.this._scoringHistory.to2dTable((GLMModel.GLMParameters)GLM.this._parms, GLM.this._xval_deviances_generate_SH, GLM.this._xval_sd_generate_SH);
            GLM.this._model.update(GLM.this._job._key);
            GLM.this._model.generateSummary(((GLMModel.GLMParameters)GLM.this._parms)._train, ((GLM)GLM.this)._state._iter);
            this._lastScore = System.currentTimeMillis();
            long scoringTime = System.currentTimeMillis() - t1;
            this._scoringInterval = Math.max(this._scoringInterval, 20L * scoringTime);
        }

        private void coldStart(double[] devHistoryTrain, double[] devHistoryTest) {
            GLM.this._state.setBeta(GLM.this._betaStart);
            GLM.this._state.setIter(0);
            GLM.this._state.setLambdaSimple(0.0);
            ((GLM)GLM.this)._state._currGram = null;
            GLM.this._state.setBetaDiff(GLM.this._betaDiffStart);
            GLM.this._state.setGradientErr(0.0);
            GLM.this._state.setGinfo(GLM.this._ginfoStart);
            GLM.this._state.setLikelihood(((GLM)GLM.this)._ginfoStart._likelihood);
            GLM.this._state.setAllIn(false);
            GLM.this._state.setGslvrNull();
            GLM.this._state.setActiveDataMultinomialNull();
            GLM.this._state.setActiveDataNull();
            int histLen = devHistoryTrain.length;
            for (int ind = 0; ind < histLen; ++ind) {
                devHistoryTrain[ind] = 0.0;
                devHistoryTest[ind] = 0.0;
            }
        }

        private void addGLMVec(Vec[] vecs, boolean deleteFirst, DataInfo dinfo) {
            String[] vecNames = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? new String[]{"__glm_ExpC", "__glm_ExpNPC"} : new String[]{"__glm_sumExp", "__glm_maxRow"};
            if (deleteFirst) {
                dinfo._adaptedFrame.remove(vecNames);
                dinfo._responses -= vecNames.length;
            }
            dinfo.addResponse(vecNames, vecs);
        }

        protected GLMModel.Submodel computeSubmodel(int i, double lambda, double nullDevTrain, double nullDevValid) {
            GLMModel.Submodel sm;
            boolean continueFromPreviousSubmodel;
            boolean bl = continueFromPreviousSubmodel = ((GLMModel.GLMParameters)GLM.this._parms).hasCheckpoint() && (((GLMModel.GLMParameters)GLM.this._parms)._alpha.length > 1 || ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length > 1) && GLM.this._checkPointFirstIter && !GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family);
            if (lambda >= GLM.this._lmax && GLM.this._state.l1pen() > 0.0) {
                if (continueFromPreviousSubmodel) {
                    sm = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels[i];
                } else {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.alpha(), GLM.this.getNullBeta(), ((GLM)GLM.this)._state._iter, nullDevTrain, nullDevValid, GLM.this._betaInfo.totalBetaLength(), null, false);
                    GLM.this._model.addSubmodel(i, sm);
                }
            } else {
                double xvalDevSE;
                if (continueFromPreviousSubmodel) {
                    sm = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels[i];
                } else {
                    sm = new GLMModel.Submodel(lambda, GLM.this._state.alpha(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, -1.0, -1.0, GLM.this._betaInfo.totalBetaLength(), GLM.this._state.zValues(), GLM.this._state.dispersionEstimated());
                    GLM.this._model.addSubmodel(i, sm);
                }
                if (GLM.this._insideCVCheck && ((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history && !GLMModel.GLMParameters.Solver.L_BFGS.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._solver) && (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family))) {
                    boolean nullVecsFound;
                    boolean bl2 = nullVecsFound = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && DKV.get(GLM.this._dinfo._adaptedFrame.vec((String)"__glm_ExpC")._key) == null || GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && DKV.get(GLM.this._dinfo._adaptedFrame.vec((String)"__glm_sumExp")._key) == null;
                    if (nullVecsFound) {
                        DataInfo[] dataInfos = ((GLM)GLM.this)._state._activeDataMultinomial;
                        if (dataInfos != null) {
                            for (int cInd = 0; cInd < GLM.this._nclass; ++cInd) {
                                Vec[] vecs = this.genGLMVectors(dataInfos[cInd], GLM.this._state.beta());
                                this.addGLMVec(vecs, true, dataInfos[cInd]);
                            }
                        }
                        Vec[] vecs = this.genGLMVectors(GLM.this._dinfo, GLM.this._state.beta());
                        this.addGLMVec(vecs, true, GLM.this._dinfo);
                    }
                }
                if (!GLM.this._checkPointFirstIter) {
                    GLM.this._state.setLambda(lambda);
                }
                GLM.this.checkMemoryFootPrint(GLM.this._state.activeData());
                do {
                    if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                        for (int c = 0; c < GLM.this._nclass; ++c) {
                            Log.info(GLM.this.LogMsg("Class " + c + " got " + GLM.this._state.activeDataMultinomial(c).fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total"));
                        }
                    } else {
                        Log.info(GLM.this.LogMsg("Got " + GLM.this._state.activeData().fullN() + " active columns out of " + ((GLM)GLM.this)._state._dinfo.fullN() + " total"));
                    }
                    this.fitModel();
                } while (!GLM.this._state.checkKKTs());
                Log.info(GLM.this.LogMsg("solution has " + ArrayUtils.countNonzeros(GLM.this._state.beta()) + " nonzeros"));
                double trainDev = GLM.this._state.deviance() / (double)GLM.this._nobs;
                double validDev = Double.NaN;
                if (GLM.this._validDinfo != null) {
                    validDev = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta()), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta())).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                }
                Log.info(GLM.this.LogMsg("train deviance = " + trainDev + ", valid deviance = " + validDev));
                double xvalDev = GLM.this._xval_deviances == null || GLM.this._xval_deviances.length <= i ? -1.0 : GLM.this._xval_deviances[i];
                double d = xvalDevSE = GLM.this._xval_sd == null || GLM.this._xval_deviances.length <= i ? -1.0 : GLM.this._xval_sd[i];
                if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    GLM.this._lambdaSearchScoringHistory.addLambdaScore(((GLM)GLM.this)._state._iter, ArrayUtils.countNonzeros(GLM.this._state.beta()), GLM.this._state.lambda(), trainDev, validDev, xvalDev, xvalDevSE, GLM.this._state.alpha());
                }
                sm = new GLMModel.Submodel(GLM.this._state.lambda(), GLM.this._state.alpha(), GLM.this._state.beta(), ((GLM)GLM.this)._state._iter, trainDev, validDev, GLM.this._betaInfo.totalBetaLength(), GLM.this._state.zValues(), GLM.this._state.dispersionEstimated());
                GLM.this._model.updateSubmodel(i, sm);
            }
            return sm;
        }

        @Override
        public void computeImpl() {
            ArrayList<Key> keep;
            try {
                this.doCompute();
                keep = new ArrayList<Key>();
            }
            catch (Throwable throwable) {
                ArrayList<Key> keep2 = new ArrayList<Key>();
                if (!(GLM.this._doInit && GLM.this._cvRuns || GLM.this._betaConstraints == null)) {
                    DKV.remove(((GLM)GLM.this)._betaConstraints._key);
                    GLM.this._betaConstraints.delete();
                }
                if (!(GLM.this._doInit && GLM.this._cvRuns || ((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints == null)) {
                    GamUtils.keepFrameKeys(keep2, ((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints);
                }
                if (GLM.this._model != null) {
                    if (((GLMModel.GLMParameters)GLM.this._parms)._influence != null) {
                        GamUtils.keepFrameKeys(keep2, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._regression_influence_diagnostics);
                        if (((GLMModel.GLMParameters)GLM.this._parms)._keepBetaDiffVar) {
                            GamUtils.keepFrameKeys(keep2, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._betadiff_var);
                        }
                        Scope.untrack((Key[])keep2.toArray(new Key[keep2.size()]));
                    }
                    GLM.this._model.unlock(GLM.this._job);
                }
                throw throwable;
            }
            if (!(GLM.this._doInit && GLM.this._cvRuns || GLM.this._betaConstraints == null)) {
                DKV.remove(((GLM)GLM.this)._betaConstraints._key);
                GLM.this._betaConstraints.delete();
            }
            if (!(GLM.this._doInit && GLM.this._cvRuns || ((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints == null)) {
                GamUtils.keepFrameKeys(keep, ((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints);
            }
            if (GLM.this._model != null) {
                if (((GLMModel.GLMParameters)GLM.this._parms)._influence != null) {
                    GamUtils.keepFrameKeys(keep, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._regression_influence_diagnostics);
                    if (((GLMModel.GLMParameters)GLM.this._parms)._keepBetaDiffVar) {
                        GamUtils.keepFrameKeys(keep, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._betadiff_var);
                    }
                    Scope.untrack((Key[])keep.toArray(new Key[keep.size()]));
                }
                GLM.this._model.unlock(GLM.this._job);
            }
        }

        private Vec[] genGLMVectors(DataInfo dinfo, double[] nb) {
            double maxRow = ArrayUtils.maxValue(nb);
            double sumExp = 0.0;
            if (((GLMModel.GLMParameters)GLM.this._parms)._family == GLMModel.GLMParameters.Family.multinomial) {
                int P = dinfo.fullN();
                int N = dinfo.fullN() + 1;
                for (int i = 1; i < GLM.this._nclass; ++i) {
                    sumExp += Math.exp(nb[i * N + P] - maxRow);
                }
            }
            Vec[] vecs = dinfo._adaptedFrame.anyVec().makeDoubles(2, new double[]{sumExp, maxRow});
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._is_cv_model) {
                Scope.untrack((Key[])new Key[]{vecs[0]._key, vecs[1]._key});
                GLM.this.removeLater(new Key[]{vecs[0]._key, vecs[1]._key});
            }
            return vecs;
        }

        private void doCompute() {
            double nullDevTrain = Double.NaN;
            double nullDevValid = Double.NaN;
            if (GLM.this._doInit) {
                GLM.this.init(true);
            }
            if (GLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(GLM.this);
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._start_time = System.currentTimeMillis();
            if (((GLMModel.GLMParameters)GLM.this._parms)._expose_constraints && ((GLMModel.GLMParameters)GLM.this._parms)._linear_constraints != null) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._equalityConstraintsBeta = ((GLM)GLM.this)._state._equalityConstraintsBeta;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._lessThanEqualToConstraintsBeta = ((GLM)GLM.this)._state._lessThanEqualToConstraintsBeta;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._equalityConstraintsLinear = ((GLM)GLM.this)._state._equalityConstraintsLinear;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._lessThanEqualToConstraintsLinear = ((GLM)GLM.this)._state._lessThanEqualToConstraintsLinear;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._constraintCoefficientNames = ((GLM)GLM.this)._state._csGLMState._constraintNames;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._initConstraintMatrix = ((GLM)GLM.this)._state._csGLMState._initCSMatrix;
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._max_iterations == 0) {
                return;
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                if (GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family)) {
                    nullDevTrain = ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                } else {
                    double d = nullDevTrain = GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, ((GLM)GLM.this)._state._dinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._state._dinfo._adaptedFrame)).avgDev();
                }
                if (GLM.this._validDinfo != null) {
                    nullDevValid = GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskOrdinal)new GLMTask.GLMResDevTaskOrdinal(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMTask.GLMResDevTaskMultinomial)new GLMTask.GLMResDevTaskMultinomial(GLM.this._job._key, GLM.this._validDinfo, GLM.this.getNullBeta(), GLM.this._nclass).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev() : ((GLMTask.GLMResDevTask)new GLMTask.GLMResDevTask(GLM.this._job._key, GLM.this._validDinfo, (GLMModel.GLMParameters)GLM.this._parms, GLM.this.getNullBeta()).doAll(((GLM)GLM.this)._validDinfo._adaptedFrame)).avgDev());
                }
                this._workPerIteration = 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._nlambdas;
            } else {
                this._workPerIteration = 1L + 1000000L / (long)((GLMModel.GLMParameters)GLM.this._parms)._max_iterations;
            }
            if (!GLMModel.GLMParameters.Solver.L_BFGS.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._solver) && (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family))) {
                Vec[] vecs = this.genGLMVectors(GLM.this._dinfo, GLM.this.getNullBeta());
                this.addGLMVec(vecs, false, GLM.this._dinfo);
            }
            GLM.this._ginfoStart = GLMUtils.copyGInfo(GLM.this._state.ginfo());
            GLM.this._betaDiffStart = GLM.this._state.getBetaDiff();
            double oldDevTrain = nullDevTrain;
            double oldDevTest = nullDevValid;
            double[] devHistoryTrain = new double[5];
            double[] devHistoryTest = new double[5];
            if (((GLMModel.GLMParameters)GLM.this._parms).hasCheckpoint()) {
                GLM.this._state.copyCheckModel2State(GLM.this._model, GLM.this._gamColIndices);
                if (((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length == 1) {
                    ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels = null;
                }
            }
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                this.updateProgress(false);
            }
            int alphaStart = 0;
            int lambdaStart = 0;
            int submodelCount = 0;
            if (((GLMModel.GLMParameters)GLM.this._parms).hasCheckpoint() && ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels != null) {
                submodelCount = GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length - 1;
                alphaStart = submodelCount / ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length;
                lambdaStart = submodelCount % ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length;
            }
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._lambda_array_size = ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length;
            block0: for (int alphaInd = alphaStart; alphaInd < ((GLMModel.GLMParameters)GLM.this._parms)._alpha.length; ++alphaInd) {
                GLM.this._state.setAlpha(((GLMModel.GLMParameters)GLM.this._parms)._alpha[alphaInd]);
                if (alphaInd > 0 && !GLM.this._checkPointFirstIter) {
                    this.coldStart(devHistoryTrain, devHistoryTest);
                }
                for (int i = lambdaStart; !(i >= ((GLMModel.GLMParameters)GLM.this._parms)._lambda.length || GLM.this._job.stop_requested() || GLM.this.timeout() && ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length > 0 || ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations != -1 && ((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations); ++i) {
                    if ((((GLMModel.GLMParameters)GLM.this._parms)._cold_start || !((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLMModel.GLMParameters)GLM.this._parms)._cold_start) && i > 0 && !GLM.this._checkPointFirstIter) {
                        this.coldStart(devHistoryTrain, devHistoryTest);
                    }
                    GLMModel.Submodel sm = this.computeSubmodel(submodelCount, ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i], nullDevTrain, nullDevValid);
                    if (GLM.this._checkPointFirstIter) {
                        GLM.this._checkPointFirstIter = false;
                    }
                    double trainDev = sm.devianceTrain;
                    double testDev = sm.devianceValid;
                    devHistoryTest[submodelCount % devHistoryTest.length] = (oldDevTest - testDev) / oldDevTest;
                    oldDevTest = testDev;
                    devHistoryTrain[submodelCount % devHistoryTrain.length] = (oldDevTrain - trainDev) / oldDevTrain;
                    oldDevTrain = trainDev;
                    if (((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] < GLM.this._lmax && Double.isNaN(GLM.this._lambdaCVEstimate) && ((GLMModel.GLMParameters)GLM.this._parms)._early_stopping && ((GLM)GLM.this)._state._iter >= devHistoryTrain.length) {
                        double s = ArrayUtils.maxValue(devHistoryTrain);
                        if (s < 1.0E-4) {
                            Log.info(GLM.this.LogMsg("converged at lambda[" + i + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] + "alpha[" + alphaInd + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._alpha[alphaInd] + ", improvement on train = " + s));
                            continue block0;
                        }
                        if (GLM.this._validDinfo != null && ((GLMModel.GLMParameters)GLM.this._parms)._nfolds <= 1 && (s = ArrayUtils.maxValue(devHistoryTest)) < 0.0) {
                            Log.info(GLM.this.LogMsg("converged at lambda[" + i + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._lambda[i] + "alpha[" + alphaInd + "] = " + ((GLMModel.GLMParameters)GLM.this._parms)._alpha[alphaInd] + ", improvement on test = " + s));
                            continue block0;
                        }
                    }
                    if ((((GLMModel.GLMParameters)GLM.this._parms)._lambda_search || ((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history) && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval || ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval > 0 && ((GLM)GLM.this)._state._iter % ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval == 0)) {
                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx = submodelCount;
                        ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodelIdx(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx, (GLMModel.GLMParameters)GLM.this._parms);
                        this.scoreAndUpdateModel();
                    }
                    GLM.this._job.update(this._workPerIteration, "iter=" + ((GLM)GLM.this)._state._iter + " lmb=" + lambdaFormatter.format(GLM.this._state.lambda()) + " alpha=" + lambdaFormatter.format(GLM.this._state.alpha()) + "deviance trn/tst= " + devFormatter.format(trainDev) + "/" + devFormatter.format(testDev) + " P=" + ArrayUtils.countNonzeros(GLM.this._state.beta()));
                    ++submodelCount;
                }
            }
            if (GLM.this._betaConstraintsOn && this.betaConstraintsCheckEnabled() && (!GLM.this._linearConstraintsOn || ((GLMModel.GLMParameters)GLM.this._parms)._separate_linear_beta)) {
                this.checkCoeffsBounds();
            }
            if (GLM.this.stop_requested() || GLM.this._earlyStop) {
                if (GLM.this.timeout()) {
                    Log.info("Stopping GLM training because of timeout");
                } else if (GLM.this._earlyStop) {
                    Log.info("Stopping GLM training due to hitting early stopping criteria.");
                } else {
                    throw new Job.JobCancelledException();
                }
            }
            if (((GLM)GLM.this)._state._iter >= ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.warn("Reached maximum number of iterations " + ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations + "!");
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._nfolds > 1 && !Double.isNaN(GLM.this._lambdaCVEstimate) && GLM.this._bestCVSubmodel < ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels.length) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx = GLM.this._bestCVSubmodel;
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).setSubmodelIdx(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._best_submodel_idx, (GLMModel.GLMParameters)((GLM)GLM.this)._model._parms);
            } else {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).pickBestModel((GLMModel.GLMParameters)((GLM)GLM.this)._model._parms);
            }
            if (this._vcov != null) {
                GLM.this._model.setVcov(this._vcov);
                GLM.this._model.update(GLM.this._job._key);
            }
            ((GLM)GLM.this)._model._finalScoring = true;
            this.scoreAndUpdateModel();
            ((GLM)GLM.this)._model._finalScoring = false;
            if (GLMModel.GLMParameters.Influence.dfbetas.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._influence)) {
                this.genRID();
            }
            if (((GLMModel.GLMParameters)GLM.this._parms)._generate_variable_inflation_factors) {
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._vif_predictor_names = GLM.this._model.buildVariableInflationFactors(GLM.this._train, GLM.this._dinfo);
            }
            TwoDimTable scoring_history_early_stop = ScoringInfo.createScoringHistoryTable(GLM.this._model.getScoringInfo(), null != ((GLMModel.GLMParameters)GLM.this._parms)._valid, false, ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).getModelCategory(), false, ((GLMModel.GLMParameters)GLM.this._parms).hasCustomMetricFunc());
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history = GLMUtils.combineScoringHistory(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._scoring_history, scoring_history_early_stop);
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._varimp = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).calculateVarimp();
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._variable_importances = ModelMetrics.calcVarImp(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._varimp);
            if (GLM.this._linearConstraintsOn) {
                ConstrainedGLMUtils.printConstraintSummary(GLM.this._model, GLM.this._state, GLM.this._dinfo.coefNames());
            }
            GLM.this._model.update(GLM.this._job._key);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations) {
                GLM.this._job.update(this._workPerIteration * (long)(((GLMModel.GLMParameters)GLM.this._parms)._max_iterations - ((GLM)GLM.this)._state._iter));
            }
            if (GLM.this._iceptAdjust != 0.0) {
                assert (((GLMModel.GLMParameters)GLM.this._parms)._intercept);
                double[] b = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._global_beta;
                int n = b.length - 1;
                b[n] = b[n] + GLM.this._iceptAdjust;
                for (GLMModel.Submodel sm : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._submodels) {
                    int n2 = sm.beta.length - 1;
                    sm.beta[n2] = sm.beta[n2] + GLM.this._iceptAdjust;
                }
                GLM.this._model.update(GLM.this._job._key);
            }
        }

        public void genRID() {
            double[] beta = GLM.this._dinfo.denormalizeBeta(GLM.this._state.beta());
            double[] stdErr = (double[])((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).stdErr().clone();
            String[] names = GLMUtils.genDfbetasNames(GLM.this._model);
            DataInfo.TransformType transform = DataInfo.TransformType.NONE;
            if (((GLMModel.GLMParameters)GLM.this._parms)._standardize) {
                transform = GLM.this._dinfo._predictor_transform;
                GLM.this._dinfo.setPredictorTransform(DataInfo.TransformType.NONE);
            }
            Frame RIDFrame = GLMModel.GLMParameters.Family.gaussian.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) ? this.genRIDGaussian(((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).beta(), this._cholInvInfluence, names) : this.genRIDBinomial(beta, this._cholInvInfluence, stdErr, names);
            Scope.track(RIDFrame);
            Frame combinedFrame = GLMUtils.buildRIDFrame((GLMModel.GLMParameters)GLM.this._parms, GLM.this._train.deepCopy(Key.make().toString()), RIDFrame);
            ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._regression_influence_diagnostics = combinedFrame.getKey();
            DKV.put(combinedFrame);
            if (((GLMModel.GLMParameters)GLM.this._parms)._standardize) {
                GLM.this._dinfo.setPredictorTransform(transform);
            }
        }

        private Frame genRIDBinomial(double[] beta, double[][] inv, double[] stdErr, String[] names) {
            RegressionInfluenceDiagnosticsTasks.RegressionInfluenceDiagBinomial ridBinomial = new RegressionInfluenceDiagnosticsTasks.RegressionInfluenceDiagBinomial(GLM.this._job, beta, inv, (GLMModel.GLMParameters)GLM.this._parms, GLM.this._dinfo, stdErr);
            ridBinomial.doAll(names.length, (byte)3, GLM.this._dinfo._adaptedFrame);
            return ridBinomial.outputFrame(Key.make(), names, new String[names.length][]);
        }

        private Frame genRIDGaussian(double[] beta, double[][] inv, String[] names) {
            double[] betaReduced;
            double[] stdErr = ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).stdErr();
            double[][] gramMat = this._gramInfluence._gram.getXX();
            RegressionInfluenceDiagnosticsTasks.ComputeNewBetaVarEstimatedGaussian betaMinusOne = new RegressionInfluenceDiagnosticsTasks.ComputeNewBetaVarEstimatedGaussian(inv, this._gramInfluence._xy, GLM.this._job, GLM.this._dinfo, gramMat, this._gramInfluence.sumOfRowWeights, this._gramInfluence._yy, stdErr);
            betaMinusOne.doAll(names.length + 1, (byte)3, GLM.this._dinfo._adaptedFrame);
            String[] namesVar = new String[names.length + 1];
            System.arraycopy(names, 0, namesVar, 0, names.length);
            namesVar[names.length] = "varEstimate";
            Frame newBetasVarEst = betaMinusOne.outputFrame(Key.make(), namesVar, new String[namesVar.length][]);
            if (((GLMModel.GLMParameters)GLM.this._parms)._keepBetaDiffVar) {
                DKV.put(newBetasVarEst);
                ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output)._betadiff_var = newBetasVarEst._key;
            } else {
                Scope.track(newBetasVarEst);
            }
            if (names.length == beta.length) {
                betaReduced = beta;
            } else {
                betaReduced = new double[names.length];
                GLMUtils.removeRedCols(beta, betaReduced, stdErr);
            }
            RegressionInfluenceDiagnosticsTasks.RegressionInfluenceDiagGaussian genRid = new RegressionInfluenceDiagnosticsTasks.RegressionInfluenceDiagGaussian(inv, betaReduced, GLM.this._job);
            genRid.doAll(names.length, (byte)3, newBetasVarEst);
            return genRid.outputFrame(Key.make(), names, new String[names.length][]);
        }

        private boolean betaConstraintsCheckEnabled() {
            return Boolean.parseBoolean(GLM.this.getSysProperty("glm.beta.constraints.checkEnabled", "true")) && !GLMModel.GLMParameters.Family.multinomial.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family) && !GLMModel.GLMParameters.Family.ordinal.equals((Object)((GLMModel.GLMParameters)GLM.this._parms)._family);
        }

        private void checkCoeffsBounds() {
            double[] coeffs;
            BetaConstraint bc = ((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints != null ? new BetaConstraint(((GLMModel.GLMParameters)GLM.this._parms)._beta_constraints.get()) : new BetaConstraint();
            double[] dArray = coeffs = ((GLMModel.GLMParameters)GLM.this._parms)._standardize ? ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).getNormBeta() : ((GLMModel.GLMOutput)((GLM)GLM.this)._model._output).beta();
            if (coeffs == null) {
                return;
            }
            if (bc._betaLB == null && bc._betaUB == null) {
                return;
            }
            int coeffsLen = bc._betaLB != null ? bc._betaLB.length : bc._betaUB.length;
            StringBuffer errorMessage = new StringBuffer();
            boolean lowerBoundNull = bc._betaLB == null;
            boolean upperBoundNull = bc._betaUB == null;
            for (int index = 0; index < coeffsLen; ++index) {
                if (coeffs[index] == 0.0) continue;
                if (lowerBoundNull && !Double.isInfinite(bc._betaUB[index]) && coeffs[index] > bc._betaUB[index]) {
                    errorMessage.append("GLM model coefficient " + coeffs[index] + " exceeds beta constraint upper bounds: upper: " + bc._betaUB[index] + "\n");
                    continue;
                }
                if (upperBoundNull && !Double.isInfinite(bc._betaLB[index]) && coeffs[index] < bc._betaLB[index]) {
                    errorMessage.append("GLM model coefficient " + coeffs[index] + " falls below beta constraint lower bounds: upper: " + bc._betaLB[index] + "\n");
                    continue;
                }
                if (lowerBoundNull || upperBoundNull || !(coeffs[index] < bc._betaLB[index]) || !(coeffs[index] > bc._betaUB[index])) continue;
                errorMessage.append("GLM model coefficient " + coeffs[index] + " exceeds beta constraint bounds.  Lower: " + bc._betaLB[index] + ", upper: " + bc._betaUB[index] + "\n");
            }
            if (errorMessage.length() > 0) {
                throw new H2OFailException("\n" + errorMessage.toString());
            }
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this.doCleanup();
            super.onCompletion(caller);
        }

        @Override
        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this.doCleanup();
            return super.onExceptionalCompletion(t, caller);
        }

        @Override
        public boolean progress(double[] beta, OptimizationUtils.GradientInfo ginfo) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            if (ginfo instanceof ProximalGradientInfo) {
                ginfo = ((ProximalGradientInfo)ginfo)._origGinfo;
                GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
                GLM.this._state.updateState(beta, gginfo);
                if (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                    this.updateProgress(false);
                }
                return !GLM.this.stop_requested() && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
            }
            GLMGradientInfo gginfo = (GLMGradientInfo)ginfo;
            if (gginfo._gradient == null) {
                GLM.this._state.updateState(beta, gginfo._likelihood);
            } else {
                GLM.this._state.updateState(beta, gginfo);
            }
            if (!(((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && !((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history || GLM.this._insideCVCheck)) {
                this.updateProgress(true);
            }
            boolean bl = converged = !GLM.this._earlyStopEnabled && GLM.this._state.converged();
            if (converged) {
                Log.info(GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg));
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
        }

        public boolean progress(double[] beta, double likelihood) {
            boolean converged;
            ++((GLM)GLM.this)._state._iter;
            GLM.this._state.updateState(beta, likelihood);
            if (!(((GLMModel.GLMParameters)GLM.this._parms)._lambda_search && !((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history || GLM.this._insideCVCheck)) {
                this.updateProgress(true);
            }
            boolean bl = converged = !GLM.this._earlyStopEnabled && GLM.this._state.converged();
            if (converged) {
                Log.info(GLM.this.LogMsg(((GLM)GLM.this)._state.convergenceMsg));
            }
            return !GLM.this.stop_requested() && !converged && ((GLM)GLM.this)._state._iter < ((GLMModel.GLMParameters)GLM.this._parms)._max_iterations && !GLM.this._earlyStop;
        }

        protected void updateProgress(boolean canScore) {
            assert (!((GLMModel.GLMParameters)GLM.this._parms)._lambda_search || ((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history);
            if (!((GLMModel.GLMParameters)GLM.this._parms)._generate_scoring_history && !((GLMModel.GLMParameters)GLM.this._parms)._lambda_search) {
                GLM.this._scoringHistory.addIterationScore(((GLM)GLM.this)._state._iter, GLM.this._state.likelihood(), GLM.this._state.objective());
                GLM.this._job.update(this._workPerIteration, GLM.this._state.toString());
            }
            if (canScore && (((GLMModel.GLMParameters)GLM.this._parms)._score_each_iteration || this.timeSinceLastScoring() > this._scoringInterval || ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval > 0 && ((GLM)GLM.this)._state._iter % ((GLMModel.GLMParameters)GLM.this._parms)._score_iteration_interval == 0)) {
                GLM.this._model.update(GLM.this._state.expandBeta(GLM.this._state.beta()), -1.0, -1.0, ((GLM)GLM.this)._state._iter);
                this.scoreAndUpdateModel();
                GLM.this._earlyStop = GLM.this._earlyStopEnabled && GLM.this.updateEarlyStop();
            }
        }
    }

    static class LambdaSearchScoringHistory {
        ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _lambdas = new ArrayList();
        private ArrayList<Integer> _lambdaIters = new ArrayList();
        private ArrayList<Integer> _lambdaPredictors = new ArrayList();
        private ArrayList<Double> _lambdaDevTrain = new ArrayList();
        private ArrayList<Double> _lambdaDevTest;
        private ArrayList<Double> _lambdaDevXval;
        private ArrayList<Double> _lambdaDevXvalSE;
        private ArrayList<Double> _alphas = new ArrayList();

        public LambdaSearchScoringHistory(boolean hasTest, boolean hasXval) {
            if (hasTest) {
                this._lambdaDevTest = new ArrayList();
            }
            if (hasXval) {
                this._lambdaDevXval = new ArrayList();
                this._lambdaDevXvalSE = new ArrayList();
            }
        }

        public ArrayList<Integer> getScoringIters() {
            return this._lambdaIters;
        }

        public ArrayList<Long> getScoringTimes() {
            return this._scoringTimes;
        }

        public ArrayList<Double> getLambdas() {
            return this._lambdas;
        }

        public ArrayList<Double> getAlphas() {
            return this._alphas;
        }

        public ArrayList<Double> getDevTrain() {
            return this._lambdaDevTrain;
        }

        public ArrayList<Double> getDevTest() {
            return this._lambdaDevTest;
        }

        public ArrayList<Integer> getPredictors() {
            return this._lambdaPredictors;
        }

        public synchronized void addLambdaScore(int iter2, int predictors, double lambda, double devRatioTrain, double devRatioTest, double devRatioXval, double devRatoioXvalSE, double alpha) {
            if (this._lambdaIters.size() > 0 && iter2 <= this._lambdaIters.get(this._lambdaIters.size() - 1)) {
                return;
            }
            this._scoringTimes.add(System.currentTimeMillis());
            this._lambdaIters.add(iter2);
            this._alphas.add(alpha);
            this._lambdas.add(lambda);
            this._lambdaPredictors.add(predictors);
            this._lambdaDevTrain.add(devRatioTrain);
            if (this._lambdaDevTest != null) {
                this._lambdaDevTest.add(devRatioTest);
            }
            if (this._lambdaDevXval != null) {
                this._lambdaDevXval.add(devRatioXval);
            }
            if (this._lambdaDevXvalSE != null) {
                this._lambdaDevXvalSE.add(devRatoioXvalSE);
            }
        }

        public synchronized TwoDimTable to2dTable() {
            String[] cnames = new String[]{"timestamp", "duration", "iteration", "lambda", "predictors", "deviance_train"};
            if (this._lambdaDevTest != null) {
                cnames = ArrayUtils.append(cnames, "deviance_test");
            }
            if (this._lambdaDevXval != null) {
                cnames = ArrayUtils.append(cnames, new String[]{"deviance_xval", "deviance_se"});
            }
            String[] ctypes = new String[]{"string", "string", "int", "string", "int", "double"};
            if (this._lambdaDevTest != null) {
                ctypes = ArrayUtils.append(ctypes, "double");
            }
            if (this._lambdaDevXval != null) {
                ctypes = ArrayUtils.append(ctypes, new String[]{"double", "double"});
            }
            String[] cformats = new String[]{"%s", "%s", "%d", "%s", "%d", "%.3f"};
            if (this._lambdaDevTest != null) {
                cformats = ArrayUtils.append(cformats, "%.3f");
            }
            if (this._lambdaDevXval != null) {
                cformats = ArrayUtils.append(cformats, new String[]{"%.3f", "%.3f"});
            }
            cnames = ArrayUtils.append(cnames, "alpha");
            ctypes = ArrayUtils.append(ctypes, "double");
            cformats = ArrayUtils.append(cformats, "%.6f");
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._lambdaIters.size()], cnames, ctypes, cformats, "");
            for (int i = 0; i < this._lambdaIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, DATE_TIME_FORMATTER.print(this._scoringTimes.get(i)));
                res.set(i, col++, PrettyPrint.msecs(this._scoringTimes.get(i) - this._scoringTimes.get(0), true));
                res.set(i, col++, this._lambdaIters.get(i));
                res.set(i, col++, lambdaFormatter.format(this._lambdas.get(i)));
                res.set(i, col++, this._lambdaPredictors.get(i));
                res.set(i, col++, this._lambdaDevTrain.get(i));
                if (this._lambdaDevTest != null) {
                    res.set(i, col++, this._lambdaDevTest.get(i));
                }
                if (this._lambdaDevXval != null && this._lambdaDevXval.size() > i) {
                    res.set(i, col++, this._lambdaDevXval.get(i));
                    res.set(i, col++, this._lambdaDevXvalSE.get(i));
                }
                res.set(i, col++, this._alphas.get(i));
            }
            return res;
        }

        void restoreFromCheckpoint(TwoDimTable sHist, int[] colIndices) {
            int numRows = sHist.getRowDim();
            for (int rowInd = 0; rowInd < numRows; ++rowInd) {
                this._scoringTimes.add(DATE_TIME_FORMATTER.parseMillis((String)sHist.get(rowInd, colIndices[1])));
                this._lambdaIters.add((int)((Integer)sHist.get(rowInd, colIndices[0])));
                this._lambdas.add(Double.valueOf((String)sHist.get(rowInd, colIndices[2])));
                this._alphas.add((Double)sHist.get(rowInd, colIndices[6]));
                this._lambdaPredictors.add((int)((Integer)sHist.get(rowInd, colIndices[3])));
                this._lambdaDevTrain.add((double)((Double)sHist.get(rowInd, colIndices[4])));
                if (colIndices[5] <= -1) continue;
                this._lambdaDevTest.add((double)((Double)sHist.get(rowInd, colIndices[5])));
            }
        }
    }

    static class ScoringHistory {
        private ArrayList<Integer> _scoringIters = new ArrayList();
        private ArrayList<Long> _scoringTimes = new ArrayList();
        private ArrayList<Double> _likelihoods = new ArrayList();
        private ArrayList<Double> _objectives = new ArrayList();
        private ArrayList<Double> _lambdas;
        private ArrayList<Double> _lambdaDevTrain;
        private ArrayList<Double> _lambdaDevTest;
        private ArrayList<Double> _alphas;

        public ArrayList<Integer> getScoringIters() {
            return this._scoringIters;
        }

        public ArrayList<Long> getScoringTimes() {
            return this._scoringTimes;
        }

        public ArrayList<Double> getLikelihoods() {
            return this._likelihoods;
        }

        public ArrayList<Double> getObjectives() {
            return this._objectives;
        }

        public ScoringHistory(boolean hasTest, boolean hasXval, boolean generate_scoring_historty) {
            if (hasTest) {
                this._lambdaDevTest = new ArrayList();
            }
            if (generate_scoring_historty) {
                this._lambdas = new ArrayList();
                this._lambdaDevTrain = new ArrayList();
                if (hasTest) {
                    this._lambdaDevTest = new ArrayList();
                }
                this._alphas = new ArrayList();
            }
        }

        public synchronized void addIterationScore(int iter2, double likelihood, double obj) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) >= iter2) {
                return;
            }
            this._scoringIters.add(iter2);
            this._scoringTimes.add(System.currentTimeMillis());
            this._likelihoods.add(likelihood);
            this._objectives.add(obj);
        }

        public synchronized void addIterationScore(boolean updateTrain, boolean updateValid, int iter2, double likelihood, double obj, double dev, double devValid, long nobs, long nobsValid, double lambda, double alpha) {
            if (this._scoringIters.size() > 0 && this._scoringIters.get(this._scoringIters.size() - 1) >= iter2) {
                return;
            }
            if (updateTrain) {
                this._scoringIters.add(iter2);
                this._scoringTimes.add(System.currentTimeMillis());
                this._likelihoods.add(likelihood);
                this._objectives.add(obj);
                this._lambdaDevTrain.add(dev / (double)nobs);
                this._lambdas.add(lambda);
                this._alphas.add(alpha);
            }
            if (updateValid) {
                this._lambdaDevTest.add(devValid / (double)nobsValid);
            }
        }

        public synchronized TwoDimTable to2dTable(GLMModel.GLMParameters parms, double[] xvalDev, double[] xvalSE) {
            String[] cnames = new String[]{"timestamp", "duration", "iterations", "negative_log_likelihood", "objective"};
            String[] ctypes = new String[]{"string", "string", "int", "double", "double"};
            String[] cformats = new String[]{"%s", "%s", "%d", "%.5f", "%.5f"};
            if (parms._generate_scoring_history) {
                cnames = ArrayUtils.append(cnames, new String[]{"alpha", "lambda", "deviance_train"});
                ctypes = ArrayUtils.append(ctypes, new String[]{"double", "double", "double"});
                cformats = ArrayUtils.append(cformats, new String[]{"%.5f", "%.5f", "%.5f"});
                if (this._lambdaDevTest != null) {
                    cnames = ArrayUtils.append(cnames, new String[]{"deviance_test"});
                    ctypes = ArrayUtils.append(ctypes, new String[]{"double"});
                    cformats = ArrayUtils.append(cformats, new String[]{"%.5f"});
                }
                if (xvalDev != null && xvalDev.length > 0) {
                    cnames = ArrayUtils.append(cnames, new String[]{"deviance_xval", "deviance_se"});
                    ctypes = ArrayUtils.append(ctypes, new String[]{"double", "double"});
                    cformats = ArrayUtils.append(cformats, new String[]{"%.5f", "%.5f"});
                }
            }
            TwoDimTable res = new TwoDimTable("Scoring History", "", new String[this._scoringIters.size()], cnames, ctypes, cformats, "");
            for (int i = 0; i < this._scoringIters.size(); ++i) {
                int col = 0;
                res.set(i, col++, DATE_TIME_FORMATTER.print(this._scoringTimes.get(i)));
                res.set(i, col++, PrettyPrint.msecs(this._scoringTimes.get(i) - this._scoringTimes.get(0), true));
                res.set(i, col++, this._scoringIters.get(i));
                res.set(i, col++, this._likelihoods.get(i));
                res.set(i, col++, this._objectives.get(i));
                if (!parms._generate_scoring_history) continue;
                res.set(i, col++, this._alphas.get(i));
                res.set(i, col++, this._lambdas.get(i));
                res.set(i, col++, this._lambdaDevTrain.get(i));
                if (this._lambdaDevTest != null) {
                    res.set(i, col++, this._lambdaDevTest.get(i));
                }
                if (xvalDev == null || i >= xvalDev.length) continue;
                res.set(i, col++, xvalDev[i]);
                res.set(i, col, xvalSE[i]);
            }
            return res;
        }

        void restoreFromCheckpoint(TwoDimTable sHist, int[] colIndices) {
            int numRows = sHist.getRowDim();
            for (int rowInd = 0; rowInd < numRows; ++rowInd) {
                this._scoringIters.add((Integer)sHist.get(rowInd, colIndices[0]));
                this._scoringTimes.add(DATE_TIME_FORMATTER.parseMillis((String)sHist.get(rowInd, colIndices[1])));
                this._likelihoods.add((Double)sHist.get(rowInd, colIndices[2]));
                this._objectives.add((Double)sHist.get(rowInd, colIndices[3]));
            }
        }
    }
}

