/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.glm.GLMModel;
import hex.glm.TweedieMLDispersionOnly;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.math3.special.Gamma;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.util.FrameUtils;
import water.util.Log;

public class DispersionTask {
    public static final int RESPIND = 0;
    public static final int MUIND = 1;
    public static final int WEIGHTIND = 2;

    public static class GenPrediction
    extends MRTask<GenPrediction> {
        final GLMModel _m;
        final DataInfo _dinfo;
        final boolean _sparse;
        private final double[] _beta;

        public GenPrediction(double[] beta, GLMModel m, DataInfo dinfo) {
            this._beta = beta;
            this._m = m;
            this._dinfo = dinfo;
            this._sparse = FrameUtils.sparseRatio(dinfo._adaptedFrame) < 0.5;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] preds) {
            int ncols;
            double[] ps = new double[((GLMModel.GLMOutput)this._m._output)._nclasses + 1];
            float[] res = new float[1];
            int nc = ((GLMModel.GLMOutput)this._m._output).nclasses();
            int n = ncols = nc == 1 ? 1 : nc + 1;
            if (this._sparse) {
                for (DataInfo.Row r : this._dinfo.extractSparseRows(chks)) {
                    this.processRow(r, res, ps, preds, ncols);
                }
            } else {
                DataInfo.Row r = this._dinfo.newDenseRow();
                for (int rid = 0; rid < chks[0]._len; ++rid) {
                    this._dinfo.extractDenseRow(chks, rid, r);
                    this.processRow(r, res, ps, preds, ncols);
                }
            }
        }

        private void processRow(DataInfo.Row r, float[] res, double[] ps, NewChunk[] preds, int ncols) {
            if (this._dinfo._responses != 0) {
                res[0] = (float)r.response[0];
            }
            if (r.predictors_bad) {
                Arrays.fill(ps, Double.NaN);
            } else if (r.weight == 0.0) {
                Arrays.fill(ps, 0.0);
            } else {
                ps[0] = ((GLMModel.GLMParameters)this._m._parms).linkInv(r.innerProduct(this._beta) + r.offset);
            }
            for (int c = 0; c < ncols; ++c) {
                preds[c].addNum(ps[c]);
            }
        }
    }

    public static class ComputeMaxSumSeriesTsk
    extends MRTask<ComputeMaxSumSeriesTsk> {
        double _variancePower;
        double _dispersionParameter;
        double _alpha;
        boolean _weightPresent;
        Frame _infoFrame;
        int _constColOffset;
        int _workColOffset;
        int _nWorkCols;
        double _oneOverPhiPower;
        double _oneMinusAlpha;
        double _oneOverPhiSquare;
        double _oneOverPhi3;
        double _logLL;
        double _dLogLL;
        double _d2LogLL;
        boolean _debugOn;
        double _oneOverDispersion;
        double _alphaMinus1TLogDispersion;
        double _alphaTimesPI;
        double _alphaMinus1OverPhi;
        double _alphaMinus1SquareOverPhiSquare;
        int _nWVs = 3;
        int _indexBound;
        double _logDispersionEpsilon;
        boolean[] _computationAccuracy;
        int _constantColumnNumber;
        long _nobsLL;
        long _nobsDLL;
        long _nobsD2LL;
        long _nobNegSum;
        final boolean _calAll;

        public ComputeMaxSumSeriesTsk(TweedieMLDispersionOnly tdispersion, GLMModel.GLMParameters parms, boolean calALL) {
            this._variancePower = tdispersion._variancePower;
            this._dispersionParameter = tdispersion._dispersionParameter;
            this._alpha = (2.0 - this._variancePower) / (1.0 - this._variancePower);
            this._weightPresent = tdispersion._weightPresent;
            this._infoFrame = tdispersion._infoFrame;
            this._nWorkCols = tdispersion._nWorkingCol;
            this._constantColumnNumber = tdispersion._constFrameNames.length;
            this._constColOffset = this._infoFrame.numCols() - this._nWorkCols - tdispersion._constNCol;
            this._workColOffset = this._infoFrame.numCols() - this._nWorkCols;
            this._oneMinusAlpha = 1.0 - this._alpha;
            this._oneOverPhiPower = 1.0 / Math.pow(this._dispersionParameter, this._oneMinusAlpha);
            this._oneOverPhiSquare = 1.0 / (this._dispersionParameter * this._dispersionParameter);
            this._oneOverPhi3 = this._oneOverPhiSquare / this._dispersionParameter;
            this._debugOn = parms._debugTDispersionOnly;
            this._oneOverDispersion = 1.0 / this._dispersionParameter;
            this._alphaMinus1TLogDispersion = (this._alpha - 1.0) * Math.log(this._dispersionParameter);
            this._alphaTimesPI = this._alpha * Math.PI;
            this._indexBound = parms._max_series_index;
            this._logDispersionEpsilon = Math.log(parms._tweedie_epsilon);
            this._computationAccuracy = new boolean[this._nWVs];
            this._alphaMinus1OverPhi = (this._alpha - 1.0) / this._dispersionParameter;
            this._alphaMinus1SquareOverPhiSquare = this._alphaMinus1OverPhi * this._alphaMinus1OverPhi;
            this._calAll = calALL;
        }

        public static void setInfoIndices(Map<InfoColNames, Integer> infoColName2Ind, int constOffset, boolean weightPresent) {
            int offset = weightPresent ? 3 : 2;
            InfoColNames[] infoC = InfoColNames.values();
            offset += constOffset;
            int infoColLen = infoC.length;
            for (int index = 0; index < infoColLen; ++index) {
                infoColName2Ind.put(infoC[index], index + offset);
            }
        }

        public static void setConstIndices(Map<ConstColNames, Integer> constColName2Ind, int offset) {
            ConstColNames[] constVal = ConstColNames.values();
            int constantColNum = constVal.length;
            for (int index = 0; index < constantColNum; ++index) {
                constColName2Ind.put(constVal[index], index + offset);
            }
        }

        @Override
        public void map(Chunk[] chks) {
            int chkLen = chks[0].len();
            int jKIndMax = 0;
            int jKL = 0;
            int jKU = 0;
            int djKL = 0;
            int djKU = 0;
            int d2jKL = 0;
            int d2jKU = 0;
            double wvMax = 0.0;
            double dwvMax = 0.0;
            double d2wvMax = 0.0;
            double logZ = 0.0;
            double sumWVj = 0.0;
            double sumDWVj = 0.0;
            double sumD2WVj = 0.0;
            double oneOverSumWVj = 0.0;
            this._logLL = 0.0;
            this._dLogLL = 0.0;
            this._d2LogLL = 0.0;
            this._nobsLL = 0L;
            this._nobsDLL = 0L;
            this._nobsD2LL = 0L;
            this._nobNegSum = 0L;
            double tempLL = 0.0;
            double tempDLL = 0.0;
            double tempD2LL = 0.0;
            HashMap<ConstColNames, Integer> constColName2Ind = new HashMap<ConstColNames, Integer>();
            HashMap<InfoColNames, Integer> infoColName2Ind = new HashMap<InfoColNames, Integer>();
            ComputeMaxSumSeriesTsk.setConstIndices(constColName2Ind, this._weightPresent ? 3 : 2);
            ComputeMaxSumSeriesTsk.setInfoIndices(infoColName2Ind, constColName2Ind.size(), this._weightPresent);
            for (int rInd = 0; rInd < chkLen; ++rInd) {
                double weight;
                double response = chks[0].atd(rInd);
                double d = weight = this._weightPresent ? chks[2].atd(rInd) : 1.0;
                if (response >= 0.0) {
                    if (response > 0.0) {
                        jKIndMax = this.findMaxTermIndex(chks, rInd, (Integer)constColName2Ind.get((Object)ConstColNames.JMaxConst));
                        logZ = this.calLogZ(chks, rInd, (Integer)constColName2Ind.get((Object)ConstColNames.zConst));
                        wvMax = this.calLogWVMax(chks, rInd, jKIndMax, logZ);
                        double logjKIndMax = Math.log(jKIndMax);
                        dwvMax = wvMax + logjKIndMax;
                        d2wvMax = dwvMax + logjKIndMax;
                        jKL = this.estimateLowerBound(jKIndMax, wvMax, logZ, new EvalLogWVEnv());
                        jKU = this.estimateUpperBound(jKIndMax, wvMax, logZ, 0, new EvalLogWVEnv());
                        if (this._calAll) {
                            djKL = this.estimateLowerBound(jKIndMax, dwvMax, logZ, new EvalLogDWVEnv());
                            djKU = this.estimateUpperBound(jKIndMax, dwvMax, logZ, 1, new EvalLogDWVEnv());
                            d2jKL = this.estimateLowerBound(jKIndMax, d2wvMax, logZ, new EvalLogD2WVEnv());
                            d2jKU = this.estimateUpperBound(jKIndMax, d2wvMax, logZ, 2, new EvalLogD2WVEnv());
                        }
                        if ((sumWVj = this.sumWV(jKL, jKU, wvMax, logZ, new EvalLogWVEnv())) <= 0.0) {
                            ++this._nobNegSum;
                        }
                    }
                    if (sumWVj > 0.0) {
                        tempLL = this.evalLogLikelihood(chks, rInd, sumWVj, constColName2Ind);
                        if (Double.isFinite(tempLL)) {
                            this._logLL += tempLL;
                            this._nobsLL = (long)((double)this._nobsLL + weight);
                        }
                        if (this._calAll) {
                            if (response > 0.0) {
                                oneOverSumWVj = 1.0 / sumWVj;
                                sumDWVj = this.sumWV(djKL, djKU, dwvMax, logZ, new EvalLogDWVEnv()) * this._alphaMinus1OverPhi;
                                sumD2WVj = this.sumWV(d2jKL, d2jKU, d2wvMax, logZ, new EvalLogD2WVEnv()) * this._alphaMinus1SquareOverPhiSquare - sumDWVj * this._oneOverDispersion;
                            }
                            if (Double.isFinite(tempDLL = this.evalDlldPhi(chks, rInd, sumDWVj, oneOverSumWVj, constColName2Ind))) {
                                this._dLogLL += tempDLL;
                                this._nobsDLL = (long)((double)this._nobsDLL + weight);
                            }
                            if (Double.isFinite(tempD2LL = this.evalD2lldPhi2(chks, rInd, sumDWVj, sumD2WVj, oneOverSumWVj, constColName2Ind))) {
                                this._d2LogLL += tempD2LL;
                                this._nobsD2LL = (long)((double)this._nobsD2LL + weight);
                            }
                        }
                    }
                }
                if (!this._debugOn) continue;
                this.setDebugValues(rInd, jKIndMax, logZ, wvMax, dwvMax, d2wvMax, jKL, jKU, djKL, djKU, d2jKL, d2jKU, sumWVj, sumDWVj, sumD2WVj, tempLL, tempDLL, tempD2LL, chks, infoColName2Ind, response);
            }
            if (this._debugOn && this._variancePower > 2.0) {
                Log.info("Chunk IDX " + chks[0].cidx() + " contains " + this._nobNegSum + " rows of data with series sum < 0.");
            }
        }

        public void setDebugValues(int rInd, int jkIndMax, double logZ, double wvMax, double dwvMax, double d2wvMax, int jKL, int jKU, int djKL, int djKU, int d2jKL, int d2jKU, double sumWV, double sumDWV, double sumD2WV, double ll, double dll, double d2ll, Chunk[] chks, Map<InfoColNames, Integer> infoColName2Ind, double response) {
            if (response == 0.0) {
                chks[infoColName2Ind.get((Object)InfoColNames.MaxValIndex)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGZ)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGWVMax)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGDWVMax)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGD2WVMax)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.JkL)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.JkU)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.DjkL)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.DjkU)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.D2jkL)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.D2jkU)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.SumWV)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.SumDWV)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.SumD2WV)].set(rInd, 0L);
                chks[infoColName2Ind.get((Object)InfoColNames.LL)].set(rInd, ll);
                chks[infoColName2Ind.get((Object)InfoColNames.DLL)].set(rInd, dll);
                chks[infoColName2Ind.get((Object)InfoColNames.D2LL)].set(rInd, d2ll);
            } else {
                chks[infoColName2Ind.get((Object)InfoColNames.MaxValIndex)].set(rInd, jkIndMax);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGZ)].set(rInd, logZ);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGWVMax)].set(rInd, wvMax);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGDWVMax)].set(rInd, dwvMax);
                chks[infoColName2Ind.get((Object)InfoColNames.LOGD2WVMax)].set(rInd, d2wvMax);
                chks[infoColName2Ind.get((Object)InfoColNames.JkL)].set(rInd, jKL);
                chks[infoColName2Ind.get((Object)InfoColNames.JkU)].set(rInd, jKU);
                chks[infoColName2Ind.get((Object)InfoColNames.DjkL)].set(rInd, djKL);
                chks[infoColName2Ind.get((Object)InfoColNames.DjkU)].set(rInd, djKU);
                chks[infoColName2Ind.get((Object)InfoColNames.D2jkL)].set(rInd, d2jKL);
                chks[infoColName2Ind.get((Object)InfoColNames.D2jkU)].set(rInd, d2jKU);
                chks[infoColName2Ind.get((Object)InfoColNames.SumWV)].set(rInd, sumWV);
                chks[infoColName2Ind.get((Object)InfoColNames.SumDWV)].set(rInd, sumDWV);
                chks[infoColName2Ind.get((Object)InfoColNames.SumD2WV)].set(rInd, sumD2WV);
                chks[infoColName2Ind.get((Object)InfoColNames.LL)].set(rInd, ll);
                chks[infoColName2Ind.get((Object)InfoColNames.DLL)].set(rInd, dll);
                chks[infoColName2Ind.get((Object)InfoColNames.D2LL)].set(rInd, d2ll);
            }
        }

        @Override
        public void reduce(ComputeMaxSumSeriesTsk other) {
            this._logLL += other._logLL;
            this._dLogLL += other._dLogLL;
            this._d2LogLL += other._d2LogLL;
            this._nobsLL += other._nobsLL;
            this._nobsDLL += other._nobsDLL;
            this._nobsD2LL += other._nobsD2LL;
            this._nobNegSum += other._nobNegSum;
        }

        @Override
        public void postGlobal() {
            if (this._variancePower > 2.0 && this._debugOn) {
                Log.info("number of data rows with negative sum " + this._nobNegSum);
            }
        }

        public int estimateLowerBound(int jOrkMax, double logWorVmax, double logZ, CalWVdWVd2WV cVal) {
            if (jOrkMax == 1) {
                return 1;
            }
            double logWV1 = cVal.calculate(1, this._alpha, logZ, logWorVmax, this._variancePower);
            if (logWV1 - logWorVmax >= this._logDispersionEpsilon) {
                return 1;
            }
            int indexLow = 1;
            int indexHigh = jOrkMax;
            int indexMid = (int)Math.round(0.5 * (double)(indexLow + indexHigh));
            while (indexLow < indexHigh && indexHigh != indexMid && indexLow != indexMid) {
                double logVal = cVal.calculate(indexMid, this._alpha, logZ, logWorVmax, this._variancePower);
                if (logVal - logWorVmax < this._logDispersionEpsilon) {
                    indexLow = indexMid;
                } else {
                    indexHigh = indexMid;
                }
                indexMid = (int)Math.round(0.5 * (double)(indexLow + indexHigh));
            }
            if (cVal.calculate(indexLow, this._alpha, logZ, logWorVmax, this._variancePower) - logWorVmax < this._logDispersionEpsilon) {
                return indexLow;
            }
            return indexMid;
        }

        public int estimateUpperBound(int jOrkMax, double logWorVmax, double logZ, int wvIndex, CalWVdWVd2WV cVal) {
            double logWj = cVal.calculate(this._indexBound, this._alpha, logZ, logWorVmax, this._variancePower);
            if (logWj - logWorVmax > this._logDispersionEpsilon) {
                this._computationAccuracy[wvIndex] = false;
                return this._indexBound;
            }
            int indexLow = jOrkMax;
            int indexHigh = this._indexBound;
            int indexMid = (int)Math.round(0.5 * (double)(indexLow + indexHigh));
            while (indexLow < indexHigh && indexHigh != indexMid && indexLow != indexMid) {
                logWj = cVal.calculate(indexMid, this._alpha, logZ, logWorVmax, this._variancePower);
                if (logWj - logWorVmax < this._logDispersionEpsilon) {
                    indexHigh = indexMid;
                } else {
                    indexLow = indexMid;
                }
                indexMid = (int)Math.round(0.5 * (double)(indexLow + indexHigh));
            }
            return indexMid;
        }

        double sumWV(int jkL, int jkU, double logWVMax, double logZ, CalWVdWVd2WV cCal) {
            if (this._variancePower < 2.0) {
                return Math.exp(Math.log(IntStream.rangeClosed(jkL, jkU).mapToDouble(x -> Math.exp(cCal.calculate(x, this._alpha, logZ, logWVMax, this._variancePower) - logWVMax)).sum()) + logWVMax);
            }
            double seriesSum = IntStream.rangeClosed(jkL, jkU).mapToDouble(x -> Math.exp(cCal.calculate(x, this._alpha, logZ, logWVMax, this._variancePower) - logWVMax) * Math.pow(-1.0, x) * Math.sin((double)(-x) * this._alphaTimesPI)).sum();
            if (seriesSum > 0.0) {
                return Math.exp(logWVMax + Math.log(seriesSum));
            }
            return Math.exp(logWVMax) * seriesSum;
        }

        public int findMaxTermIndex(Chunk[] chks, int rowInd, int colInd) {
            if (chks[0].atd(rowInd) != 0.0) {
                return (int)Math.max(1.0, Math.ceil(chks[colInd].atd(rowInd) * this._oneOverDispersion));
            }
            return 0;
        }

        public double calLogZ(Chunk[] chks, int rInd, int zConstCol) {
            if (chks[0].atd(rInd) != 0.0) {
                return Math.log(chks[zConstCol].atd(rInd)) + this._alphaMinus1TLogDispersion;
            }
            return 0.0;
        }

        public double calLogWVMax(Chunk[] chks, int rowInd, int indexMax, double logZ) {
            double resp = chks[0].atd(rowInd);
            if (this._variancePower < 2.0 && resp != 0.0) {
                return (double)indexMax * logZ - Gamma.logGamma(1 + indexMax) - Gamma.logGamma(-this._alpha * (double)indexMax);
            }
            if (resp != 0.0) {
                return (double)indexMax * logZ + Gamma.logGamma(1.0 + this._alpha * (double)indexMax) - Gamma.logGamma(1 + indexMax);
            }
            return 0.0;
        }

        public double evalDlldPhi(Chunk[] chks, int rowInd, double sumDWVj, double oneOverSumWVj, Map<ConstColNames, Integer> constColName2Ind) {
            double response = chks[0].atd(rowInd);
            if (response == 0.0) {
                return chks[constColName2Ind.get((Object)ConstColNames.FirstOrderDerivConst)].atd(rowInd) * this._oneOverPhiSquare;
            }
            if (Double.isFinite(response)) {
                return chks[constColName2Ind.get((Object)ConstColNames.FirstOrderDerivConst)].atd(rowInd) * this._oneOverPhiSquare + sumDWVj * oneOverSumWVj;
            }
            return 0.0;
        }

        public double evalD2lldPhi2(Chunk[] chks, int rowInd, double sumDWVj, double sumD2WVj, double oneOverSumWVj, Map<ConstColNames, Integer> constColName2Ind) {
            double response = chks[0].atd(rowInd);
            if (response == 0.0) {
                return chks[constColName2Ind.get((Object)ConstColNames.SecondOrderDerivConst)].atd(rowInd) * this._oneOverPhi3;
            }
            if (Double.isFinite(response)) {
                return chks[constColName2Ind.get((Object)ConstColNames.SecondOrderDerivConst)].atd(rowInd) * this._oneOverPhi3 + sumD2WVj * oneOverSumWVj - sumDWVj * sumDWVj * oneOverSumWVj * oneOverSumWVj;
            }
            return 0.0;
        }

        public double evalLogLikelihood(Chunk[] chks, int rowInd, double sumWV, Map<ConstColNames, Integer> constColName2Ind) {
            double response = chks[0].atd(rowInd);
            double logPart2 = this._oneOverDispersion * chks[constColName2Ind.get((Object)ConstColNames.LogPart2Const)].atd(rowInd);
            if (Double.isFinite(response)) {
                if (response == 0.0) {
                    return logPart2;
                }
                if (this._variancePower < 2.0) {
                    return Math.log(sumWV) + chks[constColName2Ind.get((Object)ConstColNames.LogOneOverY)].atd(rowInd) + logPart2;
                }
                return Math.log(sumWV) + chks[constColName2Ind.get((Object)ConstColNames.LogOneOverPiY)].atd(rowInd) + logPart2;
            }
            return 0.0;
        }

        public static class EvalLogD2WVEnv
        implements CalWVdWVd2WV {
            @Override
            public double calculate(int jOrk, double alpha, double logZ, double funcMax, double varianceP) {
                return new EvalLogWVEnv().calculate(jOrk, alpha, logZ, funcMax, varianceP) + 2.0 * Math.log(jOrk);
            }
        }

        public static class EvalLogDWVEnv
        implements CalWVdWVd2WV {
            @Override
            public double calculate(int jOrk, double alpha, double logZ, double funcMax, double varianceP) {
                return new EvalLogWVEnv().calculate(jOrk, alpha, logZ, funcMax, varianceP) + Math.log(jOrk);
            }
        }

        public static class EvalLogWVEnv
        implements CalWVdWVd2WV {
            @Override
            public double calculate(int jOrk, double alpha, double logZ, double funcMax, double varianceP) {
                if (varianceP < 2.0) {
                    return (double)jOrk * logZ - Gamma.logGamma(1 + jOrk) - Gamma.logGamma(-alpha * (double)jOrk);
                }
                return (double)jOrk * logZ + Gamma.logGamma(1.0 + alpha * (double)jOrk) - Gamma.logGamma(1 + jOrk);
            }
        }

        public static interface CalWVdWVd2WV {
            public double calculate(int var1, double var2, double var4, double var6, double var8);
        }
    }

    public static class ComputeTweedieConstTsk
    extends MRTask<ComputeTweedieConstTsk> {
        double _variancePower;
        double _alpha;
        boolean _weightPresent;
        double _twoMinusP;
        double _oneOver2MinusP;
        double _oneMinusP;
        double _oneOver1MinusP;
        double _oneOverPi;
        double _pMinusOne;
        double _oneMinusAlpha;

        public ComputeTweedieConstTsk(double vPower, Frame infoFrame) {
            this._variancePower = vPower;
            this._alpha = (2.0 - vPower) / (1.0 - vPower);
            this._weightPresent = infoFrame.numCols() > 2;
            this._twoMinusP = 2.0 - vPower;
            this._oneOver2MinusP = 1.0 / this._twoMinusP;
            this._oneMinusP = 1.0 - this._variancePower;
            this._oneOver1MinusP = 1.0 / this._oneMinusP;
            this._oneOverPi = 0.3183098861837907;
            this._pMinusOne = this._variancePower - 1.0;
            this._oneMinusAlpha = 1.0 - this._alpha;
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] constChks) {
            HashMap<ConstColNames, Integer> constColName2Ind = new HashMap<ConstColNames, Integer>();
            ComputeMaxSumSeriesTsk.setConstIndices(constColName2Ind, 0);
            int chkLen = chks[0].len();
            for (int rowInd = 0; rowInd < chkLen; ++rowInd) {
                this.calJMaxConst(chks, constChks, rowInd, (Integer)constColName2Ind.get((Object)ConstColNames.JMaxConst));
                this.calZConst(chks, constChks, rowInd, (Integer)constColName2Ind.get((Object)ConstColNames.zConst));
                this.calPart2Const(chks, constChks, rowInd, (Integer)constColName2Ind.get((Object)ConstColNames.LogPart2Const));
                this.calPart1LogConst(chks, constChks, rowInd, (Integer)constColName2Ind.get((Object)ConstColNames.LogOneOverY));
                this.calPart1LogPIConst(chks, constChks, rowInd, (Integer)constColName2Ind.get((Object)ConstColNames.LogOneOverPiY));
                this.calDerivConst(chks, constChks, rowInd, new int[]{(Integer)constColName2Ind.get((Object)ConstColNames.FirstOrderDerivConst), (Integer)constColName2Ind.get((Object)ConstColNames.SecondOrderDerivConst)});
            }
        }

        public void calZConst(Chunk[] chks, NewChunk[] constChks, int rowInd, int newChkColInd) {
            double response = chks[0].atd(rowInd);
            if (Double.isFinite(response)) {
                if (response > 0.0) {
                    double val;
                    double d = val = this._variancePower < 2.0 ? Math.pow(response, -this._alpha) * Math.pow(this._pMinusOne, this._alpha) * this._oneOver2MinusP : -Math.pow(response, -this._alpha) * Math.pow(this._pMinusOne, this._alpha) * this._oneOver2MinusP;
                    if (this._weightPresent) {
                        val *= Math.pow(chks[2].atd(rowInd), this._oneMinusAlpha);
                    }
                    constChks[newChkColInd].addNum(val);
                } else {
                    constChks[newChkColInd].addNum(0.0);
                }
            } else {
                constChks[newChkColInd].addNA();
            }
        }

        public void calDerivConst(Chunk[] chks, NewChunk[] constChks, int rowInd, int[] newChkColInd) {
            double weight;
            double response = chks[0].atd(rowInd);
            double mu = chks[1].atd(rowInd);
            double d = weight = this._weightPresent ? chks[2].atd(rowInd) : 1.0;
            if (Double.isFinite(response) && Double.isFinite(mu)) {
                double val = -response * Math.pow(mu, this._oneMinusP) * this._oneOver1MinusP + Math.pow(mu, this._twoMinusP) * this._oneOver2MinusP;
                constChks[newChkColInd[0]].addNum(val *= weight * weight);
                constChks[newChkColInd[1]].addNum(val *= -2.0 * weight);
            } else {
                constChks[newChkColInd[0]].addNA();
                constChks[newChkColInd[1]].addNA();
            }
        }

        public void calPart1LogConst(Chunk[] chks, NewChunk[] constChks, int rowInd, int newChkColInd) {
            double response = chks[0].atd(rowInd);
            if (Double.isFinite(response) && response > 0.0) {
                constChks[newChkColInd].addNum(Math.log(1.0 / response));
            } else {
                constChks[newChkColInd].addNA();
            }
        }

        public void calPart1LogPIConst(Chunk[] chks, NewChunk[] constChks, int rowInd, int newChkColInd) {
            double response = chks[0].atd(rowInd);
            if (Double.isFinite(response) && response > 0.0) {
                constChks[newChkColInd].addNum(Math.log(this._oneOverPi / response));
            } else {
                constChks[newChkColInd].addNA();
            }
        }

        public void calPart2Const(Chunk[] chks, NewChunk[] constChks, int rowInd, int newChkColInd) {
            double response = chks[0].atd(rowInd);
            double mu = chks[1].atd(rowInd);
            if (Double.isFinite(response) && Double.isFinite(mu)) {
                double val = -Math.pow(mu, this._twoMinusP) * this._oneOver2MinusP;
                if (response > 0.0) {
                    val += response * Math.pow(mu, this._oneMinusP) * this._oneOver1MinusP;
                }
                if (this._weightPresent) {
                    val *= chks[2].atd(rowInd);
                }
                constChks[newChkColInd].addNum(val);
            } else {
                constChks[newChkColInd].addNA();
            }
        }

        public void calJMaxConst(Chunk[] chks, NewChunk[] constChks, int rowInd, int newChkColInd) {
            double response = chks[0].atd(rowInd);
            double mu = chks[1].atd(rowInd);
            if (Double.isFinite(response) && Double.isFinite(mu) && response > 0.0) {
                double val;
                double d = val = this._variancePower < 2.0 ? Math.pow(response, this._twoMinusP) * this._oneOver2MinusP : -Math.pow(response, this._twoMinusP) * this._oneOver2MinusP;
                if (this._weightPresent) {
                    val *= chks[2].atd(rowInd);
                }
                constChks[newChkColInd].addNum(val);
            } else {
                constChks[newChkColInd].addNA();
            }
        }
    }

    public static enum InfoColNames {
        MaxValIndex,
        LOGZ,
        LOGWVMax,
        LOGDWVMax,
        LOGD2WVMax,
        JkL,
        JkU,
        DjkL,
        DjkU,
        D2jkL,
        D2jkU,
        SumWV,
        SumDWV,
        SumD2WV,
        LL,
        DLL,
        D2LL;

    }

    public static enum ConstColNames {
        JMaxConst,
        zConst,
        LogPart2Const,
        LogOneOverY,
        LogOneOverPiY,
        FirstOrderDerivConst,
        SecondOrderDerivConst;

    }
}

