/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import Jama.Matrix;
import hex.DataInfo;
import hex.glm.ComputationState;
import hex.glm.GLM;
import hex.glm.GLMModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import water.DKV;
import water.Iced;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.TwoDimTable;

public class ConstrainedGLMUtils {
    public static final double EPS = 1.0E-15;
    public static final double EPS2 = 1.0E-12;

    public static LinearConstraints[] combineConstraints(LinearConstraints[] const1, LinearConstraints[] const2) {
        ArrayList allList = new ArrayList();
        if (const1 != null) {
            allList.addAll(Arrays.stream(const1).collect(Collectors.toList()));
        }
        if (const2 != null) {
            allList.addAll(Arrays.stream(const2).collect(Collectors.toList()));
        }
        return allList.size() == 0 ? null : (LinearConstraints[])allList.stream().toArray(LinearConstraints[]::new);
    }

    public static int[] extractBetaConstraints(ComputationState state, String[] coefNames) {
        GLM.BetaConstraint betaC = state.activeBC();
        ArrayList<LinearConstraints> equalityC = new ArrayList<LinearConstraints>();
        ArrayList<LinearConstraints> lessThanEqualToC = new ArrayList<LinearConstraints>();
        ArrayList<Integer> betaIndexOnOff = new ArrayList<Integer>();
        boolean bothEndsPresent = betaC._betaUB != null && betaC._betaLB != null;
        boolean lowerEndPresentOnly = betaC._betaUB == null && betaC._betaLB != null;
        boolean upperEndPresentOnly = betaC._betaUB != null && betaC._betaLB == null;
        int numCons = betaC._betaLB != null ? betaC._betaLB.length - 1 : betaC._betaUB.length - 1;
        for (int index = 0; index < numCons; ++index) {
            if (bothEndsPresent && !Double.isInfinite(betaC._betaUB[index]) && betaC._betaLB[index] == betaC._betaUB[index]) {
                ConstrainedGLMUtils.addBCEqualityConstraint(equalityC, betaC, coefNames, index);
                betaIndexOnOff.add(1);
                continue;
            }
            if (bothEndsPresent && !Double.isInfinite(betaC._betaUB[index]) && !Double.isInfinite(betaC._betaLB[index]) && betaC._betaLB[index] < betaC._betaUB[index]) {
                ConstrainedGLMUtils.addBCGreaterThanConstraint(lessThanEqualToC, betaC, coefNames, index);
                ConstrainedGLMUtils.addBCLessThanConstraint(lessThanEqualToC, betaC, coefNames, index);
                betaIndexOnOff.add(1);
                betaIndexOnOff.add(0);
                continue;
            }
            if ((lowerEndPresentOnly || betaC._betaUB != null && Double.isInfinite(betaC._betaUB[index])) && betaC._betaLB != null && !Double.isInfinite(betaC._betaLB[index])) {
                ConstrainedGLMUtils.addBCGreaterThanConstraint(lessThanEqualToC, betaC, coefNames, index);
                betaIndexOnOff.add(1);
                continue;
            }
            if (!upperEndPresentOnly && (betaC._betaLB == null || !Double.isInfinite(betaC._betaLB[index])) || betaC._betaUB == null || Double.isInfinite(betaC._betaUB[index])) continue;
            ConstrainedGLMUtils.addBCLessThanConstraint(lessThanEqualToC, betaC, coefNames, index);
            betaIndexOnOff.add(1);
        }
        state.setLinearConstraints(equalityC.toArray(new LinearConstraints[0]), lessThanEqualToC.toArray(new LinearConstraints[0]), true);
        return betaIndexOnOff.size() == 0 ? null : betaIndexOnOff.stream().mapToInt(x -> x).toArray();
    }

    public static void addBCEqualityConstraint(List<LinearConstraints> equalityC, GLM.BetaConstraint betaC, String[] coefNames, int index) {
        LinearConstraints oneEqualityConstraint = new LinearConstraints();
        oneEqualityConstraint._constraints.put(coefNames[index], 1.0);
        oneEqualityConstraint._constraints.put("constant", -betaC._betaLB[index]);
        equalityC.add(oneEqualityConstraint);
    }

    public static void addBCGreaterThanConstraint(List<LinearConstraints> lessThanC, GLM.BetaConstraint betaC, String[] coefNames, int index) {
        LinearConstraints lessThanEqualToConstraint = new LinearConstraints();
        lessThanEqualToConstraint._constraints.put(coefNames[index], -1.0);
        lessThanEqualToConstraint._constraints.put("constant", betaC._betaLB[index]);
        lessThanC.add(lessThanEqualToConstraint);
    }

    public static void addBCLessThanConstraint(List<LinearConstraints> lessThanC, GLM.BetaConstraint betaC, String[] coefNames, int index) {
        LinearConstraints greaterThanConstraint = new LinearConstraints();
        greaterThanConstraint._constraints.put(coefNames[index], 1.0);
        greaterThanConstraint._constraints.put("constant", -betaC._betaUB[index]);
        lessThanC.add(greaterThanConstraint);
    }

    public static void extractLinearConstraints(ComputationState state, Key<Frame> linearConstraintFrameKey, DataInfo dinfo) {
        ArrayList<LinearConstraints> equalityC = new ArrayList<LinearConstraints>();
        ArrayList<LinearConstraints> lessThanEqualToC = new ArrayList<LinearConstraints>();
        Frame linearConstraintF = (Frame)DKV.getGet(linearConstraintFrameKey);
        List<String> colNamesList = Stream.of(dinfo._adaptedFrame.names()).collect(Collectors.toList());
        List<String> coefNamesList = Stream.of(dinfo.coefNames()).collect(Collectors.toList());
        int numberOfConstraints = linearConstraintF.vec("constraint_numbers").toCategoricalVec().domain().length;
        int numRow = (int)linearConstraintF.numRows();
        List<Integer> rowIndices = IntStream.range(0, numRow).boxed().collect(Collectors.toList());
        for (int conInd = 0; conInd < numberOfConstraints; ++conInd) {
            if (rowIndices.isEmpty()) continue;
            int rowIndex = (Integer)rowIndices.get(0);
            String constraintType = linearConstraintF.vec("types").stringAt(rowIndex).toLowerCase();
            if ("equal".equals(constraintType)) {
                ConstrainedGLMUtils.extractConstraint(linearConstraintF, rowIndices, equalityC, dinfo, coefNamesList, colNamesList);
                continue;
            }
            if ("lessthanequal".equals(constraintType)) {
                ConstrainedGLMUtils.extractConstraint(linearConstraintF, rowIndices, lessThanEqualToC, dinfo, coefNamesList, colNamesList);
                continue;
            }
            throw new IllegalArgumentException("Type of linear constraints can only be Equal to LessThanEqualTo.");
        }
        state.setLinearConstraints(equalityC.toArray(new LinearConstraints[0]), lessThanEqualToC.toArray(new LinearConstraints[0]), false);
    }

    public static void extractConstraint(Frame constraintF, List<Integer> rowIndices, List<LinearConstraints> equalC, DataInfo dinfo, List<String> coefNames, List<String> colNames) {
        ArrayList<Integer> processedRowIndices = new ArrayList<Integer>();
        int constraintNumberFrame = (int)constraintF.vec("constraint_numbers").at(rowIndices.get(0).intValue());
        LinearConstraints currentConstraint = new LinearConstraints();
        String constraintType = constraintF.vec("types").stringAt(rowIndices.get(0).intValue()).toLowerCase();
        boolean standardize = dinfo._normMul != null;
        boolean constantFound = false;
        for (Integer rowIndex : rowIndices) {
            String coefName = constraintF.vec("names").stringAt(rowIndex.intValue());
            String currType = constraintF.vec("types").stringAt(rowIndex.intValue()).toLowerCase();
            if (!coefNames.contains(coefName) && !"constant".equals(coefName)) {
                throw new IllegalArgumentException("Coefficient name " + coefName + " is not a valid coefficient name.  It be a valid coefficient name or it can be constant");
            }
            if ((int)constraintF.vec("constraint_numbers").at(rowIndex.intValue()) != constraintNumberFrame) continue;
            if (!constraintType.equals(currType)) {
                throw new IllegalArgumentException("Constraint type  of the same constraint must be the same but is not.  Expected type: " + constraintType + ".  Actual type: " + currType);
            }
            if ("constant".equals(coefName)) {
                constantFound = true;
            }
            processedRowIndices.add(rowIndex);
            int colInd = colNames.indexOf(coefName) - dinfo._cats;
            if (standardize && colNames.contains(coefName) && colInd >= 0) {
                currentConstraint._constraints.put(coefName, constraintF.vec("values").at(rowIndex.intValue()) * dinfo._normMul[colInd]);
                continue;
            }
            currentConstraint._constraints.put(coefName, constraintF.vec("values").at(rowIndex.intValue()));
        }
        if (!constantFound) {
            currentConstraint._constraints.put("constant", 0.0);
        }
        if (currentConstraint._constraints.size() < 3) {
            throw new IllegalArgumentException("Linear constraint must have at least two coefficients.  For constraints on just one coefficient: " + constraintF.vec("names").stringAt(0L) + ", use betaConstraints instead.");
        }
        equalC.add(currentConstraint);
        rowIndices.removeAll(processedRowIndices);
    }

    public static double[][] formConstraintMatrix(ComputationState state, List<String> constraintNamesList, int[] betaEqualLessThanInd) {
        constraintNamesList.addAll(ConstrainedGLMUtils.extractConstraintCoeffs(state));
        int numRow = (betaEqualLessThanInd == null ? 0 : ArrayUtils.sum(betaEqualLessThanInd)) + (state._equalityConstraintsLinear == null ? 0 : state._equalityConstraintsLinear.length) + (state._lessThanEqualToConstraintsLinear == null ? 0 : state._lessThanEqualToConstraintsLinear.length);
        double[][] initConstraintMatrix = new double[numRow][constraintNamesList.size()];
        ConstrainedGLMUtils.fillConstraintValues(state, constraintNamesList, initConstraintMatrix, betaEqualLessThanInd);
        return initConstraintMatrix;
    }

    public static void fillConstraintValues(ComputationState state, List<String> constraintNamesList, double[][] initCMatrix, int[] betaLessThan) {
        int rowIndex = 0;
        if (state._equalityConstraintsBeta != null) {
            rowIndex = ConstrainedGLMUtils.extractConstraintValues(state._equalityConstraintsBeta, constraintNamesList, initCMatrix, rowIndex, null);
        }
        if (state._lessThanEqualToConstraintsBeta != null) {
            rowIndex = ConstrainedGLMUtils.extractConstraintValues(state._lessThanEqualToConstraintsBeta, constraintNamesList, initCMatrix, rowIndex, betaLessThan);
        }
        if (state._equalityConstraintsLinear != null) {
            rowIndex = ConstrainedGLMUtils.extractConstraintValues(state._equalityConstraintsLinear, constraintNamesList, initCMatrix, rowIndex, null);
        }
        if (state._lessThanEqualToConstraintsLinear != null) {
            ConstrainedGLMUtils.extractConstraintValues(state._lessThanEqualToConstraintsLinear, constraintNamesList, initCMatrix, rowIndex, null);
        }
    }

    public static int extractConstraintValues(LinearConstraints[] constraints, List<String> constraintNamesList, double[][] initCMatrix, int rowIndex, int[] betaLessThan) {
        int numConstr = constraints.length;
        for (int index = 0; index < numConstr; ++index) {
            if (betaLessThan != null && betaLessThan[index] != 1) continue;
            Set coeffKeys = constraints[index]._constraints.keySet();
            for (String oneKey : coeffKeys) {
                if (!constraintNamesList.contains(oneKey)) continue;
                initCMatrix[rowIndex][constraintNamesList.indexOf((Object)oneKey)] = (Double)constraints[index]._constraints.get(oneKey);
            }
            ++rowIndex;
        }
        return rowIndex;
    }

    public static void printConstraintSummary(GLMModel model, ComputationState state, String[] coefNames) {
        LinearConstraintConditions cCond = ConstrainedGLMUtils.printConstraintSummary(state, coefNames);
        ((GLMModel.GLMOutput)model._output)._linear_constraint_states = cCond._constraintDescriptions;
        ((GLMModel.GLMOutput)model._output)._all_constraints_satisfied = cCond._allConstraintsSatisfied;
        ConstrainedGLMUtils.makeConstraintSummaryTable(model, cCond);
    }

    public static void makeConstraintSummaryTable(GLMModel model, LinearConstraintConditions cCond) {
        int numRow = cCond._constraintBounds.length;
        String[] colHeaders = new String[]{"constraint", "values", "condition", "condition_satisfied"};
        String[] colTypes = new String[]{"string", "double", "string", "string"};
        String[] colFormats = new String[]{"%s", "%5.2f", "%s", "%s"};
        TwoDimTable cTable = new TwoDimTable("Beta (if exists) and Linear Constraints Table", null, new String[numRow], colHeaders, colTypes, colFormats, "constraint");
        for (int index = 0; index < numRow; ++index) {
            cTable.set(index, 0, cCond._constraintNValues[index]);
            cTable.set(index, 1, cCond._constraintValues[index]);
            cTable.set(index, 2, cCond._constraintBounds[index]);
            cTable.set(index, 3, cCond._constraintSatisfied[index]);
        }
        ((GLMModel.GLMOutput)model._output)._linear_constraints_table = cTable;
    }

    public static LinearConstraintConditions printConstraintSummary(ComputationState state, String[] coefNames) {
        double[] beta = state.beta();
        boolean constraintsSatisfied = true;
        List<String> coefNameList = Arrays.stream(coefNames).collect(Collectors.toList());
        ArrayList<String> constraintConditions = new ArrayList<String>();
        ArrayList<String> cSatisfied = new ArrayList<String>();
        ArrayList<Double> cValues = new ArrayList<Double>();
        ArrayList<String> cConditions = new ArrayList<String>();
        ArrayList<String> constraintStrings = new ArrayList<String>();
        if (state._equalityConstraintsBeta != null) {
            boolean bl = constraintsSatisfied = ConstrainedGLMUtils.evaluateConstraint(state, state._equalityConstraintsBeta, true, beta, coefNameList, "Beta equality constraint: ", constraintConditions, cSatisfied, cValues, cConditions, constraintStrings) && constraintsSatisfied;
        }
        if (state._lessThanEqualToConstraintsBeta != null) {
            boolean bl = constraintsSatisfied = ConstrainedGLMUtils.evaluateConstraint(state, state._lessThanEqualToConstraintsBeta, false, beta, coefNameList, "Beta inequality constraint: ", constraintConditions, cSatisfied, cValues, cConditions, constraintStrings) && constraintsSatisfied;
        }
        if (state._equalityConstraintsLinear != null) {
            boolean bl = constraintsSatisfied = ConstrainedGLMUtils.evaluateConstraint(state, state._equalityConstraintsLinear, true, beta, coefNameList, "Linear equality constraint: ", constraintConditions, cSatisfied, cValues, cConditions, constraintStrings) && constraintsSatisfied;
        }
        if (state._lessThanEqualToConstraints != null) {
            constraintsSatisfied = ConstrainedGLMUtils.evaluateConstraint(state, state._lessThanEqualToConstraints, false, beta, coefNameList, "Linear inequality constraint: ", constraintConditions, cSatisfied, cValues, cConditions, constraintStrings) && constraintsSatisfied;
        }
        return new LinearConstraintConditions((String[])constraintConditions.stream().toArray(String[]::new), (String[])cSatisfied.stream().toArray(String[]::new), cValues.stream().mapToDouble(x -> x).toArray(), (String[])cConditions.stream().toArray(String[]::new), (String[])constraintStrings.stream().toArray(String[]::new), constraintsSatisfied);
    }

    public static boolean evaluateConstraint(ComputationState state, LinearConstraints[] constraints, boolean equalityConstr, double[] beta, List<String> coefNames, String startStr, List<String> constraintCond, List<String> cSatisfied, List<Double> cValues, List<String> cConditions, List<String> constraintsStrings) {
        int constLen = constraints.length;
        boolean allSatisfied = true;
        for (int index = 0; index < constLen; ++index) {
            LinearConstraints oneC = constraints[index];
            String constrainStr = ConstrainedGLMUtils.constraint2Str(oneC, startStr, state);
            ConstrainedGLMUtils.evalOneConstraint(oneC, beta, coefNames);
            constraintsStrings.add(constrainStr + " = " + oneC._constraintsVal);
            if (equalityConstr) {
                if (Math.abs(oneC._constraintsVal) <= 1.0E-15) {
                    constraintCond.add(constrainStr + " == 0 is statisfied.");
                    cSatisfied.add("true");
                } else {
                    constraintCond.add(constrainStr + " = " + oneC._constraintsVal + " and does not satisfy the condition == 0.");
                    cSatisfied.add("false");
                    allSatisfied = false;
                }
                cConditions.add("== 0");
            } else {
                if (oneC._constraintsVal <= 0.0) {
                    constraintCond.add(constrainStr + " <= " + oneC._constraintsVal + " which satisfies the constraint <= 0.");
                    cSatisfied.add("true");
                } else {
                    constraintCond.add(constrainStr + " = " + oneC._constraintsVal + " and does not satisfy the condition <= 0");
                    cSatisfied.add("false");
                    allSatisfied = false;
                }
                cConditions.add("<= 0");
            }
            cValues.add(oneC._constraintsVal);
        }
        return allSatisfied;
    }

    public static String constraint2Str(LinearConstraints oneConst, String startStr, ComputationState state) {
        boolean isBetaConstraint = oneConst._constraints.size() < 3;
        StringBuilder sb = new StringBuilder();
        sb.append(startStr);
        DataInfo dinfo = state.activeData();
        boolean standardize = dinfo._normMul != null;
        List trainNames = Arrays.stream(dinfo.coefNames()).collect(Collectors.toList());
        double constantVal = 0.0;
        int colInd = -1;
        int coefOffset = dinfo._catOffsets == null || dinfo._catOffsets.length == 0 ? 0 : dinfo._catOffsets[dinfo._catOffsets.length - 1];
        for (String coefName : oneConst._constraints.keySet()) {
            double constrVal = (Double)oneConst._constraints.get(coefName);
            if (constrVal == 0.0) continue;
            if ("constant".equals(coefName)) {
                constantVal = constrVal;
                continue;
            }
            if (!trainNames.contains(coefName)) continue;
            colInd = trainNames.indexOf(coefName) - coefOffset;
            if (standardize && colInd >= 0 && !isBetaConstraint) {
                if (constrVal > 0.0) {
                    sb.append('+');
                }
                sb.append(constrVal / dinfo._normMul[colInd]);
            } else {
                sb.append(constrVal);
            }
            sb.append('*');
            sb.append(coefName);
        }
        if (constantVal != 0.0) {
            if (constantVal > 0.0) {
                sb.append("+");
            }
            if (isBetaConstraint && colInd >= 0 && standardize) {
                sb.append(constantVal * dinfo._normMul[colInd]);
            } else {
                sb.append(constantVal);
            }
        }
        return sb.toString();
    }

    public static List<String> extractConstraintCoeffs(ComputationState state) {
        ArrayList<String> tConstraintCoeffName = new ArrayList<String>();
        boolean nonZeroConstant = false;
        if (state._equalityConstraintsBeta != null) {
            nonZeroConstant = ConstrainedGLMUtils.extractCoeffNames(tConstraintCoeffName, state._equalityConstraintsBeta);
        }
        if (state._lessThanEqualToConstraintsBeta != null) {
            boolean bl = nonZeroConstant = ConstrainedGLMUtils.extractCoeffNames(tConstraintCoeffName, state._lessThanEqualToConstraintsBeta) || nonZeroConstant;
        }
        if (state._equalityConstraintsLinear != null) {
            boolean bl = nonZeroConstant = ConstrainedGLMUtils.extractCoeffNames(tConstraintCoeffName, state._equalityConstraintsLinear) || nonZeroConstant;
        }
        if (state._lessThanEqualToConstraintsLinear != null) {
            nonZeroConstant = ConstrainedGLMUtils.extractCoeffNames(tConstraintCoeffName, state._lessThanEqualToConstraintsLinear) || nonZeroConstant;
        }
        HashSet<String> noDuplicateNames = new HashSet<String>(tConstraintCoeffName);
        if (!nonZeroConstant) {
            noDuplicateNames.remove("constant");
        }
        return new ArrayList<String>(noDuplicateNames);
    }

    public static boolean extractCoeffNames(List<String> coeffList, LinearConstraints[] constraints) {
        int numConst = constraints.length;
        boolean nonZeroConstant = false;
        for (int index = 0; index < numConst; ++index) {
            Set keys = constraints[index]._constraints.keySet();
            coeffList.addAll(keys);
            if (!keys.contains("constant")) continue;
            nonZeroConstant = (Double)constraints[index]._constraints.get("constant") != 0.0;
        }
        return nonZeroConstant;
    }

    public static List<String> foundRedundantConstraints(ComputationState state, double[][] initConstraintMatrix) {
        Matrix constMatrix = new Matrix(initConstraintMatrix);
        Matrix matrixSquare = constMatrix.times(constMatrix.transpose());
        int rank = matrixSquare.rank();
        if (rank < constMatrix.getRowDimension()) {
            double[][] rMatVal = matrixSquare.qr().getR().getArray();
            List diag = IntStream.range(0, rMatVal.length).mapToDouble(x -> Math.abs(rMatVal[x][x])).boxed().collect(Collectors.toList());
            int[] sortedIndices = IntStream.range(0, diag.size()).boxed().sorted((i, j) -> ((Double)diag.get((int)i)).compareTo((Double)diag.get((int)j))).mapToInt(ele -> ele).toArray();
            List<Integer> duplicatedEleIndice = IntStream.range(0, diag.size() - rank).map(x -> sortedIndices[x]).boxed().collect(Collectors.toList());
            return ConstrainedGLMUtils.genRedundantConstraint(state, duplicatedEleIndice);
        }
        return null;
    }

    public static List<String> genRedundantConstraint(ComputationState state, List<Integer> duplicatedEleIndics) {
        ArrayList<String> redundantConstraint = new ArrayList<String>();
        for (Integer redIndex : duplicatedEleIndics) {
            redundantConstraint.add(ConstrainedGLMUtils.grabRedundantConstraintMessage(state, redIndex));
        }
        return redundantConstraint;
    }

    public static String grabRedundantConstraintMessage(ComputationState state, Integer constraintIndex) {
        LinearConstraints redundantConst = ConstrainedGLMUtils.getConstraintFromIndex(state, constraintIndex);
        if (redundantConst != null) {
            boolean standardize = state.activeData()._normMul != null;
            boolean isBetaConstraint = redundantConst._constraints.size() < 3;
            StringBuilder sb = new StringBuilder();
            DataInfo dinfo = state.activeData();
            List trainNames = Arrays.stream(dinfo.coefNames()).collect(Collectors.toList());
            sb.append("This constraint is redundant ");
            double constantVal = 0.0;
            int colInd = -1;
            int coefOffset = dinfo._catOffsets == null || dinfo._catOffsets.length == 0 ? 0 : dinfo._catOffsets[dinfo._catOffsets.length - 1];
            for (String coefName : redundantConst._constraints.keySet()) {
                double constrVal = (Double)redundantConst._constraints.get(coefName);
                if (constrVal == 0.0) continue;
                if ("constant".equals(coefName)) {
                    constantVal = constrVal;
                    continue;
                }
                if (!trainNames.contains(coefName)) continue;
                colInd = trainNames.indexOf(coefName) - coefOffset;
                if (standardize && colInd >= 0 && !isBetaConstraint) {
                    if (constrVal > 0.0) {
                        sb.append('+');
                    }
                    sb.append(constrVal * dinfo._normMul[colInd]);
                } else {
                    sb.append(constrVal);
                }
                sb.append('*');
                sb.append(coefName);
            }
            if (constantVal != 0.0) {
                if (constantVal > 0.0) {
                    sb.append("+");
                }
                if (isBetaConstraint && colInd >= 0) {
                    sb.append(constantVal * dinfo._normMul[colInd]);
                } else {
                    sb.append(constantVal);
                }
            }
            sb.append(" <= or == 0.");
            sb.append(" Please remove it from your beta/linear constraints.");
            return sb.toString();
        }
        return null;
    }

    public static LinearConstraints getConstraintFromIndex(ComputationState state, Integer constraintIndex) {
        int constIndexWOffset = constraintIndex;
        if (state._equalityConstraintsBeta != null) {
            if (constIndexWOffset < state._equalityConstraintsBeta.length) {
                return state._equalityConstraintsBeta[constIndexWOffset];
            }
            constIndexWOffset -= state._equalityConstraintsBeta.length;
        }
        if (state._lessThanEqualToConstraintsBeta != null) {
            if (constIndexWOffset < state._lessThanEqualToConstraintsBeta.length) {
                return state._lessThanEqualToConstraintsBeta[constIndexWOffset];
            }
            constIndexWOffset -= state._lessThanEqualToConstraintsBeta.length;
        }
        if (state._equalityConstraintsLinear != null) {
            if (constIndexWOffset < state._equalityConstraintsLinear.length) {
                return state._equalityConstraintsLinear[constIndexWOffset];
            }
            constIndexWOffset -= state._equalityConstraintsLinear.length;
        }
        if (state._lessThanEqualToConstraints != null && constIndexWOffset < state._lessThanEqualToConstraints.length) {
            return state._lessThanEqualToConstraints[constIndexWOffset];
        }
        return null;
    }

    public static void evalOneConstraint(LinearConstraints constraint, double[] beta, List<String> coefNames) {
        double sumV = 0.0;
        IcedHashMap<String, Double> constraints = constraint._constraints;
        for (String coef : constraints.keySet()) {
            if ("constant".equals(coef)) {
                sumV += ((Double)constraints.get(coef)).doubleValue();
                continue;
            }
            sumV += (Double)constraints.get(coef) * beta[coefNames.indexOf(coef)];
        }
        constraint._constraintsVal = sumV;
    }

    public static void genInitialLambda(Random randObj, LinearConstraints[] constraints, double[] lambda) {
        int numC = constraints.length;
        for (int index = 0; index < numC; ++index) {
            lambda[index] = Math.abs(randObj.nextGaussian());
            LinearConstraints oneC = constraints[index];
            if (!oneC._active || !(oneC._constraintsVal < 0.0)) continue;
            int n = index;
            lambda[n] = lambda[n] * -1.0;
        }
    }

    public static void adjustLambda(LinearConstraints[] constraints, double[] lambda) {
        for (LinearConstraints oneC : constraints) {
            if (oneC._active) continue;
            lambda[index] = 0.0;
        }
    }

    public static double[][] sumGramConstribution(ConstraintsGram[] gramConstraints, int numCoefs) {
        if (gramConstraints == null) {
            return null;
        }
        double[][] gramContr = new double[numCoefs][numCoefs];
        for (ConstraintsGram oneGram : gramConstraints) {
            if (!oneGram._active) continue;
            for (CoefIndices key : oneGram._coefIndicesValue.keySet()) {
                int coef1 = key._firstCoefIndex;
                int coef2 = key._secondCoefIndex;
                double[] dArray = gramContr[coef1];
                int n = coef2;
                dArray[n] = dArray[n] + (Double)oneGram._coefIndicesValue.get(key);
                if (coef1 == coef2) continue;
                gramContr[coef2][coef1] = gramContr[coef1][coef2];
            }
        }
        return gramContr;
    }

    public static void addConstraintGradient(double[] lambda, ConstraintsDerivatives[] constraintD, GLM.GLMGradientInfo gradientInfo) {
        int numConstraints = lambda.length;
        for (int index = 0; index < numConstraints; ++index) {
            ConstraintsDerivatives oneC = constraintD[index];
            if (!oneC._active) continue;
            for (Integer key : oneC._constraintsDerivative.keySet()) {
                int n = key;
                gradientInfo._gradient[n] = gradientInfo._gradient[n] + lambda[index] * (Double)oneC._constraintsDerivative.get(key);
            }
        }
    }

    public static void addPenaltyGradient(ConstraintsDerivatives[] constraintDeriv, LinearConstraints[] constraintD, GLM.GLMGradientInfo gradientInfo, double ck) {
        int numConstraints = constraintDeriv.length;
        for (int index = 0; index < numConstraints; ++index) {
            ConstraintsDerivatives oneD = constraintDeriv[index];
            if (!oneD._active) continue;
            LinearConstraints oneConts = constraintD[index];
            for (Integer coefK : oneD._constraintsDerivative.keySet()) {
                int n = coefK;
                gradientInfo._gradient[n] = gradientInfo._gradient[n] + ck * oneConts._constraintsVal * (Double)oneD._constraintsDerivative.get(coefK);
            }
        }
    }

    public static void updateConstraintParameters(ComputationState state, double[] lambdaEqual, double[] lambdaLessThan, LinearConstraints[] equalConst, LinearConstraints[] lessThanConst, GLMModel.GLMParameters parms) {
        double hBetaMagSquare = state._csGLMState._constraintMagSquare;
        if (hBetaMagSquare <= state._csGLMState._etakCSSquare) {
            if (equalConst != null) {
                ConstrainedGLMUtils.updateLambda(lambdaEqual, state._csGLMState._ckCS, equalConst);
            }
            if (lessThanConst != null) {
                ConstrainedGLMUtils.updateLambda(lambdaLessThan, state._csGLMState._ckCS, lessThanConst);
            }
            state._csGLMState._epsilonkCS /= state._csGLMState._ckCS;
            state._csGLMState._etakCS /= Math.pow(state._csGLMState._ckCS, parms._constraint_beta);
        } else {
            state._csGLMState._ckCS *= parms._constraint_tau;
            state._csGLMState._ckCSHalf = state._csGLMState._ckCS * 0.5;
            state._csGLMState._epsilonkCS = state._csGLMState._epsilon0 / state._csGLMState._ckCS;
            state._csGLMState._etakCS = parms._constraint_eta0 / Math.pow(state._csGLMState._ckCS, parms._constraint_alpha);
        }
        state._csGLMState._epsilonkCSSquare = state._csGLMState._epsilonkCS * state._csGLMState._epsilonkCS;
        state._csGLMState._etakCSSquare = state._csGLMState._etakCS * state._csGLMState._etakCS;
    }

    public static void calculateConstraintSquare(ComputationState state, LinearConstraints[] equalConst, LinearConstraints[] lessThanConst) {
        double sumSquare = 0.0;
        if (equalConst != null) {
            sumSquare += Arrays.stream(equalConst).mapToDouble(x -> x._constraintsVal * x._constraintsVal).sum();
        }
        if (lessThanConst != null) {
            sumSquare += Arrays.stream(lessThanConst).filter(x -> x._active).mapToDouble(x -> x._constraintsVal * x._constraintsVal).sum();
        }
        state._csGLMState._constraintMagSquare = sumSquare;
    }

    public static void updateLambda(double[] lambda, double ckCS, LinearConstraints[] constraints) {
        int numC = constraints.length;
        for (int index = 0; index < numC; ++index) {
            LinearConstraints oneC = constraints[index];
            if (!oneC._active) continue;
            int n = index;
            lambda[n] = lambda[n] + ckCS * oneC._constraintsVal;
        }
    }

    public static boolean constraintsStop(GLM.GLMGradientInfo gradientInfo, ComputationState state) {
        state._csGLMState._gradientMagSquare = ArrayUtils.innerProduct(gradientInfo._gradient, gradientInfo._gradient);
        return state._csGLMState._constraintMagSquare <= 1.0E-6 && state._csGLMState._gradientMagSquare <= 1.0E-12;
    }

    public static boolean activeConstraints(LinearConstraints[] equalityC, LinearConstraints[] lessThanEqualToC) {
        if (equalityC != null) {
            return true;
        }
        return Arrays.stream(lessThanEqualToC).filter(x -> x._active).count() > 0L;
    }

    public static GLM.GLMGradientInfo calGradient(double[] betaCnd, ComputationState state, GLM.GLMGradientSolver ginfo, double[] lambdaE, double[] lambdaL, LinearConstraints[] constraintE, LinearConstraints[] constraintL) {
        boolean hasLessConstraints;
        GLM.GLMGradientInfo gradientInfo = ginfo.getGradient(betaCnd, state);
        boolean hasEqualConstraints = constraintE != null;
        boolean bl = hasLessConstraints = constraintL != null;
        if (hasEqualConstraints) {
            ConstrainedGLMUtils.addConstraintGradient(lambdaE, state._derivativeEqual, gradientInfo);
            ConstrainedGLMUtils.addPenaltyGradient(state._derivativeEqual, constraintE, gradientInfo, state._csGLMState._ckCS);
            gradientInfo._objVal += ComputationState.addConstraintObj(lambdaE, constraintE, state._csGLMState._ckCSHalf);
        }
        if (hasLessConstraints) {
            ConstrainedGLMUtils.addConstraintGradient(lambdaL, state._derivativeLess, gradientInfo);
            ConstrainedGLMUtils.addPenaltyGradient(state._derivativeLess, constraintL, gradientInfo, state._csGLMState._ckCS);
            gradientInfo._objVal += ComputationState.addConstraintObj(lambdaL, constraintL, state._csGLMState._ckCSHalf);
        }
        return gradientInfo;
    }

    public static void updateConstraintValues(double[] betaCnd, List<String> coefNames, LinearConstraints[] equalityConstraints, LinearConstraints[] lessThanEqualToConstraints) {
        if (equalityConstraints != null) {
            Arrays.stream(equalityConstraints).forEach(constraint -> {
                ConstrainedGLMUtils.evalOneConstraint(constraint, betaCnd, coefNames);
                constraint._active = true;
            });
        }
        if (lessThanEqualToConstraints != null) {
            Arrays.stream(lessThanEqualToConstraints).forEach(constraint -> {
                ConstrainedGLMUtils.evalOneConstraint(constraint, betaCnd, coefNames);
                constraint._active = constraint._constraintsVal >= 0.0;
            });
        }
    }

    public static String[] collinearInConstraints(String[] collinear_cols, String[] constraintNames) {
        List cNames = Arrays.stream(constraintNames).collect(Collectors.toList());
        return (String[])Arrays.stream(collinear_cols).filter(x -> cNames.contains(x)).toArray(String[]::new);
    }

    public static int countNumConst(ComputationState state) {
        int numConst = 0;
        numConst += state._equalityConstraintsBeta == null ? 0 : state._equalityConstraintsBeta.length;
        numConst += state._lessThanEqualToConstraintsBeta == null ? 0 : state._lessThanEqualToConstraintsBeta.length / 2;
        numConst += state._equalityConstraintsLinear == null ? 0 : state._equalityConstraintsLinear.length;
        return numConst += state._lessThanEqualToConstraints == null ? 0 : state._lessThanEqualToConstraints.length;
    }

    public static class LinearConstraintConditions {
        final String[] _constraintDescriptions;
        final String[] _constraintSatisfied;
        final double[] _constraintValues;
        final String[] _constraintBounds;
        final String[] _constraintNValues;
        final boolean _allConstraintsSatisfied;

        public LinearConstraintConditions(String[] constraintC, String[] cSatisfied, double[] cValues, String[] cBounds, String[] cNV, boolean conditionS) {
            this._constraintDescriptions = constraintC;
            this._constraintSatisfied = cSatisfied;
            this._constraintValues = cValues;
            this._constraintBounds = cBounds;
            this._constraintNValues = cNV;
            this._allConstraintsSatisfied = conditionS;
        }
    }

    public static class ConstraintGLMStates {
        double _ckCS;
        double _ckCSHalf;
        double _epsilonkCS;
        public double _epsilonkCSSquare;
        double _etakCS;
        double _etakCSSquare;
        double _epsilon0;
        String[] _constraintNames;
        double[][] _initCSMatrix;
        double _gradientMagSquare;
        double _constraintMagSquare;

        public ConstraintGLMStates(String[] constrainNames, double[][] initMatrix, GLMModel.GLMParameters parms) {
            this._constraintNames = constrainNames;
            this._initCSMatrix = initMatrix;
            this._ckCS = parms._constraint_c0;
            this._ckCSHalf = parms._constraint_c0 * 0.5;
            this._epsilonkCS = 1.0 / parms._constraint_c0;
            this._epsilonkCSSquare = this._epsilonkCS * this._epsilonkCS;
            this._etakCS = parms._constraint_eta0 / Math.pow(parms._constraint_c0, parms._constraint_alpha);
            this._etakCSSquare = this._etakCS * this._etakCS;
            this._epsilon0 = 1.0 / parms._constraint_c0;
        }
    }

    public static class CoefIndices
    implements hex.glm.CoefIndices {
        final int _firstCoefIndex;
        final int _secondCoefIndex;

        public CoefIndices(int firstInd, int secondInd) {
            this._firstCoefIndex = firstInd;
            this._secondCoefIndex = secondInd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            return this._firstCoefIndex == ((CoefIndices)o)._firstCoefIndex && this._secondCoefIndex == ((CoefIndices)o)._secondCoefIndex;
        }

        public String toString() {
            return "first coefficient index: " + this._firstCoefIndex + ", second coefficient index " + this._secondCoefIndex;
        }
    }

    public static class ConstraintsGram
    extends Iced {
        public IcedHashMap<CoefIndices, Double> _coefIndicesValue = new IcedHashMap();
        public boolean _active;
    }

    public static class ConstraintsDerivatives
    extends Iced {
        public IcedHashMap<Integer, Double> _constraintsDerivative = new IcedHashMap();
        public boolean _active;

        public ConstraintsDerivatives(boolean active) {
            this._active = active;
        }
    }

    public static class LinearConstraints
    extends Iced {
        public IcedHashMap<String, Double> _constraints = new IcedHashMap();
        public double _constraintsVal = Double.NaN;
        public boolean _active = true;
    }
}

