/*
 * Decompiled with CFR 0.152.
 */
package hex.glm;

import hex.DataInfo;
import hex.glm.ConstrainedGLMUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.glm.GLMTask;
import hex.glm.GLMUtils;
import hex.gram.Gram;
import hex.optimization.ADMM;
import hex.optimization.OptimizationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import water.H2O;
import water.H2ORuntime;
import water.Job;
import water.MemoryManager;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.MathUtils;

public final class ComputationState {
    private static final double R2_EPS = 1.0E-7;
    public static final double EPS_CS = 1.0E-6;
    public static final double EPS_CS_SQUARE = 1.0E-12;
    private static final int MIN_PAR = 1000;
    final boolean _intercept;
    final int _nbetas;
    public final GLMModel.GLMParameters _parms;
    private GLM.BetaConstraint _bc;
    double _alpha;
    double[] _ymu;
    double[] _u;
    private double[] _zValues;
    private boolean _dispersionEstimated;
    boolean _allIn;
    int _iter;
    private double _lambda = 0.0;
    private double _lambdaMax = Double.NaN;
    private GLM.GLMGradientInfo _ginfo;
    private double _likelihood;
    private double _gradientErr;
    private boolean _lambdaNull;
    private double _gMax;
    private DataInfo _activeData;
    private GLM.BetaConstraint _activeBC;
    ConstrainedGLMUtils.LinearConstraints[] _equalityConstraintsLinear = null;
    ConstrainedGLMUtils.LinearConstraints[] _lessThanEqualToConstraintsLinear = null;
    ConstrainedGLMUtils.LinearConstraints[] _equalityConstraintsBeta = null;
    ConstrainedGLMUtils.LinearConstraints[] _lessThanEqualToConstraintsBeta = null;
    ConstrainedGLMUtils.LinearConstraints[] _equalityConstraints = null;
    ConstrainedGLMUtils.LinearConstraints[] _lessThanEqualToConstraints = null;
    double[] _lambdaEqual;
    double[] _lambdaLessThanEqualTo;
    ConstrainedGLMUtils.ConstraintsDerivatives[] _derivativeEqual = null;
    ConstrainedGLMUtils.ConstraintsDerivatives[] _derivativeLess = null;
    ConstrainedGLMUtils.ConstraintsGram[] _gramEqual = null;
    ConstrainedGLMUtils.ConstraintsGram[] _gramLess = null;
    private final GLM.BetaInfo _modelBetaInfo;
    private double[] _beta;
    final DataInfo _dinfo;
    private GLM.GLMGradientSolver _gslvr;
    private final Job _job;
    private int _activeClass = -1;
    double[][][] _penaltyMatrix;
    int[][] _gamBetaIndices;
    int _totalBetaLength;
    int _betaLengthPerClass;
    public boolean _noReg;
    public ConstrainedGLMUtils.ConstraintGLMStates _csGLMState;
    public boolean _lsNeeded = false;
    public DataInfo[] _activeDataMultinomial;
    private double _betaDiff;
    private double _relImprovement;
    String convergenceMsg = "";
    GramXY _currGram;
    GLMModel.GLMWeightsFun _glmw;

    public ComputationState(Job job, GLMModel.GLMParameters parms, DataInfo dinfo, GLM.BetaConstraint bc, GLM.BetaInfo bi) {
        this._job = job;
        this._parms = parms;
        this._activeBC = this._bc = bc;
        this._activeData = this._dinfo = dinfo;
        this._intercept = this._parms._intercept;
        this._alpha = this._parms._alpha[0];
        this._nbetas = bi._nBetas;
        this._betaLengthPerClass = dinfo.fullN() + 1;
        this._totalBetaLength = this._betaLengthPerClass * this._nbetas;
        this._modelBetaInfo = bi;
    }

    public void initConstraintDerivatives(ConstrainedGLMUtils.LinearConstraints[] equalityConstraints, ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints, List<String> coeffNames) {
        boolean hasEqualityConstraints = equalityConstraints != null;
        boolean hasLessConstraints = lessThanEqualToConstraints != null;
        this._derivativeEqual = hasEqualityConstraints ? ComputationState.calDerivatives(equalityConstraints, coeffNames) : null;
        this._derivativeLess = hasLessConstraints ? ComputationState.calDerivatives(lessThanEqualToConstraints, coeffNames) : null;
        this._gramEqual = hasEqualityConstraints ? ComputationState.calGram(this._derivativeEqual) : null;
        this._gramLess = hasLessConstraints ? ComputationState.calGram(this._derivativeLess) : null;
    }

    public void updateConstraintInfo(ConstrainedGLMUtils.LinearConstraints[] equalityConstraints, ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints) {
        this.updateDerivativeActive(this._derivativeEqual, this._gramEqual, equalityConstraints);
        this.updateDerivativeActive(this._derivativeLess, this._gramLess, lessThanEqualToConstraints);
    }

    public void updateDerivativeActive(ConstrainedGLMUtils.ConstraintsDerivatives[] derivativesConst, ConstrainedGLMUtils.ConstraintsGram[] gramConst, ConstrainedGLMUtils.LinearConstraints[] constraints) {
        if (constraints != null) {
            IntStream.range(0, derivativesConst.length).forEach(index -> {
                derivativesConst[index]._active = constraints[index]._active;
                gramConst[index]._active = constraints[index]._active;
            });
        }
    }

    public void resizeConstraintInfo(ConstrainedGLMUtils.LinearConstraints[] equalityConstraints, ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints) {
        boolean hasEqualityConstraints = this._derivativeEqual != null;
        boolean hasLessConstraints = this._derivativeLess != null;
        List<String> coeffNames = Arrays.stream(this._activeData.coefNames()).collect(Collectors.toList());
        this._derivativeEqual = hasEqualityConstraints ? ComputationState.calDerivatives(equalityConstraints, coeffNames) : null;
        this._derivativeLess = hasLessConstraints ? ComputationState.calDerivatives(lessThanEqualToConstraints, coeffNames) : null;
        this._gramEqual = hasEqualityConstraints ? ComputationState.calGram(this._derivativeEqual) : null;
        this._gramLess = hasLessConstraints ? ComputationState.calGram(this._derivativeLess) : null;
    }

    public ComputationState(Job job, GLMModel.GLMParameters parms, DataInfo dinfo, GLM.BetaConstraint bc, GLM.BetaInfo bi, double[][][] penaltyMat, int[][] gamColInd) {
        this(job, parms, dinfo, bc, bi);
        this._penaltyMatrix = penaltyMat;
        this._gamBetaIndices = gamColInd;
        this._lambdaNull = this._parms._lambda == null && !this._parms._lambda_search;
    }

    void copyCheckModel2State(GLMModel model, int[][] _gamColIndices) {
        GLMModel.GLMOutput modelOutput = (GLMModel.GLMOutput)model._output;
        int coefLen = this._nbetas > 2 ? (this._dinfo.fullN() + 1) * this._nbetas : this._dinfo.fullN() + 1;
        int submodelInd = modelOutput._submodels.length > 1 ? modelOutput._submodels.length - 1 : 0;
        this.setIter(modelOutput._submodels[submodelInd].iteration);
        this.setAlpha(modelOutput._submodels[submodelInd].alpha_value);
        if (submodelInd > 0) {
            int preCurrSubmodelInd = GLMModel.GLMParameters.Family.gaussian.equals((Object)this._parms._family) ? submodelInd : submodelInd - 1;
            this._activeData._activeCols = modelOutput._submodels[preCurrSubmodelInd].idxs;
            double[] betaExpand = GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family) ? ArrayUtils.expandAndScatter(modelOutput._submodels[preCurrSubmodelInd].beta, coefLen, this._activeData._activeCols) : this.expandBeta(modelOutput._submodels[preCurrSubmodelInd].beta);
            GLM.GLMGradientInfo ginfo = new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, 0.0, this.activeBC(), this._modelBetaInfo, this._penaltyMatrix, _gamColIndices).getGradient(betaExpand);
            this._activeData._activeCols = null;
            this.updateState(betaExpand, ginfo);
            this.setLambdaSimple(this._parms._lambda[preCurrSubmodelInd]);
        }
        if (!GLMModel.GLMParameters.Family.gaussian.equals((Object)this._parms._family)) {
            this.setLambda(modelOutput._submodels[submodelInd].lambda_value);
        }
        double[] expandedBeta = modelOutput._submodels[submodelInd].idxs == null ? modelOutput._submodels[submodelInd].beta : ArrayUtils.expandAndScatter(modelOutput._submodels[submodelInd].beta, coefLen, modelOutput._submodels[submodelInd].idxs);
        GLM.GLMGradientInfo ginfo = new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, 0.0, this.activeBC(), this._modelBetaInfo, this._penaltyMatrix, _gamColIndices).getGradient(expandedBeta);
        this.updateState(expandedBeta, ginfo);
        if (model._betaCndCheckpoint != null && (this._activeData._activeCols == null || this._activeData._activeCols.length != model._betaCndCheckpoint.length)) {
            double[] betaCndCheckpoint = ArrayUtils.expandAndScatter(model._betaCndCheckpoint, coefLen, modelOutput._submodels[submodelInd].idxs);
            if (this._activeData._activeCols != null) {
                betaCndCheckpoint = ComputationState.extractSubRange(betaCndCheckpoint.length, 0, this.activeData()._activeCols, betaCndCheckpoint);
            }
            model._betaCndCheckpoint = betaCndCheckpoint;
        }
    }

    public void setZValues(double[] zValues, boolean dispersionEstimated) {
        this._zValues = zValues;
        this._dispersionEstimated = dispersionEstimated;
    }

    public boolean getLambdaNull() {
        return this._lambdaNull;
    }

    public GLM.GLMGradientSolver gslvr() {
        return this._gslvr;
    }

    public double lambda() {
        return this._lambda;
    }

    public double alpha() {
        return this._alpha;
    }

    public double[] zValues() {
        return this._zValues;
    }

    public boolean dispersionEstimated() {
        return this._dispersionEstimated;
    }

    public void setLambdaMax(double lmax) {
        this._lambdaMax = lmax;
    }

    public void setgMax(double gmax) {
        this._gMax = gmax;
    }

    public void setAlpha(double alpha) {
        this._alpha = alpha;
        this.setLambdaMax(this._gMax / Math.max(0.01, alpha));
    }

    public void setLambda(double lambda) {
        this.adjustToNewLambda(0.0, this._lambda);
        this.applyStrongRules(lambda, this._lambda);
        this._lambda = lambda;
        this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, this.l2pen(), this._activeBC, this._modelBetaInfo) : new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, this.l2pen(), this._activeBC, this._modelBetaInfo, this._penaltyMatrix, this._gamBetaIndices);
        this.adjustToNewLambda(lambda, 0.0);
    }

    public double[] beta() {
        if (this._activeClass != -1) {
            return this.betaMultinomial(this._activeClass, this._beta);
        }
        return this._beta;
    }

    public GLM.GLMGradientInfo ginfo() {
        return this._ginfo == null ? (this._ginfo = this.gslvr().getGradient(this.beta())) : this._ginfo;
    }

    public GLM.BetaConstraint activeBC() {
        return this._activeBC;
    }

    public double likelihood() {
        return this._likelihood;
    }

    public boolean ginfoNull() {
        return this._ginfo == null;
    }

    public DataInfo activeData() {
        if (this._activeClass != -1) {
            return this.activeDataMultinomial(this._activeClass);
        }
        return this._activeData;
    }

    public DataInfo activeDataMultinomial() {
        return this._activeData;
    }

    public void dropActiveData() {
        this._activeData = null;
    }

    public String toString() {
        return "iter=" + this._iter + " lmb=" + GLM.lambdaFormatter.format(this._lambda) + " alpha=" + GLM.lambdaFormatter.format(this._alpha) + " obj=" + MathUtils.roundToNDigits(this.objective(), 4) + " imp=" + GLM.lambdaFormatter.format(this._relImprovement) + " bdf=" + GLM.lambdaFormatter.format(this._betaDiff);
    }

    private void adjustToNewLambda(double lambdaNew, double lambdaOld) {
        double ldiff = lambdaNew - lambdaOld;
        if (ldiff == 0.0 || this.l2pen() == 0.0) {
            return;
        }
        double l2pen = 0.5 * ArrayUtils.l2norm2(this._beta, true);
        if (this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            l2pen /= (double)this._nbetas;
        }
        if (l2pen > 0.0) {
            if (this._ginfo == null) {
                this._ginfo = this.ginfo();
            }
            if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
                l2pen = 0.0;
                int off = 0;
                for (int c = 0; c < this._nbetas; ++c) {
                    DataInfo activeData = this.activeDataMultinomial(c);
                    for (int i = 0; i < activeData.fullN(); ++i) {
                        double b = this._beta[off + i];
                        int n = off + i;
                        this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * b;
                        l2pen += b * b;
                    }
                    if (this._parms._family == GLMModel.GLMParameters.Family.ordinal) break;
                    off += activeData.fullN() + 1;
                }
                l2pen *= 0.5;
            } else {
                for (int i = 0; i < this._activeData.fullN(); ++i) {
                    int n = i;
                    this._ginfo._gradient[n] = this._ginfo._gradient[n] + ldiff * this._beta[i];
                }
            }
        }
        this._ginfo = new GLM.GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal + ldiff * l2pen, this._ginfo._gradient);
    }

    public double l1pen() {
        return this._alpha * this._lambda;
    }

    public double l2pen() {
        return (1.0 - this._alpha) * this._lambda;
    }

    protected void applyStrongRules(double lambdaNew, double lambdaOld) {
        lambdaNew = Math.min(this._lambdaMax, lambdaNew);
        lambdaOld = Math.min(this._lambdaMax, lambdaOld);
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            this.applyStrongRulesMultinomial(lambdaNew, lambdaOld);
            return;
        }
        int P = this._dinfo.fullN();
        this._activeBC = this._bc;
        this._activeData = this._activeData != null ? this._activeData : this._dinfo;
        boolean bl = this._allIn = this._allIn || this._alpha * lambdaNew == 0.0 || this._activeBC.hasBounds() || this._parms._linear_constraints != null;
        if (!this._allIn) {
            int[] nArray;
            int newlySelected = 0;
            double rhs = Math.max(0.0, this._alpha * (2.0 * lambdaNew - lambdaOld));
            int[] newCols = MemoryManager.malloc4(P);
            int j = 0;
            if (this._activeData._activeCols == null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = P;
            } else {
                nArray = this._activeData.activeCols();
            }
            int[] oldActiveCols = nArray;
            for (int i = 0; i < P; ++i) {
                if (j < oldActiveCols.length && oldActiveCols[j] == i) {
                    ++j;
                    continue;
                }
                if (!(this._ginfo._gradient[i] > rhs) && !(-this._ginfo._gradient[i] > rhs)) continue;
                newCols[newlySelected++] = i;
            }
            if (this._parms._max_active_predictors != -1 && oldActiveCols.length + newlySelected - 1 > this._parms._max_active_predictors) {
                Integer[] bigInts = ArrayUtils.toIntegers(newCols, 0, newlySelected);
                Arrays.sort(bigInts, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return (int)Math.signum(((ComputationState)ComputationState.this)._ginfo._gradient[o2] * ((ComputationState)ComputationState.this)._ginfo._gradient[o2] - ((ComputationState)ComputationState.this)._ginfo._gradient[o1] * ((ComputationState)ComputationState.this)._ginfo._gradient[o1]);
                    }
                });
                newCols = ArrayUtils.toInt(bigInts, 0, this._parms._max_active_predictors - oldActiveCols.length + 1);
                Arrays.sort(newCols);
            } else {
                newCols = Arrays.copyOf(newCols, newlySelected);
            }
            newCols = ArrayUtils.sortedMerge(oldActiveCols, newCols);
            int active = newCols.length;
            boolean bl2 = this._allIn = active == P;
            if (!this._allIn) {
                int[] cols = newCols;
                assert (cols[active - 1] == P);
                this._beta = ArrayUtils.select(this._beta, cols);
                if (this._u != null) {
                    this._u = ArrayUtils.select(this._u, cols);
                }
                this._activeData = this._dinfo.filterExpandedColumns(cols);
                assert (this._activeData.activeCols().length == this._beta.length);
                assert (this._u == null || this._activeData.activeCols().length == this._u.length);
                this._ginfo = new GLM.GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal, ArrayUtils.select(this._ginfo._gradient, cols));
                this._activeBC = this._bc.filterExpandedColumns(this._activeData.activeCols());
                GLM.GLMGradientSolver gLMGradientSolver = this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._bc, this._modelBetaInfo) : new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, (1.0 - this._alpha) * this._lambda, this._bc, this._modelBetaInfo, this._penaltyMatrix, this._gamBetaIndices);
                assert (this._beta.length == cols.length);
                return;
            }
        }
        this._activeData = this._dinfo;
    }

    public DataInfo activeDataMultinomial(int c) {
        return this._activeDataMultinomial != null ? this._activeDataMultinomial[c] : this._dinfo;
    }

    public static double[] extractSubRange(int N, int c, int[] ids, double[] src) {
        if (ids == null) {
            return Arrays.copyOfRange(src, c * N, c * N + N);
        }
        double[] res = MemoryManager.malloc8d(ids.length);
        int j = 0;
        int off = c * N;
        for (int i : ids) {
            res[j++] = src[off + i];
        }
        return res;
    }

    static void fillSubRange(int N, int c, int[] ids, double[] src, double[] dst) {
        if (ids == null) {
            System.arraycopy(src, 0, dst, c * N, N);
        } else {
            int j = 0;
            int off = c * N;
            for (int i : ids) {
                dst[off + i] = src[j++];
            }
        }
    }

    public double[] betaMultinomial() {
        return this._beta;
    }

    public double[] betaMultinomial(int c, double[] beta) {
        return ComputationState.extractSubRange(this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols(), beta);
    }

    public double[] betaMultinomialFull(int c, double[] beta) {
        if (this._parms._remove_collinear_columns) {
            return ComputationState.extractSubRange(this._betaLengthPerClass, c, this._activeDataMultinomial[c].activeCols(), beta);
        }
        return ComputationState.extractSubRange(this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols(), beta);
    }

    public double[] shrinkFullArray(double[] fullArray) {
        if (this._activeData.activeCols() == null) {
            return fullArray;
        }
        int[] activeColsAllClass = ComputationState.genActiveColsAllClass(this._activeData.activeCols().length * this._nbetas, this._betaLengthPerClass, this._activeData.activeCols(), this._nbetas);
        return ArrayUtils.select(fullArray, activeColsAllClass);
    }

    public static double[] expandToFullArray(double[] shortenArr, int[] activeCols, int _totalBetaLength, int nclasses, int betaLengthPerClass) {
        if (activeCols == null) {
            return shortenArr;
        }
        int[] activeColsAllClass = ComputationState.genActiveColsAllClass(activeCols.length * nclasses, betaLengthPerClass, activeCols, nclasses);
        double[] fullArray = new double[_totalBetaLength];
        ComputationState.fillSubRange(_totalBetaLength, 0, activeColsAllClass, shortenArr, fullArray);
        return fullArray;
    }

    public static int[] genActiveColsAllClass(int activeColsLen, int numBetaPerClass, int[] activeColsOrig, int nclasses) {
        int[] activeCols = new int[activeColsLen];
        int offset = 0;
        int[] activeColsOneClass = activeColsOrig;
        for (int classIndex = 0; classIndex < nclasses; ++classIndex) {
            int finalOffset = numBetaPerClass * classIndex;
            int[] activeCols1Class = IntStream.of(activeColsOneClass).map(i -> i + finalOffset).toArray();
            int num2Copy = activeColsOneClass.length;
            System.arraycopy(activeCols1Class, 0, activeCols, offset, num2Copy);
            offset += num2Copy;
        }
        return activeCols;
    }

    public int[] genActiveColsIndClass(int activeColsLen, int numBetaPerClass, int[] activeColsOrig, int activeClass, int nclasses) {
        int finalOffset;
        int[] activeCols = new int[activeColsLen];
        int offset = 0;
        int[] activeColsOneClass = activeColsOrig;
        for (int classIndex = 0; classIndex < activeClass; ++classIndex) {
            finalOffset = numBetaPerClass * classIndex;
            int num2Copy = activeColsOneClass.length;
            int[] activeCols1Class = IntStream.of(activeColsOneClass).map(i -> i + finalOffset).toArray();
            System.arraycopy(activeCols1Class, 0, activeCols, offset, num2Copy);
            offset += num2Copy;
        }
        for (int classInd = activeClass; classInd < nclasses; ++classInd) {
            finalOffset = numBetaPerClass * classInd;
            int[] activeCols1Class = IntStream.range(0, numBetaPerClass).map(i -> i + finalOffset).toArray();
            System.arraycopy(activeCols1Class, 0, activeCols, offset, numBetaPerClass);
            offset += numBetaPerClass;
        }
        return activeCols;
    }

    public GLMSubsetGinfo ginfoMultinomial(int c) {
        return new GLMSubsetGinfo(this._ginfo, this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols());
    }

    public GLMSubsetGinfo ginfoMultinomialRCC(int c) {
        if (this._activeData.fullN() + 1 == this._activeData.activeCols().length) {
            return new GLMSubsetGinfo(this._ginfo, this._activeData.fullN() + 1, c, IntStream.range(0, this._activeData.activeCols().length).toArray());
        }
        return new GLMSubsetGinfo(this._ginfo, this._activeData.fullN() + 1, c, this._activeData.activeCols());
    }

    public void setBC(GLM.BetaConstraint bc) {
        this._activeBC = this._bc = bc;
    }

    public void setLinearConstraints(ConstrainedGLMUtils.LinearConstraints[] equalityC, ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToC, boolean forBeta) {
        if (forBeta) {
            this._equalityConstraintsBeta = equalityC.length == 0 ? null : equalityC;
            this._lessThanEqualToConstraintsBeta = lessThanEqualToC.length == 0 ? null : lessThanEqualToC;
        } else {
            this._equalityConstraintsLinear = equalityC.length == 0 ? null : equalityC;
            this._lessThanEqualToConstraintsLinear = lessThanEqualToC.length == 0 ? null : lessThanEqualToC;
        }
    }

    public void setActiveClass(int activeClass) {
        this._activeClass = activeClass;
    }

    public double deviance() {
        switch (this._parms._family) {
            case gaussian: 
            case binomial: 
            case quasibinomial: 
            case ordinal: 
            case multinomial: 
            case fractionalbinomial: {
                return 2.0 * this.likelihood();
            }
            case poisson: 
            case gamma: 
            case negativebinomial: 
            case tweedie: {
                return this.likelihood();
            }
        }
        throw new RuntimeException("unknown family " + (Object)((Object)this._parms._family));
    }

    public OptimizationUtils.GradientSolver gslvrMultinomial(final int c) {
        double[] betaCopy = new double[this._totalBetaLength];
        if (this._beta.length < this._totalBetaLength) {
            int[] activeCols;
            if (this._beta.length == this._activeData.activeCols().length * this._nbetas) {
                activeCols = ComputationState.genActiveColsAllClass(this._beta.length, this._betaLengthPerClass, this._activeData.activeCols(), this._nbetas);
                ComputationState.fillSubRange(this._totalBetaLength, 0, activeCols, this._beta, betaCopy);
            } else {
                activeCols = this.genActiveColsIndClass(this._beta.length, this._betaLengthPerClass, this._activeData.activeCols(), c, this._nbetas);
                ComputationState.fillSubRange(this._totalBetaLength, 0, activeCols, this._beta, betaCopy);
            }
        } else {
            System.arraycopy(this._beta, 0, betaCopy, 0, this._totalBetaLength);
        }
        final double[] fullbeta = betaCopy;
        return new OptimizationUtils.GradientSolver(){

            @Override
            public OptimizationUtils.GradientInfo getGradient(double[] beta) {
                ComputationState.fillSubRange(ComputationState.this._dinfo.fullN() + 1, c, ComputationState.this._activeDataMultinomial[c].activeCols(), beta, fullbeta);
                GLM.GLMGradientInfo fullGinfo = ComputationState.this._gslvr.getGradient(fullbeta);
                if (fullbeta.length > fullGinfo._gradient.length) {
                    double[] fullGinfoGradient = ComputationState.expandToFullArray(fullGinfo._gradient, ComputationState.this._activeData.activeCols(), ComputationState.this._totalBetaLength, ComputationState.this._nbetas, ComputationState.this._betaLengthPerClass);
                    fullGinfo._gradient = fullGinfoGradient;
                }
                return new GLMSubsetGinfo(fullGinfo, ComputationState.this._betaLengthPerClass, c, ComputationState.this._activeData.activeCols());
            }

            @Override
            public OptimizationUtils.GradientInfo getObjective(double[] beta) {
                return this.getGradient(beta);
            }
        };
    }

    public void setBetaMultinomial(int c, double[] beta, double[] bc) {
        if (this._u != null) {
            Arrays.fill(this._u, 0.0);
        }
        if (this._parms._remove_collinear_columns) {
            ComputationState.fillSubRange(this._betaLengthPerClass, c, this._activeDataMultinomial[c].activeCols(), bc, beta);
        } else {
            ComputationState.fillSubRange(this._activeData.fullN() + 1, c, this._activeDataMultinomial[c].activeCols(), bc, beta);
        }
    }

    protected int applyStrongRulesMultinomial_old(double lambdaNew, double lambdaOld) {
        int P = this._dinfo.fullN();
        int N = P + 1;
        int selected = 0;
        this._activeBC = this._bc;
        this._activeData = this._dinfo;
        if (!this._allIn) {
            if (this._activeDataMultinomial == null) {
                this._activeDataMultinomial = new DataInfo[this._nbetas];
            }
            double rhs = this._alpha * (2.0 * lambdaNew - lambdaOld);
            int[] oldActiveCols = this._activeData._activeCols == null ? new int[]{} : this._activeData.activeCols();
            int[] cols = MemoryManager.malloc4(N * this._nbetas);
            int j = 0;
            for (int c = 0; c < this._nbetas; ++c) {
                int i;
                int start = selected;
                for (i = 0; i < P; ++i) {
                    if (j < oldActiveCols.length && i == oldActiveCols[j]) {
                        cols[selected++] = i;
                        ++j;
                        continue;
                    }
                    if (!(this._ginfo._gradient[c * N + i] > rhs) && !(this._ginfo._gradient[c * N + i] < -rhs)) continue;
                    cols[selected++] = i;
                }
                cols[selected++] = P;
                this._activeDataMultinomial[c] = this._dinfo.filterExpandedColumns(Arrays.copyOfRange(cols, start, selected));
                i = start;
                while (i < selected) {
                    int n = i++;
                    cols[n] = cols[n] + c * N;
                }
            }
            this._allIn = selected == cols.length;
        }
        return selected;
    }

    protected void applyStrongRulesMultinomial(double lambdaNew, double lambdaOld) {
        int P = this._dinfo.fullN();
        int N = P + 1;
        int selected = 0;
        this._activeBC = this._bc;
        this._activeData = this._dinfo;
        if (!this._allIn) {
            if (this._activeDataMultinomial == null) {
                this._activeDataMultinomial = new DataInfo[this._nbetas];
            }
            double rhs = this._alpha * (2.0 * lambdaNew - lambdaOld);
            int[] cols = MemoryManager.malloc4(N * this._nbetas);
            int oldActiveColsTotal = 0;
            for (int c = 0; c < this._nbetas; ++c) {
                int[] nArray;
                int j = 0;
                if (this._activeDataMultinomial[c] == null) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = P;
                } else {
                    nArray = this._activeDataMultinomial[c]._activeCols;
                }
                int[] oldActiveCols = nArray;
                oldActiveColsTotal += oldActiveCols.length;
                for (int i = 0; i < P; ++i) {
                    if (j < oldActiveCols.length && i == oldActiveCols[j]) {
                        ++j;
                        continue;
                    }
                    if (this._ginfo == null) {
                        this._ginfo = this.ginfo();
                    }
                    if (!(this._ginfo._gradient[c * N + i] > rhs) && !(this._ginfo._gradient[c * N + i] < -rhs)) continue;
                    cols[selected++] = c * N + i;
                }
            }
            if (this._parms._max_active_predictors != -1 && this._parms._max_active_predictors - oldActiveColsTotal + this._nbetas < selected) {
                Integer[] bigInts = ArrayUtils.toIntegers(cols, 0, selected);
                Arrays.sort(bigInts, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return (int)Math.signum(((ComputationState)ComputationState.this)._ginfo._gradient[o2] * ((ComputationState)ComputationState.this)._ginfo._gradient[o2] - ((ComputationState)ComputationState.this)._ginfo._gradient[o1] * ((ComputationState)ComputationState.this)._ginfo._gradient[o1]);
                    }
                });
                cols = ArrayUtils.toInt(bigInts, 0, this._parms._max_active_predictors - oldActiveColsTotal + this._nbetas);
                Arrays.sort(cols);
                selected = cols.length;
            }
            int i = 0;
            int[] cs = new int[P + 1];
            int sum = 0;
            for (int c = 0; c < this._nbetas; ++c) {
                int[] nArray;
                int[] classcols = cs;
                if (this._activeDataMultinomial[c] == null) {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = P;
                } else {
                    nArray = this._activeDataMultinomial[c]._activeCols;
                }
                int[] oldActiveCols = nArray;
                int k = 0;
                while (i < selected && cols[i] < (c + 1) * N) {
                    classcols[k++] = cols[i++] - c * N;
                }
                classcols = ArrayUtils.sortedMerge(oldActiveCols, Arrays.copyOf(classcols, k));
                sum += classcols.length;
                this._activeDataMultinomial[c] = this._dinfo.filterExpandedColumns(classcols);
            }
            assert (this._parms._max_active_predictors == -1 || sum <= this._parms._max_active_predictors + this._nbetas) : "sum = " + sum + " max_active_preds = " + this._parms._max_active_predictors + ", nclasses = " + this._nbetas;
            this._allIn = sum == N * this._nbetas;
        }
    }

    protected boolean checkKKTsMultinomial() {
        return true;
    }

    protected boolean checkKKTs() {
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            return this.checkKKTsMultinomial();
        }
        double[] beta = this._beta;
        double[] u = this._u;
        if (this._activeData._activeCols != null) {
            beta = ArrayUtils.expandAndScatter(beta, this._dinfo.fullN() + 1, this._activeData._activeCols);
            if (this._u != null) {
                u = ArrayUtils.expandAndScatter(this._u, this._dinfo.fullN() + 1, this._activeData._activeCols);
            }
        }
        int[] activeCols = this._activeData.activeCols();
        if (beta != this._beta || this._ginfo == null) {
            this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, (1.0 - this._alpha) * this._lambda, this._bc, this._modelBetaInfo) : new GLM.GLMGradientSolver(this._job, this._parms, this._dinfo, (1.0 - this._alpha) * this._lambda, this._bc, this._modelBetaInfo, this._penaltyMatrix, this._gamBetaIndices);
            this._ginfo = this._gslvr.getGradient(beta);
        }
        double[] grad = (double[])this._ginfo._gradient.clone();
        double err = 1.0E-4;
        if (u != null && u != this._u) {
            int k = 0;
            for (int i = 0; i < u.length; ++i) {
                if (this._activeData._activeCols[k] == i) {
                    ++k;
                    continue;
                }
                assert (u[i] == 0.0);
                u[i] = -grad[i];
            }
        }
        ADMM.subgrad(this._alpha * this._lambda, beta, grad);
        for (int c : activeCols) {
            if (grad[c] > err) {
                err = grad[c];
                continue;
            }
            if (!(grad[c] < -err)) continue;
            err = -grad[c];
        }
        this._gradientErr = err;
        this._beta = beta;
        this._u = u;
        this._activeBC = null;
        if (this._parms._max_active_predictors == this._activeData.fullN()) {
            Log.info("skipping KKT check, reached maximum number of active predictors (" + this._parms._max_active_predictors + ")");
        } else if (!this._allIn) {
            int[] failedCols = new int[64];
            int fcnt = 0;
            for (int i = 0; i < grad.length - 1; ++i) {
                if (Arrays.binarySearch(activeCols, i) >= 0 || !(grad[i] > err) && !(-grad[i] > err)) continue;
                if (fcnt == failedCols.length) {
                    failedCols = Arrays.copyOf(failedCols, failedCols.length << 1);
                }
                failedCols[fcnt++] = i;
            }
            if (fcnt > 0) {
                Log.info(fcnt + " variables failed KKT conditions, adding them to the model and recomputing.");
                int n = activeCols.length;
                int[] newCols = Arrays.copyOf(activeCols, activeCols.length + fcnt);
                for (int i = 0; i < fcnt; ++i) {
                    newCols[n + i] = failedCols[i];
                }
                Arrays.sort(newCols);
                this._beta = ArrayUtils.select(beta, newCols);
                if (this._u != null) {
                    this._u = ArrayUtils.select(this._u, newCols);
                }
                this._ginfo = new GLM.GLMGradientInfo(this._ginfo._likelihood, this._ginfo._objVal, ArrayUtils.select(this._ginfo._gradient, newCols));
                this._activeData = this._dinfo.filterExpandedColumns(newCols);
                this._activeBC = this._bc.filterExpandedColumns(this._activeData.activeCols());
                this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC, this._modelBetaInfo) : new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC, this._modelBetaInfo, this._penaltyMatrix, this._gamBetaIndices);
                return false;
            }
        }
        return true;
    }

    public void addOffset2Cols(int[] cols) {
        int offset = this._activeClass * this._activeData.activeCols().length;
        int colsLen = cols.length;
        for (int index = 0; index < colsLen; ++index) {
            cols[index] = cols[index] + offset;
        }
    }

    public int[] removeCols(int[] cols) {
        int[] activeCols;
        int[] colsWOffset = (int[])cols.clone();
        if (this._nbetas > 2 && this._parms._remove_collinear_columns) {
            activeCols = ArrayUtils.removeIds(this._activeDataMultinomial[this._activeClass].activeCols(), cols);
            this.addOffset2Cols(colsWOffset);
        } else {
            activeCols = ArrayUtils.removeIds(this._activeData.activeCols(), cols);
        }
        if (this._beta != null) {
            this._beta = ArrayUtils.removeIds(this._beta, colsWOffset);
        }
        if (this._u != null) {
            this._u = ArrayUtils.removeIds(this._u, colsWOffset);
        }
        if (this._ginfo != null && this._ginfo._gradient != null) {
            this._ginfo._gradient = ArrayUtils.removeIds(this._ginfo._gradient, colsWOffset);
        }
        this._activeData = this._dinfo.filterExpandedColumns(activeCols);
        this._activeBC = this._bc.filterExpandedColumns(activeCols);
        this._gslvr = this._penaltyMatrix == null ? new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC, this._modelBetaInfo) : new GLM.GLMGradientSolver(this._job, this._parms, this._activeData, (1.0 - this._alpha) * this._lambda, this._activeBC, this._modelBetaInfo, this._penaltyMatrix, this._gamBetaIndices);
        this._currGram = null;
        return activeCols;
    }

    private double penalty(double[] beta) {
        if (this._lambda == 0.0) {
            return 0.0;
        }
        double l1norm = 0.0;
        double l2norm = 0.0;
        if (this._parms._family == GLMModel.GLMParameters.Family.multinomial || this._parms._family == GLMModel.GLMParameters.Family.ordinal) {
            int len = beta.length / this._nbetas;
            assert (len * this._nbetas == beta.length);
            for (int c = 0; c < this._nbetas; ++c) {
                for (int i = c * len; i < (c + 1) * len - 1; ++i) {
                    double d = beta[i];
                    l1norm += d >= 0.0 ? d : -d;
                    l2norm += d * d;
                }
                if (this._parms._family != GLMModel.GLMParameters.Family.ordinal) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < beta.length - 1; ++i) {
                double d = beta[i];
                l1norm += d >= 0.0 ? d : -d;
                l2norm += d * d;
            }
        }
        return this.l1pen() * l1norm + 0.5 * this.l2pen() * l2norm;
    }

    public double objective() {
        return this._beta == null ? Double.MAX_VALUE : this.objective(this._beta, this._likelihood);
    }

    public double objective(double[] beta, double likelihood) {
        double gamVal = 0.0;
        if (this._parms._glmType == GLMModel.GLMParameters.GLMType.gam) {
            gamVal = beta.length == this._totalBetaLength ? GLMUtils.calSmoothNess(beta, this._penaltyMatrix, this._gamBetaIndices) : GLMUtils.calSmoothNess(this.expandBeta(beta), this._penaltyMatrix, this._gamBetaIndices);
        }
        if (this._csGLMState != null && (this._equalityConstraints != null || this._lessThanEqualToConstraints != null)) {
            return this._ginfo._objVal;
        }
        return likelihood * this._parms._obj_reg + gamVal + this.penalty(beta) + (this._activeBC == null ? 0.0 : this._activeBC.proxPen(beta));
    }

    public static ConstrainedGLMUtils.ConstraintsDerivatives[] calDerivatives(ConstrainedGLMUtils.LinearConstraints[] constraints, List<String> coefNames) {
        int numConstraints = constraints.length;
        ConstrainedGLMUtils.ConstraintsDerivatives[] constDeriv = new ConstrainedGLMUtils.ConstraintsDerivatives[numConstraints];
        for (int index = 0; index < numConstraints; ++index) {
            ConstrainedGLMUtils.LinearConstraints oneConstraint = constraints[index];
            constDeriv[index] = ComputationState.genOneDerivative(oneConstraint, coefNames);
        }
        return constDeriv;
    }

    public static ConstrainedGLMUtils.ConstraintsDerivatives genOneDerivative(ConstrainedGLMUtils.LinearConstraints oneConstraints, List<String> coeffNames) {
        ConstrainedGLMUtils.ConstraintsDerivatives constraintDerivative = new ConstrainedGLMUtils.ConstraintsDerivatives(oneConstraints._active);
        IcedHashMap<String, Double> coeffNameValues = oneConstraints._constraints;
        for (String coefName : coeffNameValues.keySet()) {
            int index = coeffNames.indexOf(coefName);
            if (index < 0) continue;
            constraintDerivative._constraintsDerivative.put(index, (Double)coeffNameValues.get(coefName));
        }
        return constraintDerivative;
    }

    public static ConstrainedGLMUtils.ConstraintsGram[] calGram(ConstrainedGLMUtils.ConstraintsDerivatives[] derivativeEqual) {
        return (ConstrainedGLMUtils.ConstraintsGram[])Arrays.stream(derivativeEqual).map(x -> ComputationState.constructGram(x)).toArray(ConstrainedGLMUtils.ConstraintsGram[]::new);
    }

    public static ConstrainedGLMUtils.ConstraintsGram constructGram(ConstrainedGLMUtils.ConstraintsDerivatives constDeriv) {
        ConstrainedGLMUtils.ConstraintsGram cGram = new ConstrainedGLMUtils.ConstraintsGram();
        List predictorIndexc = constDeriv._constraintsDerivative.keySet().stream().collect(Collectors.toList());
        Collections.sort(predictorIndexc);
        while (!predictorIndexc.isEmpty()) {
            Integer firstEle = (Integer)predictorIndexc.get(0);
            for (Integer oneCoeff : predictorIndexc) {
                ConstrainedGLMUtils.CoefIndices coefPairs = new ConstrainedGLMUtils.CoefIndices(firstEle, oneCoeff);
                cGram._coefIndicesValue.put(coefPairs, (Double)constDeriv._constraintsDerivative.get(firstEle) * (Double)constDeriv._constraintsDerivative.get(oneCoeff));
            }
            predictorIndexc.remove(0);
        }
        cGram._active = constDeriv._active;
        return cGram;
    }

    protected double updateState(double[] beta, double likelihood) {
        this._betaDiff = ArrayUtils.linfnorm(this._beta == null ? beta : ArrayUtils.subtract(this._beta, beta), false);
        double objOld = this.objective();
        this._beta = beta;
        this._ginfo = null;
        this._likelihood = likelihood;
        this._relImprovement = (objOld - this.objective()) / Math.abs(objOld);
        return this._relImprovement;
    }

    public boolean converged() {
        boolean converged = false;
        if (this._betaDiff < this._parms._beta_epsilon) {
            this.convergenceMsg = "betaDiff < eps; betaDiff = " + this._betaDiff + ", eps = " + this._parms._beta_epsilon;
            converged = true;
        } else if (this._relImprovement < this._parms._objective_epsilon) {
            this.convergenceMsg = "relImprovement < eps; relImprovement = " + this._relImprovement + ", eps = " + this._parms._objective_epsilon;
            converged = true;
        } else {
            this.convergenceMsg = "not converged, betaDiff = " + this._betaDiff + ", relImprovement = " + this._relImprovement;
        }
        return converged;
    }

    public double updateState(double[] beta, GLM.GLMGradientInfo ginfo) {
        double objOld;
        if (this._beta != null && beta.length > this._beta.length) {
            double[] shortBeta = this.shrinkFullArray(beta);
            this._betaDiff = ArrayUtils.linfnorm(this._beta == null ? beta : ArrayUtils.subtract(this._beta, shortBeta), false);
            objOld = this.objective();
            if (this._beta == null) {
                this._beta = (double[])shortBeta.clone();
            } else {
                System.arraycopy(shortBeta, 0, this._beta, 0, shortBeta.length);
            }
        } else {
            this._betaDiff = ArrayUtils.linfnorm(this._beta == null ? beta : ArrayUtils.subtract(this._beta, beta), false);
            objOld = this.objective();
            if (this._beta == null) {
                this._beta = (double[])beta.clone();
            } else {
                System.arraycopy(beta, 0, this._beta, 0, beta.length);
            }
        }
        this._ginfo = ginfo;
        this._likelihood = ginfo._likelihood;
        this._relImprovement = (objOld - this.objective()) / Math.abs(objOld);
        return this._relImprovement;
    }

    double getBetaDiff() {
        return this._betaDiff;
    }

    protected void setBetaDiff(double betaDiff) {
        this._betaDiff = betaDiff;
    }

    protected void setGradientErr(double gErr) {
        this._gradientErr = gErr;
    }

    protected void setGinfo(GLM.GLMGradientInfo ginfo) {
        this._ginfo = GLMUtils.copyGInfo(ginfo);
    }

    protected void setBeta(double[] beta) {
        if (this._beta == null) {
            this._beta = (double[])beta.clone();
        } else {
            System.arraycopy(beta, 0, this._beta, 0, beta.length);
        }
    }

    protected void setIter(int iteration) {
        this._iter = iteration;
    }

    protected void setLikelihood(double llk) {
        this._likelihood = llk;
    }

    protected void setAllIn(boolean val) {
        this._allIn = val;
    }

    protected void setGslvrNull() {
        this._gslvr = null;
    }

    protected void setActiveDataMultinomialNull() {
        this._activeDataMultinomial = null;
    }

    protected void setActiveDataNull() {
        this._activeData = null;
    }

    protected void setLambdaSimple(double lambda) {
        this._lambda = lambda;
    }

    public double[] expandBeta(double[] beta) {
        int fullCoefLen = (this._dinfo.fullN() + 1) * this._nbetas;
        if (this._activeData._activeCols == null || beta.length == fullCoefLen) {
            return beta;
        }
        if (this._nbetas <= 2 || !this._parms._remove_collinear_columns) {
            return ArrayUtils.expandAndScatter(beta, (this._dinfo.fullN() + 1) * this._nbetas, this._activeData._activeCols);
        }
        return ComputationState.expandToFullArray(beta, this._activeData.activeCols(), this._totalBetaLength, this._nbetas, this._betaLengthPerClass);
    }

    protected GramXY computeNewGram(DataInfo activeData, double[] beta, GLMModel.GLMParameters.Solver s) {
        GramXY res;
        Object[] activeCols;
        double obj_reg = this._parms._obj_reg;
        if (this._glmw == null) {
            this._glmw = new GLMModel.GLMWeightsFun(this._parms);
        }
        GLMTask.GLMIterationTask gt = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(this._job._key, activeData, this._glmw, beta, this._activeClass).doAll(activeData._adaptedFrame);
        gt._gram.mul(obj_reg);
        if (this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam)) {
            activeCols = null;
            int[] activeColumns = activeData.activeCols();
            if (activeColumns.length < this._dinfo.fullN()) {
                activeCols = ArrayUtils.toIntegers(activeColumns, 0, activeColumns.length);
            }
            gt._gram.addGAMPenalty((Integer[])activeCols, this._penaltyMatrix, this._gamBetaIndices);
        }
        ArrayUtils.mult(gt._xy, obj_reg);
        activeCols = activeData.activeCols();
        int[] zeros = gt._gram.findZeroCols();
        if (this._parms._family != GLMModel.GLMParameters.Family.multinomial && zeros.length > 0 && zeros.length <= activeData.activeCols().length) {
            gt._gram.dropCols(zeros);
            this.removeCols(zeros);
            res = new GramXY(gt._gram, ArrayUtils.removeIds(gt._xy, zeros), null, gt._beta == null ? null : ArrayUtils.removeIds(gt._beta, zeros), this.activeData().activeCols(), null, gt._yy, gt._likelihood);
        } else {
            res = new GramXY(gt._gram, gt._xy, null, beta, (int[])activeCols, null, gt._yy, gt._likelihood);
        }
        if (GLMModel.GLMParameters.Family.gaussian.equals((Object)this._parms._family)) {
            res.sumOfRowWeights = gt.sumOfRowWeights;
        }
        return res;
    }

    public GramXY computeGramRCC(double[] beta, GLMModel.GLMParameters.Solver s) {
        return this.computeNewGram(this._activeData, ArrayUtils.select(beta, this._activeData.activeCols()), s);
    }

    protected GramGrad computeGram(double[] beta, GLM.GLMGradientInfo gradientInfo) {
        DataInfo activeData = this.activeData();
        double obj_reg = this._parms._obj_reg;
        if (this._glmw == null) {
            this._glmw = new GLMModel.GLMWeightsFun(this._parms);
        }
        GLMTask.GLMIterationTask gt = (GLMTask.GLMIterationTask)new GLMTask.GLMIterationTask(this._job._key, activeData, this._glmw, beta, this._activeClass).doAll(activeData._adaptedFrame);
        double[][] fullGram = gt._gram.getXX();
        ArrayUtils.mult(fullGram, obj_reg);
        if (this._gramEqual != null) {
            ArrayUtils.elementwiseSumSymmetricArrays(fullGram, ArrayUtils.mult(ConstrainedGLMUtils.sumGramConstribution(this._gramEqual, fullGram.length), this._csGLMState._ckCS));
        }
        if (this._gramLess != null) {
            ArrayUtils.elementwiseSumSymmetricArrays(fullGram, ArrayUtils.mult(ConstrainedGLMUtils.sumGramConstribution(this._gramLess, fullGram.length), this._csGLMState._ckCS));
        }
        if (this._parms._glmType.equals((Object)GLMModel.GLMParameters.GLMType.gam)) {
            gt._gram.addGAMPenalty(this._penaltyMatrix, this._gamBetaIndices, fullGram);
        }
        double[] xy = ComputationState.formXY(fullGram, beta, gradientInfo._gradient);
        int[] zeros = GramGrad.findZeroCols(fullGram);
        if (this._parms._family != GLMModel.GLMParameters.Family.multinomial && zeros.length > 0 && zeros.length <= activeData.activeCols().length) {
            fullGram = GramGrad.dropCols(zeros, fullGram);
            this.removeCols(zeros);
            return new GramGrad(fullGram, ArrayUtils.removeIds(gradientInfo._gradient, zeros), ArrayUtils.removeIds(beta, zeros), gradientInfo._objVal, gt.sumOfRowWeights, ArrayUtils.removeIds(xy, zeros));
        }
        return new GramGrad(fullGram, gradientInfo._gradient, beta, gradientInfo._objVal, gt.sumOfRowWeights, xy);
    }

    public static double addConstraintObj(double[] lambda, ConstrainedGLMUtils.LinearConstraints[] constraints, double ckHalf) {
        int numConstraints = constraints.length;
        double objValueAdd = 0.0;
        for (int index = 0; index < numConstraints; ++index) {
            ConstrainedGLMUtils.LinearConstraints oneC = constraints[index];
            if (!oneC._active) continue;
            objValueAdd += lambda[index] * oneC._constraintsVal;
            objValueAdd += ckHalf * oneC._constraintsVal * oneC._constraintsVal;
        }
        return objValueAdd;
    }

    public static double[] formXY(double[][] fullGram, double[] beta, double[] grad) {
        int len = grad.length;
        double[] xy = new double[len];
        ArrayUtils.multArrVec(fullGram, beta, xy);
        return IntStream.range(0, len).mapToDouble(x -> xy[x] - grad[x]).toArray();
    }

    public GramXY computeGram(double[] beta, GLMModel.GLMParameters.Solver s) {
        boolean weighted;
        double obj_reg = this._parms._obj_reg;
        boolean bl = weighted = !GLMModel.GLMParameters.Family.gaussian.equals((Object)this._parms._family) || !GLMModel.GLMParameters.Link.identity.equals((Object)this._parms._link);
        if (GLMModel.GLMParameters.Family.multinomial.equals((Object)this._parms._family)) {
            return this.computeNewGram(this.activeDataMultinomial(this._activeClass), beta, s);
        }
        if (s != GLMModel.GLMParameters.Solver.COORDINATE_DESCENT) {
            return this.computeNewGram(this.activeData(), beta, s);
        }
        if (this._currGram == null) {
            this._currGram = this.computeNewGram(this.activeData(), beta, s);
            return this._currGram;
        }
        DataInfo activeData = this.activeData();
        assert (beta == null || beta.length == activeData.fullN() + 1);
        int[] activeCols = activeData.activeCols();
        if (Arrays.equals(this._currGram.activeCols, activeCols)) {
            return !weighted || Arrays.equals(this._currGram.beta, beta) ? this._currGram : (this._currGram = this.computeNewGram(activeData, beta, s));
        }
        if (this._glmw == null) {
            this._glmw = new GLMModel.GLMWeightsFun(this._parms);
        }
        if (this._currGram != null) {
            int[] newCols = ArrayUtils.sorted_set_diff(activeCols, this._currGram.activeCols);
            int[] newColsIds = (int[])newCols.clone();
            int jj = 0;
            boolean matches = true;
            int k = 0;
            for (int i = 0; i < activeCols.length; ++i) {
                if (jj < newCols.length && activeCols[i] == newCols[jj]) {
                    newColsIds[jj++] = i;
                    matches = matches && (beta == null || beta[i] == 0.0);
                    continue;
                }
                matches = matches && (beta == null || beta[i] == this._currGram.beta[k++]);
            }
            if (!weighted || matches) {
                GLMTask.GLMIncrementalGramTask gt = (GLMTask.GLMIncrementalGramTask)new GLMTask.GLMIncrementalGramTask(newColsIds, activeData, this._glmw, beta).doAll(activeData._adaptedFrame);
                for (double[] d : gt._gram) {
                    ArrayUtils.mult(d, obj_reg);
                }
                ArrayUtils.mult(gt._xy, obj_reg);
                this._currGram = GramXY.addCols(beta, activeCols, newColsIds, this._currGram, gt._gram, gt._xy);
                return this._currGram;
            }
        }
        this._currGram = this.computeNewGram(activeData, beta, s);
        return this._currGram;
    }

    public void setConstraintInfo(GLM.GLMGradientInfo gradientInfo, ConstrainedGLMUtils.LinearConstraints[] equalityConstraints, ConstrainedGLMUtils.LinearConstraints[] lessThanEqualToConstraints, double[] lambdaEqual, double[] lambdaLessThan) {
        this._ginfo = gradientInfo;
        this._lessThanEqualToConstraints = lessThanEqualToConstraints;
        this._equalityConstraints = equalityConstraints;
        this._lambdaEqual = lambdaEqual;
        this._lambdaLessThanEqualTo = lambdaLessThan;
        this._likelihood = gradientInfo._likelihood;
    }

    public static final class GramXY {
        public final Gram gram;
        final double[] beta;
        final int[] activeCols;
        int[] newCols;
        public final double[] xy;
        private double[] grads;
        public double yy;
        public final double likelihood;
        public double sumOfRowWeights;

        public GramXY(Gram gram, double[] xy, double[] grads, double[] beta, int[] activeCols, int[] newActiveCols, double yy, double likelihood) {
            this.gram = gram;
            this.xy = xy;
            this.grads = grads;
            this.beta = beta == null ? null : (double[])beta.clone();
            this.activeCols = activeCols == null ? null : (int[])activeCols.clone();
            this.newCols = newActiveCols;
            this.yy = yy;
            this.likelihood = likelihood;
        }

        public final double[] getCODGradients() {
            double[][] xx;
            if (this.grads == null) {
                xx = this.gram.getXX();
                this.grads = new double[this.xy.length];
                for (int i = 0; i < this.grads.length; ++i) {
                    this.grads[i] = this.xy[i] - ArrayUtils.innerProduct(xx[i], this.beta) + xx[i][i] * this.beta[i];
                }
            }
            if (this.newCols != null) {
                xx = this.gram.getXX();
                for (int i : this.newCols) {
                    this.grads[i] = this.xy[i] - ArrayUtils.innerProduct(xx[i], this.beta) + xx[i][i] * this.beta[i];
                }
            }
            return this.grads;
        }

        public boolean match(double[] beta, int[] activeCols) {
            return Arrays.equals(this.beta, beta) && Arrays.equals(this.activeCols, activeCols);
        }

        static double[] mergeRow(int k, double[] xrowOld, double[] xrow, int[] newColsIds, double[][] xxUpdate) {
            int j;
            for (int i = 0; i < newColsIds.length; ++i) {
                int l;
                j = newColsIds[i];
                xrow[j] = xxUpdate[i][k];
                int n = l = i == 0 ? 0 : newColsIds[i - 1] + 1;
                while (l < j) {
                    xrow[l] = xrowOld[l - i];
                    ++l;
                }
            }
            int l = newColsIds.length;
            for (j = newColsIds[newColsIds.length - 1] + 1; j < xrow.length; ++j) {
                xrow[j] = xrowOld[j - l];
            }
            return xrow;
        }

        public static GramXY addCols(double[] beta, int[] newActiveCols, int[] newColsIds, GramXY oldGram, double[][] xxUpdate, double[] xyUpdate) {
            int k;
            double[][] xxCacheNew = new double[newActiveCols.length][];
            double[] xyNew = new double[xxCacheNew.length];
            double[] gradsNew = oldGram.grads == null ? null : new double[xxCacheNew.length];
            double[][] xx = oldGram.gram.getXX();
            for (k = 0; k < newColsIds.length; ++k) {
                int i;
                int j = newColsIds[k];
                xxCacheNew[j] = xxUpdate[k];
                xyNew[j] = xyUpdate[k];
                int n = i = k == 0 ? 0 : newColsIds[k - 1] + 1;
                while (i < j) {
                    xxCacheNew[i] = GramXY.mergeRow(i, xx[i - k], new double[newActiveCols.length], newColsIds, xxUpdate);
                    xyNew[i] = oldGram.xy[i - k];
                    if (oldGram.grads != null) {
                        gradsNew[i] = oldGram.grads[i - k];
                    }
                    ++i;
                }
            }
            k = newColsIds.length;
            for (int i = newColsIds[newColsIds.length - 1] + 1; i < xyNew.length; ++i) {
                xxCacheNew[i] = GramXY.mergeRow(i, xx[i - k], new double[newActiveCols.length], newColsIds, xxUpdate);
                xyNew[i] = oldGram.xy[i - k];
                if (oldGram.grads == null) continue;
                gradsNew[i] = oldGram.grads[i - k];
            }
            return new GramXY(new Gram(xxCacheNew), xyNew, gradsNew, beta, newActiveCols, newColsIds, oldGram.yy, oldGram.likelihood);
        }
    }

    public static class GramGrad {
        public double[][] _gram;
        public double[] beta;
        public double[] _grad;
        public double objective;
        public double _sumOfRowWeights;
        public double[] _xy;

        public GramGrad(double[][] gramM, double[] grad, double[] b, double obj, double sumOfRowWeights, double[] xy) {
            this._gram = gramM;
            this.beta = b;
            this._grad = grad;
            this.objective = obj;
            this._sumOfRowWeights = sumOfRowWeights;
            this._xy = xy;
        }

        public Gram.Cholesky cholesky(Gram.Cholesky chol, final double[][] xx) {
            int fi;
            int i;
            if (chol == null) {
                for (int i2 = 0; i2 < xx.length; ++i2) {
                    xx[i2] = (double[])xx[i2].clone();
                }
                chol = new Gram.Cholesky(xx, new double[0]);
            }
            final Gram.Cholesky fchol = chol;
            boolean sparseN = false;
            int denseN = xx.length - 0;
            ForkJoinTask[] fjts = new ForkJoinTask[denseN];
            final int[][] nz = new int[denseN][];
            for (i = 0; i < denseN; ++i) {
                fi = i;
                fjts[i] = new RecursiveAction(){

                    @Override
                    protected void compute() {
                        int[] tmp = new int[]{};
                        double[] rowi = fchol._xx[fi];
                        int n = 0;
                        for (int k = 0; k < 0; ++k) {
                            if (rowi[k] == 0.0) continue;
                            tmp[n++] = k;
                        }
                        nz[fi] = Arrays.copyOf(tmp, n);
                    }
                };
            }
            ForkJoinTask.invokeAll(fjts);
            for (i = 0; i < denseN; ++i) {
                fi = i;
                fjts[i] = new RecursiveAction(){

                    @Override
                    protected void compute() {
                        double[] rowi = fchol._xx[fi];
                        int[] nzi = nz[fi];
                        for (int j = 0; j <= fi; ++j) {
                            double[] rowj = fchol._xx[j];
                            int[] nzj = nz[j];
                            double s = 0.0;
                            int t = 0;
                            int z = 0;
                            while (t < nzi.length && z < nzj.length) {
                                int k1 = nzi[t];
                                int k2 = nzj[z];
                                if (k1 < k2) {
                                    ++t;
                                    continue;
                                }
                                if (k1 > k2) {
                                    ++z;
                                    continue;
                                }
                                s += rowi[k1] * rowj[k1];
                                ++t;
                                ++z;
                            }
                            rowi[j + 0] = xx[fi][j + 0] - s;
                        }
                    }
                };
            }
            ForkJoinTask.invokeAll(fjts);
            Object arr = new double[denseN][];
            for (int i3 = 0; i3 < ((double[][])arr).length; ++i3) {
                arr[i3] = Arrays.copyOfRange(fchol._xx[i3], 0, 0 + denseN);
            }
            int p = H2ORuntime.availableProcessors();
            Gram.InPlaceCholesky d = Gram.InPlaceCholesky.decompose_2(arr, 10, p);
            fchol.setSPD(d.isSPD());
            arr = d.getL();
            for (int i4 = 0; i4 < ((double[][])arr).length; ++i4) {
                for (int j = 0; j < i4 + 1; ++j) {
                    fchol._xx[i4][0 + j] = arr[i4][j];
                }
            }
            return chol;
        }

        public Gram.Cholesky qrCholesky(List<Integer> dropped_cols, final double[][] Z, boolean standardized) {
            int i;
            double[][] R = new double[Z.length][];
            double[] Zdiag = new double[Z.length];
            double[] ZdiagInv = new double[Z.length];
            for (i = 0; i < Z.length; ++i) {
                Zdiag[i] = Z[i][i];
                ZdiagInv[i] = 1.0 / Zdiag[i];
            }
            for (int j = 0; j < Z.length; ++j) {
                double rs_tot;
                R[j] = new double[j + 1];
                final double[] gamma = R[j];
                for (int l = 0; l <= j; ++l) {
                    gamma[l] = Z[j][l] * ZdiagInv[l];
                }
                double zjj = Z[j][j];
                for (int k = 0; k < j; ++k) {
                    zjj += gamma[k] * (gamma[k] * Z[k][k] - 2.0 * Z[j][k]);
                }
                double d = rs_tot = standardized ? ZdiagInv[j] : 1.0 / (Zdiag[j] - Z[j][0] * ZdiagInv[0] * Z[j][0]);
                if (j > 0 && zjj * rs_tot < 1.0E-7) {
                    zjj = 0.0;
                    dropped_cols.add(j - 1);
                    ZdiagInv[j] = 0.0;
                } else {
                    ZdiagInv[j] = 1.0 / zjj;
                }
                Z[j][j] = zjj;
                int jchunk = Math.max(1, 1000 / (Z.length - j));
                int nchunks = (Z.length - j - 1) / jchunk;
                nchunks = Math.min(nchunks, H2O.NUMCPUS);
                if (nchunks <= 1) {
                    this.updateZ(gamma, Z, j);
                    continue;
                }
                final int fjchunk = (Z.length - 1 - j) / nchunks;
                int rem = Z.length - 1 - j - fjchunk * nchunks;
                for (int i2 = Z.length - rem; i2 < Z.length; ++i2) {
                    this.updateZij(i2, j, Z, gamma);
                }
                RecursiveAction[] ras = new RecursiveAction[nchunks];
                final int fj = j;
                int k = 0;
                for (int i3 = j + 1; i3 < Z.length - rem; i3 += fjchunk) {
                    final int fi = i3;
                    ras[k++] = new RecursiveAction(){

                        @Override
                        protected final void compute() {
                            int max_i = Math.min(fi + fjchunk, Z.length);
                            for (int i = fi; i < max_i; ++i) {
                                this.updateZij(i, fj, Z, gamma);
                            }
                        }
                    };
                }
                ForkJoinTask.invokeAll(ras);
            }
            if (R.length < 500) {
                for (i = 0; i < R.length; ++i) {
                    for (int j = 0; j <= i; ++j) {
                        double[] dArray = R[i];
                        int n = j;
                        dArray[n] = dArray[n] * Math.sqrt(Z[j][j]);
                    }
                }
            } else {
                RecursiveAction[] ras = new RecursiveAction[R.length];
                for (int i4 = 0; i4 < ras.length; ++i4) {
                    final int fi = i4;
                    final double[] Rrow = R[i4];
                    ras[i4] = new RecursiveAction(){

                        @Override
                        protected void compute() {
                            for (int j = 0; j <= fi; ++j) {
                                int n = j;
                                Rrow[n] = Rrow[n] * Math.sqrt(Z[j][j]);
                            }
                        }
                    };
                }
                ForkJoinTask.invokeAll(ras);
            }
            if (dropped_cols.isEmpty()) {
                return new Gram.Cholesky(R, new double[0], true);
            }
            return new Gram.Cholesky(GramGrad.dropIgnoredCols(R, Z, dropped_cols), new double[0], true);
        }

        public static double[][] dropIgnoredCols(double[][] R, double[][] Z, List<Integer> dropped_cols) {
            double[][] Rnew = new double[R.length - dropped_cols.size()][];
            for (int i = 0; i < Rnew.length; ++i) {
                Rnew[i] = new double[i + 1];
            }
            int j = 0;
            for (int i = 0; i < R.length; ++i) {
                if (Z[i][i] == 0.0) continue;
                int k = 0;
                for (int l = 0; l <= i; ++l) {
                    if (k < dropped_cols.size() && l == dropped_cols.get(k) + 1) {
                        ++k;
                        continue;
                    }
                    Rnew[j][l - k] = R[i][l];
                }
                ++j;
            }
            return Rnew;
        }

        private final void updateZij(int i, int j, double[][] Z, double[] gamma) {
            double[] Zi = Z[i];
            double Zij = Zi[j];
            for (int k = 0; k < j; ++k) {
                Zij -= gamma[k] * Zi[k];
            }
            Zi[j] = Zij;
        }

        private final void updateZ(double[] gamma, double[][] Z, int j) {
            for (int i = j + 1; i < Z.length; ++i) {
                this.updateZij(i, j, Z, gamma);
            }
        }

        public static double[][] dropCols(int[] cols, double[][] xx) {
            Arrays.sort(cols);
            int newXXLen = xx.length - cols.length;
            double[][] xxNew = new double[newXXLen][newXXLen];
            int oldXXLen = xx.length;
            List newIndices = IntStream.range(0, newXXLen).boxed().collect(Collectors.toList());
            for (int index : cols) {
                newIndices.add(index, -1);
            }
            for (int rInd = 0; rInd < oldXXLen; ++rInd) {
                int newXindexX = (Integer)newIndices.get(rInd);
                for (int cInd = rInd; cInd < oldXXLen; ++cInd) {
                    int newXindexY = (Integer)newIndices.get(cInd);
                    if (newXindexY < 0 || newXindexX < 0) continue;
                    xxNew[newXindexX][newXindexY] = xx[rInd][cInd];
                    xxNew[newXindexY][newXindexX] = xx[cInd][rInd];
                }
            }
            return xxNew;
        }

        public static int[] findZeroCols(double[][] xx) {
            ArrayList<Integer> zeros = new ArrayList<Integer>();
            for (int i = 0; i < xx.length; ++i) {
                if (ArrayUtils.sum(xx[i]) != 0.0) continue;
                zeros.add(i);
            }
            if (zeros.size() == 0) {
                return new int[0];
            }
            int[] ary = new int[zeros.size()];
            for (int i = 0; i < zeros.size(); ++i) {
                ary[i] = (Integer)zeros.get(i);
            }
            return ary;
        }
    }

    public static class GLMSubsetGinfo
    extends GLM.GLMGradientInfo {
        public final GLM.GLMGradientInfo _fullInfo;

        public GLMSubsetGinfo(GLM.GLMGradientInfo fullInfo, int N, int c, int[] ids) {
            super(fullInfo._likelihood, fullInfo._objVal, ComputationState.extractSubRange(N, c, ids, fullInfo._gradient));
            this._fullInfo = fullInfo;
        }
    }
}

