/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelMetrics;
import hex.ModelMetricsAutoEncoder;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialUplift;
import hex.ModelMetricsClustering;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionCoxPH;
import hex.PojoWriter;
import hex.generic.GenericModelMojoWriter;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.generic.PojoLoader;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.algos.glm.GlmMojoModelBase;
import hex.genmodel.algos.kmeans.KMeansMojoModel;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.genmodel.descriptor.ModelDescriptorBuilder;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.glm.GLMModel;
import hex.tree.isofor.ModelMetricsAnomaly;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.JobUpdatePostMap;
import water.Key;
import water.MRTask;
import water.api.schemas3.ModelParameterSchemaV3;
import water.fvec.ByteVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.RowDataUtils;

public class GenericModel
extends Model<GenericModel, GenericModelParameters, GenericModelOutput>
implements Model.Contributions {
    private static final Map<String, ModelBehavior[]> DEFAULT_MODEL_BEHAVIORS;
    private final String _algoName;
    private final GenModelSource<?> _genModelSource;
    private GLMModel.GLMParameters _glmParameters;

    public GenericModel(Key<GenericModel> selfKey, GenericModelParameters parms, GenericModelOutput output, MojoModel mojoModel, Key<Frame> mojoSource) {
        super(selfKey, parms, output);
        this._algoName = mojoModel._algoName;
        this._genModelSource = new MojoModelSource(mojoSource, mojoModel, GenericModel.defaultModelBehaviors(this._algoName));
        this._output = new GenericModelOutput(mojoModel._modelDescriptor, mojoModel._modelAttributes, mojoModel._reproducibilityInformation);
        if (mojoModel._modelAttributes != null && mojoModel._modelAttributes.getModelParameters() != null) {
            ((GenericModelParameters)this._parms)._modelParameters = GenericModelParameters.convertParameters(mojoModel._modelAttributes.getModelParameters());
        }
        this._glmParameters = null;
        if (this._algoName.toLowerCase().contains("glm")) {
            GlmMojoModelBase glmModel = (GlmMojoModelBase)mojoModel;
            this._glmParameters = new GLMModel.GLMParameters(GLMModel.GLMParameters.Family.valueOf(this.getParamByName("family").toString()), GLMModel.GLMParameters.Link.valueOf(this.getParamByName("link").toString()), Arrays.stream(this.getParamByName("lambda").toString().trim().replaceAll("\\[", "").replaceAll("\\]", "").split(",\\s*")).mapToDouble(Double::parseDouble).toArray(), Arrays.stream(this.getParamByName("alpha").toString().trim().replaceAll("\\[", "").replaceAll("\\]", "").split(",\\s*")).mapToDouble(Double::parseDouble).toArray(), Double.parseDouble(this.getParamByName("tweedie_variance_power").toString()), Double.parseDouble(this.getParamByName("tweedie_link_power").toString()), null, Double.parseDouble(this.getParamByName("theta").toString()), glmModel.getDispersionEstimated());
        }
    }

    public GenericModel(Key<GenericModel> selfKey, GenericModelParameters parms, GenericModelOutput output, GenModel pojoModel, Key<Frame> pojoSource) {
        super(selfKey, parms, output);
        this._algoName = "pojo";
        this._genModelSource = new PojoModelSource(selfKey.toString(), pojoSource, pojoModel);
        this._output = new GenericModelOutput(ModelDescriptorBuilder.makeDescriptor(pojoModel));
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    static ModelBehavior[] defaultModelBehaviors(String algoName) {
        return DEFAULT_MODEL_BEHAVIORS.get(algoName);
    }

    private static MojoModel reconstructMojo(ByteVec mojoBytes) {
        try {
            MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend(mojoBytes.openStream(null), MojoReaderBackendFactory.CachingStrategy.MEMORY);
            return ModelMojoReader.readFrom(readerBackend, true);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unreachable MOJO file: " + mojoBytes._key, e);
        }
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        switch (((GenericModelOutput)this._output).getModelCategory()) {
            case Unknown: {
                throw new IllegalStateException("Model category is unknown");
            }
            case Binomial: {
                return new ModelMetricsBinomial.MetricBuilderBinomial(domain);
            }
            case Multinomial: {
                return new ModelMetricsMultinomial.MetricBuilderMultinomial(((GenericModelOutput)this._output).nclasses(), domain, ((GenericModelParameters)this._parms)._auc_type);
            }
            case Ordinal: {
                return new ModelMetricsOrdinal.MetricBuilderOrdinal(((GenericModelOutput)this._output).nclasses(), domain);
            }
            case Regression: {
                return new ModelMetricsRegression.MetricBuilderRegression();
            }
            case Clustering: {
                if (this.genModel() instanceof KMeansMojoModel) {
                    KMeansMojoModel kMeansMojoModel = (KMeansMojoModel)this.genModel();
                    return new ModelMetricsClustering.MetricBuilderClustering(((GenericModelOutput)this._output).nfeatures(), kMeansMojoModel.getNumClusters());
                }
                return this.unsupportedMetricsBuilder();
            }
            case AutoEncoder: {
                return new ModelMetricsAutoEncoder.MetricBuilderAutoEncoder(((GenericModelOutput)this._output).nfeatures());
            }
            case DimReduction: {
                return this.unsupportedMetricsBuilder();
            }
            case WordEmbedding: {
                return this.unsupportedMetricsBuilder();
            }
            case CoxPH: {
                return new ModelMetricsRegressionCoxPH.MetricBuilderRegressionCoxPH("start", "stop", false, new String[0]);
            }
            case AnomalyDetection: {
                return new ModelMetricsAnomaly.MetricBuilderAnomaly();
            }
            case BinomialUplift: {
                return new ModelMetricsBinomialUplift.MetricBuilderBinomialUplift(domain, null);
            }
        }
        throw H2O.unimpl();
    }

    @Override
    protected Frame adaptFrameForScore(Frame fr, boolean computeMetrics) {
        if (this.hasBehavior(ModelBehavior.USE_MOJO_PREDICT)) {
            return fr;
        }
        return super.adaptFrameForScore(fr, computeMetrics);
    }

    @Override
    protected Model.PredictScoreResult predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        if (this.hasBehavior(ModelBehavior.USE_MOJO_PREDICT)) {
            return this.predictScoreMojoImpl(fr, destination_key, j, computeMetrics);
        }
        return super.predictScoreImpl(fr, adaptFrm, destination_key, j, computeMetrics, customMetricFunc);
    }

    private Iced getParamByName(String name) {
        return Arrays.stream(((GenericModelParameters)this._parms)._modelParameters).filter((Predicate<ModelParameterSchemaV3>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getParamByName$0(java.lang.String water.api.schemas3.ModelParameterSchemaV3 ), (Lwater/api/schemas3/ModelParameterSchemaV3;)Z)((String)name)).findAny().get().actual_value;
    }

    @Override
    public double aic(double likelihood) {
        if (!this._algoName.equals("glm")) {
            return Double.NaN;
        }
        long betasCount = Arrays.stream(((GlmMojoModelBase)this.genModel()).getBeta()).filter(b -> b != 0.0).count();
        return -2.0 * likelihood + (double)(2L * betasCount);
    }

    @Override
    public double likelihood(double w, double y, double[] f) {
        if (!this._algoName.equals("glm")) {
            return Double.NaN;
        }
        if (w == 0.0) {
            return 0.0;
        }
        return this._glmParameters.likelihood(w, y, f);
    }

    Model.PredictScoreResult predictScoreMojoImpl(Frame fr, String destination_key, Job<?> j, boolean computeMetrics) {
        GenModel model = this.genModel();
        String[] names = model.getOutputNames();
        String[][] domains = model.getOutputDomains();
        byte[] type = new byte[domains.length];
        for (int i = 0; i < type.length; ++i) {
            type[i] = domains[i] != null ? 4 : 3;
        }
        PredictScoreMojoTask bs = new PredictScoreMojoTask(computeMetrics, j);
        Frame predictFr = ((PredictScoreMojoTask)bs.doAll(type, fr)).outputFrame(Key.make(destination_key), names, domains);
        return new Model.PredictScoreResult(this, bs._mb, predictFr, predictFr);
    }

    private ModelMetrics.MetricBuilder<?> unsupportedMetricsBuilder() {
        if (((GenericModelParameters)this._parms)._disable_algo_check) {
            Log.warn("Model category `" + (Object)((Object)((GenericModelOutput)this._output)._modelCategory) + "` currently doesn't support calculating model metrics. Model metrics will not be available.");
            return new MetricBuilderGeneric(this.genModel().getPredsSize(((GenericModelOutput)this._output)._modelCategory));
        }
        throw new UnsupportedOperationException((Object)((Object)((GenericModelOutput)this._output)._modelCategory) + " is not supported.");
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        return this.genModel().score0(data, preds);
    }

    @Override
    protected double[] score0(double[] data, double[] preds, double offset) {
        if (offset == 0.0) {
            return this.score0(data, preds);
        }
        return this.genModel().score0(data, offset, preds);
    }

    @Override
    protected Model.AdaptFrameParameters makeAdaptFrameParameters() {
        CategoricalEncoding encoding = this.genModel().getCategoricalEncoding();
        if (encoding.isParametrized()) {
            throw new UnsupportedOperationException("Models with categorical encoding '" + (Object)((Object)encoding) + "' are not currently supported for predicting and/or calculating metrics.");
        }
        return this.makeAdaptFrameParameters(Model.Parameters.CategoricalEncodingScheme.fromGenModel(encoding));
    }

    protected Model.AdaptFrameParameters makeAdaptFrameParameters(final Model.Parameters.CategoricalEncodingScheme encodingScheme) {
        final GenModel genModel = this.genModel();
        final ModelDescriptor descriptor = this.getModelDescriptor();
        return new Model.AdaptFrameParameters(){

            @Override
            public Model.Parameters.CategoricalEncodingScheme getCategoricalEncoding() {
                return encodingScheme;
            }

            @Override
            public String getWeightsColumn() {
                return descriptor != null ? descriptor.weightsColumn() : null;
            }

            @Override
            public String getOffsetColumn() {
                return descriptor != null ? descriptor.offsetColumn() : null;
            }

            @Override
            public String getFoldColumn() {
                return descriptor != null ? descriptor.foldColumn() : null;
            }

            @Override
            public String getResponseColumn() {
                return genModel.isSupervised() ? genModel.getResponseName() : null;
            }

            @Override
            public String getTreatmentColumn() {
                return descriptor != null ? descriptor.treatmentColumn() : null;
            }

            @Override
            public double missingColumnsType() {
                return Double.NaN;
            }

            @Override
            public int getMaxCategoricalLevels() {
                return -1;
            }
        };
    }

    private ModelDescriptor getModelDescriptor() {
        GenModel genModel = this.genModel();
        return genModel instanceof MojoModel ? ((MojoModel)genModel)._modelDescriptor : null;
    }

    @Override
    protected String[] makeScoringNames() {
        return this.genModel().getOutputNames();
    }

    @Override
    protected boolean needsPostProcess() {
        return false;
    }

    @Override
    public GenericModelMojoWriter getMojo() {
        if (this._genModelSource instanceof MojoModelSource) {
            return new GenericModelMojoWriter(this._genModelSource.backingByteVec());
        }
        throw new IllegalStateException("Cannot create a MOJO from a POJO");
    }

    private GenModel genModel() {
        GenericModel self = (GenericModel)DKV.getGet(this._key);
        return self._genModelSource.get();
    }

    @Override
    protected Model.BigScorePredict setupBigScorePredict(Model.BigScore bs) {
        GenModel genmodel = this.genModel();
        assert (genmodel != null);
        return super.setupBigScorePredict(bs);
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (((GenericModelParameters)this._parms)._path != null) {
            this._genModelSource.remove(fs, cascade);
        }
        return super.remove_impl(fs, cascade);
    }

    @Override
    public Frame scoreContributions(Frame frame, Key<Frame> destination_key) {
        return this.scoreContributions(frame, destination_key, null);
    }

    @Override
    public Frame scoreContributions(Frame frame, Key<Frame> destination_key, Job<Frame> job) {
        EasyPredictModelWrapper wrapper = this.makeWrapperWithContributions();
        Frame adaptFrm = new Frame(frame);
        GenModel model = wrapper.getModel();
        String[] columnNames = model.getOrigNames() != null ? model.getOrigNames() : model.getNames();
        adaptFrm.remove(ArrayUtils.difference(frame._names, columnNames));
        String[] outputNames = wrapper.getContributionNames();
        return ((GenericScoreContributionsTask)new GenericScoreContributionsTask(wrapper).withPostMapAction(JobUpdatePostMap.forJob(job)).doAll(outputNames.length, (byte)3, adaptFrm)).outputFrame(destination_key, outputNames, null);
    }

    EasyPredictModelWrapper makeWrapperWithContributions() {
        EasyPredictModelWrapper.Config config;
        try {
            config = new EasyPredictModelWrapper.Config().setModel(this.genModel()).setConvertUnknownCategoricalLevelsToNa(true).setEnableContributions(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new EasyPredictModelWrapper(config);
    }

    @Override
    protected String toJavaModelClassName() {
        return ModelBuilder.make(((GenericModelOutput)this._output)._original_model_identifier, null, null).getClass().getSimpleName() + "Model";
    }

    @Override
    protected String toJavaAlgo() {
        return ((GenericModelOutput)this._output)._original_model_identifier;
    }

    @Override
    protected String toJavaUUID() {
        return this.genModel().getUUID();
    }

    @Override
    protected PojoWriter makePojoWriter() {
        GenModel genModel = this.genModel();
        if (!this.havePojo()) {
            throw new UnsupportedOperationException("Only MOJO models can be converted to POJO.");
        }
        MojoModel mojoModel = (MojoModel)genModel;
        Object builder = ModelBuilder.make(mojoModel._algoName, null, null);
        return ((ModelBuilder)builder).makePojoWriter(this, mojoModel);
    }

    @Override
    public boolean havePojo() {
        GenModel genModel = this.genModel();
        return genModel instanceof MojoModel;
    }

    boolean hasBehavior(ModelBehavior b) {
        ModelBehavior[] modelBehaviors = this._genModelSource.getModelBehaviors();
        if (modelBehaviors == null) {
            return false;
        }
        return ArrayUtils.find(modelBehaviors, b) >= 0;
    }

    private static /* synthetic */ boolean lambda$getParamByName$0(String name, ModelParameterSchemaV3 p) {
        return Objects.equals(p.name, name);
    }

    static {
        HashMap<String, ModelBehavior[]> behaviors = new HashMap<String, ModelBehavior[]>();
        behaviors.put("gam", new ModelBehavior[]{ModelBehavior.USE_MOJO_PREDICT});
        DEFAULT_MODEL_BEHAVIORS = Collections.unmodifiableMap(behaviors);
    }

    static enum ModelBehavior {
        USE_MOJO_PREDICT;

    }

    private class GenericScoreContributionsTask
    extends MRTask<GenericScoreContributionsTask> {
        private transient EasyPredictModelWrapper _wrapper;

        GenericScoreContributionsTask(EasyPredictModelWrapper wrapper) {
            this._wrapper = wrapper;
        }

        @Override
        protected void setupLocal() {
            if (this._wrapper == null) {
                this._wrapper = GenericModel.this.makeWrapperWithContributions();
            }
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            try {
                this.predict(cs, ncs);
            }
            catch (PredictException e) {
                throw new RuntimeException(e);
            }
        }

        private void predict(Chunk[] cs, NewChunk[] ncs) throws PredictException {
            RowData rowData = new RowData();
            byte[] types = this._fr.types();
            for (int i = 0; i < cs[0]._len; ++i) {
                RowDataUtils.extractChunkRow(cs, this._fr._names, types, i, rowData);
                float[] contributions = this._wrapper.predictContributions(rowData);
                NewChunk.addNums(ncs, contributions);
            }
        }
    }

    private static class PojoModelSource
    extends GenModelSource<PojoModelSource> {
        final String _model_id;

        PojoModelSource(String modelId, Key<Frame> pojoSource, GenModel pojoModel) {
            super(pojoSource, pojoModel);
            this._model_id = modelId;
        }

        @Override
        GenModel reconstructGenModel(ByteVec bv) {
            Key<Frame> pojoKey = this.getSourceKey();
            try {
                return PojoLoader.loadPojoFromSourceCode(bv, pojoKey, this._model_id);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load POJO source code from Vec " + pojoKey);
            }
        }
    }

    private static class MojoModelSource
    extends GenModelSource<MojoModelSource> {
        private final ModelBehavior[] _modelBehaviors;

        MojoModelSource(Key<Frame> mojoSource, MojoModel mojoModel, ModelBehavior[] defaultModelBehaviors) {
            super(mojoSource, mojoModel);
            this._modelBehaviors = MojoModelSource.mojoModeBehaviors(mojoModel, defaultModelBehaviors);
        }

        @Override
        GenModel reconstructGenModel(ByteVec bv) {
            return GenericModel.reconstructMojo(bv);
        }

        @Override
        ModelBehavior[] getModelBehaviors() {
            return this._modelBehaviors;
        }

        static ModelBehavior[] mojoModeBehaviors(MojoModel mojoModel, ModelBehavior[] defaultModelBehaviors) {
            boolean useMojoPredict = mojoModel.getCategoricalEncoding().isParametrized();
            return useMojoPredict ? ArrayUtils.append(defaultModelBehaviors, ModelBehavior.USE_MOJO_PREDICT) : defaultModelBehaviors;
        }
    }

    private static abstract class GenModelSource<T extends Iced<T>>
    extends Iced<T> {
        private final Key<Frame> _source;
        private volatile transient GenModel _genModel;

        GenModelSource(Key<Frame> source, GenModel genModel) {
            this._source = source;
            this._genModel = genModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        GenModel get() {
            if (this._genModel == null) {
                GenModelSource genModelSource = this;
                synchronized (genModelSource) {
                    if (this._genModel == null) {
                        this._genModel = this.reconstructGenModel(this.backingByteVec());
                    }
                }
            }
            assert (this._genModel != null);
            return this._genModel;
        }

        void remove(Futures fs, boolean cascade) {
            Frame mojoFrame = this._source.get();
            if (mojoFrame != null) {
                mojoFrame.remove(fs, cascade);
            }
        }

        abstract GenModel reconstructGenModel(ByteVec var1);

        ByteVec backingByteVec() {
            return (ByteVec)this._source.get().anyVec();
        }

        Key<Frame> getSourceKey() {
            return this._source;
        }

        ModelBehavior[] getModelBehaviors() {
            return null;
        }
    }

    private static class MetricBuilderGeneric
    extends ModelMetrics.MetricBuilder<MetricBuilderGeneric> {
        private MetricBuilderGeneric(int predsSize) {
            this._work = new double[predsSize];
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            return ds;
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            return null;
        }
    }

    private class PredictScoreMojoTask
    extends MRTask<PredictScoreMojoTask> {
        private final boolean _computeMetrics;
        private final Job<?> _j;
        private ModelMetrics.MetricBuilder<?> _mb;

        public PredictScoreMojoTask(boolean computeMetrics, Job<?> j) {
            this._computeMetrics = computeMetrics;
            this._j = j;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] ncs) {
            if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
                return;
            }
            EasyPredictModelWrapper wrapper = this.makeWrapper();
            GenModel model = wrapper.getModel();
            String[] responseDomain = model.isSupervised() ? model.getDomainValues(model.getResponseName()) : null;
            Model.AdaptFrameParameters adaptFrameParameters = GenericModel.this.makeAdaptFrameParameters(Model.Parameters.CategoricalEncodingScheme.AUTO);
            this._mb = this._computeMetrics ? GenericModel.this.makeMetricBuilder(responseDomain) : null;
            try {
                this.predict(wrapper, adaptFrameParameters, responseDomain, cs, ncs);
            }
            catch (PredictException e) {
                throw new RuntimeException(e);
            }
        }

        private void predict(EasyPredictModelWrapper wrapper, Model.AdaptFrameParameters adaptFrameParameters, String[] responseDomain, Chunk[] cs, NewChunk[] ncs) throws PredictException {
            byte[] types = this._fr.types();
            String offsetColumn = adaptFrameParameters.getOffsetColumn();
            String weightsColumn = adaptFrameParameters.getWeightsColumn();
            String responseColumn = adaptFrameParameters.getResponseColumn();
            String treatmentColumn = adaptFrameParameters.getTreatmentColumn();
            boolean isClassifier = wrapper.getModel().isClassifier();
            boolean isUplift = treatmentColumn != null;
            float[] yact = isUplift ? new float[2] : new float[1];
            for (int row = 0; row < cs[0]._len; ++row) {
                double weight;
                Object response;
                RowData rowData = new RowData();
                RowDataUtils.extractChunkRow(cs, this._fr._names, types, row, rowData);
                double offset = offsetColumn != null && rowData.containsKey(offsetColumn) ? (Double)rowData.get(offsetColumn) : 0.0;
                double[] result = wrapper.predictRaw(rowData, offset);
                for (int i = 0; i < ncs.length; ++i) {
                    ncs[i].addNum(result[i]);
                }
                if (this._mb == null) continue;
                Object v0 = response = responseColumn != null && rowData.containsKey(responseColumn) ? rowData.get(responseColumn) : null;
                if (response == null) continue;
                double d = weight = weightsColumn != null && rowData.containsKey(weightsColumn) ? (Double)rowData.get(weightsColumn) : 1.0;
                if (isClassifier) {
                    int idx = ArrayUtils.find(responseDomain, String.valueOf(response));
                    if (idx < 0) continue;
                    yact[0] = idx;
                } else {
                    yact[0] = ((Number)response).floatValue();
                }
                if (isUplift) {
                    yact[1] = ((Float)rowData.get(treatmentColumn)).floatValue();
                }
                this._mb.perRow(result, yact, weight, offset, GenericModel.this);
            }
        }

        @Override
        public void reduce(PredictScoreMojoTask bs) {
            super.reduce(bs);
            if (this._mb != null) {
                this._mb.reduce(bs._mb);
            }
        }

        EasyPredictModelWrapper makeWrapper() {
            EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setModel(GenericModel.this.genModel().internal_threadSafeInstance()).setConvertUnknownCategoricalLevelsToNa(true);
            return new EasyPredictModelWrapper(config);
        }
    }
}

