/*
 * Decompiled with CFR 0.152.
 */
package hex.generic;

import hex.ModelBuilder;
import hex.ModelCategory;
import hex.generic.GenericModel;
import hex.generic.GenericModelOutput;
import hex.generic.GenericModelParameters;
import hex.generic.PojoLoader;
import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.genmodel.descriptor.ModelDescriptorBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import water.H2O;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.parser.ZipUtil;
import water.util.Log;

public class Generic
extends ModelBuilder<GenericModel, GenericModelParameters, GenericModelOutput> {
    private static final Set<String> ALLOWED_MOJO_ALGOS;

    public Generic(GenericModelParameters genericParameters) {
        super(genericParameters);
        this.init(false);
    }

    public Generic(boolean startup_once) {
        super(new GenericModelParameters(), startup_once);
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (((GenericModelParameters)this._parms)._path != null && ((GenericModelParameters)this._parms)._model_key != null) {
            this.error("_path", "Path cannot be set for MOJO that is supposed to be loaded from distributed memory (key=" + ((GenericModelParameters)this._parms)._model_key + ").");
        }
    }

    @Override
    protected ModelBuilder.Driver trainModelImpl() {
        return new MojoDelegatingModelDriver();
    }

    @Override
    public ModelCategory[] can_build() {
        return ModelCategory.values();
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    private Key<Frame> importFile() {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> fails = new ArrayList<String>();
        ArrayList<String> dels = new ArrayList<String>();
        H2O.getPM().importFiles(((GenericModelParameters)this._parms)._path, null, files, keys, fails, dels);
        if (!fails.isEmpty()) {
            throw new RuntimeException("Failed to import file: " + Arrays.toString(fails.toArray()));
        }
        assert (keys.size() == 1);
        return Key.make(keys.get(0));
    }

    private ByteVec readModelData(Key<Frame> key) throws IllegalArgumentException {
        Objects.requireNonNull(key);
        Frame mojoFrame = key.get();
        if (mojoFrame.numCols() > 1) {
            throw new IllegalArgumentException(String.format("Given model frame with key '%s' should contain only 1 column with model bytes. More columns found. Incorrect key provided ?", key));
        }
        ByteVec mojoData = (ByteVec)mojoFrame.anyVec();
        if (mojoData.length() < 1L) {
            throw new IllegalArgumentException(String.format("Given model frame with key '%s' is empty (0 bytes). Please provide a non-empty model file.", key));
        }
        return mojoData;
    }

    @Override
    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Stable;
    }

    public static GenericModel importMojoModel(String location, boolean disableAlgoCheck) {
        GenericModelParameters p = new GenericModelParameters();
        p._path = location;
        p._disable_algo_check = disableAlgoCheck;
        return (GenericModel)new Generic(p).trainModel().get();
    }

    public static GenericModel importMojoModel(URI location) {
        return Generic.importMojoModel(location.toString(), false);
    }

    static {
        HashSet<String> allowedAlgos = new HashSet<String>(6);
        allowedAlgos.add("gbm");
        allowedAlgos.add("glm");
        allowedAlgos.add("xgboost");
        allowedAlgos.add("isolationforest");
        allowedAlgos.add("extendedisolationforest");
        allowedAlgos.add("drf");
        allowedAlgos.add("deeplearning");
        allowedAlgos.add("stackedensemble");
        allowedAlgos.add("coxph");
        allowedAlgos.add("rulefit");
        allowedAlgos.add("gam");
        allowedAlgos.add("upliftdrf");
        ALLOWED_MOJO_ALGOS = Collections.unmodifiableSet(allowedAlgos);
    }

    class MojoDelegatingModelDriver
    extends ModelBuilder.Driver {
        MojoDelegatingModelDriver() {
            super(Generic.this);
        }

        @Override
        public void compute2() {
            if (((GenericModelParameters)Generic.this._parms)._path != null) {
                ((GenericModelParameters)Generic.this._parms)._model_key = Generic.this.importFile();
            }
            super.compute2();
        }

        @Override
        public void computeImpl() {
            if (((GenericModelParameters)Generic.this._parms)._model_key == null) {
                throw new IllegalArgumentException("Either MOJO zip path or key to the uploaded MOJO frame must be specified");
            }
            Key<Frame> dataKey = ((GenericModelParameters)Generic.this._parms)._model_key;
            ByteVec modelBytes = Generic.this.readModelData(dataKey);
            try {
                GenericModel genericModel;
                if (ZipUtil.isCompressed(modelBytes)) {
                    genericModel = this.importMojo(modelBytes, dataKey);
                } else if (H2O.getSysBoolProperty("pojo.import.enabled", false)) {
                    Generic.this.warn("_path", "Trying to import a POJO model - this is currently an experimental feature.");
                    genericModel = this.importPojo(modelBytes, dataKey, Generic.this._result.toString());
                } else {
                    throw new SecurityException("POJO import is disabled since it brings a security risk. To enable the feature, set the java property `sys.ai.h2o.pojo.import.enabled` to true.");
                }
                genericModel.write_lock(Generic.this._job);
                genericModel.unlock(Generic.this._job);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unreachable model file: " + dataKey, e);
            }
        }

        private GenericModel importMojo(ByteVec mojoBytes, Key<Frame> dataKey) throws IOException {
            MojoReaderBackend readerBackend = MojoReaderBackendFactory.createReaderBackend(mojoBytes.openStream(Generic.this._job._key), MojoReaderBackendFactory.CachingStrategy.MEMORY);
            MojoModel mojoModel = ModelMojoReader.readFrom(readerBackend, true);
            if (!ALLOWED_MOJO_ALGOS.contains(mojoModel._modelDescriptor.algoName().toLowerCase())) {
                if (((GenericModelParameters)Generic.this._parms)._disable_algo_check) {
                    Log.warn(String.format("MOJO model '%s' is not supported but user disabled white-list check. Trying to load anyway.", mojoModel._modelDescriptor.algoName()));
                } else {
                    throw new IllegalArgumentException(String.format("Unsupported MOJO model '%s'. ", mojoModel._modelDescriptor.algoName()));
                }
            }
            GenericModelOutput genericModelOutput = new GenericModelOutput(mojoModel._modelDescriptor, mojoModel._modelAttributes, mojoModel._reproducibilityInformation);
            return new GenericModel((Key<GenericModel>)Generic.this._result, (GenericModelParameters)Generic.this._parms, genericModelOutput, mojoModel, dataKey);
        }

        private GenericModel importPojo(ByteVec pojoBytes, Key<Frame> pojoKey, String modelId) throws IOException {
            GenModel genmodel = PojoLoader.loadPojoFromSourceCode(pojoBytes, pojoKey, modelId);
            ModelDescriptor pojoDescriptor = ModelDescriptorBuilder.makeDescriptor(genmodel);
            GenericModelOutput genericModelOutput = new GenericModelOutput(pojoDescriptor);
            return new GenericModel((Key<GenericModel>)Generic.this._result, (GenericModelParameters)Generic.this._parms, genericModelOutput, genmodel, pojoKey);
        }
    }
}

