/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.GainsLift;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialGLM;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import hex.ModelMetricsRegressionGLM;
import hex.ModelMetricsSupervised;
import hex.MultinomialAucType;
import hex.gam.GAMModel;
import hex.glm.GLMModel;
import java.util.Arrays;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class MetricBuilderGAM
extends ModelMetricsSupervised.MetricBuilderSupervised<MetricBuilderGAM> {
    double _residual_deviance;
    double _null_deviance;
    long _nobs;
    double _log_likelihood;
    double _aic;
    private double _aic2;
    final GLMModel.GLMWeightsFun _glmf;
    ModelMetrics.MetricBuilder _metricBuilder;
    final boolean _intercept;
    private final double[] _ymu;
    final boolean _computeMetrics;
    private final int _rank;
    int _nclass;

    public MetricBuilderGAM(String[] domain, double[] ymu, GLMModel.GLMWeightsFun glmf, int rank, boolean computeMetrics, boolean intercept, int nclass, MultinomialAucType aucType) {
        super(domain == null ? 0 : domain.length, domain);
        this._intercept = intercept;
        this._computeMetrics = computeMetrics;
        this._glmf = glmf;
        this._rank = rank;
        this._nclass = nclass;
        this._ymu = ymu;
        switch (this._glmf._family) {
            case binomial: 
            case quasibinomial: 
            case fractionalbinomial: {
                this._metricBuilder = new ModelMetricsBinomial.MetricBuilderBinomial(domain);
                break;
            }
            case multinomial: {
                this._metricBuilder = new ModelMetricsMultinomial.MetricBuilderMultinomial(nclass, domain, aucType);
                break;
            }
            case ordinal: {
                this._metricBuilder = new ModelMetricsOrdinal.MetricBuilderOrdinal(nclass, domain);
                break;
            }
            default: {
                this._metricBuilder = new ModelMetricsRegression.MetricBuilderRegression();
            }
        }
    }

    @Override
    public double[] perRow(double[] ds, float[] yact, double weight, double offset, Model m) {
        if (weight == 0.0) {
            return ds;
        }
        this._metricBuilder.perRow(ds, yact, weight, offset, m);
        if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.negativebinomial)) {
            this._log_likelihood += m.likelihood(weight, yact[0], ds);
        }
        if (!ArrayUtils.hasNaNsOrInfs(ds) && !ArrayUtils.hasNaNsOrInfs(yact)) {
            if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.multinomial) || this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
                this.add2(yact[0], ds[0], weight, offset);
            } else if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.binomial) || this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.quasibinomial) || this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.fractionalbinomial)) {
                this.add2(yact[0], ds[2], weight, offset);
            } else {
                this.add2(yact[0], ds[0], weight, offset);
            }
        }
        return ds;
    }

    private void add2(double yresp, double ypredict, double weight, double offset) {
        this._wcount += weight;
        ++this._nobs;
        if (!this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.multinomial) && !this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
            this._residual_deviance += weight * this._glmf.deviance(yresp, ypredict);
            this._null_deviance = offset == 0.0 ? (this._null_deviance += weight * this._glmf.deviance(yresp, this._ymu[0])) : (this._null_deviance += weight * this._glmf.deviance(yresp, this._glmf.linkInv(offset + this._glmf.link(this._ymu[0]))));
        }
        if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.poisson)) {
            long y = Math.round(yresp);
            double logfactorial = MathUtils.logFactorial(y);
            this._aic2 += weight * (yresp * Math.log(ypredict) - logfactorial - ypredict);
        }
    }

    @Override
    public void reduce(MetricBuilderGAM other) {
        if (this._computeMetrics) {
            this._metricBuilder.reduce(other._metricBuilder);
        }
        this._residual_deviance += other._residual_deviance;
        this._null_deviance += other._null_deviance;
        if (Arrays.asList(GLMModel.GLMParameters.Family.gaussian, GLMModel.GLMParameters.Family.binomial, GLMModel.GLMParameters.Family.quasibinomial, GLMModel.GLMParameters.Family.fractionalbinomial, GLMModel.GLMParameters.Family.poisson, GLMModel.GLMParameters.Family.negativebinomial, GLMModel.GLMParameters.Family.gamma, GLMModel.GLMParameters.Family.tweedie).contains((Object)this._glmf._family)) {
            this._log_likelihood += other._log_likelihood;
        }
        this._nobs += other._nobs;
        this._aic2 += other._aic2;
        this._wcount += other._wcount;
    }

    public final double residualDeviance() {
        return this._residual_deviance;
    }

    public final long nullDOF() {
        return this._nobs - (long)(this._intercept ? 1 : 0);
    }

    public final long resDOF() {
        if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.ordinal)) {
            return this._nobs - (long)(this._rank / (this._nclasses - 1) + this._nclasses - 2);
        }
        return this._nobs - (long)this._rank;
    }

    protected void computeAIC() {
        this._aic = 0.0;
        switch (this._glmf._family) {
            case gaussian: {
                this._aic = (double)this._nobs * (Math.log(this._residual_deviance / (double)this._nobs * 2.0 * Math.PI) + 1.0) + 2.0;
                break;
            }
            case binomial: 
            case quasibinomial: 
            case fractionalbinomial: {
                this._aic = this._residual_deviance;
                break;
            }
            case poisson: {
                this._aic = -2.0 * this._aic2;
                break;
            }
            case gamma: {
                this._aic = Double.NaN;
                break;
            }
            case multinomial: 
            case ordinal: 
            case tweedie: {
                this._aic = Double.NaN;
                break;
            }
            case negativebinomial: {
                this._aic = 2.0 * this._log_likelihood;
                break;
            }
            default: {
                assert (false) : "missing implementation for family " + (Object)((Object)this._glmf._family);
                break;
            }
        }
        this._aic += (double)(2 * this._rank);
    }

    @Override
    public double[] perRow(double[] ds, float[] yact, Model m) {
        return this.perRow(ds, yact, 1.0, 0.0, m);
    }

    @Override
    public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
        GAMModel gamM = (GAMModel)m;
        this.computeAIC();
        ModelMetrics mm = this._metricBuilder.makeModelMetrics(gamM, f, null, null);
        if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.binomial) || this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.quasibinomial) || this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.fractionalbinomial)) {
            ModelMetricsBinomial metricsBinomial = (ModelMetricsBinomial)mm;
            GainsLift gl = null;
            if (preds != null) {
                Vec resp = f.vec(((GAMModel.GAMParameters)gamM._parms)._response_column);
                Vec weights = f.vec(((GAMModel.GAMParameters)gamM._parms)._weights_column);
                if (resp != null && GLMModel.GLMParameters.Family.fractionalbinomial != this._glmf._family) {
                    gl = new GainsLift(preds.lastVec(), resp, weights);
                    gl._groups = ((Model.Parameters)m._parms)._gainslift_bins;
                    gl.exec(((GAMModel.GAMModelOutput)gamM._output)._job);
                }
            }
            mm = new ModelMetricsBinomialGLM(m, f, mm._nobs, mm._MSE, this._domain, metricsBinomial._sigma, metricsBinomial._auc, metricsBinomial._logloss, this.residualDeviance(), this._null_deviance, this._aic, this.nullDOF(), this.resDOF(), gl, this._customMetric, this._log_likelihood);
        } else if (this._glmf._family.equals((Object)GLMModel.GLMParameters.Family.multinomial)) {
            ModelMetricsMultinomial metricsMultinomial = (ModelMetricsMultinomial)mm;
            mm = new ModelMetricsBinomialGLM.ModelMetricsMultinomialGLM(m, f, metricsMultinomial._nobs, metricsMultinomial._MSE, metricsMultinomial._domain, metricsMultinomial._sigma, metricsMultinomial._cm, metricsMultinomial._hit_ratios, metricsMultinomial._logloss, this.residualDeviance(), this._null_deviance, this._aic, this.nullDOF(), this.resDOF(), metricsMultinomial._auc, this._customMetric, this._log_likelihood);
        } else if (this._glmf._family == GLMModel.GLMParameters.Family.ordinal) {
            ModelMetricsOrdinal metricsOrdinal = (ModelMetricsOrdinal)mm;
            mm = new ModelMetricsBinomialGLM.ModelMetricsOrdinalGLM(m, f, metricsOrdinal._nobs, metricsOrdinal._MSE, metricsOrdinal._domain, metricsOrdinal._sigma, metricsOrdinal._cm, metricsOrdinal._hit_ratios, metricsOrdinal._logloss, this.residualDeviance(), this._null_deviance, this._aic, this.nullDOF(), this.resDOF(), this._customMetric, this._log_likelihood);
        } else {
            ModelMetricsRegression metricsRegression = (ModelMetricsRegression)mm;
            mm = new ModelMetricsRegressionGLM(m, f, metricsRegression._nobs, metricsRegression._MSE, metricsRegression._sigma, metricsRegression._mean_absolute_error, metricsRegression._root_mean_squared_log_error, this.residualDeviance(), this.residualDeviance() / this._wcount, this._null_deviance, this._aic, this.nullDOF(), this.resDOF(), this._customMetric, this._log_likelihood);
        }
        return gamM.addModelMetrics(mm);
    }
}

