/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.GamSplines;

import hex.gam.GamSplines.NBSplinesUtils;
import hex.genmodel.algos.gam.GamUtilsISplines;
import hex.genmodel.algos.gam.NBSplinesTypeI;

public class NBSplinesTypeIDerivative {
    private final int _order;
    private final int _basisIndex;
    private final double[] _knots;
    private final double _commonConst;
    public double[][] _coeffs;
    private NBSplinesTypeI _left;
    private NBSplinesTypeI _right;

    public NBSplinesTypeIDerivative(int basisIndex, int order, double[] fullKnots) {
        this._order = order;
        this._basisIndex = basisIndex;
        this._knots = GamUtilsISplines.extractKnots(this._basisIndex, order, fullKnots);
        this._commonConst = (double)this._order * (this._knots[this._order] == this._knots[0] ? 0.0 : 1.0 / (this._knots[this._order] - this._knots[0]));
        this._left = NBSplinesTypeI.formBasisDeriv(fullKnots, this._order - 1, basisIndex, fullKnots.length - 1);
        this._right = NBSplinesTypeI.formBasisDeriv(fullKnots, this._order - 1, basisIndex + 1, fullKnots.length - 1);
        this._coeffs = NBSplinesTypeIDerivative.extractDerivativeCoeff(this._left, this._right, fullKnots, basisIndex, this._commonConst);
    }

    public static double[][] extractDerivativeCoeff(NBSplinesTypeI left, NBSplinesTypeI rite, double[] knots, int basisIndex, double parentConst) {
        double[][] coeffsLeft = NBSplinesTypeI.extractCoeffs(left, basisIndex, parentConst);
        double[][] coeffsRite = NBSplinesTypeI.extractCoeffs(rite, basisIndex + 1, -parentConst);
        double[][] combinedCoeffs = new double[knots.length - 1][];
        GamUtilsISplines.sumCoeffs(coeffsLeft, coeffsRite, combinedCoeffs);
        return combinedCoeffs;
    }

    public static double[][] genISPenaltyMatrix(double[] knots, int order) {
        int numBasis = knots.length + order - 2;
        if (order <= 1) {
            return new double[numBasis][numBasis];
        }
        double[] knotsWithDuplicates = GamUtilsISplines.fillKnots(knots, order);
        NBSplinesTypeIDerivative[] allDerivatives = NBSplinesTypeIDerivative.form1stOrderDerivatives(numBasis, order, knotsWithDuplicates);
        double[][] penaltyMat = new double[numBasis][numBasis];
        for (int i = 0; i < numBasis; ++i) {
            for (int j = i; j < numBasis; ++j) {
                double[][] coeffProduct = NBSplinesTypeIDerivative.formDerivateProduct(allDerivatives[i]._coeffs, allDerivatives[j]._coeffs);
                penaltyMat[i][j] = NBSplinesUtils.integratePolynomial(knotsWithDuplicates, coeffProduct);
                penaltyMat[j][i] = penaltyMat[i][j];
            }
        }
        return penaltyMat;
    }

    public static double[][] genMSPenaltyMatrix(double[] knots, int order) {
        int numBasis = knots.length + order - 2;
        if (order <= 2) {
            return new double[numBasis][numBasis];
        }
        double[] knotsWithDuplicates = GamUtilsISplines.fillKnots(knots, order);
        double[][][] allDerivCoeffs = NBSplinesTypeIDerivative.form2ndDerivCoeffs(numBasis, order, knotsWithDuplicates);
        double[][] penaltyMat = new double[numBasis][numBasis];
        for (int i = 0; i < numBasis; ++i) {
            for (int j = i; j < numBasis; ++j) {
                double[][] coeffProduct = NBSplinesTypeIDerivative.formDerivateProduct(allDerivCoeffs[i], allDerivCoeffs[j]);
                penaltyMat[i][j] = NBSplinesUtils.integratePolynomial(knotsWithDuplicates, coeffProduct);
                penaltyMat[j][i] = penaltyMat[i][j];
            }
        }
        return penaltyMat;
    }

    public static double[][][] form2ndDerivCoeffs(int numBasis, int order, double[] fullKnots) {
        double[][][] derivCoeffs = new double[numBasis][][];
        NBSplinesTypeI[] msBasis = new NBSplinesTypeI[numBasis];
        int numKnotInt = fullKnots.length - 1;
        for (int index = 0; index < numBasis; ++index) {
            msBasis[index] = NBSplinesTypeI.formBasisDeriv(fullKnots, order, index, numKnotInt);
            NBSplinesTypeI.extractNBSplineCoeffs(msBasis[index], order, new double[]{1.0}, 1.0, index);
            derivCoeffs[index] = NBSplinesTypeIDerivative.derivativeCoeffs(msBasis[index]._nodeCoeffs);
        }
        return derivCoeffs;
    }

    public static double[][] derivativeCoeffs(double[][] origCoeffs) {
        int numCoeffs = origCoeffs.length;
        double[][] derivCoeffs = new double[numCoeffs][];
        for (int index = 0; index < numCoeffs; ++index) {
            double[] currCoeffs = origCoeffs[index];
            if (currCoeffs == null || currCoeffs.length <= 2) continue;
            int count = 0;
            int currCoeffLen = currCoeffs.length;
            derivCoeffs[index] = new double[currCoeffLen - 2];
            for (int index2 = 2; index2 < currCoeffLen; ++index2) {
                derivCoeffs[index][count++] = currCoeffs[index2] * (double)index2 * (double)(index2 - 1);
            }
        }
        return derivCoeffs;
    }

    public static NBSplinesTypeIDerivative[] form1stOrderDerivatives(int numBasis, int order, double[] fullKnots) {
        NBSplinesTypeIDerivative[] allDerivs = new NBSplinesTypeIDerivative[numBasis];
        for (int index = 0; index < numBasis; ++index) {
            allDerivs[index] = new NBSplinesTypeIDerivative(index, order, fullKnots);
        }
        return allDerivs;
    }

    public static double[][] formDerivateProduct(double[][] firstCoeff, double[][] secondCoeff) {
        int numBasis = firstCoeff.length;
        double[][] polyProduct = new double[numBasis][];
        for (int index = 0; index < numBasis; ++index) {
            if (firstCoeff[index] == null || secondCoeff[index] == null) continue;
            polyProduct[index] = GamUtilsISplines.polynomialProduct(firstCoeff[index], secondCoeff[index]);
        }
        return polyProduct;
    }
}

