/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.ModelMojoWriter;
import hex.gam.GAMModel;
import hex.glm.GLMModel;
import java.io.IOException;

public class GAMMojoWriter
extends ModelMojoWriter<GAMModel, GAMModel.GAMParameters, GAMModel.GAMModelOutput> {
    @Override
    public String mojoVersion() {
        return "1.00";
    }

    public GAMMojoWriter() {
    }

    public GAMMojoWriter(GAMModel model) {
        super(model);
    }

    @Override
    protected void writeModelData() throws IOException {
        int numGamCols = ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns.length;
        this.writekv("use_all_factor_levels", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._use_all_factor_levels);
        this.writekv("cats", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._cats);
        this.writekv("cat_offsets", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._catOffsets);
        this.writekv("numsCenter", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._nums);
        this.writekv("num", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo._nums + numGamCols);
        boolean imputeMeans = ((GAMModel.GAMParameters)((GAMModel)this.model)._parms).missingValuesHandling().equals((Object)GLMModel.GLMParameters.MissingValuesHandling.MeanImputation);
        this.writekv("mean_imputation", imputeMeans);
        if (imputeMeans) {
            this.writekv("numNAFillsCenter", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.numNAFill());
            this.writekv("catNAFills", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._dinfo.catNAFill());
        }
        if (((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family.equals((Object)GLMModel.GLMParameters.Family.binomial)) {
            this.writekv("family", "bernoulli");
        } else {
            this.writekv("family", (Object)((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family);
        }
        this.writekv("link", (Object)((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._link);
        if (((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family.equals((Object)GLMModel.GLMParameters.Family.tweedie)) {
            this.writekv("tweedie_link_power", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._tweedie_link_power);
        }
        this.writekv("num_knots", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._num_knots);
        this.writekv("num_knots_sorted", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._num_knots_sorted);
        this.write2DStringArrays(((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns, "gam_columns");
        this.write2DStringArrays(((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns_sorted, "gam_columns_sorted");
        int numGamLength = 0;
        int numGamCLength = 0;
        for (int cInd = 0; cInd < numGamCols; ++cInd) {
            numGamLength += ((GAMModel)this.model)._gamColNamesNoCentering[cInd].length;
            numGamCLength += ((GAMModel)this.model)._gamColNames[cInd].length;
        }
        int[] gamColumnDim = this.genGamColumnDim(((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns);
        this.writekv("gam_column_dim", gamColumnDim);
        int[] gamColumnDimSorted = this.genGamColumnDim(((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gam_columns_sorted);
        this.writekv("gam_column_dim_sorted", gamColumnDimSorted);
        String[] trainColGamColNoCenter = this.genTrainColGamCols(numGamLength, numGamCLength);
        this.writekv("num_expanded_gam_columns", numGamLength);
        this.writekv("num_expanded_gam_columns_center", numGamCLength);
        this.writeStringArrays(trainColGamColNoCenter, "_names_no_centering");
        this.writekv("total feature size", trainColGamColNoCenter.length);
        int[] gamColNamesDim = this.genGamColumnDim(((GAMModel)this.model)._gamColNamesNoCentering);
        this.writekv("gamColName_dim", gamColNamesDim);
        this.write2DStringArrays(((GAMModel)this.model)._gamColNames, "gamColNamesCenter");
        this.write2DStringArrays(((GAMModel)this.model)._gamColNamesNoCentering, "gamColNames");
        if (((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._family == GLMModel.GLMParameters.Family.ordinal) {
            this.write2DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial_no_centering, "beta_multinomial");
            this.writekv("beta length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial_no_centering[0].length);
            this.write2DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial, "beta_multinomial_centering");
            this.writekv("beta center length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_multinomial[0].length);
        } else {
            this.writekv("beta", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_no_centering);
            this.writekv("beta length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta_no_centering.length);
            this.writekv("beta_center", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta);
            this.writekv("beta center length per class", ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._model_beta.length);
        }
        this.writekv("bs", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._bs);
        this.writekv("bs_sorted", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._bs_sorted);
        this.write3DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._knots, "knots");
        this.write3DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._zTranspose, "zTranspose");
        this.writekv("_d", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._gamPredSize);
        this.writekv("num_CS_col", ((GAMModel)this.model)._cubicSplineNum);
        this.writekv("num_IS_col", ((GAMModel)this.model)._iSplineNum);
        this.writekv("num_MS_col", ((GAMModel)this.model)._mSplineNum);
        if (((GAMModel)this.model)._iSplineNum > 0 || ((GAMModel)this.model)._mSplineNum > 0) {
            this.writekv("spline_orders_sorted", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._spline_orders_sorted);
            this.writekv("spline_orders", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._spline_orders);
        }
        if (((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._zTransposeCS != null) {
            this.write3DIntArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._allPolyBasisList, "polynomialBasisList");
            this.write3DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._zTransposeCS, "zTransposeCS");
            this.write2DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._gamColMeansRaw, "gamColMeansRaw");
            this.write2DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._oneOGamColStd, "gamColStdRaw");
            this.writekv("_M", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._M);
            this.writekv("_m", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._m);
            this.writekv("num_knots_TP", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._num_knots_tp);
            this.writekv("standardize", ((GAMModel.GAMParameters)((GAMModel)this.model)._parms)._standardize);
            this.writekv("num_TP_col", ((GAMModel)this.model)._thinPlateSmoothersWithKnotsNum);
        } else {
            this.writekv("num_TP_col", 0);
        }
        if (((GAMModel)this.model)._cubicSplineNum > 0) {
            this.write3DArray(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._binvD, "_binvD");
        }
    }

    public int[] genGamColumnDim(String[][] gamColumnNames) {
        int numGamCols = gamColumnNames.length;
        int[] gamColDim = new int[numGamCols];
        for (int index = 0; index < numGamCols; ++index) {
            gamColDim[index] = gamColumnNames[index].length;
        }
        return gamColDim;
    }

    public String[] genTrainColGamCols(int gamColLength, int gamCColLength) {
        int colLength = ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._names.length - gamCColLength + gamColLength - 1;
        int normalColLength = ((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._names.length - gamCColLength - 1;
        String[] trainNamesNGamNames = new String[colLength];
        System.arraycopy(((GAMModel.GAMModelOutput)((GAMModel)this.model)._output)._names, 0, trainNamesNGamNames, 0, normalColLength);
        int startInd = normalColLength;
        for (int gind = 0; gind < ((GAMModel)this.model)._gamColNamesNoCentering.length; ++gind) {
            int copyLen = ((GAMModel)this.model)._gamColNamesNoCentering[gind].length;
            System.arraycopy(((GAMModel)this.model)._gamColNamesNoCentering[gind], 0, trainNamesNGamNames, startInd, copyLen);
            startInd += copyLen;
        }
        return trainNamesNGamNames;
    }
}

