/*
 * Decompiled with CFR 0.152.
 */
package hex.gam;

import hex.DataInfo;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.gam.GAMModel;
import hex.gam.GamSplines.ThinPlateDistanceWithKnots;
import hex.gam.GamSplines.ThinPlatePolynomialWithKnots;
import hex.gam.GamSplines.ThinPlateRegressionUtils;
import hex.gam.MatrixFrameUtils.GAMModelUtils;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.gam.MatrixFrameUtils.GenCSSplineGamOneColumn;
import hex.gam.MatrixFrameUtils.GenISplineGamOneColumn;
import hex.gam.MatrixFrameUtils.GenMSplineGamOneColumn;
import hex.genmodel.utils.ArrayUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import hex.gram.Gram;
import hex.util.LinearAlgebraUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import jsr166y.ForkJoinTask;
import jsr166y.RecursiveAction;
import org.apache.commons.lang.NotImplementedException;
import water.DKV;
import water.H2O;
import water.Key;
import water.Lockable;
import water.MemoryManager;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Rapids;
import water.rapids.Val;
import water.util.ArrayUtils;
import water.util.IcedHashSet;
import water.util.Log;

public class GAM
extends ModelBuilder<GAMModel, GAMModel.GAMParameters, GAMModel.GAMModelOutput> {
    private static final int MIN_CSPLINE_NUM_KNOTS = 3;
    private static final int MIN_MorI_SPLINE_KNOTS = 2;
    private double[][][] _knots;
    private int _thinPlateSmoothersWithKnotsNum = 0;
    private int _cubicSplineNum = 0;
    private int _iSplineNum = 0;
    private int _mSplineNum = 0;
    double[][] _gamColMeansRaw;
    public double[][] _oneOGamColStd;
    public double[] _penaltyScale;
    public int _glmNFolds = 0;
    Model.Parameters.FoldAssignmentScheme _foldAssignment = null;
    String _foldColumn = null;
    boolean _cvOn = false;

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression};
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    @Override
    public ModelBuilder.BuilderVisibility builderVisibility() {
        return ModelBuilder.BuilderVisibility.Experimental;
    }

    @Override
    public boolean havePojo() {
        return false;
    }

    @Override
    public boolean haveMojo() {
        return true;
    }

    public GAM(boolean startup_once) {
        super(new GAMModel.GAMParameters(), startup_once);
    }

    public GAM(GAMModel.GAMParameters parms) {
        super(parms);
        this.init(false);
    }

    public GAM(GAMModel.GAMParameters parms, Key<GAMModel> key) {
        super(parms, key);
        this.init(false);
    }

    public double[][][] generateKnotsFromKeys() {
        int numGamCols = ((GAMModel.GAMParameters)this._parms)._gam_columns.length;
        double[][][] knots = new double[numGamCols][][];
        boolean allNull = ((GAMModel.GAMParameters)this._parms)._knot_ids == null;
        int csInd = 0;
        int isInd = this._cubicSplineNum;
        int msInd = this._cubicSplineNum + this._iSplineNum;
        int tpInd = this._cubicSplineNum + this._iSplineNum + this._mSplineNum;
        for (int outIndex = 0; outIndex < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++outIndex) {
            int numBasis;
            int gamIndex;
            String tempKey;
            String string = tempKey = allNull ? null : ((GAMModel.GAMParameters)this._parms)._knot_ids[outIndex];
            if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 1) {
                gamIndex = tpInd++;
            } else if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 0) {
                gamIndex = csInd++;
            } else if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 2) {
                gamIndex = isInd++;
            } else if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 3) {
                gamIndex = msInd++;
            } else {
                throw new NotImplementedException("Spline type not implemented.");
            }
            knots[gamIndex] = new double[((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex].length][];
            if (tempKey != null) {
                Frame knotFrame = (Frame)DKV.getGet(tempKey);
                double[][] knotContent = new double[(int)knotFrame.numRows()][((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex].length];
                ArrayUtils.FrameToArray f2a = new ArrayUtils.FrameToArray(0, ((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex].length - 1, knotFrame.numRows(), knotContent);
                knotContent = ((ArrayUtils.FrameToArray)f2a.doAll(knotFrame)).getArray();
                double[][] knotCTranspose = water.util.ArrayUtils.transpose(knotContent);
                for (int innerIndex = 0; innerIndex < knotCTranspose.length; ++innerIndex) {
                    knots[gamIndex][innerIndex] = new double[knotContent.length];
                    System.arraycopy(knotCTranspose[innerIndex], 0, knots[gamIndex][innerIndex], 0, knots[gamIndex][innerIndex].length);
                    if (knotCTranspose.length != 1 || ((GAMModel.GAMParameters)this._parms)._bs[outIndex] != 0 && ((GAMModel.GAMParameters)this._parms)._bs[outIndex] != 3 && ((GAMModel.GAMParameters)this._parms)._bs[outIndex] != 2) continue;
                    this.failVerifyKnots(knots[gamIndex][innerIndex], outIndex);
                }
                ((GAMModel.GAMParameters)this._parms)._num_knots[outIndex] = knotContent.length;
            } else {
                Frame predictVec = new Frame(((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex], ((GAMModel.GAMParameters)this._parms).train().vecs(((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex]));
                if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 0 || ((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 2 || ((GAMModel.GAMParameters)this._parms)._bs[outIndex] == 3) {
                    knots[gamIndex][0] = GamUtils.generateKnotsOneColumn(predictVec, ((GAMModel.GAMParameters)this._parms)._num_knots[outIndex]);
                    this.failVerifyKnots(knots[gamIndex][0], outIndex);
                } else {
                    knots[gamIndex] = ThinPlateRegressionUtils.genKnotsMultiplePreds(predictVec, (GAMModel.GAMParameters)this._parms, outIndex);
                    this.failVerifyKnots(knots[gamIndex][0], outIndex);
                }
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[outIndex] != 3 || (numBasis = ((GAMModel.GAMParameters)this._parms)._spline_orders[outIndex] + ((GAMModel.GAMParameters)this._parms)._num_knots[outIndex] - 2) >= 2) continue;
            this.error("spline_orders and num_knots", "M-spline for column " + ((GAMModel.GAMParameters)this._parms)._gam_columns[outIndex][0] + " with spline_orders=1 must have more than 2 knots.");
        }
        return knots;
    }

    public void failVerifyKnots(double[] knots, int gam_column_index) {
        for (int index = 0; index < knots.length; ++index) {
            if (Double.isNaN(knots[index])) {
                this.error("gam_columns/knots_id", String.format("Knots generated by default or specified in knots_id ended up containing a NaN value for gam_column %s.   Please specify alternate knots_id or choose other columns.", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index][0]));
                return;
            }
            if (index > 0 && knots[index - 1] > knots[index]) {
                this.error("knots_id", String.format("knots not sorted in ascending order for gam_column %s. Knots at index %d: %f.  Knots at index %d: %f", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index][0], index - 1, knots[index - 1], index, knots[index]));
                return;
            }
            if (index <= 0 || knots[index - 1] != knots[index]) continue;
            this.error("gam_columns/knots_id", String.format("chosen gam_column %s does have not enough values to generate well-defined knots. Please choose other columns or reduce the number of knots.  If knots are specified in knots_id, choose alternate knots_id as the knots are not in ascending order.  Knots at index %d: %f.  Knots at index %d: %f", ((GAMModel.GAMParameters)this._parms)._gam_columns[gam_column_index][0], index - 1, knots[index - 1], index, knots[index]));
            return;
        }
    }

    @Override
    public void init(boolean expensive) {
        if (((GAMModel.GAMParameters)this._parms)._nfolds > 0 || ((GAMModel.GAMParameters)this._parms)._fold_column != null) {
            ((GAMModel.GAMParameters)this._parms)._glmCvOn = true;
            ((GAMModel.GAMParameters)this._parms)._glmNFolds = ((GAMModel.GAMParameters)this._parms)._fold_column == null ? ((GAMModel.GAMParameters)this._parms)._nfolds : ((GAMModel.GAMParameters)this._parms).train().vec(((GAMModel.GAMParameters)this._parms)._fold_column).toCategoricalVec().domain().length;
            this._cvOn = true;
            this._glmNFolds = ((GAMModel.GAMParameters)this._parms)._glmNFolds;
            if (((GAMModel.GAMParameters)this._parms)._fold_assignment != null) {
                ((GAMModel.GAMParameters)this._parms)._glmFoldAssignment = ((GAMModel.GAMParameters)this._parms)._fold_assignment;
                this._foldAssignment = ((GAMModel.GAMParameters)this._parms)._fold_assignment;
                ((GAMModel.GAMParameters)this._parms)._fold_assignment = null;
            }
            if (((GAMModel.GAMParameters)this._parms)._fold_column != null) {
                ((GAMModel.GAMParameters)this._parms)._glmFoldColumn = ((GAMModel.GAMParameters)this._parms)._fold_column;
                this._foldColumn = ((GAMModel.GAMParameters)this._parms)._fold_column;
                ((GAMModel.GAMParameters)this._parms)._fold_column = null;
            }
            ((GAMModel.GAMParameters)this._parms)._nfolds = 0;
        }
        super.init(expensive);
        if (((GAMModel.GAMParameters)this._parms)._bs != null) {
            boolean containsMonotoneSplines;
            boolean allMonotoneSplines = Arrays.stream(((GAMModel.GAMParameters)this._parms)._bs).filter(x -> x == 2).count() == (long)((GAMModel.GAMParameters)this._parms)._bs.length;
            boolean bl = containsMonotoneSplines = Arrays.stream(((GAMModel.GAMParameters)this._parms)._bs).filter(x -> x == 2).count() > 0L;
            if (allMonotoneSplines && containsMonotoneSplines && !((GAMModel.GAMParameters)this._parms)._non_negative) {
                this.warn("non_negative", " is not set to true when I-spline/monotone-spline (bs=2) is chosen.  You will not get monotonic output in this case even though you choose I-spline.");
            }
        }
        if (expensive && this._knots == null) {
            this.validateGAMParameters();
        }
    }

    private void validateGAMParameters() {
        if (((GAMModel.GAMParameters)this._parms)._max_iterations == 0) {
            this.error("_max_iterations", H2O.technote(2, "if specified, must be >= 1."));
        }
        if (((GAMModel.GAMParameters)this._parms)._gam_columns == null) {
            this.error("_gam_columns", "must specify columns names to apply GAM to.  If you don't have any, use GLM.");
        } else {
            this.checkGAMParamsLengths();
            if (((GAMModel.GAMParameters)this._parms)._bs == null) {
                GamUtils.setDefaultBSType((GAMModel.GAMParameters)this._parms);
            }
            this.assertValidGAMColumnsCountSplineTypes();
        }
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        if (((GAMModel.GAMParameters)this._parms)._scale == null) {
            GamUtils.setDefaultScale((GAMModel.GAMParameters)this._parms);
        }
        GamUtils.setGamPredSize((GAMModel.GAMParameters)this._parms, this._cubicSplineNum + this._iSplineNum + this._mSplineNum);
        if (this._thinPlateSmoothersWithKnotsNum > 0) {
            GamUtils.setThinPlateParameters((GAMModel.GAMParameters)this._parms, this._thinPlateSmoothersWithKnotsNum);
        }
        this.checkOrChooseNumKnots();
        this.checkTrainRowNumKnots();
        this._knots = this.generateKnotsFromKeys();
        GamUtils.sortGAMParameters((GAMModel.GAMParameters)this._parms, this._cubicSplineNum, this._iSplineNum, this._mSplineNum);
        this.checkThinPlateParams();
        if (((GAMModel.GAMParameters)this._parms)._saveZMatrix && this._train.numCols() - 1 + ((GAMModel.GAMParameters)this._parms)._num_knots.length < 2) {
            this.error("_saveZMatrix", "can only be enabled if the number of predictors plus Gam columns in gam_columns exceeds 2");
        }
        if (((GAMModel.GAMParameters)this._parms)._lambda_search || !((GAMModel.GAMParameters)this._parms)._intercept || ((GAMModel.GAMParameters)this._parms)._lambda == null || ((GAMModel.GAMParameters)this._parms)._lambda[0] > 0.0) {
            ((GAMModel.GAMParameters)this._parms)._use_all_factor_levels = true;
        }
        this.checkNFamilyNLinkAssignment();
    }

    public void checkTrainRowNumKnots() {
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
            Frame dataset = ((GAMModel.GAMParameters)this._parms).train();
            String cname = ((GAMModel.GAMParameters)this._parms)._gam_columns[index][0];
            if (((GAMModel.GAMParameters)this._parms)._bs[index] < 0 && ((GAMModel.GAMParameters)this._parms)._bs[index] > 3) {
                this.error("bs", " bs can only be 0, 1, 2 and 3 but is " + ((GAMModel.GAMParameters)this._parms)._bs[index]);
            }
            if (!dataset.vec(cname).isInt() || !(dataset.vec(cname).max() - dataset.vec(cname).min() + 1.0 < (double)((GAMModel.GAMParameters)this._parms)._num_knots[index])) continue;
            this.error("gam_columns", "column " + cname + " has cardinality lower than the number of knots and cannot be used as a gam column.");
        }
    }

    public void checkGAMParamsLengths() {
        if (((GAMModel.GAMParameters)this._parms)._bs != null && ((GAMModel.GAMParameters)this._parms)._gam_columns.length != ((GAMModel.GAMParameters)this._parms)._bs.length) {
            this.error("bs", "Number of spline types in bs must match the number of gam column groups (gam_columns.length) specified in gam_columns");
        }
        if (((GAMModel.GAMParameters)this._parms)._knot_ids != null && ((GAMModel.GAMParameters)this._parms)._knot_ids.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("knot_ids", "Number of knot_ids specified must match the number of gam column groups (gam_columns.length) specified in gam_columns");
        }
        if (((GAMModel.GAMParameters)this._parms)._num_knots != null && ((GAMModel.GAMParameters)this._parms)._num_knots.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("num_knots", "Number of num_knots specified must match the number of gam column groups (gam_columns.length) specified in gam_columns");
        }
        if (((GAMModel.GAMParameters)this._parms)._scale != null && ((GAMModel.GAMParameters)this._parms)._scale.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("scale", "Number of scale specified must match the number of gam column groups (gam_columns.length) specified in gam_columns");
        }
        if (((GAMModel.GAMParameters)this._parms)._splines_non_negative != null && ((GAMModel.GAMParameters)this._parms)._splines_non_negative.length != ((GAMModel.GAMParameters)this._parms)._gam_columns.length) {
            this.error("splines_non_negative", "Number of splines_non_negative specified must match the number of gam column groups (gam_columns.length) specified in gam_columns");
        }
    }

    public void checkNFamilyNLinkAssignment() {
        if (((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.AUTO) {
            if (this.nclasses() == 1 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.identity && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.log && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.inverse && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote(2, "AUTO for undelying response requires the link to be family_default, identity, log or inverse."));
            } else if (this.nclasses() == 2 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default && ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.logit && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote(2, "AUTO for undelying response requires the link to be family_default or logit."));
            } else if (this.nclasses() > 2 & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.family_default & ((GAMModel.GAMParameters)this._parms)._link != GLMModel.GLMParameters.Link.multinomial && ((GAMModel.GAMParameters)this._parms)._link != null) {
                this.error("_family", H2O.technote(2, "AUTO for undelying response requires the link to be family_default or multinomial."));
            }
            ((GAMModel.GAMParameters)this._parms)._family = this._nclass == 1 ? GLMModel.GLMParameters.Family.gaussian : (this._nclass == 2 ? GLMModel.GLMParameters.Family.binomial : GLMModel.GLMParameters.Family.multinomial);
        }
        if (((GAMModel.GAMParameters)this._parms)._link == null || ((GAMModel.GAMParameters)this._parms)._link.equals((Object)GLMModel.GLMParameters.Link.family_default)) {
            ((GAMModel.GAMParameters)this._parms)._link = ((GAMModel.GAMParameters)this._parms)._family.defaultLink;
        }
        if ((((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.binomial) && this.response().get_type() != 4) {
            this.error("_response_column", String.format("For given response family '%s', please provide a categorical response column. Current response column type is '%s'.", new Object[]{((GAMModel.GAMParameters)this._parms)._family, this.response().get_type_str()}));
        }
    }

    public void checkThinPlateParams() {
        if (this._thinPlateSmoothersWithKnotsNum == 0) {
            return;
        }
        ((GAMModel.GAMParameters)this._parms)._num_knots_tp = new int[this._thinPlateSmoothersWithKnotsNum];
        System.arraycopy(((GAMModel.GAMParameters)this._parms)._num_knots_sorted, this._cubicSplineNum + this._iSplineNum + this._mSplineNum, ((GAMModel.GAMParameters)this._parms)._num_knots_tp, 0, this._thinPlateSmoothersWithKnotsNum);
        int tpIndex = 0;
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
            if (((GAMModel.GAMParameters)this._parms)._bs_sorted[index] != 1) continue;
            if (((GAMModel.GAMParameters)this._parms)._num_knots_sorted[index] < ((GAMModel.GAMParameters)this._parms)._M[tpIndex] + 1) {
                this.error("num_knots", "num_knots for gam column start with  " + ((GAMModel.GAMParameters)this._parms)._gam_columns_sorted[index][0] + " did not specify enough num_knots.  It should be equal or greater than " + (((GAMModel.GAMParameters)this._parms)._M[tpIndex] + 1) + ".");
            }
            ++tpIndex;
        }
    }

    public void checkOrChooseNumKnots() {
        if (((GAMModel.GAMParameters)this._parms)._num_knots == null) {
            ((GAMModel.GAMParameters)this._parms)._num_knots = new int[((GAMModel.GAMParameters)this._parms)._gam_columns.length];
        }
        if (((GAMModel.GAMParameters)this._parms)._spline_orders == null) {
            ((GAMModel.GAMParameters)this._parms)._spline_orders = new int[((GAMModel.GAMParameters)this._parms)._gam_columns.length];
            Arrays.fill(((GAMModel.GAMParameters)this._parms)._spline_orders, 3);
        } else {
            for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._spline_orders.length; ++index) {
                if (((GAMModel.GAMParameters)this._parms)._bs[index] != 2 && ((GAMModel.GAMParameters)this._parms)._bs[index] != 3 || ((GAMModel.GAMParameters)this._parms)._spline_orders[index] >= 1) continue;
                this.error("spline_orders", "GAM I-spline spline_orders must be >= 1");
            }
        }
        int tpCount = 0;
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._num_knots.length; ++index) {
            if (((GAMModel.GAMParameters)this._parms)._knot_ids != null && (((GAMModel.GAMParameters)this._parms)._knot_ids == null || ((GAMModel.GAMParameters)this._parms)._knot_ids[index] != null)) continue;
            int numKnots = ((GAMModel.GAMParameters)this._parms)._num_knots[index];
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 2 || ((GAMModel.GAMParameters)this._parms)._bs[index] == 3) {
                if (((GAMModel.GAMParameters)this._parms)._num_knots[index] == 0) {
                    ((GAMModel.GAMParameters)this._parms)._num_knots[index] = 2;
                    if (((GAMModel.GAMParameters)this._parms)._bs[index] == 3 && ((GAMModel.GAMParameters)this._parms)._spline_orders[index] == 1) {
                        int n = index;
                        ((GAMModel.GAMParameters)this._parms)._num_knots[n] = ((GAMModel.GAMParameters)this._parms)._num_knots[n] + 1;
                    }
                } else if (((GAMModel.GAMParameters)this._parms)._num_knots[index] < 2) {
                    this.error("num_knots", " must >= 2 for M or I-splines.");
                }
            }
            int naSum = 0;
            for (int innerIndex = 0; innerIndex < ((GAMModel.GAMParameters)this._parms)._gam_columns[index].length; ++innerIndex) {
                naSum = (int)((long)naSum + ((GAMModel.GAMParameters)this._parms).train().vec(((GAMModel.GAMParameters)this._parms)._gam_columns[index][innerIndex]).naCnt());
            }
            long eligibleRows = this._train.numRows() - (long)naSum;
            if (((GAMModel.GAMParameters)this._parms)._num_knots[index] == 0) {
                int defaultRows = 10;
                if (((GAMModel.GAMParameters)this._parms)._bs[index] == 1) {
                    defaultRows = Math.max(defaultRows, ((GAMModel.GAMParameters)this._parms)._M[tpCount] + 2);
                    ++tpCount;
                }
                if (((GAMModel.GAMParameters)this._parms)._bs[index] == 2 || ((GAMModel.GAMParameters)this._parms)._bs[index] == 3) {
                    defaultRows = 2;
                }
                ((GAMModel.GAMParameters)this._parms)._num_knots[index] = eligibleRows < (long)defaultRows ? (int)eligibleRows : defaultRows;
                continue;
            }
            if ((long)numKnots > eligibleRows) {
                this.error("num_knots", " number of knots specified in num_knots: " + numKnots + " for smoother with first predictor " + ((GAMModel.GAMParameters)this._parms)._gam_columns[index][0] + ".  Reduce _num_knots.");
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 0 && ((GAMModel.GAMParameters)this._parms)._num_knots[index] < 3) {
                this.error("num_knots", " number of knots specified in num_knots " + numKnots + " for cs splines must be >= " + 3 + ".");
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] != 2 && ((GAMModel.GAMParameters)this._parms)._bs[index] != 3 || ((GAMModel.GAMParameters)this._parms)._num_knots[index] >= 2) continue;
            this.error("num_knots", " number of knots specified " + numKnots + " for M or I-splines must be >= " + 2);
        }
    }

    public void assertValidGAMColumnsCountSplineTypes() {
        Frame dataset = ((GAMModel.GAMParameters)this._parms).train();
        List<String> cNames = Arrays.asList(dataset.names());
        for (int index = 0; index < ((GAMModel.GAMParameters)this._parms)._gam_columns.length; ++index) {
            if (((GAMModel.GAMParameters)this._parms)._bs == null) continue;
            if (((GAMModel.GAMParameters)this._parms)._gam_columns[index].length > 1 && ((GAMModel.GAMParameters)this._parms)._bs[index] != 1) {
                this.error("bs", "Smoother with multiple predictors can only use with thin plate spines, i.e., bs = 1");
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 1) {
                ++this._thinPlateSmoothersWithKnotsNum;
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 0) {
                ++this._cubicSplineNum;
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 2) {
                if (GLMModel.GLMParameters.Family.multinomial.equals((Object)((GAMModel.GAMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.ordinal.equals((Object)((GAMModel.GAMParameters)this._parms)._family)) {
                    this.error("family", "multinomial and ordinal families cannot be used with I-splines.");
                }
                ++this._iSplineNum;
            }
            if (((GAMModel.GAMParameters)this._parms)._bs[index] == 3) {
                ++this._mSplineNum;
            }
            for (int innerIndex = 0; innerIndex < ((GAMModel.GAMParameters)this._parms)._gam_columns[index].length; ++innerIndex) {
                String cname = ((GAMModel.GAMParameters)this._parms)._gam_columns[index][innerIndex];
                if (!cNames.contains(cname)) {
                    this.error("gam_columns", "column name: " + cname + " does not exist in your dataset.");
                }
                if (dataset.vec(cname).isCategorical()) {
                    this.error("gam_columns", "column " + cname + " is categorical and cannot be used as a gam column.");
                }
                if (dataset.vec(cname).isBad() || dataset.vec(cname).isTime() || dataset.vec(cname).isUUID() || dataset.vec(cname).isConst()) {
                    this.error("gam_columns", String.format("Column '%s' of type '%s' cannot be used as GAM column. Column types BAD, TIME, CONSTANT and UUID cannot be used.", cname, dataset.vec(cname).get_type_str()));
                }
                if (dataset.vec(cname).isNumeric()) continue;
                this.error("gam_columns", "column " + cname + " is not numerical and cannot be used as a gam column.");
            }
        }
    }

    @Override
    protected boolean computePriorClassDistribution() {
        return ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.multinomial || ((GAMModel.GAMParameters)this._parms)._family == GLMModel.GLMParameters.Family.ordinal;
    }

    @Override
    protected GAMDriver trainModelImpl() {
        if (((GAMModel.GAMParameters)this._parms)._glmCvOn) {
            this._cvOn = true;
            if (((GAMModel.GAMParameters)this._parms)._glmFoldAssignment != null) {
                this._foldAssignment = ((GAMModel.GAMParameters)this._parms)._glmFoldAssignment;
            }
            if (((GAMModel.GAMParameters)this._parms)._glmFoldColumn != null) {
                this._foldColumn = ((GAMModel.GAMParameters)this._parms)._glmFoldColumn;
            }
            this._glmNFolds = ((GAMModel.GAMParameters)this._parms)._glmNFolds;
        }
        return new GAMDriver();
    }

    @Override
    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(folds, 2);
    }

    private class GAMDriver
    extends ModelBuilder.Driver {
        double[][][] _zTranspose;
        double[][][] _zTransposeCS;
        double[][][] _penaltyMatCenter;
        double[][][] _penaltyMat;
        double[][][] _penaltyMatCS;
        double[][][] _starT;
        public double[][][] _binvD;
        public int[] _numKnots;
        String[][] _gamColNames;
        String[][] _gamColNamesCenter;
        Key<Frame>[] _gamFrameKeysCenter;
        double[][] _gamColMeans;
        int[][][] _allPolyBasisList;
        DataInfo _dinfo;

        private GAMDriver() {
            super(GAM.this);
            this._dinfo = null;
        }

        Frame adaptTrain() {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            this._zTranspose = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.firstOneLess);
            GAMModelUtils.zeroOutIStranspose(((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted, this._zTranspose);
            this._penaltyMat = ((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat ? GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.sameOrig) : (double[][][])null;
            this._penaltyMatCenter = GamUtils.allocate3DArray(numGamFrame, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.bothOneLess);
            GamUtils.removeCenteringIS(this._penaltyMatCenter, (GAMModel.GAMParameters)GAM.this._parms);
            if (GAM.this._cubicSplineNum > 0) {
                this._binvD = GamUtils.allocate3DArrayCS(GAM.this._cubicSplineNum, (GAMModel.GAMParameters)GAM.this._parms, GamUtils.AllocateType.firstTwoLess);
            }
            this._numKnots = MemoryManager.malloc4(numGamFrame);
            this._gamColNames = new String[numGamFrame][];
            this._gamColNamesCenter = new String[numGamFrame][];
            this._gamFrameKeysCenter = new Key[numGamFrame];
            this._gamColMeans = new double[numGamFrame][];
            GAM.this._penaltyScale = new double[numGamFrame];
            if (GAM.this._thinPlateSmoothersWithKnotsNum > 0) {
                int[] kMinusM = water.util.ArrayUtils.subtract(((GAMModel.GAMParameters)GAM.this._parms)._num_knots_tp, ((GAMModel.GAMParameters)GAM.this._parms)._M);
                this._zTransposeCS = GamUtils.allocate3DArrayTP(GAM.this._thinPlateSmoothersWithKnotsNum, (GAMModel.GAMParameters)GAM.this._parms, kMinusM, ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_tp);
                this._penaltyMatCS = GamUtils.allocate3DArrayTP(GAM.this._thinPlateSmoothersWithKnotsNum, (GAMModel.GAMParameters)GAM.this._parms, kMinusM, kMinusM);
                this._allPolyBasisList = new int[GAM.this._thinPlateSmoothersWithKnotsNum][][];
                GAM.this._gamColMeansRaw = new double[GAM.this._thinPlateSmoothersWithKnotsNum][];
                GAM.this._oneOGamColStd = new double[GAM.this._thinPlateSmoothersWithKnotsNum][];
                if (((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat) {
                    this._starT = GamUtils.allocate3DArrayTP(GAM.this._thinPlateSmoothersWithKnotsNum, (GAMModel.GAMParameters)GAM.this._parms, ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_tp, ((GAMModel.GAMParameters)GAM.this._parms)._M);
                }
            }
            this.addGAM2Train();
            return GamUtils.buildGamFrame((GAMModel.GAMParameters)GAM.this._parms, GAM.this._train, this._gamFrameKeysCenter, GAM.this._foldColumn);
        }

        void addGAM2Train() {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            RecursiveAction[] generateGamColumn = new RecursiveAction[numGamFrame];
            int thinPlateInd = 0;
            int singlePredictorSmootherInd = 0;
            Frame trainFrame = ((GAMModel.GAMParameters)GAM.this._parms).train();
            for (int index = 0; index < numGamFrame; ++index) {
                Frame predictVec = GamUtils.prepareGamVec(index, (GAMModel.GAMParameters)GAM.this._parms, trainFrame);
                int numKnots = ((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 2 || ((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 3 ? ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_sorted[index] + ((GAMModel.GAMParameters)GAM.this._parms)._spline_orders_sorted[index] - 2 : ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_sorted[index];
                int numKnotsM1 = numKnots - 1;
                if (((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 1) {
                    int kPlusM = ((GAMModel.GAMParameters)GAM.this._parms)._num_knots_sorted[index] + ((GAMModel.GAMParameters)GAM.this._parms)._M[thinPlateInd];
                    this._gamColNames[index] = new String[kPlusM];
                    this._gamColNamesCenter[index] = new String[numKnotsM1];
                    this._gamColMeans[index] = new double[kPlusM];
                    this._allPolyBasisList[thinPlateInd] = new int[((GAMModel.GAMParameters)GAM.this._parms)._M[thinPlateInd]][((GAMModel.GAMParameters)GAM.this._parms)._gamPredSize[index]];
                    GAM.this._gamColMeansRaw[thinPlateInd] = new double[((GAMModel.GAMParameters)GAM.this._parms)._gamPredSize[index]];
                    GAM.this._oneOGamColStd[thinPlateInd] = new double[((GAMModel.GAMParameters)GAM.this._parms)._gamPredSize[index]];
                    generateGamColumn[index] = new ThinPlateRegressionSmootherWithKnots(predictVec, (GAMModel.GAMParameters)GAM.this._parms, index, GAM.this._knots[index], thinPlateInd++);
                    continue;
                }
                this._gamColNames[index] = GamUtils.generateGamColNames(index, (GAMModel.GAMParameters)GAM.this._parms);
                this._gamColMeans[index] = new double[numKnots];
                if (((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 0) {
                    this._gamColNamesCenter[index] = new String[numKnotsM1];
                    generateGamColumn[index] = new CubicSplineSmoother(predictVec, (GAMModel.GAMParameters)GAM.this._parms, index, this._gamColNames[index], GAM.this._knots[index][0], singlePredictorSmootherInd++);
                    continue;
                }
                if (((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 2) {
                    this._gamColNamesCenter[index] = new String[numKnots];
                    generateGamColumn[index] = new ISplineSmoother(predictVec, (GAMModel.GAMParameters)GAM.this._parms, index, this._gamColNames[index], GAM.this._knots[index][0], singlePredictorSmootherInd++);
                    continue;
                }
                if (((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] == 3) {
                    this._gamColNamesCenter[index] = new String[numKnotsM1];
                    generateGamColumn[index] = new MSplineSmoother(predictVec, (GAMModel.GAMParameters)GAM.this._parms, index, this._gamColNames[index], GAM.this._knots[index][0], singlePredictorSmootherInd++);
                    continue;
                }
                throw new NotImplementedException("Spline type not implemented.");
            }
            ForkJoinTask.invokeAll(generateGamColumn);
            if (GAM.this._iSplineNum > 0 && !((GAMModel.GAMParameters)GAM.this._parms)._betaConstraintsOff) {
                Frame constraintF = this.genConstraints();
                Scope.track(constraintF);
                if (((GAMModel.GAMParameters)GAM.this._parms)._beta_constraints != null) {
                    DKV.put(constraintF);
                    Frame origConstraints = (Frame)DKV.getGet(((GAMModel.GAMParameters)GAM.this._parms)._beta_constraints);
                    String tree = "(rbind " + origConstraints.getKey().toString() + " " + constraintF.getKey().toString() + " )";
                    Val val = Rapids.exec(tree);
                    Frame newConstraints = new Frame(val.getFrame());
                    DKV.put(newConstraints);
                    Scope.track(newConstraints);
                    ((GAMModel.GAMParameters)GAM.this._parms)._beta_constraints = newConstraints._key;
                } else {
                    ((GAMModel.GAMParameters)GAM.this._parms)._beta_constraints = constraintF._key;
                    DKV.put(constraintF);
                }
            }
        }

        public Frame genConstraints() {
            int numGamCols = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            String[] colNames = new String[]{"names", "lower_bounds", "upper_bounds"};
            Vec.VectorGroup vg = Vec.VectorGroup.VG_LEN1;
            ArrayList iSplineColNames = new ArrayList();
            ArrayList upperBList = new ArrayList();
            ArrayList lowerBList = new ArrayList();
            for (int index = 0; index < numGamCols; ++index) {
                if (((GAMModel.GAMParameters)GAM.this._parms)._bs_sorted[index] != 2) continue;
                int numCols = this._gamColNamesCenter[index].length;
                iSplineColNames.addAll(Stream.of(this._gamColNamesCenter[index]).collect(Collectors.toList()));
                if (((GAMModel.GAMParameters)GAM.this._parms)._splines_non_negative_sorted[index]) {
                    upperBList.addAll(DoubleStream.generate(() -> Double.POSITIVE_INFINITY).limit(numCols).boxed().collect(Collectors.toList()));
                    lowerBList.addAll(DoubleStream.generate(() -> 0.0).limit(numCols).boxed().collect(Collectors.toList()));
                    continue;
                }
                upperBList.addAll(DoubleStream.generate(() -> 0.0).limit(numCols).boxed().collect(Collectors.toList()));
                lowerBList.addAll(DoubleStream.generate(() -> Double.NEGATIVE_INFINITY).limit(numCols).boxed().collect(Collectors.toList()));
            }
            int numConstraints = iSplineColNames.size();
            if (numConstraints > 0) {
                String[] constraintNames = (String[])iSplineColNames.stream().toArray(String[]::new);
                double[] lowerBounds = lowerBList.stream().mapToDouble(Double::doubleValue).toArray();
                double[] upperBounds = upperBList.stream().mapToDouble(Double::doubleValue).toArray();
                Vec gamNames = Scope.track(Vec.makeVec(constraintNames, vg.addVec()));
                Vec lowBounds = Scope.track(Vec.makeVec(lowerBounds, vg.addVec()));
                Vec upBounds = Scope.track(Vec.makeVec(upperBounds, vg.addVec()));
                return new Frame(Key.make(), colNames, new Vec[]{gamNames, lowBounds, upBounds});
            }
            return null;
        }

        void verifyGamTransformedFrame(Frame gamTransformed) {
            int numGamFrame = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            for (int findex = 0; findex < numGamFrame; ++findex) {
                int numGamCols = this._gamColNamesCenter[findex].length;
                for (int index = 0; index < numGamCols; ++index) {
                    if (!gamTransformed.vec(this._gamColNamesCenter[findex][index]).isConst()) continue;
                    GAM.this.error(this._gamColNamesCenter[findex][index], "gam column transformation generated constant columns for " + ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns[findex]);
                }
            }
        }

        @Override
        public void computeImpl() {
            Frame newValidFrame;
            GAM.this.init(true);
            if (GAM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(GAM.this);
            }
            Frame newTFrame = new Frame(GAM.this.rebalance(this.adaptTrain(), false, Key.make() + ".temporary.train"));
            this.verifyGamTransformedFrame(newTFrame);
            if (GAM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(GAM.this);
            }
            if (GAM.this.valid() != null) {
                int[] singleGamColsCount = new int[]{GAM.this._cubicSplineNum, GAM.this._iSplineNum, GAM.this._mSplineNum};
                GAM.this._valid = GAM.this.rebalance(GAMModel.adaptValidFrame(((GAMModel.GAMParameters)GAM.this._parms).valid(), GAM.this._valid, (GAMModel.GAMParameters)GAM.this._parms, this._gamColNamesCenter, this._binvD, this._zTranspose, GAM.this._knots, this._zTransposeCS, this._allPolyBasisList, GAM.this._gamColMeansRaw, GAM.this._oneOGamColStd, singleGamColsCount), false, Key.make() + ".temporary.valid");
            }
            DKV.put(newTFrame);
            Frame frame = newValidFrame = GAM.this._valid == null ? null : new Frame(GAM.this._valid);
            if (newValidFrame != null) {
                DKV.put(newValidFrame);
            }
            GAM.this._job.update(0L, "Initializing model training");
            this.buildModel(newTFrame, newValidFrame);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void buildModel(Frame newTFrame, Frame newValidFrame) {
            Lockable model = null;
            IcedHashSet<Key> validKeys = new IcedHashSet<Key>();
            try {
                GAM.this._job.update(0L, "Adding GAM columns to training dataset...");
                if (GAM.this._foldColumn != null) {
                    ((GAMModel.GAMParameters)GAM.this._parms)._fold_column = GAM.this._foldColumn;
                }
                this._dinfo = new DataInfo((Frame)GAM.this._train.clone(), GAM.this._valid, 1, ((GAMModel.GAMParameters)GAM.this._parms)._use_all_factor_levels || ((GAMModel.GAMParameters)GAM.this._parms)._lambda_search, ((GAMModel.GAMParameters)GAM.this._parms)._standardize ? DataInfo.TransformType.STANDARDIZE : DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || ((GAMModel.GAMParameters)GAM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.PlugValues, ((GAMModel.GAMParameters)GAM.this._parms).makeImputer(), false, GAM.this.hasWeightCol(), GAM.this.hasOffsetCol(), GAM.this.hasFoldCol(), ((GAMModel.GAMParameters)GAM.this._parms).interactionSpec());
                DKV.put(this._dinfo._key, this._dinfo);
                if (GAM.this._foldColumn != null) {
                    ((GAMModel.GAMParameters)GAM.this._parms)._fold_column = null;
                }
                model = new GAMModel(GAM.this.dest(), (GAMModel.GAMParameters)GAM.this._parms, new GAMModel.GAMModelOutput(GAM.this, this._dinfo));
                model.write_lock(GAM.this._job);
                if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                    ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._gamTransformedTrainCenter = newTFrame._key;
                }
                GAM.this._job.update(1L, "calling GLM to build GAM model...");
                GLMModel glmModel = this.buildGLMModel((GAMModel.GAMParameters)GAM.this._parms, newTFrame, newValidFrame);
                if (((GAMModel)model).evalAutoParamsEnabled) {
                    ((GAMModel)model).initActualParamValuesAfterGlmCreation();
                }
                Scope.track_generic(glmModel);
                GAM.this._job.update(0L, "Building out GAM model...");
                model.update(GAM.this._job);
                this.fillOutGAMModel(glmModel, (GAMModel)model);
                GAM.this._job.update(0L, "Scoring training frame");
                this.scoreGenModelMetrics((GAMModel)model, glmModel, GAM.this.train(), true);
                if (GAM.this.valid() != null) {
                    this.scoreGenModelMetrics((GAMModel)model, glmModel, GAM.this.valid(), false);
                }
            }
            catch (Gram.NonSPDMatrixException exception) {
                try {
                    throw new Gram.NonSPDMatrixException("Consider enable lambda_search, decrease scale parameter value for TP smoothers, \ndisable scaling for TP penalty matrics, or not use thin plate regression smoothers at all.");
                }
                catch (Throwable throwable) {
                    try {
                        ArrayList<Key> keep = new ArrayList<Key>();
                        if (model != null) {
                            if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                                GamUtils.keepFrameKeys(keep, newTFrame._key);
                            } else {
                                DKV.remove(newTFrame._key);
                            }
                            if (GAM.this._cvOn) {
                                if (((GAMModel.GAMParameters)GAM.this._parms)._keep_cross_validation_predictions) {
                                    GamUtils.keepFrameKeys(keep, ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._cross_validation_holdout_predictions_frame_id);
                                    for (int fInd = 0; fInd < GAM.this._glmNFolds; ++fInd) {
                                        GamUtils.keepFrameKeys(keep, ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._cross_validation_predictions[fInd]);
                                    }
                                }
                                if (((GAMModel.GAMParameters)GAM.this._parms)._keep_cross_validation_fold_assignment) {
                                    GamUtils.keepFrameKeys(keep, ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._cross_validation_fold_assignment_frame_id);
                                }
                            }
                        }
                        if (this._dinfo != null) {
                            this._dinfo.remove();
                        }
                        if (newValidFrame != null && validKeys != null) {
                            GamUtils.keepFrameKeys(keep, newValidFrame._key);
                            validKeys.addIfAbsent(newValidFrame._key);
                            ((GAMModel)model)._validKeys = validKeys;
                        }
                        Scope.untrack((Key[])keep.toArray(new Key[keep.size()]));
                        throw throwable;
                    }
                    finally {
                        model.update(GAM.this._job);
                        model.unlock(GAM.this._job);
                    }
                }
            }
            try {
                ArrayList<Key> keep = new ArrayList<Key>();
                if (model != null) {
                    if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                        GamUtils.keepFrameKeys(keep, newTFrame._key);
                    } else {
                        DKV.remove(newTFrame._key);
                    }
                    if (GAM.this._cvOn) {
                        if (((GAMModel.GAMParameters)GAM.this._parms)._keep_cross_validation_predictions) {
                            GamUtils.keepFrameKeys(keep, ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._cross_validation_holdout_predictions_frame_id);
                            for (int fInd = 0; fInd < GAM.this._glmNFolds; ++fInd) {
                                GamUtils.keepFrameKeys(keep, ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._cross_validation_predictions[fInd]);
                            }
                        }
                        if (((GAMModel.GAMParameters)GAM.this._parms)._keep_cross_validation_fold_assignment) {
                            GamUtils.keepFrameKeys(keep, ((GAMModel.GAMModelOutput)((GAMModel)model)._output)._cross_validation_fold_assignment_frame_id);
                        }
                    }
                }
                if (this._dinfo != null) {
                    this._dinfo.remove();
                }
                if (newValidFrame != null && validKeys != null) {
                    GamUtils.keepFrameKeys(keep, newValidFrame._key);
                    validKeys.addIfAbsent(newValidFrame._key);
                    ((GAMModel)model)._validKeys = validKeys;
                }
                Scope.untrack((Key[])keep.toArray(new Key[keep.size()]));
                return;
            }
            finally {
                model.update(GAM.this._job);
                model.unlock(GAM.this._job);
            }
        }

        private void scoreGenModelMetrics(GAMModel model, GLMModel glmModel, Frame scoreFrame, boolean forTraining) {
            ModelMetrics glmMetrics;
            Frame scoringTrain = new Frame(scoreFrame);
            model.adaptTestForTrain(scoringTrain, true, true);
            Frame scoredResult = model.score(scoringTrain);
            scoredResult.delete();
            ModelMetrics modelMetrics = glmMetrics = forTraining ? ((GLMModel.GLMOutput)glmModel._output)._training_metrics : ((GLMModel.GLMOutput)glmModel._output)._validation_metrics;
            if (forTraining) {
                ((GAMModel.GAMModelOutput)model._output).copyMetrics(model, scoringTrain, forTraining, glmMetrics);
                Log.info("GAM[dest=" + GAM.this.dest() + "]" + ((GAMModel.GAMModelOutput)model._output)._training_metrics.toString());
            } else {
                ((GAMModel.GAMModelOutput)model._output).copyMetrics(model, scoringTrain, forTraining, glmMetrics);
                Log.info("GAM[dest=" + GAM.this.dest() + "]" + ((GAMModel.GAMModelOutput)model._output)._validation_metrics.toString());
            }
        }

        GLMModel buildGLMModel(GAMModel.GAMParameters parms, Frame trainData, Frame validFrame) {
            GLMModel.GLMParameters glmParam = this.copyGAMParams2GLMParams(parms, trainData, validFrame);
            int numGamCols = ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns.length;
            for (int find = 0; find < numGamCols; ++find) {
                if (((GAMModel.GAMParameters)GAM.this._parms)._scale_sorted == null || ((GAMModel.GAMParameters)GAM.this._parms)._scale_sorted[find] == 1.0) continue;
                this._penaltyMatCenter[find] = water.util.ArrayUtils.mult(this._penaltyMatCenter[find], ((GAMModel.GAMParameters)GAM.this._parms)._scale_sorted[find]);
            }
            glmParam._glmType = GLMModel.GLMParameters.GLMType.gam;
            if (GAM.this._foldColumn == null) {
                glmParam._nfolds = GAM.this._glmNFolds;
            } else {
                glmParam._fold_column = GAM.this._foldColumn;
                glmParam._nfolds = 0;
            }
            glmParam._fold_assignment = GAM.this._foldAssignment;
            return (GLMModel)new GLM(glmParam, this._penaltyMatCenter, this._gamColNamesCenter).trainModel().get();
        }

        void fillOutGAMModel(GLMModel glm, GAMModel model) {
            model._gamColNamesNoCentering = this._gamColNames;
            model._gamColNames = this._gamColNamesCenter;
            ((GAMModel.GAMModelOutput)model._output)._gamColNames = this._gamColNamesCenter;
            ((GAMModel.GAMModelOutput)model._output)._zTranspose = this._zTranspose;
            ((GAMModel.GAMModelOutput)model._output)._zTransposeCS = this._zTransposeCS;
            ((GAMModel.GAMModelOutput)model._output)._allPolyBasisList = this._allPolyBasisList;
            model._gamFrameKeysCenter = this._gamFrameKeysCenter;
            model._nclass = GAM.this._nclass;
            ((GAMModel.GAMModelOutput)model._output)._binvD = this._binvD;
            ((GAMModel.GAMModelOutput)model._output)._knots = GAM.this._knots;
            ((GAMModel.GAMModelOutput)model._output)._numKnots = this._numKnots;
            model._cubicSplineNum = GAM.this._cubicSplineNum;
            model._mSplineNum = GAM.this._mSplineNum;
            model._iSplineNum = GAM.this._iSplineNum;
            model._thinPlateSmoothersWithKnotsNum = GAM.this._thinPlateSmoothersWithKnotsNum;
            ((GAMModel.GAMModelOutput)model._output)._gamColMeansRaw = GAM.this._gamColMeansRaw;
            ((GAMModel.GAMModelOutput)model._output)._oneOGamColStd = GAM.this._oneOGamColStd;
            ((GAMModel.GAMModelOutput)model._output)._best_alpha = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).alpha_value;
            ((GAMModel.GAMModelOutput)model._output)._best_lambda = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).lambda_value;
            ((GAMModel.GAMModelOutput)model._output)._devianceTrain = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).devianceTrain;
            ((GAMModel.GAMModelOutput)model._output)._devianceValid = ((GLMModel.GLMOutput)glm._output).getSubmodel((int)((GLMModel.GLMOutput)glm._output)._selected_submodel_idx).devianceValid;
            model._gamColMeans = ArrayUtils.flat(this._gamColMeans);
            if (((GAMModel.GAMParameters)GAM.this._parms)._lambda == null) {
                ((GAMModel.GAMParameters)GAM.this._parms)._lambda = (double[])((GLMModel.GLMParameters)glm._parms)._lambda.clone();
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._keep_gam_cols) {
                ((GAMModel.GAMModelOutput)model._output)._gam_transformed_center_key = ((GAMModel.GAMModelOutput)model._output)._gamTransformedTrainCenter.toString();
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._savePenaltyMat) {
                ((GAMModel.GAMModelOutput)model._output)._penaltyMatricesCenter = this._penaltyMatCenter;
                ((GAMModel.GAMModelOutput)model._output)._penaltyMatrices = this._penaltyMat;
                ((GAMModel.GAMModelOutput)model._output)._penaltyScale = GAM.this._penaltyScale;
                if (GAM.this._thinPlateSmoothersWithKnotsNum > 0) {
                    ((GAMModel.GAMModelOutput)model._output)._penaltyMatCS = this._penaltyMatCS;
                    ((GAMModel.GAMModelOutput)model._output)._starT = this._starT;
                }
            }
            if (((GAMModel.GAMParameters)GAM.this._parms)._store_knot_locations) {
                ((GAMModel.GAMModelOutput)model._output).copyKnots(GAM.this._knots, ((GAMModel.GAMParameters)GAM.this._parms)._gam_columns_sorted);
            }
            GAMModelUtils.copyGLMCoeffs(glm, model, (GAMModel.GAMParameters)GAM.this._parms, GAM.this.nclasses());
            GAMModelUtils.copyGLMtoGAMModel(model, glm, (GAMModel.GAMParameters)GAM.this._parms, GAM.this.valid() != null);
            if (GAM.this._cvOn) {
                ((GAMModel.GAMParameters)GAM.this._parms)._betaConstraintsOff = true;
                GamUtils.copyCVGLMtoGAMModel(model, glm, (GAMModel.GAMParameters)GAM.this._parms, GAM.this._foldColumn);
                ((GAMModel.GAMParameters)GAM.this._parms)._betaConstraintsOff = false;
                ((GAMModel.GAMParameters)GAM.this._parms)._nfolds = GAM.this._foldColumn == null ? GAM.this._glmNFolds : 0;
                ((GAMModel.GAMParameters)GAM.this._parms)._fold_assignment = GAM.this._foldAssignment;
                ((GAMModel.GAMParameters)GAM.this._parms)._fold_column = GAM.this._foldColumn;
            }
        }

        public GLMModel.GLMParameters copyGAMParams2GLMParams(GAMModel.GAMParameters parms, Frame trainData, Frame valid) {
            GLMModel.GLMParameters glmParam = new GLMModel.GLMParameters();
            List<String> gamOnlyList = Arrays.asList("_num_knots", "_gam_columns", "_bs", "_scale", "_train", "_saveZMatrix", "_saveGamCols", "_savePenaltyMat");
            Field[] field1 = GAMModel.GAMParameters.class.getDeclaredFields();
            GamUtils.setParamField(parms, glmParam, false, field1, gamOnlyList);
            Field[] field2 = Model.Parameters.class.getDeclaredFields();
            GamUtils.setParamField(parms, glmParam, true, field2, gamOnlyList);
            glmParam._train = trainData._key;
            glmParam._valid = valid == null ? null : valid._key;
            glmParam._nfolds = GAM.this._glmNFolds;
            glmParam._fold_assignment = GAM.this._foldAssignment;
            return glmParam;
        }

        public class CubicSplineSmoother
        extends RecursiveAction {
            final Frame _predictVec;
            final int _numKnots;
            final int _numKnotsM1;
            final int _splineType;
            final boolean _savePenaltyMat;
            final String[] _newColNames;
            final double[] _knots;
            final GAMModel.GAMParameters _parms;
            final int _gamColIndex;
            final int _singlePredSplineInd;

            public CubicSplineSmoother(Frame predV, GAMModel.GAMParameters parms, int gamColIndex, String[] gamColNames, double[] knots, int csInd) {
                this._predictVec = predV;
                this._numKnots = parms._num_knots_sorted[gamColIndex];
                this._numKnotsM1 = this._numKnots - 1;
                this._splineType = parms._bs_sorted[gamColIndex];
                this._savePenaltyMat = parms._savePenaltyMat;
                this._newColNames = gamColNames;
                this._knots = knots;
                this._parms = parms;
                this._gamColIndex = gamColIndex;
                this._singlePredSplineInd = csInd;
            }

            @Override
            protected void compute() {
                GenCSSplineGamOneColumn genOneGamCol = (GenCSSplineGamOneColumn)new GenCSSplineGamOneColumn(this._splineType, this._numKnots, this._knots, this._predictVec).doAll(this._numKnots, (byte)3, this._predictVec);
                if (this._savePenaltyMat) {
                    water.util.ArrayUtils.copy2DArray(genOneGamCol._penaltyMat, GAMDriver.this._penaltyMat[this._gamColIndex]);
                    GAM.this._penaltyScale[this._gamColIndex] = genOneGamCol._s_scale;
                }
                Frame oneAugmentedColumnCenter = genOneGamCol.outputFrame(Key.make(), this._newColNames, null);
                for (int index = 0; index < this._numKnots; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index] = oneAugmentedColumnCenter.vec(index).mean();
                }
                oneAugmentedColumnCenter = genOneGamCol.centralizeFrame(oneAugmentedColumnCenter, this._predictVec.name(0) + "_" + this._splineType + "_center_cs_", this._parms);
                water.util.ArrayUtils.copy2DArray(genOneGamCol._ZTransp, GAMDriver.this._zTranspose[this._gamColIndex]);
                double[][] transformedPenalty = water.util.ArrayUtils.multArrArr(water.util.ArrayUtils.multArrArr(genOneGamCol._ZTransp, genOneGamCol._penaltyMat), water.util.ArrayUtils.transpose(genOneGamCol._ZTransp));
                water.util.ArrayUtils.copy2DArray(transformedPenalty, GAMDriver.this._penaltyMatCenter[this._gamColIndex]);
                GAMDriver.this._gamFrameKeysCenter[this._gamColIndex] = oneAugmentedColumnCenter._key;
                DKV.put(oneAugmentedColumnCenter);
                System.arraycopy(oneAugmentedColumnCenter.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, this._numKnotsM1);
                water.util.ArrayUtils.copy2DArray(genOneGamCol._bInvD, GAMDriver.this._binvD[this._singlePredSplineInd]);
            }
        }

        public class MSplineSmoother
        extends RecursiveAction {
            final Frame _predictVec;
            final int _numKnots;
            final int _order;
            final double[] _knots;
            final boolean _savePenaltyMat;
            final String[] _newGAMColNames;
            final int _gamColIndex;
            final int _singlePredSplineInd;
            final int _splineType;

            public MSplineSmoother(Frame gamPred, GAMModel.GAMParameters parms, int gamColIndex, String[] gamColNames, double[] knots, int singlePredInd) {
                this._predictVec = gamPred;
                this._numKnots = parms._num_knots_sorted[gamColIndex];
                this._knots = knots;
                this._order = parms._spline_orders_sorted[gamColIndex];
                this._savePenaltyMat = parms._savePenaltyMat;
                this._newGAMColNames = gamColNames;
                this._gamColIndex = gamColIndex;
                this._singlePredSplineInd = singlePredInd;
                this._splineType = parms._bs_sorted[gamColIndex];
            }

            @Override
            protected void compute() {
                int order = ((GAMModel.GAMParameters)GAM.this._parms)._spline_orders_sorted[this._gamColIndex];
                int numBasis = this._knots.length + order - 2;
                int numBasisM1 = numBasis - 1;
                int totKnots = numBasis + order;
                GenMSplineGamOneColumn oneGAMCol = new GenMSplineGamOneColumn((GAMModel.GAMParameters)GAM.this._parms, this._knots, this._gamColIndex, this._predictVec, numBasis, totKnots);
                oneGAMCol.doAll(oneGAMCol._numBasis, (byte)3, this._predictVec);
                if (this._savePenaltyMat) {
                    water.util.ArrayUtils.copy2DArray(oneGAMCol._penaltyMat, GAMDriver.this._penaltyMat[this._gamColIndex]);
                    GAM.this._penaltyScale[this._gamColIndex] = oneGAMCol._s_scale;
                }
                Frame oneGamifiedColCenter = oneGAMCol.outputFrame(Key.make(), this._newGAMColNames, null);
                for (int index = 0; index < numBasis; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index] = oneGamifiedColCenter.vec(index).mean();
                }
                oneGamifiedColCenter = oneGAMCol.centralizeFrame(oneGamifiedColCenter, this._predictVec.name(0) + "_" + this._splineType + "_center", (GAMModel.GAMParameters)GAM.this._parms);
                water.util.ArrayUtils.copy2DArray(oneGAMCol._ZTransp, GAMDriver.this._zTranspose[this._gamColIndex]);
                DKV.put(oneGamifiedColCenter);
                GAMDriver.this._gamFrameKeysCenter[this._gamColIndex] = oneGamifiedColCenter._key;
                System.arraycopy(oneGamifiedColCenter.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, numBasisM1);
                double[][] transformedPenalty = water.util.ArrayUtils.multArrArr(water.util.ArrayUtils.multArrArr(oneGAMCol._ZTransp, oneGAMCol._penaltyMat), water.util.ArrayUtils.transpose(oneGAMCol._ZTransp));
                water.util.ArrayUtils.copy2DArray(transformedPenalty, GAMDriver.this._penaltyMatCenter[this._gamColIndex]);
                System.arraycopy(oneGamifiedColCenter.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, numBasisM1);
            }
        }

        public class ISplineSmoother
        extends RecursiveAction {
            final Frame _predictVec;
            final int _numKnots;
            final int _order;
            final double[] _knots;
            final boolean _savePenaltyMat;
            final String[] _newGAMColNames;
            final int _gamColIndex;
            final int _singlePredSplineInd;
            final int _splineType;

            public ISplineSmoother(Frame gamPred, GAMModel.GAMParameters parms, int gamColIndex, String[] gamColNames, double[] knots, int singlePredInd) {
                this._predictVec = gamPred;
                this._numKnots = parms._num_knots_sorted[gamColIndex];
                this._knots = knots;
                this._order = parms._spline_orders_sorted[gamColIndex];
                this._savePenaltyMat = parms._savePenaltyMat;
                this._newGAMColNames = gamColNames;
                this._gamColIndex = gamColIndex;
                this._singlePredSplineInd = singlePredInd;
                this._splineType = parms._bs_sorted[gamColIndex];
            }

            @Override
            protected void compute() {
                int order = ((GAMModel.GAMParameters)GAM.this._parms)._spline_orders_sorted[this._gamColIndex];
                int numBasis = this._knots.length + order - 2;
                int totKnots = numBasis + order;
                GenISplineGamOneColumn oneGAMCol = new GenISplineGamOneColumn((GAMModel.GAMParameters)GAM.this._parms, this._knots, this._gamColIndex, this._predictVec, numBasis, totKnots);
                oneGAMCol.doAll(oneGAMCol._numBasis, (byte)3, this._predictVec);
                if (this._savePenaltyMat) {
                    water.util.ArrayUtils.copy2DArray(oneGAMCol._penaltyMat, GAMDriver.this._penaltyMat[this._gamColIndex]);
                    GAM.this._penaltyScale[this._gamColIndex] = oneGAMCol._s_scale;
                }
                Frame oneGamifiedColumn = oneGAMCol.outputFrame(Key.make(), this._newGAMColNames, null);
                for (int index = 0; index < numBasis; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index] = oneGamifiedColumn.vec(index).mean();
                }
                DKV.put(oneGamifiedColumn);
                GAMDriver.this._gamFrameKeysCenter[this._gamColIndex] = oneGamifiedColumn._key;
                System.arraycopy(oneGamifiedColumn.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, numBasis);
                water.util.ArrayUtils.copy2DArray(oneGAMCol._penaltyMat, GAMDriver.this._penaltyMatCenter[this._gamColIndex]);
            }
        }

        public class ThinPlateRegressionSmootherWithKnots
        extends RecursiveAction {
            final Frame _predictVec;
            final int _numKnots;
            final int _numKnotsM1;
            final int _numKnotsMM;
            final int _splineType;
            final boolean _savePenaltyMat;
            final double[][] _knots;
            final GAMModel.GAMParameters _parms;
            final int _gamColIndex;
            final int _thinPlateGamColIndex;
            final int _numPred;
            final int _M;

            public ThinPlateRegressionSmootherWithKnots(Frame predV, GAMModel.GAMParameters parms, int gamColIndex, double[][] knots, int thinPlateInd) {
                this._predictVec = predV;
                this._knots = knots;
                this._numKnots = parms._num_knots_sorted[gamColIndex];
                this._numKnotsM1 = this._numKnots - 1;
                this._parms = parms;
                this._splineType = this._parms._bs_sorted[gamColIndex];
                this._gamColIndex = gamColIndex;
                this._thinPlateGamColIndex = thinPlateInd;
                this._savePenaltyMat = this._parms._savePenaltyMat;
                this._numPred = parms._gam_columns_sorted[gamColIndex].length;
                this._M = this._parms._M[this._thinPlateGamColIndex];
                this._numKnotsMM = this._numKnots - this._M;
            }

            @Override
            protected void compute() {
                double[] rawColMeans = new double[this._numPred];
                double[] oneOverColStd = new double[this._numPred];
                for (int colInd = 0; colInd < this._numPred; ++colInd) {
                    rawColMeans[colInd] = this._predictVec.vec(colInd).mean();
                    oneOverColStd[colInd] = 1.0 / this._predictVec.vec(colInd).sigma();
                }
                System.arraycopy(rawColMeans, 0, GAM.this._gamColMeansRaw[this._thinPlateGamColIndex], 0, rawColMeans.length);
                System.arraycopy(oneOverColStd, 0, GAM.this._oneOGamColStd[this._thinPlateGamColIndex], 0, oneOverColStd.length);
                ThinPlateDistanceWithKnots distanceMeasure = (ThinPlateDistanceWithKnots)new ThinPlateDistanceWithKnots(this._knots, this._numPred, oneOverColStd, this._parms._standardize_tp_gam_cols).doAll(this._numKnots, (byte)3, this._predictVec);
                List<Integer[]> polyBasisDegree = ThinPlateRegressionUtils.findPolyBasis(this._numPred, ThinPlateRegressionUtils.calculatem(this._numPred));
                int[][] polyBasisArray = ThinPlateRegressionUtils.convertList2Array(polyBasisDegree, this._M, this._numPred);
                water.util.ArrayUtils.copy2DArray(polyBasisArray, GAMDriver.this._allPolyBasisList[this._thinPlateGamColIndex]);
                String colNameStub = ThinPlateRegressionUtils.genThinPlateNameStart(this._parms, this._gamColIndex);
                String[] gamColNames = GamUtils.generateGamColNamesThinPlateKnots(this._gamColIndex, this._parms, polyBasisArray, colNameStub);
                System.arraycopy(gamColNames, 0, GAMDriver.this._gamColNames[this._gamColIndex], 0, gamColNames.length);
                String[] distanceColNames = ThinPlateRegressionUtils.extractColNames(gamColNames, 0, 0, this._numKnots);
                String[] polyNames = ThinPlateRegressionUtils.extractColNames(gamColNames, this._numKnots, 0, this._M);
                Frame thinPlateFrame = distanceMeasure.outputFrame(Key.make(), distanceColNames, null);
                for (int index = 0; index < this._numKnots; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index] = thinPlateFrame.vec(index).mean();
                }
                double[][] starT = ThinPlateRegressionUtils.generateStarT(this._knots, polyBasisDegree, rawColMeans, oneOverColStd, this._parms._standardize_tp_gam_cols);
                double[][] qmat = LinearAlgebraUtils.generateQR(starT);
                double[][] penaltyMat = distanceMeasure.generatePenalty();
                double[][] zCST = LinearAlgebraUtils.generateOrthogonalComplement(qmat, starT, this._numKnotsMM, this._parms._seed);
                water.util.ArrayUtils.copy2DArray(zCST, GAMDriver.this._zTransposeCS[this._thinPlateGamColIndex]);
                ThinPlatePolynomialWithKnots thinPlatePoly = (ThinPlatePolynomialWithKnots)new ThinPlatePolynomialWithKnots(this._numPred, polyBasisArray, rawColMeans, oneOverColStd, this._parms._standardize_tp_gam_cols).doAll(this._M, (byte)3, this._predictVec);
                Frame thinPlatePolyBasis = thinPlatePoly.outputFrame(null, polyNames, null);
                for (int index = 0; index < this._M; ++index) {
                    GAMDriver.this._gamColMeans[this._gamColIndex][index + this._numKnots] = thinPlatePolyBasis.vec(index).mean();
                }
                thinPlateFrame = ThinPlateDistanceWithKnots.applyTransform(thinPlateFrame, colNameStub + "TPKnots_", this._parms, zCST, this._numKnotsMM);
                thinPlateFrame.add(thinPlatePolyBasis.names(), thinPlatePolyBasis.removeAll());
                double[][] ztranspose = GenCSSplineGamOneColumn.generateZTransp(thinPlateFrame, this._numKnots);
                water.util.ArrayUtils.copy2DArray(ztranspose, GAMDriver.this._zTranspose[this._gamColIndex]);
                double[][] penaltyMatCS = water.util.ArrayUtils.multArrArr(water.util.ArrayUtils.multArrArr(zCST, penaltyMat), water.util.ArrayUtils.transpose(zCST));
                if (this._parms._scale_tp_penalty_mat) {
                    ThinPlateRegressionUtils.ScaleTPPenalty scaleTPPenaltyCS = (ThinPlateRegressionUtils.ScaleTPPenalty)new ThinPlateRegressionUtils.ScaleTPPenalty(penaltyMatCS, thinPlateFrame).doAll(thinPlateFrame);
                    GAM.this._penaltyScale[this._gamColIndex] = scaleTPPenaltyCS._s_scale;
                    penaltyMatCS = scaleTPPenaltyCS._penaltyMat;
                }
                double[][] expandPenaltyCS = water.util.ArrayUtils.expandArray(penaltyMatCS, this._numKnots);
                if (this._savePenaltyMat) {
                    water.util.ArrayUtils.copy2DArray(penaltyMat, GAMDriver.this._penaltyMat[this._gamColIndex]);
                    water.util.ArrayUtils.copy2DArray(starT, GAMDriver.this._starT[this._thinPlateGamColIndex]);
                    water.util.ArrayUtils.copy2DArray(penaltyMatCS, GAMDriver.this._penaltyMatCS[this._thinPlateGamColIndex]);
                }
                double[][] penaltyCenter = water.util.ArrayUtils.multArrArr(water.util.ArrayUtils.multArrArr(ztranspose, expandPenaltyCS), water.util.ArrayUtils.transpose(ztranspose));
                water.util.ArrayUtils.copy2DArray(penaltyCenter, GAMDriver.this._penaltyMatCenter[this._gamColIndex]);
                thinPlateFrame = ThinPlateDistanceWithKnots.applyTransform(thinPlateFrame, colNameStub + "center", this._parms, ztranspose, this._numKnotsM1);
                GAMDriver.this._gamFrameKeysCenter[this._gamColIndex] = thinPlateFrame._key;
                DKV.put(thinPlateFrame);
                System.arraycopy(thinPlateFrame.names(), 0, GAMDriver.this._gamColNamesCenter[this._gamColIndex], 0, this._numKnotsM1);
            }
        }
    }
}

