/*
 * Decompiled with CFR 0.152.
 */
package hex.coxph;

import hex.coxph.CoxPH;
import water.H2O;
import water.LocalMR;
import water.MrFun;

class EfronDJKSetupFun
extends MrFun<EfronDJKSetupFun> {
    private final CoxPH.CoxPHTask _coxMR;
    double[] _riskTermT2;
    double[] _cumsumRiskTerm;

    public EfronDJKSetupFun() {
        this._coxMR = null;
    }

    private EfronDJKSetupFun(CoxPH.CoxPHTask coxMR) {
        this._coxMR = coxMR;
        this._riskTermT2 = new double[coxMR.sizeEvents.length];
        this._cumsumRiskTerm = new double[coxMR.sizeEvents.length];
    }

    @Override
    protected void map(int t) {
        double sizeEvents_t = this._coxMR.sizeEvents[t];
        long countEvents_t = this._coxMR.countEvents[t];
        double sumRiskEvents_t = this._coxMR.sumRiskEvents[t];
        double rcumsumRisk_t = this._coxMR.rcumsumRisk[t];
        double avgSize = sizeEvents_t / (double)countEvents_t;
        for (long e = 0L; e < countEvents_t; ++e) {
            double frac = (double)e / (double)countEvents_t;
            double term = rcumsumRisk_t - frac * sumRiskEvents_t;
            int n = t;
            this._riskTermT2[n] = this._riskTermT2[n] + avgSize * frac / term;
            int n2 = t;
            this._cumsumRiskTerm[n2] = this._cumsumRiskTerm[n2] + avgSize / term;
        }
    }

    private EfronDJKSetupFun postProcess() {
        int timeLen = this._coxMR._time.length;
        for (int t = 1; t < this._cumsumRiskTerm.length; ++t) {
            int n = t;
            this._cumsumRiskTerm[n] = this._cumsumRiskTerm[n] + (t % timeLen == 0 ? 0.0 : this._cumsumRiskTerm[t - 1]);
        }
        return this;
    }

    static EfronDJKSetupFun setupEfron(CoxPH.CoxPHTask coxMR) {
        EfronDJKSetupFun djkTermSetup = new EfronDJKSetupFun(coxMR);
        H2O.submitTask(new LocalMR((MrFun)djkTermSetup, coxMR.sizeEvents.length)).join();
        return djkTermSetup.postProcess();
    }
}

