/*
 * Decompiled with CFR 0.152.
 */
package hex.anovaglm;

import hex.DataInfo;
import hex.ModelBuilder;
import hex.ModelBuilderHelper;
import hex.ModelCategory;
import hex.anovaglm.ANOVAGLMModel;
import hex.anovaglm.ANOVAGLMUtils;
import hex.anovaglm.GenerateTransformColumns;
import hex.gam.MatrixFrameUtils.GamUtils;
import hex.glm.GLM;
import hex.glm.GLMModel;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.Key;
import water.Lockable;
import water.Scope;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class ANOVAGLM
extends ModelBuilder<ANOVAGLMModel, ANOVAGLMModel.ANOVAGLMParameters, ANOVAGLMModel.ANOVAGLMModelOutput> {
    public int _numberOfModels = 4;
    public int _numberOfPredCombo = 3;
    public int _numberOfPredictors = 3;
    DataInfo _dinfo;
    String[][] _predictComboNames;
    int[] _degreeOfFreedom;
    String[] _modelNames;
    String[] _predNamesIndividual;
    public String[][] _transformedColNames;
    public int[] _predictorColumnStart;

    public ANOVAGLM(boolean startup_once) {
        super(new ANOVAGLMModel.ANOVAGLMParameters(), startup_once);
    }

    public ANOVAGLM(ANOVAGLMModel.ANOVAGLMParameters parms) {
        super(parms);
        this.init(false);
    }

    public ANOVAGLM(ANOVAGLMModel.ANOVAGLMParameters parms, Key<ANOVAGLMModel> key) {
        super(parms, key);
        this.init(false);
    }

    @Override
    protected int nModelsInParallel(int folds) {
        return this.nModelsInParallel(1, 2);
    }

    @Override
    protected ANOVAGLMDriver trainModelImpl() {
        return new ANOVAGLMDriver();
    }

    @Override
    public ModelCategory[] can_build() {
        return new ModelCategory[]{ModelCategory.Regression, ModelCategory.Binomial, ModelCategory.Multinomial, ModelCategory.Ordinal};
    }

    @Override
    public boolean isSupervised() {
        return true;
    }

    @Override
    public boolean haveMojo() {
        return false;
    }

    @Override
    public boolean havePojo() {
        return false;
    }

    @Override
    public void init(boolean expensive) {
        super.init(expensive);
        if (expensive) {
            this.initValidateAnovaGLMParameters();
        }
    }

    private void initValidateAnovaGLMParameters() {
        if (((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._link == null) {
            ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._link = GLMModel.GLMParameters.Link.family_default;
        }
        this._dinfo = new DataInfo((Frame)this._train.clone(), this._valid, 1, true, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((ANOVAGLMModel.ANOVAGLMParameters)this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((ANOVAGLMModel.ANOVAGLMParameters)this._parms).imputeMissing(), ((ANOVAGLMModel.ANOVAGLMParameters)this._parms).makeImputer(), false, this.hasWeightCol(), this.hasOffsetCol(), this.hasFoldCol(), null);
        this._numberOfPredictors = this._dinfo._nums + this._dinfo._cats;
        if (this._numberOfPredictors < 2) {
            this.error("predictors", " there must be at least two predictors.");
        }
        if (((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._highest_interaction_term == 0) {
            ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._highest_interaction_term = this._numberOfPredictors;
        }
        if (((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._highest_interaction_term < 1 || ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._highest_interaction_term > this._numberOfPredictors) {
            this.error("highest_interaction_term", " must be >= 1 or <= number of predictors.");
        }
        if (!(GLMModel.GLMParameters.Family.gaussian.equals((Object)((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.tweedie.equals((Object)((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._family) || GLMModel.GLMParameters.Family.poisson.equals((Object)((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._family))) {
            ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._compute_p_values = false;
            ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._remove_collinear_columns = false;
        }
        if (this.nclasses() > 2) {
            this.error("family", " multinomial and ordinal are not supported at this point.");
        }
        this._numberOfPredCombo = ANOVAGLMUtils.calculatePredComboNumber(this._numberOfPredictors, ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._highest_interaction_term);
        this._numberOfModels = this._numberOfPredCombo + 1;
        this._predNamesIndividual = ANOVAGLMUtils.extractPredNames(this._dinfo, this._numberOfPredictors);
        this._predictComboNames = ANOVAGLMUtils.generatePredictorCombos(this._predNamesIndividual, ((ANOVAGLMModel.ANOVAGLMParameters)this._parms)._highest_interaction_term);
        this._transformedColNames = new String[this._numberOfPredCombo][];
        this._predictorColumnStart = new int[this._numberOfPredCombo];
        this._degreeOfFreedom = new int[this._numberOfPredCombo];
        ANOVAGLMUtils.generatePredictorNames(this._predictComboNames, this._transformedColNames, this._predictorColumnStart, this._degreeOfFreedom, this._dinfo);
        this._modelNames = ANOVAGLMUtils.generateModelNames(this._predictComboNames);
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
    }

    private class ANOVAGLMDriver
    extends ModelBuilder.Driver {
        String[] _allTransformedColNames;
        Key<Frame> _transformedColsKey;
        Frame[] _trainingFrames;
        GLMModel.GLMParameters[] _glmParams;
        GLM[] _glmBuilder;
        GLM[] _glmResults;
        Frame _completeTransformedFrame;

        private ANOVAGLMDriver() {
            super(ANOVAGLM.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void buildModel() {
            int numFrame2Delete;
            ArrayList<Key> keep;
            Lockable model = null;
            try {
                ANOVAGLM.this._dinfo = new DataInfo(this._completeTransformedFrame, ANOVAGLM.this._valid, 1, false, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, ((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms).missingValuesHandling() == GLMModel.GLMParameters.MissingValuesHandling.Skip, ((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms).imputeMissing(), ((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms).makeImputer(), false, ANOVAGLM.this.hasWeightCol(), ANOVAGLM.this.hasOffsetCol(), ANOVAGLM.this.hasFoldCol(), null);
                model = new ANOVAGLMModel(ANOVAGLM.this.dest(), (ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms, new ANOVAGLMModel.ANOVAGLMModelOutput(ANOVAGLM.this, ANOVAGLM.this._dinfo));
                model.write_lock(ANOVAGLM.this._job);
                if (((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._save_transformed_framekeys) {
                    ((ANOVAGLMModel.ANOVAGLMModelOutput)((ANOVAGLMModel)model)._output)._transformed_columns_key = this._transformedColsKey;
                }
                this._trainingFrames = ANOVAGLMUtils.buildTrainingFrames(this._transformedColsKey, ANOVAGLM.this._numberOfModels, ANOVAGLM.this._transformedColNames, (ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms);
                this._glmParams = ANOVAGLMUtils.buildGLMParameters(this._trainingFrames, (ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms);
                ANOVAGLM.this._job.update(1L, "calling GLM to build GLM models ...");
                this._glmBuilder = ANOVAGLMUtils.buildGLMBuilders(this._glmParams);
                this._glmResults = (GLM[])ModelBuilderHelper.trainModelsParallel((ModelBuilder[])this._glmBuilder, (int)((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._nparallelism);
                ((ANOVAGLMModel.ANOVAGLMModelOutput)((ANOVAGLMModel)model)._output)._glmModels = ANOVAGLMUtils.extractGLMModels(this._glmResults);
                ((ANOVAGLMModel.ANOVAGLMModelOutput)((ANOVAGLMModel)model)._output).copyGLMCoeffs(ANOVAGLM.this._modelNames);
                ANOVAGLMUtils.fillModelMetrics((ANOVAGLMModel)model, ((ANOVAGLMModel.ANOVAGLMModelOutput)((ANOVAGLMModel)model)._output)._glmModels[ANOVAGLM.this._numberOfPredCombo], this._trainingFrames[ANOVAGLM.this._numberOfPredCombo]);
                ((ANOVAGLMModel)model).fillOutput(ANOVAGLMUtils.combineAndFlat(ANOVAGLM.this._predictComboNames), ANOVAGLM.this._degreeOfFreedom);
                ANOVAGLM.this._job.update(0L, "Completed GLM model building.  Extracting metrics from GLM models and building ANOVAGLM outputs");
                model.update(ANOVAGLM.this._job);
                keep = new ArrayList<Key>();
                numFrame2Delete = ((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._save_transformed_framekeys ? this._trainingFrames.length - 1 : this._trainingFrames.length;
            }
            catch (Throwable throwable) {
                ArrayList<Key> keep2 = new ArrayList<Key>();
                int numFrame2Delete2 = ((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._save_transformed_framekeys ? this._trainingFrames.length - 1 : this._trainingFrames.length;
                ANOVAGLMUtils.removeFromDKV(this._trainingFrames, numFrame2Delete2);
                if (model != null) {
                    if (((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._save_transformed_framekeys) {
                        GamUtils.keepFrameKeys(keep2, this._transformedColsKey);
                    } else {
                        DKV.remove(this._transformedColsKey);
                    }
                    Scope.untrack((Key[])keep2.toArray(new Key[keep2.size()]));
                    model.update(ANOVAGLM.this._job);
                    model.unlock(ANOVAGLM.this._job);
                }
                throw throwable;
            }
            ANOVAGLMUtils.removeFromDKV(this._trainingFrames, numFrame2Delete);
            if (model != null) {
                if (((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._save_transformed_framekeys) {
                    GamUtils.keepFrameKeys(keep, this._transformedColsKey);
                } else {
                    DKV.remove(this._transformedColsKey);
                }
                Scope.untrack((Key[])keep.toArray(new Key[keep.size()]));
                model.update(ANOVAGLM.this._job);
                model.unlock(ANOVAGLM.this._job);
            }
        }

        void generateTransformedColumns() {
            this._allTransformedColNames = ArrayUtils.flat(ANOVAGLM.this._transformedColNames);
            ArrayList<String> expandedColNames = new ArrayList<String>(Arrays.asList(this._allTransformedColNames));
            if (ANOVAGLM.this.hasWeightCol()) {
                expandedColNames.add(((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._weights_column);
            }
            if (ANOVAGLM.this.hasOffsetCol()) {
                expandedColNames.add(((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._offset_column);
            }
            expandedColNames.add(((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._response_column);
            GenerateTransformColumns gtc = new GenerateTransformColumns(ANOVAGLM.this._transformedColNames, (ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms, ANOVAGLM.this._dinfo, ANOVAGLM.this._predNamesIndividual.length, ANOVAGLM.this._predictComboNames);
            gtc.doAll(expandedColNames.size(), (byte)3, ANOVAGLM.this._dinfo._adaptedFrame);
            this._completeTransformedFrame = gtc.outputFrame(Key.make(), expandedColNames.toArray(new String[0]), null);
            if (ANOVAGLM.this._train.vec(((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._response_column).isCategorical() && !this._completeTransformedFrame.vec(((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._response_column).isCategorical()) {
                this._completeTransformedFrame.replace(this._completeTransformedFrame.numCols() - 1, this._completeTransformedFrame.vec(((ANOVAGLMModel.ANOVAGLMParameters)ANOVAGLM.this._parms)._response_column).toCategoricalVec()).remove();
            }
            this._transformedColsKey = this._completeTransformedFrame._key;
            DKV.put(this._completeTransformedFrame);
        }

        @Override
        public void computeImpl() {
            ANOVAGLM.this.init(true);
            if (ANOVAGLM.this.error_count() > 0) {
                throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(ANOVAGLM.this);
            }
            this.generateTransformedColumns();
            ANOVAGLM.this._job.update(0L, "Finished transforming training frame");
            this.buildModel();
        }
    }
}

