/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.DataInfo;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.util.FrameUtils;

public abstract class FrameTask2<T extends FrameTask2<T>>
extends MRTask<T> {
    protected boolean _sparse;
    final Key<Job> _jobKey;
    protected final DataInfo _dinfo;
    private transient Job _job;

    public FrameTask2(H2O.H2OCountedCompleter cmp, DataInfo dinfo, Key<Job> jobKey) {
        super(cmp);
        this._dinfo = dinfo;
        this._jobKey = jobKey;
        this._sparse = this.handlesSparseData() && FrameUtils.sparseRatio(dinfo._adaptedFrame) < 0.5;
    }

    public T setSparse(boolean b) {
        this._sparse = b;
        return (T)((FrameTask2)this.self());
    }

    public void chunkInit() {
    }

    public void chunkDone() {
    }

    @Override
    public void setupLocal() {
        if (this._jobKey != null) {
            this._job = this._jobKey.get();
        }
    }

    public boolean handlesSparseData() {
        return false;
    }

    protected abstract void processRow(DataInfo.Row var1);

    @Override
    public void map(Chunk[] chks) {
        if (this._job != null && this._job.stop_requested()) {
            throw new Job.JobCancelledException(this._job);
        }
        this.chunkInit();
        if (this._sparse) {
            for (DataInfo.Row r : this._dinfo.extractSparseRows(chks)) {
                if (r.isBad() || r.weight == 0.0) continue;
                this.processRow(r);
            }
        } else {
            DataInfo.Row row = this._dinfo.newDenseRow();
            for (int r = 0; r < chks[0]._len; ++r) {
                this._dinfo.extractDenseRow(chks, r, row);
                if (row.isBad() || row.weight == 0.0) continue;
                this.processRow(row);
            }
        }
        this.chunkDone();
    }
}

