/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.stream.Stream;
import water.Job;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class ContributionsMeanAggregator
extends MRTask<ContributionsMeanAggregator> {
    final int _nBgRows;
    double[][] _partialSums;
    final int _rowIdxIdx;
    final int _nRows;
    final int _nCols;
    int _startIndex;
    final Job _j;

    public ContributionsMeanAggregator(Job j, int nRows, int nCols, int nBgRows) {
        this._j = j;
        this._nRows = nRows;
        this._nCols = nCols;
        this._rowIdxIdx = nCols;
        this._nBgRows = nBgRows;
        this._startIndex = 0;
    }

    public ContributionsMeanAggregator setStartIndex(int startIndex) {
        this._startIndex = startIndex;
        return this;
    }

    @Override
    public void map(Chunk[] cs, NewChunk[] ncs) {
        if (this.isCancelled() || null != this._j && this._j.stop_requested()) {
            return;
        }
        this._partialSums = MemoryManager.malloc8d(this._nRows, this._nCols);
        for (int i = 0; i < cs[0]._len; ++i) {
            int rowIdx = (int)cs[this._rowIdxIdx].at8(i);
            for (int j = 0; j < this._nCols; ++j) {
                double[] dArray = this._partialSums[rowIdx - this._startIndex];
                int n = j;
                dArray[n] = dArray[n] + cs[j].atd(i);
            }
        }
    }

    @Override
    public void reduce(ContributionsMeanAggregator mrt) {
        for (int i = 0; i < this._partialSums.length; ++i) {
            for (int j = 0; j < this._partialSums[0].length; ++j) {
                double[] dArray = this._partialSums[i];
                int n = j;
                dArray[n] = dArray[n] + mrt._partialSums[i][j];
            }
        }
        mrt._partialSums = null;
    }

    @Override
    protected void postGlobal() {
        NewChunk[] ncs = (NewChunk[])Stream.of(this.appendables()).map((? super T vec) -> vec.chunkForChunkIdx(0)).toArray(NewChunk[]::new);
        for (int i = 0; i < this._partialSums.length; ++i) {
            for (int j = 0; j < this._partialSums[0].length; ++j) {
                ncs[j].addNum(this._partialSums[i][j] / (double)this._nBgRows);
            }
        }
        this._partialSums = null;
        for (NewChunk nc : ncs) {
            nc.close(0, this._fs);
        }
    }
}

