/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding;

import ai.h2o.targetencoding.BlendingParams;
import ai.h2o.targetencoding.ColumnsMapping;
import ai.h2o.targetencoding.ColumnsToSingleMapping;
import ai.h2o.targetencoding.TargetEncoder;
import ai.h2o.targetencoding.TargetEncoderHelper;
import ai.h2o.targetencoding.TargetEncoderMojoWriter;
import ai.h2o.targetencoding.interaction.InteractionSupport;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.Scope;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.task.FillNAWithDoubleValueTask;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.StringUtils;
import water.util.TwoDimTable;

public class TargetEncoderModel
extends Model<TargetEncoderModel, TargetEncoderParameters, TargetEncoderOutput> {
    public static final String ALGO_NAME = "TargetEncoder";
    public static final int NO_FOLD = -1;
    static final String NA_POSTFIX = "_NA";
    static final String TMP_COLUMN_POSTFIX = "_tmp";
    static final String ENCODED_COLUMN_POSTFIX = "_te";
    static final BlendingParams DEFAULT_BLENDING_PARAMS = new BlendingParams(10.0, 20.0);
    private static final Logger LOG = Logger.getLogger(TargetEncoderModel.class);

    private static String encodedColumnName(String columnToEncode, int targetClass, Vec targetCol) {
        if (targetClass == -1 || targetCol == null) {
            return columnToEncode + ENCODED_COLUMN_POSTFIX;
        }
        String targetClassName = targetCol.domain()[targetClass];
        return columnToEncode + "_" + StringUtils.sanitizeIdentifier(targetClassName) + ENCODED_COLUMN_POSTFIX;
    }

    public TargetEncoderModel(Key<TargetEncoderModel> selfKey, TargetEncoderParameters parms, TargetEncoderOutput output) {
        super(selfKey, parms, output);
    }

    @Override
    public ModelMetrics.MetricBuilder makeMetricBuilder(String[] domain) {
        throw H2O.unimpl("No Model Metrics for TargetEncoder.");
    }

    public Frame transformTraining(Frame fr) {
        return this.transformTraining(fr, -1);
    }

    public Frame transformTraining(Frame fr, int outOfFold) {
        assert (outOfFold == -1 || ((TargetEncoderParameters)this._parms)._data_leakage_handling == DataLeakageHandlingStrategy.KFold);
        return this.transform(fr, true, outOfFold, ((TargetEncoderParameters)this._parms).getBlendingParameters(), ((TargetEncoderParameters)this._parms)._noise);
    }

    @Override
    public Frame transform(Frame fr) {
        return this.transform(fr, ((TargetEncoderParameters)this._parms).getBlendingParameters(), ((TargetEncoderParameters)this._parms)._noise);
    }

    public Frame transform(Frame fr, BlendingParams blendingParams, double noiseLevel) {
        return this.transform(fr, false, -1, blendingParams, noiseLevel);
    }

    public Frame transform(Frame fr, boolean asTraining, int outOfFold, BlendingParams blendingParams, double noiseLevel) {
        if (!this.canApplyTargetEncoding(fr)) {
            return fr;
        }
        try (Scope.Safe safe = Scope.safe(fr);){
            Frame adaptFr = this.adaptForEncoding(fr);
            Frame frame = Scope.untrack(this.applyTargetEncoding(adaptFr, asTraining, outOfFold, blendingParams, noiseLevel, null));
            return frame;
        }
    }

    @Override
    protected double[] score0(double[] data, double[] preds) {
        throw new UnsupportedOperationException("TargetEncoderModel doesn't support scoring on raw data. Use transform() or score() instead.");
    }

    @Override
    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) throws IllegalArgumentException {
        if (!this.canApplyTargetEncoding(fr)) {
            Frame res = new Frame(Key.make(destination_key), fr.names(), fr.vecs());
            DKV.put(res);
            return res;
        }
        try (Scope.Safe safe = Scope.safe(fr);){
            Frame adaptFr = this.adaptForEncoding(fr);
            Frame frame = Scope.untrack(this.applyTargetEncoding(adaptFr, false, -1, ((TargetEncoderParameters)this._parms).getBlendingParameters(), ((TargetEncoderParameters)this._parms)._noise, Key.make(destination_key)));
            return frame;
        }
    }

    private Frame adaptForEncoding(Frame fr) {
        Frame adaptFr = new Frame(fr);
        Map<String, Integer> nameToIdx = TargetEncoderHelper.nameToIndex(fr);
        for (int i = 0; i < ((TargetEncoderOutput)this._output)._names.length; ++i) {
            Vec toAdapt;
            int toAdaptIdx;
            String col = ((TargetEncoderOutput)this._output)._names[i];
            Object[] domain = ((TargetEncoderOutput)this._output)._domains[i];
            if (domain == null || (toAdaptIdx = nameToIdx.getOrDefault(col, -1).intValue()) < 0 || Arrays.equals((toAdapt = adaptFr.vec(toAdaptIdx)).domain(), domain)) continue;
            Vec adapted = toAdapt.adaptTo((String[])domain);
            adaptFr.replace(toAdaptIdx, adapted);
        }
        return adaptFr;
    }

    private boolean canApplyTargetEncoding(Frame fr) {
        HashSet<String> frColumns = new HashSet<String>(Arrays.asList(fr.names()));
        boolean canApply = Arrays.stream(((TargetEncoderOutput)this._output)._input_to_encoding_column).map(m -> Arrays.asList(m.from())).anyMatch(frColumns::containsAll);
        if (!canApply) {
            LOG.info("Frame " + fr._key + " has no columns to encode with TargetEncoder, skipping it: columns=" + Arrays.toString(fr.names()) + ", target encoder columns=" + Arrays.deepToString(Arrays.stream(((TargetEncoderOutput)this._output)._input_to_encoding_column).map(ColumnsMapping::from).toArray(x$0 -> new String[x$0][])));
        }
        return canApply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Frame applyTargetEncoding(Frame data, boolean asTraining, int outOfFold, BlendingParams blendingParams, double noise, Key<Frame> resultKey) {
        EncodingStrategy strategy;
        String targetColumn = ((TargetEncoderParameters)this._parms)._response_column;
        String foldColumn = ((TargetEncoderParameters)this._parms)._fold_column;
        DataLeakageHandlingStrategy dataLeakageHandlingStrategy = asTraining ? ((TargetEncoderParameters)this._parms)._data_leakage_handling : DataLeakageHandlingStrategy.None;
        long seed = ((TargetEncoderParameters)this._parms)._seed;
        assert (outOfFold == -1 || dataLeakageHandlingStrategy == DataLeakageHandlingStrategy.KFold);
        switch (dataLeakageHandlingStrategy) {
            case KFold: {
                if (data.find(foldColumn) >= 0) break;
                throw new H2OIllegalArgumentException("KFold strategy requires a fold column `" + ((TargetEncoderParameters)this._parms)._fold_column + "` like the one used during training.");
            }
            case LeaveOneOut: {
                if (data.find(targetColumn) >= 0) break;
                throw new H2OIllegalArgumentException("LeaveOneOut strategy requires a response column `" + ((TargetEncoderParameters)this._parms)._response_column + "` like the one used during training.");
            }
        }
        if (noise < 0.0) {
            noise = this.defaultNoiseLevel(data, data.find(targetColumn));
            LOG.warn("No noise level specified, using default noise level: " + noise);
        }
        if (resultKey == null) {
            resultKey = Key.make();
        }
        switch (dataLeakageHandlingStrategy) {
            case KFold: {
                strategy = new KFoldEncodingStrategy(foldColumn, outOfFold, blendingParams, noise, seed);
                break;
            }
            case LeaveOneOut: {
                strategy = new LeaveOneOutEncodingStrategy(targetColumn, blendingParams, noise, seed);
                break;
            }
            default: {
                strategy = new DefaultEncodingStrategy(blendingParams, noise, seed);
            }
        }
        ArrayList<Keyed> tmps = new ArrayList<Keyed>();
        Frame workingFrame = null;
        try {
            Cloneable removed;
            workingFrame = this.makeWorkingFrame(data);
            Key tmpKey = workingFrame._key;
            for (ColumnsToSingleMapping columnsToEncode : ((TargetEncoderOutput)this._output)._input_to_encoding_column) {
                Object[] colGroup = columnsToEncode.from();
                String columnToEncode = columnsToEncode.toSingle();
                Frame encodings = (Frame)((TargetEncoderOutput)this._output)._target_encoding_map.get(columnToEncode);
                assert (encodings != null);
                int colIdx = InteractionSupport.addFeatureInteraction(workingFrame, (String[])colGroup, columnsToEncode.toDomain());
                if (colIdx < 0) {
                    LOG.warn("Column " + Arrays.toString(colGroup) + " is missing in frame " + data._key);
                    continue;
                }
                assert (workingFrame.name(colIdx).equals(columnToEncode));
                if (dataLeakageHandlingStrategy != DataLeakageHandlingStrategy.KFold && encodings.find(foldColumn) >= 0) {
                    encodings = TargetEncoderHelper.groupEncodingsByCategory(encodings, encodings.find(columnToEncode));
                    tmps.add(encodings);
                }
                TargetEncoderHelper.imputeCategoricalColumn(workingFrame, colIdx, columnToEncode + NA_POSTFIX);
                PrimitiveIterator.OfInt it = ((TargetEncoderOutput)this._output).listUsedTargetClasses().iterator();
                while (it.hasNext()) {
                    int tc = it.next();
                    try {
                        workingFrame = strategy.apply(workingFrame, columnToEncode, encodings, tc);
                    }
                    finally {
                        DKV.remove(tmpKey);
                        tmpKey = workingFrame._key;
                    }
                }
                if (((TargetEncoderParameters)this._parms)._keep_interaction_columns || colGroup.length <= 1) continue;
                tmps.add(workingFrame.remove(colIdx));
            }
            if (!((TargetEncoderParameters)this._parms)._keep_original_categorical_columns) {
                removed = new HashSet();
                for (ColumnsToSingleMapping columnsToEncode : ((TargetEncoderOutput)this._output)._input_to_encoding_column) {
                    for (String col : columnsToEncode.from()) {
                        if (removed.contains(col)) continue;
                        tmps.add(workingFrame.remove(col));
                        removed.add(col);
                    }
                }
            }
            DKV.remove(tmpKey);
            workingFrame._key = resultKey;
            this.reorderColumns(workingFrame);
            DKV.put(workingFrame);
            removed = workingFrame;
            return removed;
        }
        catch (Exception e) {
            if (workingFrame != null) {
                workingFrame.delete();
            }
            throw e;
        }
        finally {
            for (Keyed tmp : tmps) {
                tmp.remove();
            }
        }
    }

    private double defaultNoiseLevel(Frame fr, int targetIndex) {
        double defaultNoiseLevel = 0.01;
        double noiseLevel = 0.0;
        if (targetIndex >= 0) {
            Vec targetVec = fr.vec(targetIndex);
            noiseLevel = targetVec.isNumeric() ? defaultNoiseLevel * (targetVec.max() - targetVec.min()) : defaultNoiseLevel;
        }
        return noiseLevel;
    }

    private Frame makeWorkingFrame(Frame fr) {
        return fr.deepCopy(Key.make().toString());
    }

    private void reorderColumns(Frame fr) {
        String[] toTheEnd = ((TargetEncoderParameters)this._parms).getNonPredictors();
        Map<String, Integer> nameToIdx = TargetEncoderHelper.nameToIndex(fr);
        ArrayList<Integer> toAppendAfterNumericals = new ArrayList<Integer>();
        String[] trainColumns = ((TargetEncoderOutput)this._output)._names;
        HashSet<String> trainCols = new HashSet<String>(Arrays.asList(trainColumns));
        String[] notInTrainColumns = (String[])Arrays.stream(fr.names()).filter(c -> !trainCols.contains(c)).toArray(String[]::new);
        int[] newOrder = new int[fr.numCols()];
        int offset = 0;
        for (String col : trainColumns) {
            if (!nameToIdx.containsKey(col) || ArrayUtils.contains(toTheEnd, col)) continue;
            int idx = nameToIdx.get(col);
            if (fr.vec(idx).isCategorical()) {
                toAppendAfterNumericals.add(idx);
                continue;
            }
            newOrder[offset++] = idx;
        }
        String[] encodedColumns = (String[])Arrays.stream(((TargetEncoderOutput)this._output)._input_to_output_columns).flatMap(m -> Stream.of(m.to())).toArray(String[]::new);
        HashSet<String> encodedCols = new HashSet<String>(Arrays.asList(encodedColumns));
        for (String col : encodedColumns) {
            if (!nameToIdx.containsKey(col)) continue;
            newOrder[offset++] = nameToIdx.get(col);
        }
        for (String col : notInTrainColumns) {
            if (encodedCols.contains(col)) continue;
            toAppendAfterNumericals.add(nameToIdx.get(col));
        }
        for (String col : toTheEnd) {
            if (!nameToIdx.containsKey(col)) continue;
            toAppendAfterNumericals.add(nameToIdx.get(col));
        }
        Iterator iterator = toAppendAfterNumericals.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            newOrder[offset++] = idx;
        }
        fr.reOrder(newOrder);
    }

    @Override
    public TargetEncoderMojoWriter getMojo() {
        return new TargetEncoderMojoWriter(this);
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (((TargetEncoderOutput)this._output)._target_encoding_map != null) {
            for (Frame encodings : ((TargetEncoderOutput)this._output)._target_encoding_map.values()) {
                encodings.delete();
            }
        }
        return super.remove_impl(fs, cascade);
    }

    private static class DefaultEncodingStrategy
    extends EncodingStrategy {
        public DefaultEncodingStrategy(BlendingParams blendingParams, double noise, long seed) {
            super(blendingParams, noise, seed);
        }

        @Override
        public Frame doApply(Frame fr, String columnToEncode, Frame encodings, String encodedColumn, int targetClass) {
            int teColumnIdx = fr.find(columnToEncode);
            int encodingsTEColIdx = encodings.find(columnToEncode);
            double priorMean = TargetEncoderHelper.computePriorMean(encodings);
            Frame joinedFrame = TargetEncoderHelper.mergeEncodings(fr, encodings, teColumnIdx, encodingsTEColIdx);
            Scope.track(joinedFrame);
            int encodedColIdx = TargetEncoderHelper.applyEncodings(joinedFrame, encodedColumn, priorMean, this._blendingParams);
            this.applyNoise(joinedFrame, encodedColIdx, this._noise, this._seed);
            double valueForImputation = this.valueForImputation(columnToEncode, encodings, priorMean, this._blendingParams);
            this.imputeMissingValues(joinedFrame, encodedColIdx, valueForImputation);
            this.removeNumeratorAndDenominatorColumns(joinedFrame);
            return joinedFrame;
        }
    }

    private static class LeaveOneOutEncodingStrategy
    extends EncodingStrategy {
        String _targetColumn;

        public LeaveOneOutEncodingStrategy(String targetColumn, BlendingParams blendingParams, double noise, long seed) {
            super(blendingParams, noise, seed);
            this._targetColumn = targetColumn;
        }

        @Override
        public Frame doApply(Frame fr, String columnToEncode, Frame encodings, String encodedColumn, int targetClass) {
            int teColumnIdx = fr.find(columnToEncode);
            int encodingsTEColIdx = encodings.find(columnToEncode);
            double priorMean = TargetEncoderHelper.computePriorMean(encodings);
            Frame joinedFrame = TargetEncoderHelper.mergeEncodings(fr, encodings, teColumnIdx, encodingsTEColIdx);
            Scope.track(joinedFrame);
            TargetEncoderHelper.subtractTargetValueForLOO(joinedFrame, this._targetColumn, targetClass);
            int encodedColIdx = TargetEncoderHelper.applyEncodings(joinedFrame, encodedColumn, priorMean, this._blendingParams);
            this.applyNoise(joinedFrame, encodedColIdx, this._noise, this._seed);
            this.imputeMissingValues(joinedFrame, encodedColIdx, priorMean);
            this.removeNumeratorAndDenominatorColumns(joinedFrame);
            return joinedFrame;
        }
    }

    private static class KFoldEncodingStrategy
    extends EncodingStrategy {
        String _foldColumn;
        int _outOfFold;

        public KFoldEncodingStrategy(String foldColumn, int outOfFold, BlendingParams blendingParams, double noise, long seed) {
            super(blendingParams, noise, seed);
            this._foldColumn = foldColumn;
            this._outOfFold = outOfFold;
        }

        @Override
        public Frame doApply(Frame fr, String columnToEncode, Frame encodings, String encodedColumn, int targetClass) {
            int foldColIdx;
            Frame workingFrame = fr;
            int teColumnIdx = fr.find(columnToEncode);
            if (this._outOfFold == -1) {
                foldColIdx = fr.find(this._foldColumn);
            } else {
                workingFrame = new Frame(fr);
                Vec tmpFoldCol = workingFrame.anyVec().makeCon(this._outOfFold);
                Scope.track(tmpFoldCol);
                workingFrame.add(new String[]{this._foldColumn + TargetEncoderModel.TMP_COLUMN_POSTFIX}, new Vec[]{tmpFoldCol});
                foldColIdx = workingFrame.numCols() - 1;
            }
            int encodingsFoldColIdx = encodings.find(this._foldColumn);
            int encodingsTEColIdx = encodings.find(columnToEncode);
            long[] foldValues = TargetEncoderHelper.getUniqueColumnValues(encodings, encodingsFoldColIdx);
            int maxFoldValue = (int)ArrayUtils.maxValue(foldValues);
            double priorMean = TargetEncoderHelper.computePriorMean(encodings);
            Frame joinedFrame = TargetEncoderHelper.mergeEncodings(workingFrame, encodings, teColumnIdx, foldColIdx, encodingsTEColIdx, encodingsFoldColIdx, maxFoldValue);
            Scope.track(joinedFrame);
            if (this._outOfFold != -1) {
                joinedFrame.remove(foldColIdx);
            }
            int encodedColIdx = TargetEncoderHelper.applyEncodings(joinedFrame, encodedColumn, priorMean, this._blendingParams);
            this.applyNoise(joinedFrame, encodedColIdx, this._noise, this._seed);
            this.imputeMissingValues(joinedFrame, encodedColIdx, priorMean);
            this.removeNumeratorAndDenominatorColumns(joinedFrame);
            return joinedFrame;
        }
    }

    private static abstract class EncodingStrategy {
        BlendingParams _blendingParams;
        double _noise;
        long _seed;

        public EncodingStrategy(BlendingParams blendingParams, double noise, long seed) {
            this._blendingParams = blendingParams;
            this._noise = noise;
            this._seed = seed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Frame apply(Frame fr, String columnToEncode, Frame encodings, int targetClass) {
            try {
                Frame appliedEncodings;
                Scope.enter();
                int tcIdx = encodings.find("targetclass");
                if (tcIdx < 0) {
                    appliedEncodings = encodings;
                } else {
                    appliedEncodings = TargetEncoderHelper.filterByValue(encodings, tcIdx, targetClass);
                    Scope.track(appliedEncodings);
                    appliedEncodings.remove("targetclass");
                }
                String encodedColumn = TargetEncoderModel.encodedColumnName(columnToEncode, targetClass, tcIdx < 0 ? null : encodings.vec(tcIdx));
                Frame encoded = this.doApply(fr, columnToEncode, appliedEncodings, encodedColumn, targetClass);
                Scope.untrack(encoded);
                Frame frame = encoded;
                return frame;
            }
            finally {
                Scope.exit(new Key[0]);
            }
        }

        public abstract Frame doApply(Frame var1, String var2, Frame var3, String var4, int var5);

        protected void applyNoise(Frame frame, int columnIdx, double noiseLevel, long seed) {
            if (noiseLevel > 0.0) {
                TargetEncoderHelper.addNoise(frame, columnIdx, noiseLevel, seed);
            }
        }

        protected void imputeMissingValues(Frame fr, int columnIndex, double imputedValue) {
            Vec vec = fr.vec(columnIndex);
            assert (vec.get_type() == 3) : "Imputation of missing value is supported only for numerical vectors.";
            if (vec.naCnt() > 0L) {
                new FillNAWithDoubleValueTask(columnIndex, imputedValue).doAll(fr);
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("Frame with id = %s was imputed with posterior value = %f ( %d rows were affected)", fr._key, imputedValue, vec.naCnt()));
                }
            }
        }

        protected double valueForImputation(String columnToEncode, Frame encodings, double priorMean, BlendingParams blendingParams) {
            boolean useBlending;
            assert (encodings.name(0).equals(columnToEncode));
            int nRows = (int)encodings.numRows();
            String lastDomain = encodings.domains()[0][nRows - 1];
            boolean hadMissingValues = lastDomain.equals(columnToEncode + TargetEncoderModel.NA_POSTFIX);
            double numeratorNA = encodings.vec("numerator").at(nRows - 1);
            long denominatorNA = encodings.vec("denominator").at8(nRows - 1);
            double posteriorNA = numeratorNA / (double)denominatorNA;
            boolean bl = useBlending = blendingParams != null;
            return !hadMissingValues ? priorMean : (useBlending ? TargetEncoderHelper.getBlendedValue(posteriorNA, priorMean, denominatorNA, blendingParams) : posteriorNA);
        }

        protected void removeNumeratorAndDenominatorColumns(Frame fr) {
            Vec removedNumerator = fr.remove("numerator");
            removedNumerator.remove();
            Vec removedDenominator = fr.remove("denominator");
            removedDenominator.remove();
        }
    }

    public static class TargetEncoderOutput
    extends Model.Output {
        public final TargetEncoderParameters _parms;
        public final int _nclasses;
        public ColumnsToSingleMapping[] _input_to_encoding_column;
        public ColumnsMapping[] _input_to_output_columns;
        public IcedHashMap<String, Frame> _target_encoding_map;
        public IcedHashMap<String, Boolean> _te_column_to_hasNAs;

        public TargetEncoderOutput(TargetEncoder te) {
            super(te);
            this._parms = (TargetEncoderParameters)te._parms;
            this._nclasses = te.nclasses();
        }

        void init(IcedHashMap<String, Frame> teMap, ColumnsToSingleMapping[] columnsToEncodeMapping) {
            this._target_encoding_map = teMap;
            this._input_to_encoding_column = columnsToEncodeMapping;
            this._input_to_output_columns = this.buildInOutColumnsMapping();
            this._te_column_to_hasNAs = this.buildCol2HasNAsMap();
            this._model_summary = this.constructSummary();
        }

        private ColumnsMapping[] buildInOutColumnsMapping() {
            ColumnsMapping[] encMapping = new ColumnsMapping[this._input_to_encoding_column.length];
            for (int i = 0; i < encMapping.length; ++i) {
                ColumnsToSingleMapping toEncode = this._input_to_encoding_column[i];
                String[] groupCols = toEncode.from();
                String columnToEncode = toEncode.toSingle();
                Frame encodings = (Frame)this._target_encoding_map.get(columnToEncode);
                String[] encodedColumns = (String[])this.listUsedTargetClasses().mapToObj(tc -> TargetEncoderModel.encodedColumnName(columnToEncode, tc, encodings.vec("targetclass"))).toArray(String[]::new);
                encMapping[i] = new ColumnsMapping(groupCols, encodedColumns);
            }
            return encMapping;
        }

        private IcedHashMap<String, Boolean> buildCol2HasNAsMap() {
            IcedHashMap<String, Boolean> col2HasNAs = new IcedHashMap<String, Boolean>();
            for (Map.Entry entry : this._target_encoding_map.entrySet()) {
                String teColumn = (String)entry.getKey();
                Frame encodingsFrame = (Frame)entry.getValue();
                int teColCard = this._parms.train().vec(teColumn) == null ? -1 : this._parms.train().vec(teColumn).cardinality();
                boolean hasNAs = teColCard > 0 && teColCard < encodingsFrame.vec(teColumn).cardinality();
                col2HasNAs.put(teColumn, hasNAs);
            }
            return col2HasNAs;
        }

        private IntStream listUsedTargetClasses() {
            return this._nclasses == 1 ? IntStream.of(-1) : (this._nclasses == 2 ? IntStream.of(1) : IntStream.range(1, this._nclasses));
        }

        private TwoDimTable constructSummary() {
            TwoDimTable summary = new TwoDimTable("Target Encoder model summary", "Summary for target encoder model", new String[this._input_to_output_columns.length], new String[]{"Original name(s)", "Encoded column name(s)"}, new String[]{"string", "string"}, null, null);
            for (int i = 0; i < this._input_to_output_columns.length; ++i) {
                ColumnsMapping mapping = this._input_to_output_columns[i];
                summary.set(i, 0, String.join((CharSequence)", ", mapping.from()));
                summary.set(i, 1, String.join((CharSequence)", ", mapping.to()));
            }
            return summary;
        }

        @Override
        public ModelCategory getModelCategory() {
            return ModelCategory.TargetEncoder;
        }
    }

    public static class TargetEncoderParameters
    extends Model.Parameters {
        public String[][] _columns_to_encode;
        public boolean _blending = false;
        public double _inflection_point = DEFAULT_BLENDING_PARAMS.getInflectionPoint();
        public double _smoothing = DEFAULT_BLENDING_PARAMS.getSmoothing();
        public DataLeakageHandlingStrategy _data_leakage_handling = DataLeakageHandlingStrategy.None;
        public double _noise = 0.01;
        public boolean _keep_original_categorical_columns = true;
        boolean _keep_interaction_columns = false;

        @Override
        public String algoName() {
            return TargetEncoderModel.ALGO_NAME;
        }

        @Override
        public String fullName() {
            return TargetEncoderModel.ALGO_NAME;
        }

        @Override
        public String javaName() {
            return TargetEncoderModel.class.getName();
        }

        @Override
        public long progressUnits() {
            return 1L;
        }

        public BlendingParams getBlendingParameters() {
            return this._blending ? (this._inflection_point != 0.0 && this._smoothing != 0.0 ? new BlendingParams(this._inflection_point, this._smoothing) : DEFAULT_BLENDING_PARAMS) : null;
        }

        @Override
        protected boolean defaultDropConsCols() {
            return false;
        }
    }

    public static enum DataLeakageHandlingStrategy {
        LeaveOneOut,
        KFold,
        None;

    }
}

