/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.redismock.commands;

import ai.grakn.redismock.RedisBase;
import ai.grakn.redismock.Response;
import ai.grakn.redismock.Slice;
import ai.grakn.redismock.SliceParser;
import ai.grakn.redismock.Utils;
import ai.grakn.redismock.commands.RO_lrange;
import ai.grakn.redismock.commands.RO_rpoplpush;
import java.util.Arrays;
import java.util.List;

class RO_brpoplpush
extends RO_rpoplpush {
    RO_brpoplpush(RedisBase base, List<Slice> params) {
        super(base, params, 3);
    }

    @Override
    public Slice execute() {
        Slice source = this.params().get(0);
        long timeout = Utils.convertToLong(this.params().get(2).toString());
        long count = 0L;
        for (long currentSleep = 0L; count == 0L && currentSleep < timeout * 1000L; currentSleep += 100L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            count = this.getCount(source);
        }
        if (count != 0L) {
            return super.execute();
        }
        return Response.NULL;
    }

    private long getCount(Slice source) {
        Slice index = new Slice("0");
        List<Slice> commands = Arrays.asList(source, index, index);
        Slice result = new RO_lrange(this.base(), commands).execute();
        return SliceParser.consumeCount(result.data());
    }
}

