/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.BlockList;
import ai.djl.nn.ParameterList;
import ai.djl.nn.SymbolBlock;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.training.ParameterStore;
import ai.djl.training.initializer.Initializer;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.List;
import java.util.Map;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.proto.framework.MetaGraphDef;
import org.tensorflow.proto.framework.SignatureDef;
import org.tensorflow.proto.framework.TensorInfo;
import org.tensorflow.proto.framework.TensorShapeProto;

public class TfSymbolBlock
implements SymbolBlock {
    private SavedModelBundle bundle;
    private MetaGraphDef metaGraphDef;
    private Session session;

    public TfSymbolBlock(SavedModelBundle bundle) {
        this.bundle = bundle;
        this.session = bundle.session();
        this.metaGraphDef = bundle.metaGraphDef();
    }

    public void removeLastBlock() {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public NDList forward(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        int i;
        Session.Runner runner = this.session.runner();
        PairList<String, Shape> inputDescriptions = this.describeInput();
        PairList<String, Shape> outputDescriptions = this.describeOutput();
        for (i = 0; i < inputDescriptions.size(); ++i) {
            runner.feed((String)inputDescriptions.get(i).getKey(), ((TfNDArray)inputs.get(i)).getTensor());
        }
        for (i = 0; i < outputDescriptions.size(); ++i) {
            runner.fetch((String)outputDescriptions.get(i).getKey());
        }
        List result = runner.run();
        NDList resultNDList = new NDList();
        TfNDManager tfNDManager = (TfNDManager)inputs.head().getManager();
        for (Tensor tensor : result) {
            resultNDList.add((Object)tfNDManager.create(tensor));
        }
        return resultNDList;
    }

    public void setInitializer(Initializer initializer) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public void setInitializer(Initializer initializer, String paramName) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public Shape[] initialize(NDManager manager, DataType dataType, Shape ... inputShapes) {
        return new Shape[0];
    }

    public boolean isInitialized() {
        return this.bundle != null;
    }

    public void cast(DataType dataType) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public void clear() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.bundle != null) {
            this.bundle.close();
        }
    }

    public PairList<String, Shape> describeInput() {
        PairList inputDescriptions = new PairList();
        Map signatureDefMap = this.metaGraphDef.getSignatureDefMap();
        SignatureDef servingDefault = this.metaGraphDef.getSignatureDefOrDefault("serving_default", (SignatureDef)signatureDefMap.get(signatureDefMap.keySet().iterator().next()));
        for (Map.Entry entry : servingDefault.getInputsMap().entrySet()) {
            TensorShapeProto shapeProto = ((TensorInfo)entry.getValue()).getTensorShape();
            inputDescriptions.add((Object)((TensorInfo)entry.getValue()).getName(), (Object)new Shape(shapeProto.getDimList().stream().mapToLong(TensorShapeProto.Dim::getSize).toArray()));
        }
        return inputDescriptions;
    }

    PairList<String, Shape> describeOutput() {
        PairList outputDescription = new PairList();
        Map signatureDefMap = this.metaGraphDef.getSignatureDefMap();
        SignatureDef servingDefault = this.metaGraphDef.getSignatureDefOrDefault("serving_default", (SignatureDef)signatureDefMap.get(signatureDefMap.keySet().iterator().next()));
        for (Map.Entry entry : servingDefault.getOutputsMap().entrySet()) {
            TensorShapeProto shapeProto = ((TensorInfo)entry.getValue()).getTensorShape();
            outputDescription.add((Object)((TensorInfo)entry.getValue()).getName(), (Object)new Shape(shapeProto.getDimList().stream().mapToLong(TensorShapeProto.Dim::getSize).toArray()));
        }
        return outputDescription;
    }

    public BlockList getChildren() {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public ParameterList getDirectParameters() {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public ParameterList getParameters() {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public Shape getParameterShape(String name, Shape[] inputShapes) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        return new Shape[0];
    }

    public void saveParameters(DataOutputStream os) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    public void loadParameters(NDManager manager, DataInputStream is) {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }
}

