/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDUtils;
import ai.djl.ndarray.index.NDArrayIndexer;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.pooling.PoolingConvention;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.tensorflow.engine.TfNDArrayIndexer;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.util.PairList;
import java.util.ArrayList;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.core.Squeeze;
import org.tensorflow.op.core.Stack;
import org.tensorflow.op.image.ResizeBilinear;
import org.tensorflow.types.family.TType;

public class TfNDArrayEx
implements NDArrayEx {
    private static final NDArrayIndexer INDEXER = new TfNDArrayIndexer();
    private TfNDArray array;
    private TfNDManager manager;
    private Ops tf;
    private Operand<?> operand;

    TfNDArrayEx(TfNDArray parent) {
        this.array = parent;
        this.manager = (TfNDManager)parent.getManager();
        this.tf = this.manager.getTf();
        this.operand = parent.asOperand();
    }

    public NDArray rdiv(Number n) {
        return this.rdiv(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rdiv(NDArray b) {
        return b.div((NDArray)this.array);
    }

    public NDArray rdivi(Number n) {
        return this.rdivi(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rdivi(NDArray b) {
        return this.array.inPlaceHelper(b.div((NDArray)this.array), this.array);
    }

    public NDArray rsub(Number n) {
        return this.rsub(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rsub(NDArray b) {
        return b.sub((NDArray)this.array);
    }

    public NDArray rsubi(Number n) {
        return this.rsubi(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rsubi(NDArray b) {
        return this.array.inPlaceHelper(b.sub((NDArray)this.array), this.array);
    }

    public NDArray rmod(Number n) {
        return this.rmod(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rmod(NDArray b) {
        return b.mod((NDArray)this.array);
    }

    public NDArray rmodi(Number n) {
        return this.rmodi(this.manager.create(n).toType(this.array.getDataType(), false));
    }

    public NDArray rmodi(NDArray b) {
        return this.array.inPlaceHelper(b.mod((NDArray)this.array), this.array);
    }

    public NDArray rpow(Number n) {
        return this.manager.create(n).toType(this.array.getDataType(), false).pow((NDArray)this.array);
    }

    public NDArray rpowi(Number n) {
        return this.manager.create(n).toType(this.array.getDataType(), false).powi((NDArray)this.array);
    }

    public NDArray relu() {
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.nn.relu(this.array.asOperand()));
    }

    public NDArray sigmoid() {
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.math.sigmoid(this.array.asOperand()));
    }

    public NDArray tanh() {
        return this.array.tanh();
    }

    public NDArray softrelu() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray softsign() {
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.nn.softsign(this.array.asOperand()));
    }

    public NDArray leakyRelu(float alpha) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray elu(float alpha) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray selu() {
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.nn.selu(this.array.asOperand()));
    }

    public NDArray gelu() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray maxPool(Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalMaxPool() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray sumPool(Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalSumPool() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray avgPool(Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention, boolean countIncludePad) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalAvgPool() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray lpPool(Shape kernel, Shape stride, Shape pad, PoolingConvention poolingConvention, int pValue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray globalLpPool(int pValue) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void adamUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float beta1, float beta2, float epsilon, boolean lazyUpdate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void nagUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float momentum) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void sgdUpdate(NDList inputs, NDList weights, float learningRate, float weightDecay, float rescaleGrad, float clipGrad, float momentum, boolean lazyUpdate) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList convolution(NDList inputs, Shape kernel, Shape stride, Shape pad, Shape dilate, int numFilters, int numGroups, String layout, boolean noBias, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList fullyConnected(NDList inputs, long outChannels, boolean flatten, boolean noBias, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList embedding(NDList inputs, int numItems, int embeddingSize, boolean sparseGrad, DataType dataType, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList prelu(NDList inputs, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList dropout(NDList inputs, float probability, int[] sharedAxes, boolean training, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList batchNorm(NDList inputs, float epsilon, float momentum, int axis, boolean center, boolean scale, boolean training, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList rnn(NDList inputs, String mode, long stateSize, float dropRate, int numStackedLayers, boolean useSequenceLength, boolean useBidirectional, boolean stateOutputs, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList lstm(NDList inputs, long stateSize, float dropRate, int numStackedLayers, boolean useSequenceLength, boolean useBidirectional, boolean stateOutputs, double lstmStateClipMin, double lstmStateClipMax, PairList<String, Object> additional) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * Exception decompiling
     */
    public NDArray normalize(float[] mean, float[] std) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray toTensor() {
        TfNDArray input = this.array;
        int dim = input.getShape().dimension();
        if (dim == 3) {
            input = input.expandDims(0);
        }
        input = input.div(255.0);
        if (dim == 3) {
            input = input.squeeze(0);
        }
        return !input.getDataType().equals((Object)DataType.FLOAT32) ? input.toType(DataType.FLOAT32, false) : input;
    }

    public NDArray resize(int width, int height) {
        if (this.manager.create(this.array.getShape().getShape()).prod().toLongArray()[0] == 0L) {
            throw new IllegalArgumentException("Can't resize image with 0 dims.");
        }
        if (this.array.getShape().dimension() == 3) {
            return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.squeeze((Operand)this.tf.image.resizeBilinear(((TfNDArray)this.array.expandDims(0)).asOperand(), (Operand)this.tf.constant(new int[]{height, width}), new ResizeBilinear.Options[0]), new Squeeze.Options[0]));
        }
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.image.resizeBilinear(this.operand, (Operand)this.tf.constant(new int[]{height, width}), new ResizeBilinear.Options[0]));
    }

    public NDArrayIndexer getIndexer() {
        return INDEXER;
    }

    public NDArray where(NDArray condition, NDArray other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray stack(NDList arrays) {
        return this.stack(arrays, 0);
    }

    public NDArray stack(NDList arrays, int axis) {
        return this.stackHelper(arrays, axis);
    }

    private <T extends TType> NDArray stackHelper(NDList arrays, int axis) {
        ArrayList operands = new ArrayList(arrays.size() + 1);
        operands.add(this.array.asOperand());
        for (NDArray ndArray : arrays) {
            operands.add(((TfNDArray)ndArray).asOperand());
        }
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.stack(operands, new Stack.Options[]{Stack.axis((Long)Long.valueOf(axis))}));
    }

    public NDArray concat(NDList arrays, int axis) {
        NDUtils.checkConcatInput((NDList)arrays);
        return this.concatHelper(arrays, axis);
    }

    private <T extends TType> NDArray concatHelper(NDList arrays, int axis) {
        ArrayList operands = new ArrayList(arrays.size() + 1);
        operands.add(this.array.asOperand());
        for (NDArray ndArray : arrays) {
            operands.add(((TfNDArray)ndArray).asOperand());
        }
        return new TfNDArray((NDManager)this.manager, (Operand<?>)this.tf.concat(operands, (Operand)this.tf.constant(axis)));
    }

    public NDList multiBoxTarget(NDList inputs, float iouThreshold, float ignoreLabel, float negativeMiningRatio, float negativeMiningThreshold, int minNegativeSamples) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList multiBoxPrior(List<Float> sizes, List<Float> ratios, List<Float> steps, List<Float> offsets, boolean clip) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList multiBoxDetection(NDList inputs, boolean clip, float threshold, int backgroundId, float nmsThreshold, boolean forceSuppress, int nmsTopK) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray getArray() {
        return this.array;
    }
}

