/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Session;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.proto.CollectionDef;
import org.tensorflow.proto.MetaGraphDef;
import org.tensorflow.proto.SignatureDef;
import org.tensorflow.proto.TensorInfo;

public class SavedModelBundle
implements AutoCloseable {
    private static final String INIT_OP_SIGNATURE_KEY = "__saved_model_init_op";
    private static final String MAIN_OP_COLLECTION_KEY = "saved_model_main_op";
    private static final String LEGACY_INIT_OP_COLLECTION_KEY = "legacy_init_op";
    private static final String TABLE_INITIALIZERS_COLLECTION_KEY = "table_initializer";
    private TF_Graph graphHandle;
    private TF_Session sessionHandle;
    private MetaGraphDef metaGraphDef;
    private TF_Operation[] targetOpHandles;
    private AtomicBoolean closed;

    public SavedModelBundle(TF_Graph graphHandle, TF_Session sessionHandle, MetaGraphDef metaGraphDef) {
        this.graphHandle = graphHandle;
        this.sessionHandle = sessionHandle;
        this.metaGraphDef = metaGraphDef;
        this.closed = new AtomicBoolean(false);
        ConcurrentHashMap<String, SignatureDef> functions = new ConcurrentHashMap<String, SignatureDef>();
        metaGraphDef.getSignatureDefMap().forEach((signatureName, signatureDef) -> {
            if (!functions.containsKey(signatureName)) {
                functions.put((String)signatureName, (SignatureDef)signatureDef);
            }
        });
        ArrayList<TF_Operation> initOps = new ArrayList<TF_Operation>();
        TF_Operation initOp = this.findInitOp(functions, metaGraphDef.getCollectionDefMap());
        if (initOp != null) {
            initOps.add(initOp);
        }
        if (metaGraphDef.containsCollectionDef(TABLE_INITIALIZERS_COLLECTION_KEY)) {
            ((CollectionDef)metaGraphDef.getCollectionDefMap().get(TABLE_INITIALIZERS_COLLECTION_KEY)).getNodeList().getValueList().forEach(node -> initOps.add(tensorflow.TF_GraphOperationByName((TF_Graph)graphHandle, (String)node)));
        }
        this.targetOpHandles = initOps.toArray(new TF_Operation[0]);
    }

    private TF_Operation findInitOp(Map<String, SignatureDef> signatures, Map<String, CollectionDef> collections) {
        SignatureDef initSig = signatures.get(INIT_OP_SIGNATURE_KEY);
        if (initSig != null) {
            String opName = ((TensorInfo)initSig.getOutputsMap().get(INIT_OP_SIGNATURE_KEY)).getName();
            return tensorflow.TF_GraphOperationByName((TF_Graph)this.graphHandle, (String)opName);
        }
        CollectionDef initCollection = collections.containsKey(MAIN_OP_COLLECTION_KEY) ? collections.get(MAIN_OP_COLLECTION_KEY) : collections.get(LEGACY_INIT_OP_COLLECTION_KEY);
        if (initCollection != null) {
            CollectionDef.NodeList nodes = initCollection.getNodeList();
            if (nodes.getValueCount() != 1) {
                throw new IllegalArgumentException("Expected exactly one main op in saved model.");
            }
            String opName = nodes.getValue(0);
            return tensorflow.TF_GraphOperationByName((TF_Graph)this.graphHandle, (String)opName);
        }
        return null;
    }

    public TF_Graph getGraph() {
        return this.graphHandle;
    }

    public TF_Session getSession() {
        return this.sessionHandle;
    }

    public MetaGraphDef getMetaGraphDef() {
        return this.metaGraphDef;
    }

    TF_Operation[] getTargetOpHandles() {
        return this.targetOpHandles;
    }

    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        if (this.graphHandle != null && !this.graphHandle.isNull()) {
            this.graphHandle.close();
        }
        if (this.sessionHandle != null && !this.sessionHandle.isNull()) {
            this.sessionHandle.close();
        }
        this.metaGraphDef = null;
    }
}

