/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.NDResource;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.tensorflow.engine.TfNDArrayEx;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.tensorflow.engine.javacpp.JavacppUtils;
import ai.djl.util.NativeResource;
import ai.djl.util.Preconditions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.tensorflow.internal.c_api.TFE_TensorHandle;

public class TfNDArray
extends NativeResource<TFE_TensorHandle>
implements NDArray {
    private static final int MAX_SIZE = 100;
    private static final int MAX_DEPTH = 10;
    private static final int MAX_ROWS = 10;
    private static final int MAX_COLUMNS = 20;
    private Shape shape;
    private Device device;
    private TfNDManager manager;
    private String name;
    private TfNDArrayEx tfNDArrayEx;
    private DataType dataType;

    TfNDArray(TfNDManager manager, TFE_TensorHandle handle) {
        super((Object)handle);
        this.manager = manager;
        manager.attachInternal(this.getUid(), (AutoCloseable)((Object)this));
        this.tfNDArrayEx = new TfNDArrayEx(this);
    }

    public TfNDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            Preconditions.checkArgument((this.getHandle() != null && !((TFE_TensorHandle)this.getHandle()).isNull() ? 1 : 0) != 0, (String)"Eager session has been closed");
            this.dataType = JavacppUtils.getDataType((TFE_TensorHandle)this.getHandle());
        }
        return this.dataType;
    }

    public Device getDevice() {
        if (this.device == null) {
            Preconditions.checkArgument((this.getHandle() != null && !((TFE_TensorHandle)this.getHandle()).isNull() ? 1 : 0) != 0, (String)"Eager session has been closed");
            this.device = JavacppUtils.getDevice((TFE_TensorHandle)this.getHandle());
        }
        return this.device;
    }

    public Shape getShape() {
        if (this.shape == null) {
            Preconditions.checkArgument((this.getHandle() != null && !((TFE_TensorHandle)this.getHandle()).isNull() ? 1 : 0) != 0, (String)"Eager session has been closed");
            this.shape = JavacppUtils.getShape((TFE_TensorHandle)this.getHandle());
        }
        return this.shape;
    }

    public SparseFormat getSparseFormat() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isSparse() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray toDevice(Device device, boolean copy) {
        if (device.equals((Object)this.getDevice()) && !copy) {
            return this;
        }
        if (device.equals((Object)this.getDevice()) && copy) {
            return this.duplicate();
        }
        return new TfNDArray(this.manager, JavacppUtils.toDevice((TFE_TensorHandle)this.getHandle(), this.manager.getEagerSession(), device));
    }

    public NDArray toType(DataType dataType, boolean copy) {
        if (dataType.equals((Object)this.getDataType()) && !copy) {
            return this;
        }
        return this.manager.opExecutor("Cast").addInput(this).addParam("DstT", dataType).buildSingletonOrThrow();
    }

    public void setRequiresGradient(boolean requiresGrad) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray getGradient() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasGradient() {
        return false;
    }

    public NDArray stopGradient() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String[] toStringArray() {
        throw new UnsupportedOperationException("TensorFlow does not supporting printing String NDArray");
    }

    public ByteBuffer toByteBuffer() {
        return JavacppUtils.getByteBuffer((TFE_TensorHandle)this.getHandle());
    }

    public void set(Buffer data) {
        throw new UnsupportedOperationException("Tensor cannot be modified after creation");
    }

    public void attach(NDManager manager) {
        this.detach();
        this.manager = (TfNDManager)manager;
        manager.attachInternal(this.getUid(), (AutoCloseable)((Object)this));
    }

    public void tempAttach(NDManager manager) {
        this.detach();
        TfNDManager original = this.manager;
        this.manager = (TfNDManager)manager;
        manager.tempAttachInternal((NDManager)original, this.getUid(), (NDResource)this);
    }

    public void detach() {
        this.manager.detachInternal(this.getUid());
        this.manager = TfNDManager.getSystemManager();
    }

    public void copyTo(NDArray ndArray) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public NDArray duplicate() {
        return this.manager.opExecutor("DeepCopy").addInput(this).buildSingletonOrThrow();
    }

    /*
     * Exception decompiling
     */
    public NDArray booleanMask(NDArray index, int axis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray sequenceMask(NDArray sequenceLength, float value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public NDArray sequenceMask(NDArray sequenceLength) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public NDArray zerosLike() {
        return this.manager.opExecutor("ZerosLike").addInput(this).buildSingletonOrThrow();
    }

    public NDArray onesLike() {
        return this.manager.opExecutor("OnesLike").addInput(this).buildSingletonOrThrow();
    }

    public boolean contentEquals(Number number) {
        if (number == null) {
            return false;
        }
        try (NDArray result = this.eq(number);){
            boolean bl = result.all().getBoolean(new long[0]);
            return bl;
        }
    }

    public boolean contentEquals(NDArray other) {
        if (other == null || !this.shapeEquals(other)) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        TfNDArray eq = (TfNDArray)this.eq(other);
        return eq.all().toBooleanArray()[0];
    }

    public NDArray eq(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.eq(number);
            return nDArray;
        }
    }

    public NDArray eq(NDArray other) {
        return this.manager.opExecutor("Equal").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray neq(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.neq(number);
            return nDArray;
        }
    }

    public NDArray neq(NDArray other) {
        return this.manager.opExecutor("NotEqual").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray gt(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.gt(number);
            return nDArray;
        }
    }

    public NDArray gt(NDArray other) {
        return this.manager.opExecutor("Greater").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray gte(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.gte(number);
            return nDArray;
        }
    }

    public NDArray gte(NDArray other) {
        return this.manager.opExecutor("GreaterEqual").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray lt(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.lt(number);
            return nDArray;
        }
    }

    public NDArray lt(NDArray other) {
        return this.manager.opExecutor("Less").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray lte(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.lte(number);
            return nDArray;
        }
    }

    public NDArray lte(NDArray other) {
        return this.manager.opExecutor("LessEqual").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    /*
     * Exception decompiling
     */
    public NDArray all() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public NDArray any() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray erfinv() {
        return this.manager.opExecutor("Erfinv").addInput(this).buildSingletonOrThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NDArray norm(boolean keepDims) {
        if (this.getDataType() == DataType.FLOAT64) {
            throw new UnsupportedOperationException("float64 is not supported");
        }
        NDArray flatten = this.flatten();
        NDArray axis = this.manager.create(0);
        NDArray res = this.manager.opExecutor("EuclideanNorm").addInput(flatten).addInput(axis).addParam("keep_dims", keepDims).buildSingletonOrThrow();
        flatten.close();
        axis.close();
        if (!keepDims) {
            return res;
        }
        try {
            long[] shapes = LongStream.generate(() -> 1L).limit(this.getShape().dimension()).toArray();
            NDArray nDArray = res.reshape(shapes);
            return nDArray;
        }
        finally {
            res.close();
        }
    }

    public NDArray norm(int ord, int[] axes, boolean keepDims) {
        if (ord != 2) {
            throw new UnsupportedOperationException("Only ord=2 is supported");
        }
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("EuclideanNorm").addInput(this).addInput(axesArr).addParam("keep_dims", keepDims).buildSingletonOrThrow();
            return nDArray;
        }
    }

    /*
     * Exception decompiling
     */
    public NDArray oneHot(int depth, float onValue, float offValue, DataType dataType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray batchDot(NDArray other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray add(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.add(number);
            return nDArray;
        }
    }

    public NDArray add(NDArray other) {
        return this.manager.opExecutor("Add").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray sub(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.sub(number);
            return nDArray;
        }
    }

    public NDArray sub(NDArray other) {
        return this.manager.opExecutor("Sub").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray mul(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.mul(number);
            return nDArray;
        }
    }

    public NDArray mul(NDArray other) {
        return this.manager.opExecutor("Mul").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray div(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.div(number);
            return nDArray;
        }
    }

    public NDArray div(NDArray other) {
        return this.manager.opExecutor("Div").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray mod(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.mod(number);
            return nDArray;
        }
    }

    public NDArray mod(NDArray other) {
        return this.manager.opExecutor("Mod").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray pow(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.pow(number);
            return nDArray;
        }
    }

    public NDArray pow(NDArray other) {
        return this.manager.opExecutor("Pow").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray maximum(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.maximum(number);
            return nDArray;
        }
    }

    public NDArray maximum(NDArray other) {
        return this.manager.opExecutor("Maximum").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray minimum(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.minimum(number);
            return nDArray;
        }
    }

    public NDArray minimum(NDArray other) {
        return this.manager.opExecutor("Minimum").addInput(this).addInput(other).buildSingletonOrThrow();
    }

    public NDArray addi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.addi(number);
            return nDArray;
        }
    }

    public NDArray addi(NDArray other) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Add").addInput(this).addInput(other).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray subi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.subi(number);
            return nDArray;
        }
    }

    public NDArray subi(NDArray other) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Sub").addInput(this).addInput(other).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray muli(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.muli(number);
            return nDArray;
        }
    }

    public NDArray muli(NDArray other) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Mul").addInput(this).addInput(other).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray divi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.divi(number);
            return nDArray;
        }
    }

    public NDArray divi(NDArray other) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Div").addInput(this).addInput(other).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray toSparse(SparseFormat fmt) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray modi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.modi(number);
            return nDArray;
        }
    }

    public NDArray modi(NDArray other) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Mod").addInput(this).addInput(other).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray powi(Number n) {
        try (NDArray number = this.manager.create(n).toType(this.getDataType(), false);){
            NDArray nDArray = this.powi(number);
            return nDArray;
        }
    }

    public NDArray powi(NDArray other) {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Pow").addInput(this).addInput(other).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray sign() {
        return this.manager.opExecutor("Sign").addInput(this).buildSingletonOrThrow();
    }

    public NDArray signi() {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Sign").addInput(this).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray neg() {
        return this.manager.opExecutor("Neg").addInput(this).buildSingletonOrThrow();
    }

    public NDArray negi() {
        TFE_TensorHandle newHandle = this.manager.opExecutor("Neg").addInput(this).buildRawPointer(1)[0];
        this.setHandle(newHandle);
        return this;
    }

    public NDArray abs() {
        return this.manager.opExecutor("Abs").addInput(this).buildSingletonOrThrow();
    }

    public NDArray square() {
        return this.manager.opExecutor("Square").addInput(this).buildSingletonOrThrow();
    }

    public NDArray sqrt() {
        return this.manager.opExecutor("Sqrt").addInput(this).buildSingletonOrThrow();
    }

    public NDArray cbrt() {
        try (NDArray pow = this.getDataType().equals((Object)DataType.FLOAT64) ? this.manager.create(0.3333333333333333) : this.manager.create(0.33333334f);){
            NDArray nDArray = this.manager.opExecutor("Pow").addInput(this).addInput(pow).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray floor() {
        return this.manager.opExecutor("Floor").addInput(this).buildSingletonOrThrow();
    }

    public NDArray ceil() {
        return this.manager.opExecutor("Ceil").addInput(this).buildSingletonOrThrow();
    }

    public NDArray round() {
        return this.manager.opExecutor("Round").addInput(this).buildSingletonOrThrow();
    }

    public NDArray trunc() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray exp() {
        return this.manager.opExecutor("Exp").addInput(this).buildSingletonOrThrow();
    }

    public NDArray log() {
        return this.manager.opExecutor("Log").addInput(this).buildSingletonOrThrow();
    }

    public NDArray log10() {
        return this.log().div((Number)Math.log(10.0));
    }

    public NDArray log2() {
        return this.log().div((Number)Math.log(2.0));
    }

    public NDArray sin() {
        return this.manager.opExecutor("Sin").addInput(this).buildSingletonOrThrow();
    }

    public NDArray cos() {
        return this.manager.opExecutor("Cos").addInput(this).buildSingletonOrThrow();
    }

    public NDArray tan() {
        return this.manager.opExecutor("Tan").addInput(this).buildSingletonOrThrow();
    }

    public NDArray asin() {
        return this.manager.opExecutor("Asin").addInput(this).buildSingletonOrThrow();
    }

    public NDArray acos() {
        return this.manager.opExecutor("Acos").addInput(this).buildSingletonOrThrow();
    }

    public NDArray atan() {
        return this.manager.opExecutor("Atan").addInput(this).buildSingletonOrThrow();
    }

    public NDArray sinh() {
        return this.manager.opExecutor("Sinh").addInput(this).buildSingletonOrThrow();
    }

    public NDArray cosh() {
        return this.manager.opExecutor("Cosh").addInput(this).buildSingletonOrThrow();
    }

    public NDArray tanh() {
        return this.manager.opExecutor("Tanh").addInput(this).buildSingletonOrThrow();
    }

    public NDArray asinh() {
        return this.manager.opExecutor("Asinh").addInput(this).buildSingletonOrThrow();
    }

    public NDArray acosh() {
        return this.manager.opExecutor("Acosh").addInput(this).buildSingletonOrThrow();
    }

    public NDArray atanh() {
        return this.manager.opExecutor("Atanh").addInput(this).buildSingletonOrThrow();
    }

    public NDArray toDegrees() {
        return this.mul(180).div((Number)Math.PI);
    }

    public NDArray toRadians() {
        return this.mul(Math.PI).div((Number)180);
    }

    public NDArray max() {
        try (NDArray axes = this.manager.arange(this.getShape().dimension());){
            NDArray nDArray = this.manager.opExecutor("Max").addInput(this).addInput(axes).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray max(int[] axes, boolean keepDims) {
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("Max").addInput(this).addInput(axesArr).addParam("keep_dims", keepDims).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray min() {
        try (NDArray axes = this.manager.arange(this.getShape().dimension());){
            NDArray nDArray = this.manager.opExecutor("Min").addInput(this).addInput(axes).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray min(int[] axes, boolean keepDims) {
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("Min").addInput(this).addInput(axesArr).addParam("keep_dims", keepDims).buildSingletonOrThrow();
            return nDArray;
        }
    }

    /*
     * Loose catch block
     */
    public NDArray sum() {
        TfNDArray array = this;
        if (this.getDataType() == DataType.BOOLEAN) {
            array = array.toType(DataType.INT64, false);
        }
        try {
            try (NDArray axes = this.manager.arange(this.getShape().dimension());){
                NDArray nDArray = this.manager.opExecutor("Sum").addInput(array).addInput(axes).buildSingletonOrThrow();
                return nDArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (array != this) {
                array.close();
            }
        }
    }

    public NDArray sum(int[] axes, boolean keepDims) {
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("Sum").addInput(this).addInput(axesArr).addParam("keep_dims", keepDims).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray prod() {
        try (NDArray axes = this.manager.arange(this.getShape().dimension());){
            NDArray nDArray = this.manager.opExecutor("Prod").addInput(this).addInput(axes).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray prod(int[] axes, boolean keepDims) {
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("Prod").addInput(this).addInput(axesArr).addParam("keep_dims", keepDims).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray mean() {
        try (NDArray axes = this.manager.arange(this.getShape().dimension());){
            NDArray nDArray = this.manager.opExecutor("Mean").addInput(this).addInput(axes).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray mean(int[] axes, boolean keepDims) {
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("Mean").addInput(this).addInput(axesArr).addParam("keep_dims", keepDims).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray rotate90(int times, int[] axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray trace(int offset, int axis1, int axis2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * Exception decompiling
     */
    public NDList split(long[] indices, int axis) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray flatten() {
        return this.reshape(new Shape(new long[]{-1L}));
    }

    public NDArray reshape(Shape shape) {
        try (NDArray shapeArr = this.manager.create(shape.getShape());){
            NDArray nDArray = this.manager.opExecutor("Reshape").addInput(this).addInput(shapeArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray expandDims(int axis) {
        try (NDArray axisArr = this.manager.create(axis);){
            NDArray nDArray = this.manager.opExecutor("ExpandDims").addInput(this).addInput(axisArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray squeeze(int[] axes) {
        if (this.isScalar()) {
            axes = new int[]{};
        }
        return this.manager.opExecutor("Squeeze").addInput(this).addParam("squeeze_dims", Arrays.stream(axes).mapToLong(i -> i).toArray()).buildSingletonOrThrow();
    }

    /*
     * Exception decompiling
     */
    public NDArray logicalAnd(NDArray n) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public NDArray logicalOr(NDArray n) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray logicalXor(NDArray n) {
        return this.logicalOr(n).logicalAnd(this.logicalAnd(n).logicalNot());
    }

    public NDArray logicalNot() {
        try (NDArray input = this.toType(DataType.BOOLEAN, true);){
            NDArray nDArray = this.manager.opExecutor("LogicalNot").addInput(input).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray argSort(int axis, boolean ascending) {
        return this.sortHelper(axis, ascending, true);
    }

    public NDArray sort(int axis) {
        return this.sortHelper(axis, true, false);
    }

    public NDArray sort() {
        return this.sortHelper(-1, true, false);
    }

    private NDArray sortHelper(int axis, boolean ascending, boolean returnIndices) {
        if (this.isScalar()) {
            return this.duplicate();
        }
        int rank = this.getShape().dimension();
        try (TfNDManager subManager = (TfNDManager)this.manager.newSubManager();){
            int k;
            TfNDArray input;
            int[] transposition;
            this.attach((NDManager)subManager);
            if (axis == -1 || axis + 1 == this.getShape().dimension()) {
                transposition = null;
                input = this;
                long[] arrayShape = this.getShape().getShape();
                k = (int)arrayShape[arrayShape.length - 1];
            } else {
                k = (int)this.getShape().getShape()[axis];
                NDArray axisArr = subManager.arange(0.0f, axis, 1.0f, DataType.INT32, this.getDevice());
                NDArray axisArr1 = subManager.create(new int[]{rank - 1});
                NDArray axisArr2 = subManager.arange(axis + 1, rank - 1, 1.0f, DataType.INT32, this.getDevice());
                NDArray axisArr3 = subManager.create(new int[]{axis});
                transposition = NDArrays.concat((NDList)new NDList(new NDArray[]{axisArr, axisArr1, axisArr2, axisArr3})).toIntArray();
                input = this.transpose(transposition);
            }
            NDArray kArr = subManager.create(k);
            NDArray[] outputs = ascending ? subManager.opExecutor("TopKV2").addInput(input.neg()).addInput(kArr).build(2) : subManager.opExecutor("TopKV2").addInput(input).addInput(kArr).build(2);
            NDArray result = returnIndices ? outputs[1].toType(DataType.INT64, false) : outputs[0];
            if (transposition != null) {
                result = result.transpose(transposition);
            }
            if (ascending && !returnIndices) {
                result = result.neg();
            }
            this.attach(subManager.getParentManager());
            result.attach(subManager.getParentManager());
            NDArray nDArray = result;
            return nDArray;
        }
    }

    public NDArray softmax(int axis) {
        return this.softmaxHelper("Softmax", axis);
    }

    public NDArray logSoftmax(int axis) {
        return this.softmaxHelper("LogSoftmax", axis);
    }

    private NDArray softmaxHelper(String operation, int axis) {
        long dim = this.getShape().dimension();
        if (dim == 0L) {
            return this.duplicate();
        }
        if (axis == -1 || (long)axis == dim - 1L) {
            return this.manager.opExecutor(operation).addInput(this).buildSingletonOrThrow();
        }
        if ((long)axis < -dim || (long)axis >= dim) {
            throw new IllegalArgumentException("Invalid axes value: " + axis + ", must be in range [" + -dim + ", " + dim + ") where " + dim + " is the number of dimensions in the input.");
        }
        try (NDManager subManager = this.manager.newSubManager();){
            this.attach(subManager);
            NDList concatList = new NDList();
            concatList.add((Object)subManager.arange((int)((long)axis % dim)));
            concatList.add((Object)subManager.create((int)dim - 1).expandDims(0));
            concatList.add((Object)subManager.arange(axis + 1, (int)dim - 1));
            concatList.add((Object)subManager.create(axis).expandDims(0));
            int[] axes = NDArrays.concat((NDList)concatList, (int)0).toIntArray();
            NDArray transposed = this.transpose(axes);
            NDArray output = ((TfNDManager)subManager).opExecutor(operation).addInput(transposed).buildSingletonOrThrow();
            NDArray result = output.transpose(axes);
            result.attach(subManager.getParentManager());
            this.attach(subManager.getParentManager());
            NDArray nDArray = result;
            return nDArray;
        }
    }

    public NDArray cumSum(int axis) {
        if (this.isScalar()) {
            return this.expandDims(0);
        }
        if (Arrays.stream(this.getShape().getShape()).anyMatch(dim -> dim == 0L)) {
            return this.manager.create(new Shape(new long[]{0L}));
        }
        try (NDArray axisArr = this.manager.create(axis);){
            NDArray nDArray = this.manager.opExecutor("Cumsum").addInput(this).addInput(axisArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray cumSum() {
        return this.cumSum(0);
    }

    public void intern(NDArray replaced) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray isInfinite() {
        return this.manager.opExecutor("IsInf").addInput(this).buildSingletonOrThrow();
    }

    public NDArray isNaN() {
        return this.manager.opExecutor("IsNan").addInput(this).buildSingletonOrThrow();
    }

    public NDArray tile(long repeats) {
        if (this.isScalar()) {
            try (NDArray temp = this.reshape(new long[]{1L});){
                NDArray nDArray = temp.tile(repeats);
                return nDArray;
            }
        }
        long[] multiples = new long[this.getShape().dimension()];
        Arrays.fill(multiples, repeats);
        return this.tile(multiples);
    }

    public NDArray tile(int axis, long repeats) {
        long[] multiples = new long[this.getShape().dimension()];
        Arrays.fill(multiples, 1L);
        multiples[axis] = repeats;
        return this.tile(multiples);
    }

    public NDArray tile(long[] repeats) {
        try (NDArray repeatsArr = this.manager.create(repeats);){
            NDArray nDArray = this.manager.opExecutor("Tile").addInput(this).addInput(repeatsArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray tile(Shape desiredShape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(long repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(int axis, long repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(long[] repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray repeat(Shape desiredShape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray dot(NDArray other) {
        throw new UnsupportedOperationException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NDArray matMul(NDArray other) {
        if (this.isScalar() || other.isScalar()) {
            throw new IllegalArgumentException("scalar is not allowed for matMul()");
        }
        if (this.getShape().dimension() > 2 || other.getShape().dimension() > 2) {
            return this.manager.opExecutor("BatchMatMulV2").addInput(this).addInput(other).buildSingletonOrThrow();
        }
        boolean broadcast = false;
        TfNDArray lhs = this;
        NDArray rhs = other;
        if (this.getShape().dimension() == 1) {
            lhs = this.broadcast(new long[]{1L, this.getShape().get(0)});
            broadcast = true;
        }
        if (other.getShape().dimension() == 1) {
            rhs = rhs.broadcast(new long[]{1L, this.getShape().get(0)});
            broadcast = true;
        }
        NDArray result = this.manager.opExecutor("MatMul").addInput(lhs).addInput(rhs).buildSingletonOrThrow();
        try {
            if (broadcast) {
                NDArray nDArray = result.squeeze();
                return nDArray;
            }
            NDArray nDArray = result;
            return nDArray;
        }
        finally {
            if (lhs != this) {
                lhs.close();
            }
            if (rhs != other) {
                rhs.close();
            }
            if (broadcast) {
                result.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public NDArray clip(Number min, Number max) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public NDArray flip(int ... axes) {
        try (NDArray axesArr = this.manager.create(axes);){
            NDArray nDArray = this.manager.opExecutor("ReverseV2").addInput(this).addInput(axesArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray transpose() {
        int dim = this.getShape().dimension();
        int[] reversedShape = IntStream.range(0, dim).map(i -> dim - i - 1).toArray();
        return this.transpose(reversedShape);
    }

    public NDArray transpose(int ... dimensions) {
        if (Arrays.stream(dimensions).anyMatch(d -> d < 0)) {
            throw new UnsupportedOperationException("Passing -1 for broadcasting the dimension is not currently supported");
        }
        if (!Arrays.equals(Arrays.stream(dimensions).sorted().toArray(), IntStream.range(0, this.getShape().dimension()).toArray())) {
            throw new IllegalArgumentException("You must include each of the dimensions from 0 until " + this.getShape().dimension());
        }
        try (NDArray dimensionsArr = this.manager.create(dimensions);){
            NDArray nDArray = this.manager.opExecutor("Transpose").addInput(this).addInput(dimensionsArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray broadcast(Shape shape) {
        try (NDArray shapeArr = this.manager.create(shape.getShape());){
            NDArray nDArray = this.manager.opExecutor("BroadcastTo").addInput(this).addInput(shapeArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray argMax() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMax of an empty NDArray");
        }
        return this.manager.opExecutor("ArgMax").addInput(this).buildSingletonOrThrow();
    }

    public NDArray argMax(int axis) {
        try (NDArray axisArr = this.manager.create(axis);){
            NDArray nDArray = this.manager.opExecutor("ArgMax").addInput(this).addInput(axisArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray argMin() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMin of an empty NDArray");
        }
        return this.manager.opExecutor("ArgMin").addInput(this).buildSingletonOrThrow();
    }

    public NDArray argMin(int axis) {
        try (NDArray axisArr = this.manager.create(axis);){
            NDArray nDArray = this.manager.opExecutor("ArgMin").addInput(this).addInput(axisArr).buildSingletonOrThrow();
            return nDArray;
        }
    }

    public NDArray percentile(Number percentile) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray percentile(Number percentile, int[] dimension) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray median() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray median(int[] axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray toDense() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray nonzero() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArrayEx getNDArrayInternal() {
        return this.tfNDArrayEx;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TfNDArray) {
            return this.contentEquals((TfNDArray)((Object)obj));
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        if (this.isReleased()) {
            return "This array is already closed";
        }
        return this.toDebugString(100, 10, 10, 20);
    }

    public void close() {
        TFE_TensorHandle tensorHandle = this.handle.getAndSet(null);
        if (tensorHandle != null && !tensorHandle.isNull()) {
            tensorHandle.close();
            this.manager.detachInternal(this.getUid());
            this.manager = null;
        }
        this.tfNDArrayEx = null;
    }

    protected void setHandle(TFE_TensorHandle newHandle) {
        TFE_TensorHandle oldHandle = this.handle.getAndSet(newHandle);
        oldHandle.close();
    }
}

