/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.tensorflow.engine;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.AbstractSymbolBlock;
import ai.djl.tensorflow.engine.TfNDArray;
import ai.djl.tensorflow.engine.TfNDManager;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.SavedModelBundle;
import org.tensorflow.Session;
import org.tensorflow.Tensor;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.proto.framework.MetaGraphDef;
import org.tensorflow.proto.framework.SignatureDef;
import org.tensorflow.proto.framework.TensorInfo;
import org.tensorflow.proto.framework.TensorShapeProto;

public class TfSymbolBlock
extends AbstractSymbolBlock
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TfSymbolBlock.class);
    private static final byte VERSION = 1;
    private SavedModelBundle bundle;
    private Session session;
    private SignatureDef servingDefault;
    private PairList<String, Shape> inputDescriptions;
    private PairList<String, Shape> outputDescriptions;
    private ConcurrentHashMap<String, String> inputOutputNames = new ConcurrentHashMap();

    public TfSymbolBlock(SavedModelBundle bundle, String signatureDefKey) {
        super((byte)1);
        this.bundle = bundle;
        this.session = bundle.session();
        MetaGraphDef metaGraphDef = bundle.metaGraphDef();
        Map signatureDefMap = metaGraphDef.getSignatureDefMap();
        if (signatureDefMap.containsKey(signatureDefKey)) {
            this.servingDefault = (SignatureDef)signatureDefMap.get(signatureDefKey);
        } else {
            Set keys = signatureDefMap.keySet();
            logger.warn("SignatureDefKey: " + signatureDefKey + "not found in Saved Model Bundle.Available keys: " + String.join((CharSequence)" ", keys) + "Please use .optOptions(\"SignatureDefKey\", \"value\") with Criteria.builder to load the model.Normally the value is \"default\" for TF1.x models and \"serving_default\" for TF2.x models. Refer to: https://www.tensorflow.org/guide/saved_modelLoading the model using next available key.");
            this.servingDefault = (SignatureDef)signatureDefMap.get(keys.iterator().next());
        }
        this.describeInput();
        this.describeOutput();
    }

    public void removeLastBlock() {
        throw new UnsupportedOperationException("Not supported for TensorFlow Engine");
    }

    protected NDList forwardInternal(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        int i;
        Session.Runner runner = this.session.runner();
        for (i = 0; i < this.inputDescriptions.size(); ++i) {
            String inputName = (String)this.inputDescriptions.get(i).getKey();
            String tensorName = this.inputOutputNames.get(inputName);
            NDArray inputArray = (NDArray)inputs.get(i);
            if (inputArray.getName().isEmpty()) {
                runner.feed(tensorName, ((TfNDArray)inputArray).getTensor());
                continue;
            }
            if (inputArray.getName().equals(inputName)) {
                runner.feed(tensorName, ((TfNDArray)inputArray).getTensor());
                continue;
            }
            for (NDArray array : inputs) {
                if (!array.getName().equals(inputName)) continue;
                runner.feed(tensorName, ((TfNDArray)array).getTensor());
            }
        }
        for (i = 0; i < this.outputDescriptions.size(); ++i) {
            String key = (String)this.outputDescriptions.get(i).getKey();
            runner.fetch(this.inputOutputNames.get(key));
        }
        List result = runner.run();
        TfNDManager tfNDManager = (TfNDManager)inputs.head().getManager();
        NDList resultNDList = new NDList();
        for (int i2 = 0; i2 < result.size(); ++i2) {
            try (Tensor tensor = (Tensor)result.get(i2);){
                TfNDArray array = tfNDManager.create(tensor);
                array.setName((String)this.outputDescriptions.get(i2).getKey());
                resultNDList.add((Object)array);
                continue;
            }
        }
        return resultNDList;
    }

    public Shape[] initialize(NDManager manager, ai.djl.ndarray.types.DataType dataType, Shape ... inputShapes) {
        return new Shape[0];
    }

    public boolean isInitialized() {
        return this.bundle != null;
    }

    public final PairList<String, Shape> describeInput() {
        if (this.inputDescriptions == null) {
            this.inputDescriptions = new PairList();
            Map inputsMap = this.servingDefault.getInputsMap();
            ArrayList keys = new ArrayList(inputsMap.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                TensorInfo tensorInfo = (TensorInfo)inputsMap.get(key);
                TensorShapeProto shapeProto = tensorInfo.getTensorShape();
                this.inputOutputNames.put(key, tensorInfo.getName());
                this.inputDescriptions.add((Object)key, (Object)new Shape(shapeProto.getDimList().stream().mapToLong(TensorShapeProto.Dim::getSize).toArray()));
            }
        }
        return this.inputDescriptions;
    }

    public final PairList<String, Shape> describeOutput() {
        if (this.outputDescriptions == null) {
            this.outputDescriptions = new PairList();
            Map outputsMap = this.servingDefault.getOutputsMap();
            ArrayList keys = new ArrayList(outputsMap.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                TensorInfo tensorInfo = (TensorInfo)outputsMap.get(key);
                TensorShapeProto shapeProto = tensorInfo.getTensorShape();
                if (tensorInfo.getDtype() == DataType.DT_STRING) continue;
                this.inputOutputNames.put(key, tensorInfo.getName());
                this.outputDescriptions.add((Object)key, (Object)new Shape(shapeProto.getDimList().stream().mapToLong(TensorShapeProto.Dim::getSize).toArray()));
            }
        }
        return this.outputDescriptions;
    }

    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        return new Shape[0];
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.bundle != null) {
            this.bundle.close();
        }
    }
}

