/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class ResourceApplyMomentum
extends RawOp {
    public static final String OP_NAME = "ResourceApplyMomentum";

    public static <T extends TType> ResourceApplyMomentum create(Scope scope, Operand<?> var, Operand<?> accum, Operand<T> lr, Operand<T> grad, Operand<T> momentum, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(var.asOutput());
        opBuilder.addInput(accum.asOutput());
        opBuilder.addInput(lr.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(momentum.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useLocking != null) {
                    opBuilder.setAttr("use_locking", opts.useLocking);
                }
                if (opts.useNesterov == null) continue;
                opBuilder.setAttr("use_nesterov", opts.useNesterov);
            }
        }
        return new ResourceApplyMomentum(opBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options useNesterov(Boolean useNesterov) {
        return new Options().useNesterov(useNesterov);
    }

    private ResourceApplyMomentum(Operation operation) {
        super(operation);
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean useNesterov;

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options useNesterov(Boolean useNesterov) {
            this.useNesterov = useNesterov;
            return this;
        }

        private Options() {
        }
    }
}

