/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class RaggedTensorFromVariant<U extends TNumber, T extends TType>
extends RawOp {
    public static final String OP_NAME = "RaggedTensorFromVariant";
    private List<Output<U>> outputNestedSplits;
    private Output<T> outputDenseValues;

    public static <U extends TNumber, T extends TType> RaggedTensorFromVariant<U, T> create(Scope scope, Operand<?> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, DataType<T> Tvalues, DataType<U> Tsplits) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(encodedRagged.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("input_ragged_rank", inputRaggedRank);
        opBuilder.setAttr("output_ragged_rank", outputRaggedRank);
        opBuilder.setAttr("Tvalues", Tvalues);
        opBuilder.setAttr("Tsplits", Tsplits);
        return new RaggedTensorFromVariant<U, T>(opBuilder.build());
    }

    public static <T extends TType> RaggedTensorFromVariant<TInt64, T> create(Scope scope, Operand<?> encodedRagged, Long inputRaggedRank, Long outputRaggedRank, DataType<T> Tvalues) {
        return RaggedTensorFromVariant.create(scope, encodedRagged, inputRaggedRank, outputRaggedRank, Tvalues, TInt64.DTYPE);
    }

    public List<Output<U>> outputNestedSplits() {
        return this.outputNestedSplits;
    }

    public Output<T> outputDenseValues() {
        return this.outputDenseValues;
    }

    private RaggedTensorFromVariant(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputNestedSplitsLength = operation.outputListLength("output_nested_splits");
        this.outputNestedSplits = Arrays.asList(operation.outputList(outputIdx, outputNestedSplitsLength));
        outputIdx += outputNestedSplitsLength;
        this.outputDenseValues = operation.output(outputIdx++);
    }
}

