/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class Dequantize<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "Dequantize";
    private Output<U> output;

    public static <U extends TNumber, T extends TType> Dequantize<U> create(Scope scope, Operand<T> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, DataType<U> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(minRange.asOutput());
        opBuilder.addInput(maxRange.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.mode != null) {
                    opBuilder.setAttr("mode", opts.mode);
                }
                if (opts.narrowRange != null) {
                    opBuilder.setAttr("narrow_range", opts.narrowRange);
                }
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new Dequantize<U>(opBuilder.build());
    }

    public static <T extends TType> Dequantize<TFloat32> create(Scope scope, Operand<T> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Options ... options) {
        return Dequantize.create(scope, input, minRange, maxRange, TFloat32.DTYPE, options);
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private Dequantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String mode;
        private Boolean narrowRange;
        private Long axis;

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }

        private Options() {
        }
    }
}

